/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.diff.internal.merge.impl;

import java.util.List;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.compare.EMFComparePlugin;
import org.eclipse.emf.compare.FactoryException;
import org.eclipse.emf.compare.diff.merge.DefaultMerger;
import org.eclipse.emf.compare.diff.metamodel.DiffElement;
import org.eclipse.emf.compare.diff.metamodel.ModelElementChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChange;
import org.eclipse.emf.compare.diff.metamodel.ReferenceChangeRightTarget;
import org.eclipse.emf.compare.diff.metamodel.ReferenceOrderChange;
import org.eclipse.emf.compare.util.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ModelElementChangeRightTargetMerger
extends DefaultMerger {
    public void applyInOrigin() {
        ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
        EObject origin = theDiff.getLeftParent();
        EObject element = theDiff.getRightElement();
        EObject newOne = this.copy(element);
        EReference ref = element.eContainmentFeature();
        if (ref != null) {
            try {
                Object containmentRefVal;
                int elementIndex = -1;
                if (ref.isMany() && (containmentRefVal = element.eContainer().eGet((EStructuralFeature)ref)) instanceof List) {
                    List listVal = (List)containmentRefVal;
                    elementIndex = listVal.indexOf(element);
                }
                EFactory.eAdd((EObject)origin, (String)ref.getName(), (Object)newOne, (int)elementIndex);
                this.setXMIID(newOne, this.getXMIID(element));
            }
            catch (FactoryException e) {
                EMFComparePlugin.log((Exception)((Object)e), (boolean)true);
            }
        } else if (origin == null && this.getDiffModel().getLeftRoots().size() > 0) {
            ((EObject)this.getDiffModel().getLeftRoots().get(0)).eResource().getContents().add((Object)newOne);
        } else if (origin != null) {
            origin.eResource().getContents().add((Object)newOne);
        }
        TreeIterator siblings = this.getDiffModel().eAllContents();
        while (siblings.hasNext()) {
            ReferenceChange link;
            DiffElement op = (DiffElement)siblings.next();
            if (op instanceof ReferenceChangeRightTarget) {
                link = (ReferenceChangeRightTarget)op;
                if (!link.getLeftTarget().equals(element)) continue;
                link.setRightTarget(newOne);
                continue;
            }
            if (!(op instanceof ReferenceOrderChange) || !(link = (ReferenceOrderChange)op).getReference().equals(ref)) continue;
            link.getLeftTarget().add((Object)newOne);
        }
        super.applyInOrigin();
    }

    public void undoInTarget() {
        ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
        EObject element = theDiff.getRightElement();
        EObject parent = theDiff.getRightElement().eContainer();
        EcoreUtil.remove((EObject)element);
        this.removeDanglingReferences(parent);
        super.undoInTarget();
    }

    public boolean canUndoInTarget() {
        ModelElementChangeRightTarget theDiff = (ModelElementChangeRightTarget)this.diff;
        boolean isRightElementNotNull = theDiff.getRightElement() != null;
        return isRightElementNotNull;
    }
}

