/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.codegen.ecore.generator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.codegen.ecore.generator.Generator;
import org.eclipse.emf.common.notify.AdapterFactory;

public interface GeneratorAdapterFactory
extends AdapterFactory {
    public Generator getGenerator();

    public void setGenerator(Generator var1);

    public void initialize(Object var1);

    public void dispose();

    public static interface Descriptor {
        public GeneratorAdapterFactory createAdapterFactory();

        public static interface Registry {
            public static final Registry INSTANCE = new DelegatingRegistry();

            public Collection getDescriptors(String var1);

            public boolean addDescriptor(String var1, Descriptor var2);

            public boolean removeDescriptor(String var1, Descriptor var2);

            public boolean removeDescriptors(String var1);

            public void clear();
        }

        public static class DelegatingRegistry
        implements Registry {
            protected Registry delegateRegistry;
            protected Map map = new HashMap();

            public DelegatingRegistry() {
            }

            public DelegatingRegistry(Registry delegateRegistry) {
                this.delegateRegistry = delegateRegistry;
            }

            public Collection getDescriptors(String packageID) {
                List descriptors = this.getDescriptors(packageID, false);
                return descriptors != null && !descriptors.isEmpty() ? new ArrayList(descriptors) : this.delegatedGetDescriptors(packageID);
            }

            protected Collection delegatedGetDescriptors(String packageID) {
                return this.delegateRegistry != null ? this.delegateRegistry.getDescriptors(packageID) : Collections.EMPTY_LIST;
            }

            public boolean addDescriptor(String packageID, Descriptor descriptor) {
                return this.getDescriptors(packageID, true).add(descriptor);
            }

            public boolean removeDescriptor(String packageID, Descriptor descriptor) {
                List list = this.getDescriptors(packageID, false);
                if (list != null) {
                    return list.remove(descriptor);
                }
                return false;
            }

            public boolean removeDescriptors(String packageID) {
                List list = this.getDescriptors(packageID, false);
                if (list != null && !list.isEmpty()) {
                    this.map.remove(packageID);
                    return true;
                }
                return false;
            }

            public void clear() {
                this.map.clear();
            }

            protected List getDescriptors(String packageID, boolean forceCreate) {
                ArrayList result = (ArrayList)this.map.get(packageID);
                if (result == null && forceCreate) {
                    result = new ArrayList();
                    this.map.put(packageID, result);
                }
                return result;
            }
        }
    }
}

