/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.eresource.CDOResource;
import org.eclipse.emf.cdo.eresource.CDOResourceFactory;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.notify.impl.NotifierImpl;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.view.CDOViewSetPackageRegistryImpl;
import org.eclipse.emf.spi.cdo.InternalCDOView;
import org.eclipse.emf.spi.cdo.InternalCDOViewSet;

public class CDOViewSetImpl
extends NotifierImpl
implements InternalCDOViewSet {
    private Set<InternalCDOView> views = new HashSet<InternalCDOView>();
    private Map<String, InternalCDOView> mapOfViews = new HashMap<String, InternalCDOView>();
    private CDOResourceFactory resourceFactory = CDOResourceFactory.eINSTANCE;
    private CDOViewSetPackageRegistryImpl packageRegistry;
    private ResourceSet resourceSet;

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public EPackage.Registry getPackageRegistry() {
        return this.packageRegistry;
    }

    public CDOResourceFactory getResourceFactory() {
        return this.resourceFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CDOView[] getViews() {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.views.toArray(new CDOView[this.views.size()]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCDOView resolveView(String repositoryUUID) {
        InternalCDOView view;
        block7: {
            view = null;
            Set<InternalCDOView> set = this.views;
            synchronized (set) {
                block6: {
                    view = this.mapOfViews.get(repositoryUUID);
                    if (view != null) break block7;
                    if (repositoryUUID != null) {
                        throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewSetImpl.0"), repositoryUUID));
                    }
                    if (this.mapOfViews.size() == 1) {
                        return this.views.iterator().next();
                    }
                    if (this.mapOfViews.size() != 0) break block6;
                    return null;
                }
                throw new IllegalStateException(Messages.getString("CDOViewSetImpl.1"));
            }
        }
        return view;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InternalCDOView getView(String repositoryUUID) {
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            return this.mapOfViews.get(repositoryUUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(InternalCDOView view) {
        String repositoryUUID = view.getSession().repository().getUUID();
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            CDOView lookupView = this.mapOfViews.get(repositoryUUID);
            if (lookupView != null) {
                throw new RuntimeException(Messages.getString("CDOViewSetImpl.2"));
            }
            this.views.add(view);
            this.mapOfViews.put(repositoryUUID, view);
        }
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(3, null, (Object)view);
            this.eNotify((Notification)notification);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(InternalCDOView view) {
        String repositoryUUID = view.getSession().repository().getUUID();
        ArrayList<Resource> resToRemove = new ArrayList<Resource>();
        Set<InternalCDOView> set = this.views;
        synchronized (set) {
            this.views.remove(view);
            this.mapOfViews.remove(repositoryUUID);
            for (Resource resource : this.getResourceSet().getResources()) {
                CDOResource cdoRes;
                if (!(resource instanceof CDOResource) || (cdoRes = (CDOResource)resource).cdoView() != view) continue;
                resToRemove.add(resource);
            }
        }
        this.getResourceSet().getResources().removeAll(resToRemove);
        if (this.eNotificationRequired()) {
            NotificationImpl notification = new NotificationImpl(4, (Object)view, null);
            this.eNotify((Notification)notification);
        }
    }

    public Notifier getTarget() {
        return this.resourceSet;
    }

    public void setTarget(Notifier newTarget) {
        if (!this.isAdapterForType(newTarget)) {
            throw new IllegalArgumentException(MessageFormat.format(Messages.getString("CDOViewSetImpl.3"), newTarget));
        }
        if (this.resourceSet != null) {
            throw new IllegalStateException(Messages.getString("CDOViewSetImpl.4"));
        }
        this.resourceSet = (ResourceSet)newTarget;
        EPackage.Registry oldPackageRegistry = this.resourceSet.getPackageRegistry();
        this.packageRegistry = new CDOViewSetPackageRegistryImpl(this, oldPackageRegistry);
        this.resourceSet.setPackageRegistry((EPackage.Registry)this.packageRegistry);
        Resource.Factory.Registry registry = this.resourceSet.getResourceFactoryRegistry();
        Map map = registry.getProtocolToFactoryMap();
        map.put("cdo", this.getResourceFactory());
    }

    public boolean isAdapterForType(Object type) {
        return type instanceof ResourceSet;
    }

    public void notifyChanged(Notification notification) {
    }
}

