/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.net4j.protocol;

import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.cdo.CDOObject;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.id.CDOIDAndVersion;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.util.TransportException;
import org.eclipse.emf.cdo.internal.common.protocol.CDOProtocolImpl;
import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.session.remote.CDORemoteSession;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.cdo.transaction.CDOTimeStampContext;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.internal.cdo.bundle.OM;
import org.eclipse.emf.internal.cdo.messages.Messages;
import org.eclipse.emf.internal.cdo.net4j.protocol.AuthenticationIndication;
import org.eclipse.emf.internal.cdo.net4j.protocol.ChangeSubscriptionRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.CommitNotificationIndication;
import org.eclipse.emf.internal.cdo.net4j.protocol.CommitTransactionCancelRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.CommitTransactionPhase1Request;
import org.eclipse.emf.internal.cdo.net4j.protocol.CommitTransactionPhase2Request;
import org.eclipse.emf.internal.cdo.net4j.protocol.CommitTransactionPhase3Request;
import org.eclipse.emf.internal.cdo.net4j.protocol.CommitTransactionRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.GetRemoteSessionsRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.LoadChunkRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.LoadLibrariesRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.LoadPackagesRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.LoadRevisionByTimeRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.LoadRevisionByVersionRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.LoadRevisionRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.LockObjectsRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.ObjectLockedRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.OpenSessionRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.QueryCancelRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.QueryRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.RemoteSessionNotificationIndication;
import org.eclipse.emf.internal.cdo.net4j.protocol.RepositoryTimeRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.SetAuditRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.SetPassiveUpdateRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.SyncRevisionsRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.UnlockObjectsRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.UnsubscribeRemoteSessionsRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.VerifyRevisionRequest;
import org.eclipse.emf.internal.cdo.net4j.protocol.ViewsChangedRequest;
import org.eclipse.emf.internal.cdo.session.CDORevisionManagerImpl;
import org.eclipse.emf.spi.cdo.AbstractQueryIterator;
import org.eclipse.emf.spi.cdo.CDOSessionProtocol;
import org.eclipse.emf.spi.cdo.InternalCDOObject;
import org.eclipse.emf.spi.cdo.InternalCDORemoteSessionManager;
import org.eclipse.emf.spi.cdo.InternalCDOTransaction;
import org.eclipse.emf.spi.cdo.InternalCDOXATransaction;
import org.eclipse.net4j.signal.RemoteException;
import org.eclipse.net4j.signal.RequestWithConfirmation;
import org.eclipse.net4j.signal.SignalProtocol;
import org.eclipse.net4j.signal.SignalReactor;
import org.eclipse.net4j.util.WrappedException;
import org.eclipse.net4j.util.concurrent.RWLockManager;
import org.eclipse.net4j.util.io.StringCompressor;
import org.eclipse.net4j.util.io.StringIO;
import org.eclipse.net4j.util.om.monitor.OMMonitor;
import org.eclipse.net4j.util.om.trace.PerfTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDOClientProtocol
extends CDOProtocolImpl
implements CDOSessionProtocol {
    private static final PerfTracer REVISION_LOADING = new PerfTracer(OM.PERF_REVISION_LOADING, CDORevisionManagerImpl.class);
    private StringIO packageURICompressor = new StringCompressor(true);

    public StringIO getPackageURICompressor() {
        return this.packageURICompressor;
    }

    @Override
    public CDOSessionProtocol.OpenSessionResult openSession(String repositoryName, boolean passiveUpdateEnabled) {
        this.open();
        return this.send(new OpenSessionRequest(this, repositoryName, passiveUpdateEnabled));
    }

    @Override
    public void loadLibraries(Set<String> missingLibraries, File cacheFolder) {
        this.send(new LoadLibrariesRequest(this, missingLibraries, cacheFolder));
    }

    @Override
    public void setPassiveUpdate(Map<CDOID, CDOIDAndVersion> idAndVersions, int initialChunkSize, boolean passiveUpdateEnabled) {
        this.send(new SetPassiveUpdateRequest(this, idAndVersions, initialChunkSize, passiveUpdateEnabled));
    }

    @Override
    public CDOSessionProtocol.RepositoryTimeResult getRepositoryTime() {
        return this.send(new RepositoryTimeRequest(this));
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        return this.send(new LoadPackagesRequest(this, (InternalCDOPackageUnit)packageUnit));
    }

    @Override
    public Object loadChunk(InternalCDORevision revision, EStructuralFeature feature, int accessIndex, int fetchIndex, int fromIndex, int toIndex) {
        return this.send(new LoadChunkRequest(this, revision, feature, accessIndex, fetchIndex, fromIndex, toIndex));
    }

    @Override
    public List<InternalCDORevision> loadRevisions(Collection<CDOID> ids, int referenceChunk) {
        return this.send(new LoadRevisionRequest(this, ids, referenceChunk));
    }

    @Override
    public List<InternalCDORevision> loadRevisionsByTime(Collection<CDOID> ids, int referenceChunk, long timeStamp) {
        return this.send(new LoadRevisionByTimeRequest(this, ids, referenceChunk, timeStamp));
    }

    @Override
    public InternalCDORevision loadRevisionByVersion(CDOID id, int referenceChunk, int version) {
        return this.send(new LoadRevisionByVersionRequest(this, id, referenceChunk, version)).get(0);
    }

    @Override
    public List<InternalCDORevision> verifyRevision(List<InternalCDORevision> revisions) throws TransportException {
        return this.send(new VerifyRevisionRequest(this, revisions));
    }

    @Override
    public Collection<CDOTimeStampContext> syncRevisions(Map<CDOID, CDOIDAndVersion> idAndVersions, int initialChunkSize) {
        return this.send(new SyncRevisionsRequest(this, idAndVersions, initialChunkSize));
    }

    @Override
    public void openView(int viewId, byte protocolViewType, long timeStamp) {
        this.send(new ViewsChangedRequest(this, viewId, protocolViewType, timeStamp));
    }

    @Override
    public void closeView(int viewId) {
        this.send(new ViewsChangedRequest(this, viewId));
    }

    @Override
    public boolean[] setAudit(int viewId, long timeStamp, List<InternalCDOObject> invalidObjects) {
        return this.send(new SetAuditRequest(this, viewId, timeStamp, invalidObjects));
    }

    @Override
    public void changeSubscription(int viewId, List<CDOID> cdoIDs, boolean subscribeMode, boolean clear) {
        this.send(new ChangeSubscriptionRequest(this, viewId, cdoIDs, subscribeMode, clear));
    }

    @Override
    public List<Object> query(int viewID, AbstractQueryIterator<?> queryResult) {
        return this.send(new QueryRequest(this, viewID, queryResult));
    }

    @Override
    public boolean cancelQuery(int queryId) {
        try {
            return (Boolean)new QueryCancelRequest(this, queryId).send();
        }
        catch (Exception exception) {
            return false;
        }
    }

    @Override
    public void lockObjects(CDOView view, Map<CDOID, CDOIDAndVersion> objects, long timeout, RWLockManager.LockType lockType) throws InterruptedException {
        InterruptedException interruptedException = null;
        RuntimeException runtimeException = null;
        try {
            new LockObjectsRequest(this, view, objects, view.getSession().options().getCollectionLoadingPolicy().getInitialChunkSize(), timeout, lockType).send();
        }
        catch (RemoteException ex) {
            if (ex.getCause() instanceof RuntimeException) {
                runtimeException = (RuntimeException)ex.getCause();
            } else if (ex.getCause() instanceof InterruptedException) {
                interruptedException = (InterruptedException)ex.getCause();
            }
        }
        catch (Exception ex) {
            throw WrappedException.wrap((Exception)ex);
        }
        if (interruptedException != null) {
            throw interruptedException;
        }
        if (runtimeException != null) {
            throw runtimeException;
        }
    }

    @Override
    public void unlockObjects(CDOView view, Collection<? extends CDOObject> objects, RWLockManager.LockType lockType) {
        this.send(new UnlockObjectsRequest(this, view, objects, lockType));
    }

    @Override
    public boolean isObjectLocked(CDOView view, CDOObject object, RWLockManager.LockType lockType, boolean byOthers) {
        return this.send(new ObjectLockedRequest(this, view, object, lockType, byOthers));
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitTransaction(InternalCDOTransaction.InternalCDOCommitContext commitContext, OMMonitor monitor) {
        return this.send(new CommitTransactionRequest(this, commitContext), monitor);
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitTransactionPhase1(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        return this.send(new CommitTransactionPhase1Request(this, xaContext), monitor);
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitTransactionPhase2(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        return this.send(new CommitTransactionPhase2Request(this, xaContext), monitor);
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitTransactionPhase3(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        return this.send(new CommitTransactionPhase3Request(this, xaContext), monitor);
    }

    @Override
    public CDOSessionProtocol.CommitTransactionResult commitTransactionCancel(InternalCDOXATransaction.InternalCDOXACommitContext xaContext, OMMonitor monitor) {
        return this.send(new CommitTransactionCancelRequest(this, xaContext), monitor);
    }

    @Override
    public List<CDORemoteSession> getRemoteSessions(InternalCDORemoteSessionManager manager, boolean subscribe) {
        return this.send(new GetRemoteSessionsRequest(this, manager, subscribe));
    }

    @Override
    public void unsubscribeRemoteSessions() {
        this.send(new UnsubscribeRemoteSessionsRequest(this));
    }

    protected SignalReactor createSignalReactor(short signalID) {
        switch (signalID) {
            case 2: {
                return new AuthenticationIndication((SignalProtocol<?>)this);
            }
            case 17: {
                return new CommitNotificationIndication(this);
            }
            case 30: {
                return new RemoteSessionNotificationIndication(this);
            }
        }
        return super.createSignalReactor(signalID);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        if (!(this.getInfraStructure() instanceof CDOSession)) {
            throw new IllegalStateException(Messages.getString("CDOClientProtocol.0"));
        }
    }

    private <RESULT> RESULT send(RequestWithConfirmation<RESULT> request) {
        try {
            return (RESULT)request.send();
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }

    private CDOSessionProtocol.CommitTransactionResult send(CommitTransactionRequest request, OMMonitor monitor) {
        try {
            return (CDOSessionProtocol.CommitTransactionResult)request.send(monitor);
        }
        catch (RuntimeException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new TransportException((Throwable)ex);
        }
    }

    private List<InternalCDORevision> send(LoadRevisionRequest request) {
        try {
            REVISION_LOADING.start((Object)request);
            List<InternalCDORevision> list = this.send((RequestWithConfirmation)request);
            return list;
        }
        finally {
            REVISION_LOADING.stop((Object)request);
        }
    }
}

