/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.view;

import org.eclipse.emf.cdo.session.CDOSession;
import org.eclipse.emf.cdo.util.CDOURIUtil;
import org.eclipse.emf.cdo.view.CDOView;
import org.eclipse.emf.cdo.view.CDOViewProvider;
import org.eclipse.emf.cdo.view.ManagedContainerViewProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;

public class PluginContainerViewProvider
extends ManagedContainerViewProvider
implements CDOViewProvider {
    private static final String REGEX = "cdo:.*";
    private static final int PRIORITY = 400;

    public PluginContainerViewProvider() {
        super((IManagedContainer)IPluginContainer.INSTANCE, REGEX, 400);
    }

    public CDOView getView(URI uri, ResourceSet resourceSet) {
        IManagedContainer container = this.getContainer();
        if (container == null) {
            return null;
        }
        String repoUUID = CDOURIUtil.extractRepositoryUUID(uri);
        Object[] objectArray = container.getElements("org.eclipse.emf.cdo.sessions");
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            CDOView view;
            Object element = objectArray[n2];
            CDOSession session = (CDOSession)element;
            String uuid = session.repository().getUUID();
            if (repoUUID.equals(uuid) && (view = this.openView(session, resourceSet)) != null) {
                return view;
            }
            ++n2;
        }
        return null;
    }

    protected IManagedContainer getContainer() {
        return IPluginContainer.INSTANCE;
    }

    protected CDOView openView(CDOSession session, ResourceSet resourceSet) {
        return session.openTransaction(resourceSet);
    }
}

