/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.internal.cdo.util;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.internal.cdo.util.PackageClosure;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CrossReferencesPackageClosure
extends PackageClosure {
    @Override
    public Set<EPackage> calculate(EPackage ePackage) {
        HashSet<EPackage> visited = new HashSet<EPackage>();
        this.handleEPackage(ePackage, visited);
        return visited;
    }

    @Override
    protected void handleEPackage(EPackage ePackage, Set<EPackage> visited) {
        visited.add(ePackage);
        TreeIterator it = ePackage.eAllContents();
        while (it.hasNext()) {
            EObject content = (EObject)it.next();
            this.collectCrossReferences(content, visited);
        }
    }

    protected void collectCrossReferences(EObject content, Set<EPackage> visited) {
        EList crossReferences = content.eCrossReferences();
        for (EObject crossReference : crossReferences) {
            EPackage crossReferencePackage = crossReference.eClass().getEPackage();
            if (visited.contains(crossReferencePackage)) continue;
            this.handleEPackage(crossReferencePackage, visited);
        }
    }
}

