/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.server;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclipse.emf.cdo.common.CDOQueryInfo;
import org.eclipse.emf.cdo.common.id.CDOIDMetaRange;
import org.eclipse.emf.cdo.common.model.CDOPackageUnit;
import org.eclipse.emf.cdo.common.model.EMFUtil;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.eresource.EresourcePackage;
import org.eclipse.emf.cdo.internal.common.model.CDOPackageRegistryImpl;
import org.eclipse.emf.cdo.internal.server.CommitManager;
import org.eclipse.emf.cdo.internal.server.LockManager;
import org.eclipse.emf.cdo.internal.server.NotificationManager;
import org.eclipse.emf.cdo.internal.server.QueryManager;
import org.eclipse.emf.cdo.internal.server.ResourcesQueryHandler;
import org.eclipse.emf.cdo.internal.server.RevisionManager;
import org.eclipse.emf.cdo.internal.server.Session;
import org.eclipse.emf.cdo.internal.server.SessionManager;
import org.eclipse.emf.cdo.internal.server.Transaction;
import org.eclipse.emf.cdo.server.IQueryHandler;
import org.eclipse.emf.cdo.server.IQueryHandlerProvider;
import org.eclipse.emf.cdo.server.IRepository;
import org.eclipse.emf.cdo.server.IStore;
import org.eclipse.emf.cdo.server.IStoreAccessor;
import org.eclipse.emf.cdo.server.StoreThreadLocal;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageInfo;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageRegistry;
import org.eclipse.emf.cdo.spi.common.model.InternalCDOPackageUnit;
import org.eclipse.emf.cdo.spi.server.ContainerQueryHandlerProvider;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.net4j.util.ReflectUtil;
import org.eclipse.net4j.util.StringUtil;
import org.eclipse.net4j.util.concurrent.ConcurrencyUtil;
import org.eclipse.net4j.util.container.Container;
import org.eclipse.net4j.util.container.IManagedContainer;
import org.eclipse.net4j.util.container.IPluginContainer;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.monitor.Monitor;
import org.eclipse.net4j.util.om.monitor.OMMonitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Repository
extends Container<Object>
implements IRepository,
InternalCDOPackageRegistry.PackageLoader {
    private String name;
    private IStore store;
    private String uuid;
    private Map<String, String> properties;
    private boolean supportingRevisionDeltas;
    private boolean supportingAudits;
    private boolean verifyingRevisions;
    private InternalCDOPackageRegistry packageRegistry;
    private SessionManager sessionManager;
    private RevisionManager revisionManager;
    private QueryManager queryManager;
    private NotificationManager notificationManager;
    private CommitManager commitManager;
    private LockManager lockManager;
    private IQueryHandlerProvider queryHandlerProvider;
    private List<IRepository.ReadAccessHandler> readAccessHandlers = new ArrayList<IRepository.ReadAccessHandler>();
    private List<IRepository.WriteAccessHandler> writeAccessHandlers = new ArrayList<IRepository.WriteAccessHandler>();
    @ReflectUtil.ExcludeFromDump
    private transient long lastCommitTimeStamp;
    @ReflectUtil.ExcludeFromDump
    private transient Object lastCommitTimeStampLock = new Object();

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public IStore getStore() {
        return this.store;
    }

    @Override
    public void setStore(IStore store) {
        this.store = store;
        store.setRepository(this);
    }

    @Override
    public String getUUID() {
        if (this.uuid == null) {
            this.uuid = this.getProperties().get("overrideUUID");
            if (this.uuid == null) {
                this.uuid = UUID.randomUUID().toString();
            } else if (this.uuid.length() == 0) {
                this.uuid = this.getName();
            }
        }
        return this.uuid;
    }

    @Override
    public synchronized Map<String, String> getProperties() {
        if (this.properties == null) {
            this.properties = new HashMap<String, String>();
        }
        return this.properties;
    }

    @Override
    public synchronized void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    @Override
    public boolean isSupportingRevisionDeltas() {
        return this.supportingRevisionDeltas;
    }

    @Override
    public boolean isSupportingAudits() {
        return this.supportingAudits;
    }

    @Override
    public boolean isVerifyingRevisions() {
        return this.verifyingRevisions;
    }

    public EPackage[] loadPackages(CDOPackageUnit packageUnit) {
        IStoreAccessor accessor = StoreThreadLocal.getAccessor();
        return accessor.loadPackageUnit((InternalCDOPackageUnit)packageUnit);
    }

    public InternalCDOPackageRegistry getPackageRegistry(boolean considerCommitContext) {
        InternalCDOPackageRegistry contextualPackageRegistry;
        IStoreAccessor.CommitContext commitContext;
        if (considerCommitContext && (commitContext = StoreThreadLocal.getCommitContext()) != null && (contextualPackageRegistry = commitContext.getPackageRegistry()) != null) {
            return contextualPackageRegistry;
        }
        return this.packageRegistry;
    }

    public InternalCDOPackageRegistry getPackageRegistry() {
        return this.getPackageRegistry(true);
    }

    public void setPackageRegistry(InternalCDOPackageRegistry packageRegistry) {
        this.packageRegistry = packageRegistry;
    }

    @Override
    public SessionManager getSessionManager() {
        return this.sessionManager;
    }

    public void setSessionManager(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    @Override
    public RevisionManager getRevisionManager() {
        return this.revisionManager;
    }

    public void setRevisionManager(RevisionManager revisionManager) {
        this.revisionManager = revisionManager;
    }

    public QueryManager getQueryManager() {
        return this.queryManager;
    }

    public void setQueryManager(QueryManager queryManager) {
        this.queryManager = queryManager;
    }

    @Override
    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public void setNotificationManager(NotificationManager notificationManager) {
        this.notificationManager = notificationManager;
    }

    public CommitManager getCommitManager() {
        return this.commitManager;
    }

    public void setCommitManager(CommitManager commitManager) {
        this.commitManager = commitManager;
    }

    public LockManager getLockManager() {
        return this.lockManager;
    }

    public void setLockManager(LockManager lockManager) {
        this.lockManager = lockManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long createCommitTimeStamp() {
        long now = System.currentTimeMillis();
        Object object = this.lastCommitTimeStampLock;
        synchronized (object) {
            if (this.lastCommitTimeStamp != 0L) {
                while (this.lastCommitTimeStamp == now) {
                    ConcurrencyUtil.sleep((long)1L);
                    now = System.currentTimeMillis();
                }
            }
            this.lastCommitTimeStamp = now;
            return now;
        }
    }

    @Override
    public IQueryHandlerProvider getQueryHandlerProvider() {
        return this.queryHandlerProvider;
    }

    public void setQueryHandlerProvider(IQueryHandlerProvider queryHandlerProvider) {
        this.queryHandlerProvider = queryHandlerProvider;
    }

    @Override
    public synchronized IQueryHandler getQueryHandler(CDOQueryInfo info) {
        IQueryHandler handler;
        if ("resources".equals(info.getQueryLanguage())) {
            return new ResourcesQueryHandler();
        }
        IStoreAccessor storeAccessor = StoreThreadLocal.getAccessor();
        if (storeAccessor != null && (handler = storeAccessor.getQueryHandler(info)) != null) {
            return handler;
        }
        if (this.queryHandlerProvider == null) {
            this.queryHandlerProvider = new ContainerQueryHandlerProvider((IManagedContainer)IPluginContainer.INSTANCE);
        }
        if ((handler = this.queryHandlerProvider.getQueryHandler(info)) != null) {
            return handler;
        }
        return null;
    }

    public Object[] getElements() {
        Object[] elements = new Object[]{this.packageRegistry, this.sessionManager, this.revisionManager, this.queryManager, this.notificationManager, this.commitManager, this.lockManager, this.store};
        return elements;
    }

    public boolean isEmpty() {
        return false;
    }

    @Override
    public long getCreationTime() {
        return this.store.getCreationTime();
    }

    @Override
    public void validateTimeStamp(long timeStamp) throws IllegalArgumentException {
        long creationTimeStamp = this.getCreationTime();
        if (timeStamp < creationTimeStamp) {
            throw new IllegalArgumentException("timeStamp < repository creation time: " + creationTimeStamp);
        }
        long currentTimeStamp = System.currentTimeMillis();
        if (timeStamp > currentTimeStamp) {
            throw new IllegalArgumentException("timeStamp > current time: " + currentTimeStamp);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addHandler(IRepository.Handler handler) {
        if (handler instanceof IRepository.ReadAccessHandler) {
            List<IRepository.ReadAccessHandler> list = this.readAccessHandlers;
            synchronized (list) {
                if (!this.readAccessHandlers.contains(handler)) {
                    this.readAccessHandlers.add((IRepository.ReadAccessHandler)handler);
                }
            }
        } else if (handler instanceof IRepository.WriteAccessHandler) {
            List<IRepository.WriteAccessHandler> list = this.writeAccessHandlers;
            synchronized (list) {
                if (!this.writeAccessHandlers.contains(handler)) {
                    this.writeAccessHandlers.add((IRepository.WriteAccessHandler)handler);
                }
            }
        } else {
            throw new IllegalArgumentException("Invalid handler: " + handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeHandler(IRepository.Handler handler) {
        if (handler instanceof IRepository.ReadAccessHandler) {
            List<IRepository.ReadAccessHandler> list = this.readAccessHandlers;
            synchronized (list) {
                this.readAccessHandlers.remove(handler);
            }
        } else if (handler instanceof IRepository.WriteAccessHandler) {
            List<IRepository.WriteAccessHandler> list = this.writeAccessHandlers;
            synchronized (list) {
                this.writeAccessHandlers.remove(handler);
            }
        } else {
            throw new IllegalArgumentException("Invalid handler: " + handler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyReadAccessHandlers(Session session, CDORevision[] revisions, List<CDORevision> additionalRevisions) {
        IRepository.ReadAccessHandler[] handlers;
        List<IRepository.ReadAccessHandler> list = this.readAccessHandlers;
        synchronized (list) {
            int size = this.readAccessHandlers.size();
            if (size == 0) {
                return;
            }
            handlers = this.readAccessHandlers.toArray(new IRepository.ReadAccessHandler[size]);
        }
        IRepository.ReadAccessHandler[] readAccessHandlerArray = handlers;
        int n = handlers.length;
        int n2 = 0;
        while (n2 < n) {
            IRepository.ReadAccessHandler handler = readAccessHandlerArray[n2];
            handler.handleRevisionsBeforeSending(session, revisions, additionalRevisions);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyWriteAccessHandlers(Transaction transaction, IStoreAccessor.CommitContext commitContext, OMMonitor monitor) {
        IRepository.WriteAccessHandler[] handlers;
        List<IRepository.WriteAccessHandler> list = this.writeAccessHandlers;
        synchronized (list) {
            int size = this.writeAccessHandlers.size();
            if (size == 0) {
                return;
            }
            handlers = this.writeAccessHandlers.toArray(new IRepository.WriteAccessHandler[size]);
        }
        try {
            monitor.begin((double)handlers.length);
            IRepository.WriteAccessHandler[] writeAccessHandlerArray = handlers;
            int n = handlers.length;
            int n2 = 0;
            while (n2 < n) {
                IRepository.WriteAccessHandler handler = writeAccessHandlerArray[n2];
                handler.handleTransactionBeforeCommitting(transaction, commitContext, monitor.fork());
                ++n2;
            }
        }
        finally {
            monitor.done();
        }
    }

    public String toString() {
        return MessageFormat.format("Repository[{0}]", this.name);
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(!StringUtil.isEmpty((String)this.name), "name is empty");
        this.checkState(this.packageRegistry, "packageRegistry");
        this.checkState(this.sessionManager, "sessionManager");
        this.checkState(this.revisionManager, "revisionManager");
        this.checkState((Object)this.queryManager, "queryManager");
        this.checkState(this.notificationManager, "notificationManager");
        this.checkState((Object)this.commitManager, "commitManager");
        this.checkState((Object)this.lockManager, "lockingManager");
        this.packageRegistry.setReplacingDescriptors(true);
        this.packageRegistry.setPackageLoader((InternalCDOPackageRegistry.PackageLoader)this);
        this.sessionManager.setRepository(this);
        this.revisionManager.setRepository(this);
        this.queryManager.setRepository(this);
        this.notificationManager.setRepository(this);
        this.commitManager.setRepository(this);
        this.lockManager.setRepository(this);
        this.checkState(this.store, "store");
        String value = this.getProperties().get("supportingAudits");
        if (value != null) {
            this.supportingAudits = Boolean.valueOf(value);
            this.store.setRevisionTemporality(this.supportingAudits ? IStore.RevisionTemporality.AUDITING : IStore.RevisionTemporality.NONE);
        } else {
            this.supportingAudits = this.store.getRevisionTemporality() == IStore.RevisionTemporality.AUDITING;
        }
        this.supportingRevisionDeltas = this.store.getSupportedChangeFormats().contains((Object)IStore.ChangeFormat.DELTA);
        value = this.getProperties().get("verifyingRevisions");
        this.verifyingRevisions = value == null ? false : Boolean.valueOf(value);
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        LifecycleUtil.activate((Object)this.packageRegistry);
        LifecycleUtil.activate((Object)this.store);
        LifecycleUtil.activate((Object)this.sessionManager);
        LifecycleUtil.activate((Object)this.revisionManager);
        LifecycleUtil.activate((Object)((Object)this.queryManager));
        LifecycleUtil.activate((Object)this.notificationManager);
        LifecycleUtil.activate((Object)((Object)this.commitManager));
        LifecycleUtil.activate((Object)this.queryHandlerProvider);
        LifecycleUtil.activate((Object)((Object)this.lockManager));
        if (this.store.isFirstTime()) {
            this.initSystemPackages();
        } else {
            this.readPackageUnits();
        }
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)((Object)this.lockManager));
        LifecycleUtil.deactivate((Object)this.queryHandlerProvider);
        LifecycleUtil.deactivate((Object)((Object)this.commitManager));
        LifecycleUtil.deactivate((Object)this.notificationManager);
        LifecycleUtil.deactivate((Object)((Object)this.queryManager));
        LifecycleUtil.deactivate((Object)this.revisionManager);
        LifecycleUtil.deactivate((Object)this.sessionManager);
        LifecycleUtil.deactivate((Object)this.store);
        LifecycleUtil.deactivate((Object)this.packageRegistry);
        super.doDeactivate();
    }

    protected void initSystemPackages() {
        IStoreAccessor writer = this.store.getWriter(null);
        StoreThreadLocal.setAccessor(writer);
        try {
            InternalCDOPackageUnit ecoreUnit = this.initSystemPackage((EPackage)EcorePackage.eINSTANCE);
            InternalCDOPackageUnit eresourceUnit = this.initSystemPackage((EPackage)EresourcePackage.eINSTANCE);
            InternalCDOPackageUnit[] systemUnits = new InternalCDOPackageUnit[]{ecoreUnit, eresourceUnit};
            writer.writePackageUnits(systemUnits, (OMMonitor)new Monitor());
            writer.commit((OMMonitor)new Monitor());
        }
        finally {
            LifecycleUtil.deactivate((Object)writer);
            StoreThreadLocal.release();
        }
    }

    protected InternalCDOPackageUnit initSystemPackage(EPackage ePackage) {
        EMFUtil.registerPackage((EPackage)ePackage, (EPackage.Registry[])new EPackage.Registry[]{this.packageRegistry});
        InternalCDOPackageInfo packageInfo = this.packageRegistry.getPackageInfo(ePackage);
        CDOIDMetaRange metaIDRange = this.store.getNextMetaIDRange(packageInfo.getMetaIDRange().size());
        packageInfo.setMetaIDRange(metaIDRange);
        this.packageRegistry.getMetaInstanceMapper().mapMetaInstances(ePackage, metaIDRange);
        InternalCDOPackageUnit packageUnit = packageInfo.getPackageUnit();
        packageUnit.setTimeStamp(this.store.getCreationTime());
        packageUnit.setState(CDOPackageUnit.State.LOADED);
        return packageUnit;
    }

    protected void readPackageUnits() {
        IStoreAccessor reader = this.store.getReader(null);
        StoreThreadLocal.setAccessor(reader);
        try {
            Collection<InternalCDOPackageUnit> packageUnits = reader.readPackageUnits();
            for (InternalCDOPackageUnit packageUnit : packageUnits) {
                this.packageRegistry.putPackageUnit(packageUnit);
            }
        }
        finally {
            LifecycleUtil.deactivate((Object)reader);
            StoreThreadLocal.release();
        }
    }

    public static class Default
    extends Repository {
        protected void doBeforeActivate() throws Exception {
            if (this.getPackageRegistry() == null) {
                this.setPackageRegistry(this.createPackageRegistry());
            }
            if (this.getSessionManager() == null) {
                this.setSessionManager(this.createSessionManager());
            }
            if (this.getRevisionManager() == null) {
                this.setRevisionManager(this.createRevisionManager());
            }
            if (this.getQueryManager() == null) {
                this.setQueryManager(this.createQueryManager());
            }
            if (this.getNotificationManager() == null) {
                this.setNotificationManager(this.createNotificationManager());
            }
            if (this.getCommitManager() == null) {
                this.setCommitManager(this.createCommitManager());
            }
            if (this.getLockManager() == null) {
                this.setLockManager(this.createLockManager());
            }
            super.doBeforeActivate();
        }

        protected InternalCDOPackageRegistry createPackageRegistry() {
            return new CDOPackageRegistryImpl();
        }

        protected SessionManager createSessionManager() {
            return new SessionManager();
        }

        protected RevisionManager createRevisionManager() {
            return new RevisionManager();
        }

        protected QueryManager createQueryManager() {
            return new QueryManager();
        }

        protected NotificationManager createNotificationManager() {
            return new NotificationManager();
        }

        protected CommitManager createCommitManager() {
            return new CommitManager();
        }

        protected LockManager createLockManager() {
            return new LockManager();
        }
    }
}

