/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.cdo.internal.common.revision.cache.two;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.cdo.common.id.CDOID;
import org.eclipse.emf.cdo.common.revision.CDORevision;
import org.eclipse.emf.cdo.common.revision.cache.CDORevisionCache;
import org.eclipse.emf.cdo.internal.common.bundle.OM;
import org.eclipse.emf.cdo.spi.common.revision.InternalCDORevision;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.net4j.util.event.IEvent;
import org.eclipse.net4j.util.event.IListener;
import org.eclipse.net4j.util.lifecycle.Lifecycle;
import org.eclipse.net4j.util.lifecycle.LifecycleUtil;
import org.eclipse.net4j.util.om.trace.ContextTracer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TwoLevelRevisionCache
extends Lifecycle
implements CDORevisionCache,
IListener {
    private static final ContextTracer TRACER = new ContextTracer(OM.DEBUG_REVISION, TwoLevelRevisionCache.class);
    private CDORevisionCache level1;
    private CDORevisionCache level2;

    public CDORevisionCache getLevel1() {
        return this.level1;
    }

    public void setLevel1(CDORevisionCache level1) {
        this.level1 = level1;
    }

    public CDORevisionCache getLevel2() {
        return this.level2;
    }

    public void setLevel2(CDORevisionCache level2) {
        this.level2 = level2;
    }

    @Override
    public EClass getObjectType(CDOID id) {
        EClass objectType = this.level1.getObjectType(id);
        if (objectType == null) {
            objectType = this.level2.getObjectType(id);
        }
        return objectType;
    }

    @Override
    public InternalCDORevision getRevision(CDOID id) {
        InternalCDORevision revision = this.level1.getRevision(id);
        if (revision == null) {
            revision = this.level2.getRevision(id);
        }
        return revision;
    }

    @Override
    public InternalCDORevision getRevisionByTime(CDOID id, long timeStamp) {
        InternalCDORevision revision = this.level1.getRevisionByTime(id, timeStamp);
        if (revision == null) {
            revision = this.level2.getRevisionByTime(id, timeStamp);
        }
        return revision;
    }

    @Override
    public InternalCDORevision getRevisionByVersion(CDOID id, int version) {
        InternalCDORevision revision = this.level1.getRevisionByVersion(id, version);
        if (revision == null) {
            revision = this.level2.getRevisionByVersion(id, version);
        }
        return revision;
    }

    @Override
    public List<CDORevision> getRevisions() {
        ArrayList<CDORevision> revisions = new ArrayList<CDORevision>();
        revisions.addAll(this.level1.getRevisions());
        revisions.addAll(this.level2.getRevisions());
        return revisions;
    }

    @Override
    public boolean addRevision(InternalCDORevision revision) {
        return this.level1.addRevision(revision);
    }

    @Override
    public InternalCDORevision removeRevision(CDOID id, int version) {
        InternalCDORevision revision = this.level1.removeRevision(id, version);
        if (revision == null) {
            revision = this.level2.removeRevision(id, version);
        }
        return revision;
    }

    @Override
    public CDOID getResourceID(CDOID folderID, String name, long timeStamp) {
        CDOID id = this.level1.getResourceID(folderID, name, timeStamp);
        if (id == null) {
            id = this.level2.getResourceID(folderID, name, timeStamp);
        }
        return id;
    }

    @Override
    public void clear() {
        this.level1.clear();
        this.level2.clear();
    }

    public void notifyEvent(IEvent event) {
        CDORevisionCache.EvictionEvent e;
        InternalCDORevision revision;
        if (event instanceof CDORevisionCache.EvictionEvent && (revision = (e = (CDORevisionCache.EvictionEvent)event).getRevision()) != null) {
            CDORevisionCache cache = e.getCache();
            if (cache == this.level1) {
                this.evictedFromLevel1(revision);
            } else if (cache == this.level2) {
                this.evictedFromLevel2(revision);
            }
        }
    }

    protected void evictedFromLevel1(InternalCDORevision revision) {
        this.level2.addRevision(revision);
        if (TRACER.isEnabled()) {
            TRACER.format("Recached revision {0}", new Object[]{revision});
        }
    }

    protected void evictedFromLevel2(InternalCDORevision revision) {
    }

    protected void doBeforeActivate() throws Exception {
        super.doBeforeActivate();
        this.checkState(this.level1, "level1");
        this.checkState(this.level2, "level2");
    }

    protected void doActivate() throws Exception {
        super.doActivate();
        this.level1.addListener(this);
        this.level2.addListener(this);
        LifecycleUtil.activate((Object)this.level1);
        LifecycleUtil.activate((Object)this.level2);
    }

    protected void doDeactivate() throws Exception {
        LifecycleUtil.deactivate((Object)this.level2);
        LifecycleUtil.deactivate((Object)this.level1);
        this.level2.removeListener(this);
        this.level1.removeListener(this);
        super.doDeactivate();
    }
}

