/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.java.impl;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;
import org.eclipse.emf.java.JClass;
import org.eclipse.emf.java.JCompilationUnit;
import org.eclipse.emf.java.JField;
import org.eclipse.emf.java.JInitializer;
import org.eclipse.emf.java.JMethod;
import org.eclipse.emf.java.JPackage;
import org.eclipse.emf.java.JParameter;
import org.eclipse.emf.java.JVisibility;
import org.eclipse.emf.java.JavaFactory;
import org.eclipse.emf.java.JavaPackage;
import org.eclipse.emf.java.impl.JClassImpl;
import org.eclipse.emf.java.impl.JCompilationUnitImpl;
import org.eclipse.emf.java.impl.JFieldImpl;
import org.eclipse.emf.java.impl.JInitializerImpl;
import org.eclipse.emf.java.impl.JMethodImpl;
import org.eclipse.emf.java.impl.JPackageImpl;
import org.eclipse.emf.java.impl.JParameterImpl;

public class JavaFactoryImpl
extends EFactoryImpl
implements JavaFactory {
    public static JavaFactory init() {
        try {
            JavaFactory theJavaFactory = (JavaFactory)EPackage.Registry.INSTANCE.getEFactory("http://www.eclipse.org/emf/2002/Java");
            if (theJavaFactory != null) {
                return theJavaFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new JavaFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createJClass();
            }
            case 1: {
                return this.createJCompilationUnit();
            }
            case 2: {
                return this.createJField();
            }
            case 3: {
                return this.createJInitializer();
            }
            case 5: {
                return this.createJMethod();
            }
            case 7: {
                return this.createJPackage();
            }
            case 8: {
                return this.createJParameter();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.createJVisibilityFromString(eDataType, initialValue);
            }
            case 14: {
                return this.createJavaPackageFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 9: {
                return this.convertJVisibilityToString(eDataType, instanceValue);
            }
            case 14: {
                return this.convertJavaPackageToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public JClass createJClass() {
        JClassImpl jClass = new JClassImpl();
        return jClass;
    }

    public JCompilationUnit createJCompilationUnit() {
        JCompilationUnitImpl jCompilationUnit = new JCompilationUnitImpl();
        return jCompilationUnit;
    }

    public JField createJField() {
        JFieldImpl jField = new JFieldImpl();
        return jField;
    }

    public JInitializer createJInitializer() {
        JInitializerImpl jInitializer = new JInitializerImpl();
        return jInitializer;
    }

    public JMethod createJMethod() {
        JMethodImpl jMethod = new JMethodImpl();
        return jMethod;
    }

    public JParameter createJParameter() {
        JParameterImpl jParameter = new JParameterImpl();
        return jParameter;
    }

    public JVisibility createJVisibilityFromString(EDataType eDataType, String initialValue) {
        JVisibility result = JVisibility.get(initialValue);
        if (result == null) {
            throw new IllegalArgumentException("The value '" + initialValue + "' is not a valid enumerator of '" + eDataType.getName() + "'");
        }
        return result;
    }

    public String convertJVisibilityToString(EDataType eDataType, Object instanceValue) {
        return instanceValue == null ? null : instanceValue.toString();
    }

    public JPackage createJPackage() {
        JPackageImpl jPackage = new JPackageImpl();
        return jPackage;
    }

    public Package createJavaPackageFromString(EDataType eDataType, String initialValue) {
        return (Package)super.createFromString(eDataType, initialValue);
    }

    public String convertJavaPackageToString(EDataType eDataType, Object instanceValue) {
        return super.convertToString(eDataType, instanceValue);
    }

    public JavaPackage getJavaPackage() {
        return (JavaPackage)this.getEPackage();
    }

    @Deprecated
    public static JavaPackage getPackage() {
        return JavaPackage.eINSTANCE;
    }
}

