/*
 * Decompiled with CFR 0.152.
 */
package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.immutables.value.Value;
import org.mandas.docker.Nullable;
import org.mandas.docker.client.messages.ImmutableIpamConfig;

@JsonDeserialize(builder=ImmutableIpamConfig.Builder.class)
@Value.Immutable
public interface IpamConfig {
    @JsonProperty(value="Subnet")
    @Nullable
    public String subnet();

    @JsonProperty(value="IPRange")
    @Nullable
    public String ipRange();

    @JsonProperty(value="Gateway")
    @Nullable
    public String gateway();

    public static IpamConfig create(String subnet, String ipRange, String gateway) {
        return ImmutableIpamConfig.builder().subnet(subnet).ipRange(ipRange).gateway(gateway).build();
    }

    public static Builder builder() {
        return ImmutableIpamConfig.builder();
    }

    public static interface Builder {
        public Builder subnet(String var1);

        public Builder ipRange(String var1);

        public Builder gateway(String var1);

        public IpamConfig build();
    }
}

