package org.mandas.docker.client.messages;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * Immutable implementation of {@link ContainerExit}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContainerExit.builder()}.
 */
@SuppressWarnings({"all"})
final class ImmutableContainerExit implements ContainerExit {
  private final Long statusCode;

  private ImmutableContainerExit(Long statusCode) {
    this.statusCode = statusCode;
  }

  /**
   * @return The value of the {@code statusCode} attribute
   */
  @JsonProperty("StatusCode")
  @Override
  public Long statusCode() {
    return statusCode;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContainerExit#statusCode() statusCode} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for statusCode
   * @return A modified copy or the {@code this} object
   */
  public final ImmutableContainerExit withStatusCode(Long value) {
    Long newValue = Objects.requireNonNull(value, "statusCode");
    if (this.statusCode.equals(newValue)) return this;
    return new ImmutableContainerExit(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContainerExit} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContainerExit
        && equalsByValue((ImmutableContainerExit) another);
  }

  private boolean equalsByValue(ImmutableContainerExit another) {
    return statusCode.equals(another.statusCode);
  }

  /**
   * Computes a hash code from attributes: {@code statusCode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    int h = 5381;
    h += (h << 5) + statusCode.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code ContainerExit} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "ContainerExit{"
        + "statusCode=" + statusCode
        + "}";
  }

  /**
   * Creates an immutable copy of a {@link ContainerExit} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContainerExit instance
   */
  public static ImmutableContainerExit copyOf(ContainerExit instance) {
    if (instance instanceof ImmutableContainerExit) {
      return (ImmutableContainerExit) instance;
    }
    return ImmutableContainerExit.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContainerExit ImmutableContainerExit}.
   * <pre>
   * ImmutableContainerExit.builder()
   *    .statusCode(Long) // required {@link ContainerExit#statusCode() statusCode}
   *    .build();
   * </pre>
   * @return A new ImmutableContainerExit builder
   */
  public static ImmutableContainerExit.Builder builder() {
    return new ImmutableContainerExit.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContainerExit ImmutableContainerExit}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  static final class Builder {
    private static final long INIT_BIT_STATUS_CODE = 0x1L;
    private long initBits = 0x1L;

    private Long statusCode;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContainerExit} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(ContainerExit instance) {
      Objects.requireNonNull(instance, "instance");
      this.statusCode(instance.statusCode());
      return this;
    }

    /**
     * Initializes the value for the {@link ContainerExit#statusCode() statusCode} attribute.
     * @param statusCode The value for statusCode 
     * @return {@code this} builder for use in a chained invocation
     */
    @JsonProperty("StatusCode")
    public final Builder statusCode(Long statusCode) {
      this.statusCode = Objects.requireNonNull(statusCode, "statusCode");
      initBits &= ~INIT_BIT_STATUS_CODE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContainerExit ImmutableContainerExit}.
     * @return An immutable instance of ContainerExit
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContainerExit build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContainerExit(statusCode);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_STATUS_CODE) != 0) attributes.add("statusCode");
      return "Cannot build ContainerExit, some of required attributes are not set " + attributes;
    }
  }
}
