/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loader;

import java.io.IOException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import org.eclipse.virgo.util.common.Assert;
import org.osgi.framework.Bundle;

public class BundleDelegatingClassLoader
extends ClassLoader {
    private final ClassLoader bridge;
    private final Bundle backingBundle;

    public static BundleDelegatingClassLoader createBundleClassLoaderFor(Bundle aBundle) {
        return BundleDelegatingClassLoader.createBundleClassLoaderFor(aBundle, null);
    }

    public static BundleDelegatingClassLoader createBundleClassLoaderFor(final Bundle bundle, final ClassLoader bridge) {
        return AccessController.doPrivileged(new PrivilegedAction<BundleDelegatingClassLoader>(){

            @Override
            public BundleDelegatingClassLoader run() {
                return new BundleDelegatingClassLoader(bundle, bridge);
            }
        });
    }

    protected BundleDelegatingClassLoader(Bundle bundle, ClassLoader bridgeLoader) {
        super(null);
        Assert.notNull((Object)bundle, (String)"bundle should be non-null", (Object[])new Object[0]);
        this.backingBundle = bundle;
        this.bridge = bridgeLoader;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        Class<?> clazz = null;
        try {
            clazz = this.backingBundle.loadClass(name);
        }
        catch (ClassNotFoundException cnfe) {
            if (this.bridge != null) {
                try {
                    clazz = this.bridge.loadClass(name);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new ClassNotFoundException(String.valueOf(name) + " not found from bundle [" + this.bridge + "]", cnfe);
                }
                catch (NoClassDefFoundError e) {
                    NoClassDefFoundError ex = new NoClassDefFoundError(String.valueOf(name) + " not found from bundle [" + this.bridge + "]");
                    ex.initCause(e);
                    throw ex;
                }
            }
            throw new ClassNotFoundException(String.valueOf(name) + " not found from bundle [" + this.backingBundle + "]", cnfe);
        }
        catch (NoClassDefFoundError ncdfe) {
            NoClassDefFoundError e = new NoClassDefFoundError(String.valueOf(name) + " not found from bundle [" + this.backingBundle + "]");
            e.initCause(ncdfe);
            throw e;
        }
        return clazz;
    }

    @Override
    protected URL findResource(String name) {
        URL resource = this.backingBundle.getResource(name);
        if (this.bridge != null && resource == null) {
            resource = this.bridge.getResource(name);
        }
        return resource;
    }

    @Override
    protected Enumeration<URL> findResources(String name) throws IOException {
        Enumeration<URL> resources = this.backingBundle.getResources(name);
        if (this.bridge != null && resources == null) {
            resources = this.bridge.getResources(name);
        }
        return resources;
    }

    @Override
    public URL getResource(String name) {
        return this.findResource(name);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class<?> clazz = this.findClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public String toString() {
        return "BundleDelegatingClassLoader for [" + this.backingBundle + "]";
    }

    public Bundle getBundle() {
        return this.backingBundle;
    }
}

