/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.loading;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.naming.resources.ResourceAttributes;
import org.eclipse.gemini.web.tomcat.internal.loading.BundleEntry;

final class BundleEntryAttributes
extends ResourceAttributes {
    private static final int CREATION_DATE_UNKNOWN = 0;
    private static final long TIME_NOT_SET = -1L;
    private static final long CONTENT_LENGTH_NOT_SET = -1L;
    private static final long serialVersionUID = 7799793247259935763L;
    private final transient BundleEntry bundleEntry;
    private final String[] attrIds;

    BundleEntryAttributes(BundleEntry bundleEntry, String[] attrIds, URL url) {
        URLConnection urlConnection;
        this.bundleEntry = bundleEntry;
        this.attrIds = attrIds;
        this.getName();
        if (url != null) {
            this.setCollection(BundleEntry.isDirectory(url));
        }
        if ((urlConnection = this.getBundleEntryURLConnection(url)) != null) {
            long lastModified = this.getLastModified(urlConnection);
            this.getCreation(urlConnection, lastModified);
            this.getContentLength(urlConnection);
        }
    }

    public long getCreation() {
        return this.getCreation(null, -1L);
    }

    private long getCreation(URLConnection urlConnection, long lastModified) {
        long creation = -1L;
        if ((this.attrPresent("creationdate") || this.attrPresent("creation-date")) && (creation = super.getCreation()) == -1L) {
            if (urlConnection == null) {
                urlConnection = this.getBundleEntryURLConnection(this.bundleEntry.getURL());
            }
            if (urlConnection != null && (creation = this.determineDate(urlConnection)) == 0L) {
                if (lastModified == -1L) {
                    lastModified = this.determineLastModified(urlConnection);
                }
                creation = lastModified;
            }
            if (creation != -1L) {
                this.setCreation(creation);
            }
        }
        return creation;
    }

    private long determineDate(URLConnection urlConnection) {
        return urlConnection.getDate();
    }

    private boolean attrPresent(String attrId) {
        if (this.attrIds == null) {
            return true;
        }
        String[] stringArray = this.attrIds;
        int n = this.attrIds.length;
        int n2 = 0;
        while (n2 < n) {
            String ai = stringArray[n2];
            if (ai.equals(attrId)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public long getLastModified() {
        return this.getLastModified(null);
    }

    private long getLastModified(URLConnection urlConnection) {
        long lastModified = -1L;
        if ((this.attrPresent("getlastmodified") || this.attrPresent("last-modified")) && (lastModified = super.getLastModified()) == -1L) {
            if (urlConnection == null) {
                urlConnection = this.getBundleEntryURLConnection(this.bundleEntry.getURL());
            }
            if (urlConnection != null) {
                lastModified = this.determineLastModified(urlConnection);
            }
            if (lastModified != -1L) {
                this.setLastModified(lastModified);
            }
        }
        return lastModified;
    }

    private long determineLastModified(URLConnection urlConnection) {
        return urlConnection.getLastModified();
    }

    public String getName() {
        if (!this.attrPresent("displayname")) {
            return null;
        }
        String name = super.getName();
        if (name == null) {
            name = this.bundleEntry.getName();
        }
        return name;
    }

    public long getContentLength() {
        return this.getContentLength(null);
    }

    private long getContentLength(URLConnection urlConnection) {
        long contentLength = -1L;
        if ((this.attrPresent("getcontentlength") || this.attrPresent("content-length")) && (contentLength = super.getContentLength()) == -1L) {
            if (urlConnection == null) {
                urlConnection = this.getBundleEntryURLConnection(this.bundleEntry.getURL());
            }
            if ((contentLength = this.determineContentLength(urlConnection)) != -1L) {
                this.setContentLength(contentLength);
            }
        }
        return contentLength;
    }

    private long determineContentLength(URLConnection urlConnection) {
        return this.bundleEntry.getContentLength(urlConnection);
    }

    private URLConnection getBundleEntryURLConnection(URL url) {
        try {
            if (url != null) {
                return url.openConnection();
            }
            return null;
        }
        catch (IOException iOException) {
            return null;
        }
    }
}

