/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.List;
import java.util.function.Supplier;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherDiscoveryRequest;
import org.junit.platform.launcher.LauncherInterceptor;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.TestPlan;
import org.junit.platform.launcher.core.DelegatingLauncher;
import org.junit.platform.launcher.core.InterceptingLauncher;

class DefaultLauncherSession
implements LauncherSession {
    private static final LauncherInterceptor NOOP_INTERCEPTOR = new LauncherInterceptor(){

        @Override
        public <T> T intercept(LauncherInterceptor.Invocation<T> invocation) {
            return invocation.proceed();
        }

        @Override
        public void close() {
        }
    };
    private final LauncherInterceptor interceptor;
    private final LauncherSessionListener listener;
    private final DelegatingLauncher launcher;

    DefaultLauncherSession(List<LauncherInterceptor> interceptors, Supplier<LauncherSessionListener> listenerSupplier, Supplier<Launcher> launcherSupplier) {
        Launcher launcher;
        this.interceptor = DefaultLauncherSession.composite(interceptors);
        if (this.interceptor == NOOP_INTERCEPTOR) {
            this.listener = listenerSupplier.get();
            launcher = launcherSupplier.get();
        } else {
            this.listener = this.interceptor.intercept(listenerSupplier::get);
            launcher = new InterceptingLauncher(this.interceptor.intercept(launcherSupplier::get), this.interceptor);
        }
        this.launcher = new DelegatingLauncher(launcher);
        this.listener.launcherSessionOpened(this);
    }

    @Override
    public Launcher getLauncher() {
        return this.launcher;
    }

    LauncherSessionListener getListener() {
        return this.listener;
    }

    @Override
    public void close() {
        if (this.launcher.delegate != ClosedLauncher.INSTANCE) {
            this.launcher.delegate = ClosedLauncher.INSTANCE;
            this.listener.launcherSessionClosed(this);
            this.interceptor.close();
        }
    }

    private static LauncherInterceptor composite(List<LauncherInterceptor> interceptors) {
        if (interceptors.isEmpty()) {
            return NOOP_INTERCEPTOR;
        }
        return interceptors.stream().skip(1L).reduce(interceptors.get(0), (a, b) -> new LauncherInterceptor(){
            final /* synthetic */ LauncherInterceptor val$a;
            final /* synthetic */ LauncherInterceptor val$b;
            {
                this.val$a = launcherInterceptor;
                this.val$b = launcherInterceptor2;
            }

            @Override
            public void close() {
                try {
                    this.val$a.close();
                }
                finally {
                    this.val$b.close();
                }
            }

            @Override
            public <T> T intercept(LauncherInterceptor.Invocation<T> invocation) {
                return (T)this.val$a.intercept(() -> this.val$b.intercept(invocation));
            }
        });
    }

    private static class ClosedLauncher
    implements Launcher {
        static final ClosedLauncher INSTANCE = new ClosedLauncher();

        private ClosedLauncher() {
        }

        @Override
        public void registerLauncherDiscoveryListeners(LauncherDiscoveryListener ... listeners) {
            throw new PreconditionViolationException("Launcher session has already been closed");
        }

        @Override
        public void registerTestExecutionListeners(TestExecutionListener ... listeners) {
            throw new PreconditionViolationException("Launcher session has already been closed");
        }

        @Override
        public TestPlan discover(LauncherDiscoveryRequest launcherDiscoveryRequest) {
            throw new PreconditionViolationException("Launcher session has already been closed");
        }

        @Override
        public void execute(LauncherDiscoveryRequest launcherDiscoveryRequest, TestExecutionListener ... listeners) {
            throw new PreconditionViolationException("Launcher session has already been closed");
        }

        @Override
        public void execute(TestPlan testPlan, TestExecutionListener ... listeners) {
            throw new PreconditionViolationException("Launcher session has already been closed");
        }
    }
}

