/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.lang.rdfxml;

import org.apache.jena.riot.Lang;
import org.apache.jena.riot.LangBuilder;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.ReaderRIOTFactory;
import org.apache.jena.riot.lang.rdfxml.ReaderRDFXML_ARP0;
import org.apache.jena.riot.lang.rdfxml.ReaderRDFXML_ARP1;
import org.apache.jena.riot.lang.rdfxml.rrx.ReaderRDFXML_SAX;
import org.apache.jena.riot.lang.rdfxml.rrx_stax_ev.ReaderRDFXML_StAX_EV;
import org.apache.jena.riot.lang.rdfxml.rrx_stax_sr.ReaderRDFXML_StAX_SR;

public class RRX {
    public static final Lang RDFXML_SAX = LangBuilder.create("RDFXML-SAX", "application/rdf+sax").addAltNames("RRX-SAX", "rrxsax").addFileExtensions("rdfsax").build();
    public static final Lang RDFXML_StAX_ev = LangBuilder.create("RDFXML-StAX-EV", "application/rdf+stax-ev").addAltNames("RRX-StAX-ev", "rrxstaxev").addFileExtensions("rdfstaxev").build();
    public static final Lang RDFXML_StAX_sr = LangBuilder.create("RDFXML-StAX-SR", "application/rdf+stax-sr").addAltNames("RRX-StAX-sr", "rrxstaxsr").addFileExtensions("rdfstaxsr").build();
    @Deprecated(forRemoval=true)
    public static final Lang RDFXML_ARP1 = LangBuilder.create("RDFXML-ARP1", "application/rdf+arp1").addAltContentTypes("application/rdf+arp").addAltNames("arp1", "arp", "RDFXML-ARP").addFileExtensions("arp1", "arp").build();
    @Deprecated(forRemoval=true)
    public static final Lang RDFXML_ARP0 = LangBuilder.create("RDFXML-ARP0", "application/rdf+arp0").addAltNames("arp0").addFileExtensions("arp0").build();

    public static void register() {
        RRX.register(RDFXML_SAX, ReaderRDFXML_SAX.factory);
        RRX.register(RDFXML_StAX_ev, ReaderRDFXML_StAX_EV.factory);
        RRX.register(RDFXML_StAX_sr, ReaderRDFXML_StAX_SR.factory);
        RRX.register(RDFXML_ARP1, ReaderRDFXML_ARP1.factory);
        RRX.register(RDFXML_ARP0, ReaderRDFXML_ARP0.factory);
    }

    private static void register(Lang lang, ReaderRIOTFactory factory) {
        RDFLanguages.register(lang);
        RDFParserRegistry.registerLangTriples(lang, factory);
    }

    public static void unregister() {
        RRX.unregister(RDFXML_SAX);
        RRX.unregister(RDFXML_StAX_ev);
        RRX.unregister(RDFXML_StAX_sr);
        RRX.unregister(RDFXML_ARP1);
        RRX.unregister(RDFXML_ARP0);
    }

    private static void unregister(Lang lang) {
        RDFParserRegistry.removeRegistration(lang);
        RDFLanguages.unregister(lang);
    }
}

