/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.gitflow.op;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.op.PushOperation;
import org.eclipse.egit.core.op.PushOperationResult;
import org.eclipse.egit.gitflow.Activator;
import org.eclipse.egit.gitflow.GitFlowRepository;
import org.eclipse.egit.gitflow.internal.CoreText;
import org.eclipse.egit.gitflow.op.GitFlowOperation;

public class CurrentBranchPublishOperation
extends GitFlowOperation {
    private PushOperationResult operationResult;
    private int timeout;

    public CurrentBranchPublishOperation(GitFlowRepository repository, int timeout) throws CoreException {
        super(repository);
        this.timeout = timeout;
    }

    public void execute(IProgressMonitor monitor) throws CoreException {
        try {
            PushOperation pushOperation = new PushOperation(this.repository.getRepository(), "origin", false, this.timeout);
            pushOperation.run(monitor);
            this.operationResult = pushOperation.getOperationResult();
        }
        catch (InvocationTargetException e) {
            Throwable targetException = e.getTargetException();
            throw new CoreException(Activator.error(targetException.getMessage(), targetException));
        }
        String newLocalBranch = this.getCurrentBranchhName();
        try {
            this.repository.setRemote(newLocalBranch, "origin");
            this.repository.setUpstreamBranchName(newLocalBranch, this.repository.getRepository().getFullBranch());
        }
        catch (IOException e) {
            throw new CoreException(Activator.error(CoreText.unableToStoreGitConfig, e));
        }
    }

    public PushOperationResult getOperationResult() {
        return this.operationResult;
    }

    private String getCurrentBranchhName() {
        try {
            return this.repository.getRepository().getBranch();
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return null;
    }
}

