/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.javascript.host.css;

import com.gargoylesoftware.css.parser.media.MediaQuery;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.css.CssMediaList;
import com.gargoylesoftware.htmlunit.javascript.HtmlUnitScriptable;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxClass;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxConstructor;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxFunction;
import com.gargoylesoftware.htmlunit.javascript.configuration.JsxGetter;
import com.gargoylesoftware.htmlunit.javascript.configuration.SupportedBrowser;
import com.gargoylesoftware.htmlunit.javascript.host.css.CSSStyleSheet;
import net.sourceforge.htmlunit.corejs.javascript.Scriptable;

@JsxClass
public class MediaList
extends HtmlUnitScriptable {
    private final CssMediaList cssMediaList_;

    @JsxConstructor(value={SupportedBrowser.CHROME, SupportedBrowser.EDGE, SupportedBrowser.FF, SupportedBrowser.FF_ESR})
    public MediaList() {
        this.cssMediaList_ = null;
    }

    public MediaList(CSSStyleSheet parent, CssMediaList cssMediaList) {
        this.cssMediaList_ = cssMediaList;
        this.setParentScope((Scriptable)parent);
        this.setPrototype(this.getPrototype(this.getClass()));
    }

    @JsxFunction
    public String item(int index) {
        if (this.cssMediaList_ == null || index < 0 || index >= this.getLength()) {
            return null;
        }
        MediaQuery mq = this.cssMediaList_.getMediaQuery(index);
        return mq.toString();
    }

    @JsxGetter
    public int getLength() {
        if (this.cssMediaList_ == null) {
            return 0;
        }
        return this.cssMediaList_.getLength();
    }

    @JsxGetter
    public String getMediaText() {
        if (this.cssMediaList_ == null) {
            return null;
        }
        return this.cssMediaList_.getMediaText();
    }

    @Override
    public Object getDefaultValue(Class<?> hint) {
        if (this.getPrototype() != null && this.cssMediaList_ != null) {
            if (this.cssMediaList_.getLength() == 0) {
                BrowserVersion browserVersion = this.getBrowserVersion();
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_MEDIA_LIST_EMPTY_STRING)) {
                    return "";
                }
                if (browserVersion.hasFeature(BrowserVersionFeatures.JS_MEDIA_LIST_ALL)) {
                    return "all";
                }
            }
            return this.cssMediaList_.getMediaText();
        }
        return super.getDefaultValue(hint);
    }
}

