/*
 * Decompiled with CFR 0.152.
 */
package com.gargoylesoftware.htmlunit.html;

import com.gargoylesoftware.htmlunit.BrowserVersionFeatures;
import com.gargoylesoftware.htmlunit.ElementNotFoundException;
import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.SgmlPage;
import com.gargoylesoftware.htmlunit.WebAssert;
import com.gargoylesoftware.htmlunit.html.DisabledElement;
import com.gargoylesoftware.htmlunit.html.DomAttr;
import com.gargoylesoftware.htmlunit.html.DomElement;
import com.gargoylesoftware.htmlunit.html.DomNode;
import com.gargoylesoftware.htmlunit.html.FormFieldWithNameHistory;
import com.gargoylesoftware.htmlunit.html.HtmlElement;
import com.gargoylesoftware.htmlunit.html.HtmlInput;
import com.gargoylesoftware.htmlunit.html.HtmlOption;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.html.LabelableElement;
import com.gargoylesoftware.htmlunit.html.SubmittableElement;
import com.gargoylesoftware.htmlunit.html.ValidatableElement;
import com.gargoylesoftware.htmlunit.javascript.host.event.Event;
import com.gargoylesoftware.htmlunit.javascript.host.event.MouseEvent;
import com.gargoylesoftware.htmlunit.util.NameValuePair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class HtmlSelect
extends HtmlElement
implements DisabledElement,
SubmittableElement,
LabelableElement,
FormFieldWithNameHistory,
ValidatableElement {
    public static final String TAG_NAME = "select";
    private final String originalName_;
    private Collection<String> newNames_ = Collections.emptySet();
    private int lastSelectedIndex_ = -1;
    private String customValidity_;

    HtmlSelect(String qualifiedName, SgmlPage page, Map<String, DomAttr> attributes) {
        super(qualifiedName, page, attributes);
        this.originalName_ = this.getNameAttribute();
    }

    @Override
    public void onAllChildrenAddedToPage(boolean postponed) {
        List<HtmlOption> options;
        int size;
        try {
            size = Integer.parseInt(this.getSizeAttribute());
            if (size < 0) {
                this.removeAttribute("size");
                size = 0;
            }
        }
        catch (NumberFormatException e) {
            this.removeAttribute("size");
            size = 0;
        }
        if (this.getSelectedOptions().isEmpty() && size <= 1 && !this.isMultipleSelectEnabled() && !(options = this.getOptions()).isEmpty()) {
            HtmlOption first = options.get(0);
            first.setSelectedInternal(true);
        }
    }

    @Override
    public boolean handles(Event event) {
        if (event instanceof MouseEvent && this.hasFeature(BrowserVersionFeatures.EVENT_MOUSE_ON_DISABLED)) {
            return true;
        }
        return super.handles(event);
    }

    public List<HtmlOption> getSelectedOptions() {
        ArrayList<HtmlOption> result;
        if (this.isMultipleSelectEnabled()) {
            result = new ArrayList<HtmlOption>();
            for (HtmlElement element : this.getHtmlElementDescendants()) {
                if (!(element instanceof HtmlOption) || !((HtmlOption)element).isSelected()) continue;
                result.add((HtmlOption)element);
            }
        } else {
            result = new ArrayList(1);
            HtmlOption lastSelected = null;
            for (HtmlElement element : this.getHtmlElementDescendants()) {
                HtmlOption option;
                if (!(element instanceof HtmlOption) || !(option = (HtmlOption)element).isSelected()) continue;
                lastSelected = option;
            }
            if (lastSelected != null) {
                result.add(lastSelected);
            }
        }
        return Collections.unmodifiableList(result);
    }

    public List<HtmlOption> getOptions() {
        return Collections.unmodifiableList(this.getElementsByTagNameImpl("option"));
    }

    public HtmlOption getOption(int index) {
        return (HtmlOption)this.getElementsByTagNameImpl("option").get(index);
    }

    public int getOptionSize() {
        return this.getElementsByTagName("option").size();
    }

    public void setOptionSize(int newLength) {
        NodeList elementList = this.getElementsByTagName("option");
        for (int i = elementList.size() - 1; i >= newLength; --i) {
            ((HtmlElement)elementList.get(i)).remove();
        }
    }

    public void removeOption(int index) {
        DomElement.ChildElementsIterator iterator = new DomElement.ChildElementsIterator(this);
        int i = 0;
        while (iterator.hasNext()) {
            DomElement element = iterator.next();
            if (!(element instanceof HtmlOption)) continue;
            if (i == index) {
                element.remove();
                this.ensureSelectedIndex();
                return;
            }
            ++i;
        }
    }

    public void replaceOption(int index, HtmlOption newOption) {
        DomElement.ChildElementsIterator iterator = new DomElement.ChildElementsIterator(this);
        int i = 0;
        while (iterator.hasNext()) {
            DomElement element = iterator.next();
            if (!(element instanceof HtmlOption)) continue;
            if (i == index) {
                element.replace(newOption);
                this.ensureSelectedIndex();
                return;
            }
            ++i;
        }
        if (newOption.isSelected()) {
            this.setSelectedAttribute(newOption, true);
        }
    }

    public void appendOption(HtmlOption newOption) {
        this.appendChild(newOption);
        this.ensureSelectedIndex();
    }

    @Override
    public DomNode appendChild(Node node) {
        HtmlOption option;
        DomNode response = super.appendChild(node);
        if (node instanceof HtmlOption && (option = (HtmlOption)node).isSelected()) {
            this.doSelectOption(option, true, false, false, false);
        }
        return response;
    }

    public <P extends Page> P setSelectedAttribute(String optionValue, boolean isSelected) {
        return this.setSelectedAttribute(optionValue, isSelected, true);
    }

    public <P extends Page> P setSelectedAttribute(String optionValue, boolean isSelected, boolean invokeOnFocus) {
        try {
            boolean attributeOnly = this.hasFeature(BrowserVersionFeatures.JS_SELECT_SET_VALUES_CHECKS_ONLY_VALUE_ATTRIBUTE) && !optionValue.isEmpty();
            HtmlOption selected = attributeOnly ? this.getOptionByValueStrict(optionValue) : this.getOptionByValue(optionValue);
            return this.setSelectedAttribute(selected, isSelected, invokeOnFocus, true, false, true);
        }
        catch (ElementNotFoundException e) {
            for (HtmlOption o : this.getSelectedOptions()) {
                o.setSelected(false);
            }
            return (P)this.getPage();
        }
    }

    public <P extends Page> P setSelectedAttribute(HtmlOption selectedOption, boolean isSelected) {
        return this.setSelectedAttribute(selectedOption, isSelected, true, true, false, true);
    }

    public <P extends Page> P setSelectedAttribute(HtmlOption selectedOption, boolean isSelected, boolean invokeOnFocus, boolean shiftKey, boolean ctrlKey, boolean isClick) {
        boolean changeSelectedState;
        if (isSelected && invokeOnFocus) {
            ((HtmlPage)this.getPage()).setFocusedElement(this);
        }
        boolean bl = changeSelectedState = selectedOption.isSelected() != isSelected;
        if (changeSelectedState) {
            this.doSelectOption(selectedOption, isSelected, shiftKey, ctrlKey, isClick);
            HtmlInput.executeOnChangeHandlerIfAppropriate(this);
        }
        return (P)this.getPage().getWebClient().getCurrentWindow().getEnclosedPage();
    }

    private void doSelectOption(HtmlOption selectedOption, boolean isSelected, boolean shiftKey, boolean ctrlKey, boolean isClick) {
        if (this.isMultipleSelectEnabled()) {
            selectedOption.setSelectedInternal(isSelected);
            if (isClick && !ctrlKey) {
                if (!shiftKey) {
                    this.setOnlySelected(selectedOption, isSelected);
                    this.lastSelectedIndex_ = this.getOptions().indexOf(selectedOption);
                } else if (isSelected && this.lastSelectedIndex_ != -1) {
                    List<HtmlOption> options = this.getOptions();
                    int newIndex = options.indexOf(selectedOption);
                    for (int i = 0; i < options.size(); ++i) {
                        options.get(i).setSelectedInternal(HtmlSelect.isBetween(i, this.lastSelectedIndex_, newIndex));
                    }
                }
            }
        } else {
            this.setOnlySelected(selectedOption, isSelected);
        }
    }

    void setOnlySelected(HtmlOption selectedOption, boolean isSelected) {
        for (HtmlOption option : this.getOptions()) {
            option.setSelectedInternal(option == selectedOption && isSelected);
        }
    }

    private static boolean isBetween(int number, int min, int max) {
        return max > min ? number >= min && number <= max : number >= max && number <= min;
    }

    @Override
    public NameValuePair[] getSubmitNameValuePairs() {
        String name = this.getNameAttribute();
        List<HtmlOption> selectedOptions = this.getSelectedOptions();
        NameValuePair[] pairs = new NameValuePair[selectedOptions.size()];
        int i = 0;
        for (HtmlOption option : selectedOptions) {
            pairs[i++] = new NameValuePair(name, option.getValueAttribute());
        }
        return pairs;
    }

    boolean isValidForSubmission() {
        return this.getOptionSize() > 0;
    }

    @Override
    public void reset() {
        for (HtmlOption option : this.getOptions()) {
            option.reset();
        }
        this.onAllChildrenAddedToPage(false);
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        this.setSelectedAttribute(defaultValue, true);
    }

    @Override
    public String getDefaultValue() {
        List<HtmlOption> options = this.getSelectedOptions();
        if (options.size() > 0) {
            return options.get(0).getValueAttribute();
        }
        return "";
    }

    @Override
    public void setDefaultChecked(boolean defaultChecked) {
    }

    @Override
    public boolean isDefaultChecked() {
        return false;
    }

    public boolean isMultipleSelectEnabled() {
        return this.getAttributeDirect("multiple") != ATTRIBUTE_NOT_DEFINED;
    }

    public HtmlOption getOptionByValue(String value) throws ElementNotFoundException {
        WebAssert.notNull("value", value);
        for (HtmlOption option : this.getOptions()) {
            if (!option.getValueAttribute().equals(value)) continue;
            return option;
        }
        throw new ElementNotFoundException("option", "value", value);
    }

    private HtmlOption getOptionByValueStrict(String value) throws ElementNotFoundException {
        WebAssert.notNull("value", value);
        for (HtmlOption option : this.getOptions()) {
            if (!option.getAttributeDirect("value").equals(value)) continue;
            return option;
        }
        throw new ElementNotFoundException("option", "value", value);
    }

    public HtmlOption getOptionByText(String text) throws ElementNotFoundException {
        WebAssert.notNull("text", text);
        for (HtmlOption option : this.getOptions()) {
            if (!option.getText().equals(text)) continue;
            return option;
        }
        throw new ElementNotFoundException("option", "text", text);
    }

    public final String getNameAttribute() {
        return this.getAttributeDirect("name");
    }

    public final String getSizeAttribute() {
        return this.getAttributeDirect("size");
    }

    public final int getSize() {
        int size = 0;
        String sizeAttribute = this.getSizeAttribute();
        if (ATTRIBUTE_NOT_DEFINED != sizeAttribute && sizeAttribute != DomElement.ATTRIBUTE_VALUE_EMPTY) {
            try {
                size = Integer.parseInt(sizeAttribute);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return size;
    }

    public final String getMultipleAttribute() {
        return this.getAttributeDirect("multiple");
    }

    @Override
    public final String getDisabledAttribute() {
        return this.getAttributeDirect("disabled");
    }

    @Override
    public final boolean isDisabled() {
        return this.hasAttribute("disabled");
    }

    public boolean isReadOnly() {
        return this.hasAttribute("readOnly");
    }

    public final String getTabIndexAttribute() {
        return this.getAttributeDirect("tabindex");
    }

    public final String getOnFocusAttribute() {
        return this.getAttributeDirect("onfocus");
    }

    public final String getOnBlurAttribute() {
        return this.getAttributeDirect("onblur");
    }

    public final String getOnChangeAttribute() {
        return this.getAttributeDirect("onchange");
    }

    @Override
    protected void setAttributeNS(String namespaceURI, String qualifiedName, String attributeValue, boolean notifyAttributeChangeListeners, boolean notifyMutationObservers) {
        if ("name".equals(qualifiedName)) {
            if (this.newNames_.isEmpty()) {
                this.newNames_ = new HashSet<String>();
            }
            this.newNames_.add(attributeValue);
        }
        super.setAttributeNS(namespaceURI, qualifiedName, attributeValue, notifyAttributeChangeListeners, notifyMutationObservers);
    }

    @Override
    public String getOriginalName() {
        return this.originalName_;
    }

    @Override
    public Collection<String> getNewNames() {
        return this.newNames_;
    }

    @Override
    public HtmlElement.DisplayStyle getDefaultStyleDisplay() {
        return HtmlElement.DisplayStyle.INLINE_BLOCK;
    }

    public int getSelectedIndex() {
        List<HtmlOption> selectedOptions = this.getSelectedOptions();
        if (selectedOptions.isEmpty()) {
            return -1;
        }
        List<HtmlOption> allOptions = this.getOptions();
        return allOptions.indexOf(selectedOptions.get(0));
    }

    public void setSelectedIndex(int index) {
        for (HtmlOption itemToUnSelect : this.getSelectedOptions()) {
            this.setSelectedAttribute(itemToUnSelect, false);
        }
        if (index < 0) {
            return;
        }
        List<HtmlOption> allOptions = this.getOptions();
        if (index < allOptions.size()) {
            HtmlOption itemToSelect = allOptions.get(index);
            this.setSelectedAttribute(itemToSelect, true, false, true, false, true);
        }
    }

    public void ensureSelectedIndex() {
        if (this.getOptionSize() == 0) {
            this.setSelectedIndex(-1);
        } else if (this.getSelectedIndex() == -1 && !this.isMultipleSelectEnabled()) {
            this.setSelectedIndex(0);
        }
    }

    public int indexOf(HtmlOption option) {
        if (option == null) {
            return 0;
        }
        int index = 0;
        for (HtmlElement element : this.getHtmlElementDescendants()) {
            if (option == element) {
                return index;
            }
            ++index;
        }
        return 0;
    }

    @Override
    protected boolean isRequiredSupported() {
        return true;
    }

    @Override
    public boolean willValidate() {
        return this.hasFeature(BrowserVersionFeatures.HTMLSELECT_WILL_VALIDATE_ALWAYS_TRUE) || !this.isDisabled() && (this.hasFeature(BrowserVersionFeatures.HTMLSELECT_WILL_VALIDATE_IGNORES_READONLY) || !this.isReadOnly());
    }

    @Override
    public void setCustomValidity(String message) {
        this.customValidity_ = message;
    }

    @Override
    public boolean isValid() {
        return this.isValidValidityState();
    }

    @Override
    public boolean isCustomErrorValidityState() {
        return !StringUtils.isEmpty((CharSequence)this.customValidity_);
    }

    @Override
    public boolean isValidValidityState() {
        return !this.isCustomErrorValidityState() && !this.isValueMissingValidityState();
    }

    @Override
    public boolean isValueMissingValidityState() {
        return ATTRIBUTE_NOT_DEFINED != this.getAttributeDirect("required") && this.getSelectedOptions().isEmpty();
    }
}

