/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.mvc.instances.proxy;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import ee.jakarta.tck.mvc.tests.mvc.instances.proxy.ApplicationScopedController;
import ee.jakarta.tck.mvc.tests.mvc.instances.proxy.RequestScopedBean;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class InjectProxyTest {
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(ApplicationScopedController.class).addClass(RequestScopedBean.class).addView("proxy = '${proxy}'", "view.jsp").build();
    }

    @Test
    @SpecAssertion(section="controller_instances", id="scope-proxy")
    public void injectProxyIfRequired() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/proxy").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"proxy = 'true'"));
    }
}

