/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.mvc.instances.cdi;

import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebResponse;
import ee.jakarta.tck.mvc.tests.mvc.instances.cdi.CdiController;
import ee.jakarta.tck.mvc.tests.mvc.instances.cdi.HybridController;
import ee.jakarta.tck.mvc.tests.mvc.instances.cdi.SomeCdiBean;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class CdiControllerTest {
    @ArquillianResource
    private URL baseUrl;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive().addClass(CdiController.class).addClass(HybridController.class).addClass(SomeCdiBean.class).addView("Text = '${text}'", "injection.jsp").build();
    }

    @Test
    @SpecAssertion(section="controller_instances", id="ctrl-cdi")
    public void controllerCdiInjection() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/cdi/injection").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Text = 'Text from injected bean'"));
    }

    @Test
    @SpecAssertion(section="controller_instances", id="ctrl-cdi-hybrid")
    public void hybridCdiInjection() throws IOException {
        WebResponse response = new WebClient().getPage(this.baseUrl.toString() + "mvc/hybrid/injection").getWebResponse();
        Assert.assertThat((Object)response.getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)response.getContentAsString(), (Matcher)CoreMatchers.containsString((String)"Text = 'Text from injected bean'"));
    }
}

