/*
 * Decompiled with CFR 0.152.
 */
package ee.jakarta.tck.mvc.tests.application.app;

import com.gargoylesoftware.htmlunit.Page;
import com.gargoylesoftware.htmlunit.WebClient;
import ee.jakarta.tck.mvc.tests.application.app.MvcAppAnnotationApplication;
import ee.jakarta.tck.mvc.tests.application.app.MvcAppAnnotationController;
import ee.jakarta.tck.mvc.util.Archives;
import java.io.IOException;
import java.net.URL;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.test.audit.annotations.SpecAssertion;
import org.jboss.test.audit.annotations.SpecAssertions;
import org.jboss.test.audit.annotations.SpecVersion;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
@SpecVersion(spec="mvc", version="1.0")
public class MvcAppAnnotationTest {
    @ArquillianResource
    private URL baseUrl;
    private WebClient webClient;

    @Deployment(testable=false)
    public static WebArchive createDeployment() {
        return Archives.getMvcArchive(MvcAppAnnotationApplication.class).addClass(MvcAppAnnotationController.class).addView("1 + 2 = ${1+2}", "view.jsp").build();
    }

    @Before
    public void before() {
        this.webClient = new WebClient();
        this.webClient.getOptions().setThrowExceptionOnFailingStatusCode(false);
        this.webClient.getOptions().setRedirectEnabled(false);
    }

    @Test
    @SpecAssertions(value={@SpecAssertion(section="mvc_applications", id="application-class"), @SpecAssertion(section="mvc_applications", id="url-space")})
    public void testUrlSpaceViaAnnotation() throws IOException {
        Page page = this.webClient.getPage(this.baseUrl.toString() + "annotation-app-path/application/app/annotation");
        Assert.assertThat((Object)page.getWebResponse().getStatusCode(), (Matcher)CoreMatchers.equalTo((Object)200));
        Assert.assertThat((Object)page.getWebResponse().getContentAsString(), (Matcher)CoreMatchers.containsString((String)"1 + 2 = 3"));
    }
}

