/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.URLs;

import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class URLWithScheme {
    @Nonnull
    public final String scheme;
    @Nullable
    public final String host;
    @Nullable
    public final Integer port;
    @Nonnull
    public final String path;

    protected URLWithScheme(@Nonnull String scheme, @Nullable String host, @Nullable Integer port, @Nonnull String path) {
        this.scheme = scheme.toLowerCase(Locale.ENGLISH);
        this.host = host == null ? host : host.toLowerCase(Locale.ENGLISH);
        this.port = port;
        this.path = path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof URLWithScheme)) {
            return false;
        }
        URLWithScheme that = (URLWithScheme)o;
        return this.scheme.equals(that.scheme) && Objects.equals(this.host, that.host) && Objects.equals(this.port, that.port) && this.path.equals(that.path);
    }

    public int hashCode() {
        return Objects.hash(this.scheme, this.host, this.port, this.path);
    }
}

