/*
 * Decompiled with CFR 0.152.
 */
package com.shapesecurity.salvation2.Directives;

import com.shapesecurity.salvation2.Directive;
import com.shapesecurity.salvation2.Policy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ReportUriDirective
extends Directive {
    private List<String> uris = new ArrayList<String>();

    public ReportUriDirective(List<String> values, Directive.DirectiveErrorConsumer errors) {
        super(values);
        int index = 0;
        for (String value : values) {
            this._addUri(value, index, errors);
            ++index;
        }
        if (this.values.isEmpty()) {
            errors.add(Policy.Severity.Error, "The report-uri value requires at least one value", -1);
        }
    }

    private void _addUri(String uri, int index, Directive.DirectiveErrorConsumer errors) {
        if (this.uris.contains(uri)) {
            errors.add(Policy.Severity.Info, "Duplicate report-to URI; are you sure you intend to get multiple copies of each report?", index);
        }
        this.uris.add(uri);
    }

    public List<String> getUris() {
        return Collections.unmodifiableList(this.uris);
    }

    public void addUri(String uri, Directive.ManipulationErrorConsumer errors) {
        this._addUri(uri, -1, ReportUriDirective.wrapManipulationErrorConsumer(errors));
        this.addValue(uri);
    }

    public boolean removeUri(String uri) {
        if (!this.uris.contains(uri)) {
            return false;
        }
        while (this.uris.contains(uri)) {
            this.uris.remove(uri);
        }
        ArrayList<String> copy = new ArrayList<String>(this.values.size());
        for (String existing : this.values) {
            if (existing.equals(uri)) continue;
            copy.add(existing);
        }
        this.values = copy;
        return true;
    }
}

