/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.htmlunit.cyberneko;

public class HTMLEntitiesParser {
    public static final int STATE_START = 0;
    private static final int STATE_ENDS_WITH_SEMICOLON = -2;
    private static final int STATE_HEXADECIMAL_CHAR = -102;
    private static final int STATE_DECIMAL_CHAR = -104;
    private static final int STATE_NUMERIC_CHAR_END_SEMICOLON_MISSING = -105;
    private int state = 0;
    private int consumedCount;
    private String match;
    private int code;
    private int matchLength;

    public String getMatch() {
        return this.match;
    }

    public int getMatchLength() {
        return this.matchLength;
    }

    public int getRewindCount() {
        return this.consumedCount - this.matchLength;
    }

    public boolean endsWithSemicolon() {
        return -2 == this.state;
    }

    public void setMatchFromCode() {
        if (0 == this.code || this.code > 0x10FFFF) {
            this.match = "\ufffd";
            this.matchLength = this.consumedCount;
            return;
        }
        if (Character.isSurrogate((char)this.code)) {
            this.match = "\ufffd";
            return;
        }
        switch (this.code) {
            case 128: {
                this.match = "\u20ac";
                this.matchLength = this.consumedCount;
                return;
            }
            case 130: {
                this.match = "\u201a";
                this.matchLength = this.consumedCount;
                return;
            }
            case 131: {
                this.match = "\u0192";
                this.matchLength = this.consumedCount;
                return;
            }
            case 132: {
                this.match = "\u201e";
                this.matchLength = this.consumedCount;
                return;
            }
            case 133: {
                this.match = "\u2026";
                this.matchLength = this.consumedCount;
                return;
            }
            case 134: {
                this.match = "\u2020";
                this.matchLength = this.consumedCount;
                return;
            }
            case 135: {
                this.match = "\u2021";
                this.matchLength = this.consumedCount;
                return;
            }
            case 136: {
                this.match = "\u02c6";
                this.matchLength = this.consumedCount;
                return;
            }
            case 137: {
                this.match = "\u2030";
                this.matchLength = this.consumedCount;
                return;
            }
            case 138: {
                this.match = "\u0160";
                this.matchLength = this.consumedCount;
                return;
            }
            case 139: {
                this.match = "\u2039";
                this.matchLength = this.consumedCount;
                return;
            }
            case 140: {
                this.match = "\u0152";
                this.matchLength = this.consumedCount;
                return;
            }
            case 142: {
                this.match = "\u017d";
                this.matchLength = this.consumedCount;
                return;
            }
            case 145: {
                this.match = "\u2018";
                this.matchLength = this.consumedCount;
                return;
            }
            case 146: {
                this.match = "\u2019";
                this.matchLength = this.consumedCount;
                return;
            }
            case 147: {
                this.match = "\u201c";
                this.matchLength = this.consumedCount;
                return;
            }
            case 148: {
                this.match = "\u201d";
                this.matchLength = this.consumedCount;
                return;
            }
            case 149: {
                this.match = "\u2022";
                this.matchLength = this.consumedCount;
                return;
            }
            case 150: {
                this.match = "\u2013";
                this.matchLength = this.consumedCount;
                return;
            }
            case 151: {
                this.match = "\u2014";
                this.matchLength = this.consumedCount;
                return;
            }
            case 152: {
                this.match = "\u20dc";
                this.matchLength = this.consumedCount;
                return;
            }
            case 153: {
                this.match = "\u2122";
                this.matchLength = this.consumedCount;
                return;
            }
            case 154: {
                this.match = "\u0161";
                this.matchLength = this.consumedCount;
                return;
            }
            case 155: {
                this.match = "\u203a";
                this.matchLength = this.consumedCount;
                return;
            }
            case 156: {
                this.match = "\u0153";
                this.matchLength = this.consumedCount;
                return;
            }
            case 158: {
                this.match = "\u017e";
                this.matchLength = this.consumedCount;
                return;
            }
            case 159: {
                this.match = "\u0178";
                this.matchLength = this.consumedCount;
                return;
            }
        }
        this.match = new String(Character.toChars(this.code));
        this.matchLength = this.consumedCount;
    }

    public boolean parseNumeric(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 0: {
                if (88 == current || 120 == current) {
                    this.state = -102;
                    return true;
                }
                if (48 > current || current > 57) break;
                this.state = -104;
                this.code = this.code * 10 + current - 48;
                return true;
            }
            case -102: {
                if (48 <= current && current <= 57) {
                    this.code = this.code * 16 + current - 48;
                    return true;
                }
                if (65 <= current && current <= 70) {
                    this.code = this.code * 16 + current - 55;
                    return true;
                }
                if (97 <= current && current <= 102) {
                    this.code = this.code * 16 + current - 87;
                    return true;
                }
                if (59 == current) {
                    this.setMatchFromCode();
                    return false;
                }
                this.state = -105;
                this.setMatchFromCode();
                this.matchLength = this.consumedCount - 1;
                break;
            }
            case -104: {
                if (48 <= current && current <= 57) {
                    this.code = this.code * 10 + current - 48;
                    return true;
                }
                if (59 == current) {
                    this.setMatchFromCode();
                    return false;
                }
                this.state = -105;
                this.setMatchFromCode();
                this.matchLength = this.consumedCount - 1;
            }
        }
        return false;
    }

    private boolean parse1(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 0: {
                switch (current) {
                    case 65: {
                        this.state = 1;
                        return true;
                    }
                    case 66: {
                        this.state = 77;
                        return true;
                    }
                    case 67: {
                        this.state = 126;
                        return true;
                    }
                    case 68: {
                        this.state = 342;
                        return true;
                    }
                    case 69: {
                        this.state = 666;
                        return true;
                    }
                    case 70: {
                        this.state = 788;
                        return true;
                    }
                    case 71: {
                        this.state = 842;
                        return true;
                    }
                    case 72: {
                        this.state = 929;
                        return true;
                    }
                    case 73: {
                        this.state = 995;
                        return true;
                    }
                    case 74: {
                        this.state = 1096;
                        return true;
                    }
                    case 75: {
                        this.state = 1118;
                        return true;
                    }
                    case 76: {
                        this.state = 1143;
                        return true;
                    }
                    case 77: {
                        this.state = 1514;
                        return true;
                    }
                    case 78: {
                        this.state = 1553;
                        return true;
                    }
                    case 79: {
                        this.state = 2064;
                        return true;
                    }
                    case 80: {
                        this.state = 2173;
                        return true;
                    }
                    case 81: {
                        this.state = 2258;
                        return true;
                    }
                    case 82: {
                        this.state = 2270;
                        return true;
                    }
                    case 83: {
                        this.state = 2525;
                        return true;
                    }
                    case 84: {
                        this.state = 2722;
                        return true;
                    }
                    case 85: {
                        this.state = 2817;
                        return true;
                    }
                    case 86: {
                        this.state = 2997;
                        return true;
                    }
                    case 87: {
                        this.state = 3067;
                        return true;
                    }
                    case 88: {
                        this.state = 3084;
                        return true;
                    }
                    case 89: {
                        this.state = 3094;
                        return true;
                    }
                    case 90: {
                        this.state = 3125;
                        return true;
                    }
                    case 97: {
                        this.state = 3166;
                        return true;
                    }
                    case 98: {
                        this.state = 3311;
                        return true;
                    }
                    case 99: {
                        this.state = 3623;
                        return true;
                    }
                    case 100: {
                        this.state = 3915;
                        return true;
                    }
                    case 101: {
                        this.state = 4156;
                        return true;
                    }
                    case 102: {
                        this.state = 4342;
                        return true;
                    }
                    case 103: {
                        this.state = 4442;
                        return true;
                    }
                    case 104: {
                        this.state = 4588;
                        return true;
                    }
                    case 105: {
                        this.state = 4704;
                        return true;
                    }
                    case 106: {
                        this.state = 4847;
                        return true;
                    }
                    case 107: {
                        this.state = 4873;
                        return true;
                    }
                    case 108: {
                        this.state = 4904;
                        return true;
                    }
                    case 109: {
                        this.state = 5397;
                        return true;
                    }
                    case 110: {
                        this.state = 5510;
                        return true;
                    }
                    case 111: {
                        this.state = 5945;
                        return true;
                    }
                    case 112: {
                        this.state = 6092;
                        return true;
                    }
                    case 113: {
                        this.state = 6272;
                        return true;
                    }
                    case 114: {
                        this.state = 6309;
                        return true;
                    }
                    case 115: {
                        this.state = 6642;
                        return true;
                    }
                    case 116: {
                        this.state = 7043;
                        return true;
                    }
                    case 117: {
                        this.state = 7238;
                        return true;
                    }
                    case 118: {
                        this.state = 7408;
                        return true;
                    }
                    case 119: {
                        this.state = 7562;
                        return true;
                    }
                    case 120: {
                        this.state = 7593;
                        return true;
                    }
                    case 121: {
                        this.state = 7672;
                        return true;
                    }
                    case 122: {
                        this.state = 7702;
                        return true;
                    }
                }
                break;
            }
            case 1: {
                switch (current) {
                    case 69: {
                        this.state = 2;
                        return true;
                    }
                    case 77: {
                        this.state = 6;
                        return true;
                    }
                    case 97: {
                        this.state = 8;
                        return true;
                    }
                    case 98: {
                        this.state = 13;
                        return true;
                    }
                    case 99: {
                        this.state = 18;
                        return true;
                    }
                    case 102: {
                        this.state = 23;
                        return true;
                    }
                    case 103: {
                        this.state = 25;
                        return true;
                    }
                    case 108: {
                        this.state = 30;
                        return true;
                    }
                    case 109: {
                        this.state = 34;
                        return true;
                    }
                    case 110: {
                        this.state = 38;
                        return true;
                    }
                    case 111: {
                        this.state = 40;
                        return true;
                    }
                    case 112: {
                        this.state = 46;
                        return true;
                    }
                    case 114: {
                        this.state = 58;
                        return true;
                    }
                    case 115: {
                        this.state = 62;
                        return true;
                    }
                    case 116: {
                        this.state = 69;
                        return true;
                    }
                    case 117: {
                        this.state = 74;
                        return true;
                    }
                }
                break;
            }
            case 2: {
                switch (current) {
                    case 108: {
                        this.state = 3;
                        return true;
                    }
                }
                break;
            }
            case 3: {
                switch (current) {
                    case 105: {
                        this.state = 4;
                        return true;
                    }
                }
                break;
            }
            case 4: {
                switch (current) {
                    case 103: {
                        this.match = "\u00c6";
                        this.matchLength = this.consumedCount;
                        this.state = 5;
                        return true;
                    }
                }
                break;
            }
            case 5: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 6: {
                switch (current) {
                    case 80: {
                        this.match = "&";
                        this.matchLength = this.consumedCount;
                        this.state = 7;
                        return true;
                    }
                }
                break;
            }
            case 7: {
                switch (current) {
                    case 59: {
                        this.match = "&";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 8: {
                switch (current) {
                    case 99: {
                        this.state = 9;
                        return true;
                    }
                }
                break;
            }
            case 9: {
                switch (current) {
                    case 117: {
                        this.state = 10;
                        return true;
                    }
                }
                break;
            }
            case 10: {
                switch (current) {
                    case 116: {
                        this.state = 11;
                        return true;
                    }
                }
                break;
            }
            case 11: {
                switch (current) {
                    case 101: {
                        this.match = "\u00c1";
                        this.matchLength = this.consumedCount;
                        this.state = 12;
                        return true;
                    }
                }
                break;
            }
            case 12: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 13: {
                switch (current) {
                    case 114: {
                        this.state = 14;
                        return true;
                    }
                }
                break;
            }
            case 14: {
                switch (current) {
                    case 101: {
                        this.state = 15;
                        return true;
                    }
                }
                break;
            }
            case 15: {
                switch (current) {
                    case 118: {
                        this.state = 16;
                        return true;
                    }
                }
                break;
            }
            case 16: {
                switch (current) {
                    case 101: {
                        this.state = 17;
                        return true;
                    }
                }
                break;
            }
            case 17: {
                switch (current) {
                    case 59: {
                        this.match = "\u0102";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 18: {
                switch (current) {
                    case 105: {
                        this.state = 19;
                        return true;
                    }
                    case 121: {
                        this.state = 22;
                        return true;
                    }
                }
                break;
            }
            case 19: {
                switch (current) {
                    case 114: {
                        this.state = 20;
                        return true;
                    }
                }
                break;
            }
            case 20: {
                switch (current) {
                    case 99: {
                        this.match = "\u00c2";
                        this.matchLength = this.consumedCount;
                        this.state = 21;
                        return true;
                    }
                }
                break;
            }
            case 21: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 22: {
                switch (current) {
                    case 59: {
                        this.match = "\u0410";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 23: {
                switch (current) {
                    case 114: {
                        this.state = 24;
                        return true;
                    }
                }
                break;
            }
            case 24: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd04";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 25: {
                switch (current) {
                    case 114: {
                        this.state = 26;
                        return true;
                    }
                }
                break;
            }
            case 26: {
                switch (current) {
                    case 97: {
                        this.state = 27;
                        return true;
                    }
                }
                break;
            }
            case 27: {
                switch (current) {
                    case 118: {
                        this.state = 28;
                        return true;
                    }
                }
                break;
            }
            case 28: {
                switch (current) {
                    case 101: {
                        this.match = "\u00c0";
                        this.matchLength = this.consumedCount;
                        this.state = 29;
                        return true;
                    }
                }
                break;
            }
            case 29: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 30: {
                switch (current) {
                    case 112: {
                        this.state = 31;
                        return true;
                    }
                }
                break;
            }
            case 31: {
                switch (current) {
                    case 104: {
                        this.state = 32;
                        return true;
                    }
                }
                break;
            }
            case 32: {
                switch (current) {
                    case 97: {
                        this.state = 33;
                        return true;
                    }
                }
                break;
            }
            case 33: {
                switch (current) {
                    case 59: {
                        this.match = "\u0391";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 34: {
                switch (current) {
                    case 97: {
                        this.state = 35;
                        return true;
                    }
                }
                break;
            }
            case 35: {
                switch (current) {
                    case 99: {
                        this.state = 36;
                        return true;
                    }
                }
                break;
            }
            case 36: {
                switch (current) {
                    case 114: {
                        this.state = 37;
                        return true;
                    }
                }
                break;
            }
            case 37: {
                switch (current) {
                    case 59: {
                        this.match = "\u0100";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 38: {
                switch (current) {
                    case 100: {
                        this.state = 39;
                        return true;
                    }
                }
                break;
            }
            case 39: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a53";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 40: {
                switch (current) {
                    case 103: {
                        this.state = 41;
                        return true;
                    }
                    case 112: {
                        this.state = 44;
                        return true;
                    }
                }
                break;
            }
            case 41: {
                switch (current) {
                    case 111: {
                        this.state = 42;
                        return true;
                    }
                }
                break;
            }
            case 42: {
                switch (current) {
                    case 110: {
                        this.state = 43;
                        return true;
                    }
                }
                break;
            }
            case 43: {
                switch (current) {
                    case 59: {
                        this.match = "\u0104";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 44: {
                switch (current) {
                    case 102: {
                        this.state = 45;
                        return true;
                    }
                }
                break;
            }
            case 45: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd38";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 46: {
                switch (current) {
                    case 112: {
                        this.state = 47;
                        return true;
                    }
                }
                break;
            }
            case 47: {
                switch (current) {
                    case 108: {
                        this.state = 48;
                        return true;
                    }
                }
                break;
            }
            case 48: {
                switch (current) {
                    case 121: {
                        this.state = 49;
                        return true;
                    }
                }
                break;
            }
            case 49: {
                switch (current) {
                    case 70: {
                        this.state = 50;
                        return true;
                    }
                }
                break;
            }
            case 50: {
                switch (current) {
                    case 117: {
                        this.state = 51;
                        return true;
                    }
                }
                break;
            }
            case 51: {
                switch (current) {
                    case 110: {
                        this.state = 52;
                        return true;
                    }
                }
                break;
            }
            case 52: {
                switch (current) {
                    case 99: {
                        this.state = 53;
                        return true;
                    }
                }
                break;
            }
            case 53: {
                switch (current) {
                    case 116: {
                        this.state = 54;
                        return true;
                    }
                }
                break;
            }
            case 54: {
                switch (current) {
                    case 105: {
                        this.state = 55;
                        return true;
                    }
                }
                break;
            }
            case 55: {
                switch (current) {
                    case 111: {
                        this.state = 56;
                        return true;
                    }
                }
                break;
            }
            case 56: {
                switch (current) {
                    case 110: {
                        this.state = 57;
                        return true;
                    }
                }
                break;
            }
            case 57: {
                switch (current) {
                    case 59: {
                        this.match = "\u2061";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 58: {
                switch (current) {
                    case 105: {
                        this.state = 59;
                        return true;
                    }
                }
                break;
            }
            case 59: {
                switch (current) {
                    case 110: {
                        this.state = 60;
                        return true;
                    }
                }
                break;
            }
            case 60: {
                switch (current) {
                    case 103: {
                        this.match = "\u00c5";
                        this.matchLength = this.consumedCount;
                        this.state = 61;
                        return true;
                    }
                }
                break;
            }
            case 61: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 62: {
                switch (current) {
                    case 99: {
                        this.state = 63;
                        return true;
                    }
                    case 115: {
                        this.state = 65;
                        return true;
                    }
                }
                break;
            }
            case 63: {
                switch (current) {
                    case 114: {
                        this.state = 64;
                        return true;
                    }
                }
                break;
            }
            case 64: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udc9c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 65: {
                switch (current) {
                    case 105: {
                        this.state = 66;
                        return true;
                    }
                }
                break;
            }
            case 66: {
                switch (current) {
                    case 103: {
                        this.state = 67;
                        return true;
                    }
                }
                break;
            }
            case 67: {
                switch (current) {
                    case 110: {
                        this.state = 68;
                        return true;
                    }
                }
                break;
            }
            case 68: {
                switch (current) {
                    case 59: {
                        this.match = "\u2254";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 69: {
                switch (current) {
                    case 105: {
                        this.state = 70;
                        return true;
                    }
                }
                break;
            }
            case 70: {
                switch (current) {
                    case 108: {
                        this.state = 71;
                        return true;
                    }
                }
                break;
            }
            case 71: {
                switch (current) {
                    case 100: {
                        this.state = 72;
                        return true;
                    }
                }
                break;
            }
            case 72: {
                switch (current) {
                    case 101: {
                        this.match = "\u00c3";
                        this.matchLength = this.consumedCount;
                        this.state = 73;
                        return true;
                    }
                }
                break;
            }
            case 73: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 74: {
                switch (current) {
                    case 109: {
                        this.state = 75;
                        return true;
                    }
                }
                break;
            }
            case 75: {
                switch (current) {
                    case 108: {
                        this.match = "\u00c4";
                        this.matchLength = this.consumedCount;
                        this.state = 76;
                        return true;
                    }
                }
                break;
            }
            case 76: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 77: {
                switch (current) {
                    case 97: {
                        this.state = 78;
                        return true;
                    }
                    case 99: {
                        this.state = 91;
                        return true;
                    }
                    case 101: {
                        this.state = 93;
                        return true;
                    }
                    case 102: {
                        this.state = 109;
                        return true;
                    }
                    case 111: {
                        this.state = 111;
                        return true;
                    }
                    case 114: {
                        this.state = 114;
                        return true;
                    }
                    case 115: {
                        this.state = 118;
                        return true;
                    }
                    case 117: {
                        this.state = 121;
                        return true;
                    }
                }
                break;
            }
            case 78: {
                switch (current) {
                    case 99: {
                        this.state = 79;
                        return true;
                    }
                    case 114: {
                        this.state = 86;
                        return true;
                    }
                }
                break;
            }
            case 79: {
                switch (current) {
                    case 107: {
                        this.state = 80;
                        return true;
                    }
                }
                break;
            }
            case 80: {
                switch (current) {
                    case 115: {
                        this.state = 81;
                        return true;
                    }
                }
                break;
            }
            case 81: {
                switch (current) {
                    case 108: {
                        this.state = 82;
                        return true;
                    }
                }
                break;
            }
            case 82: {
                switch (current) {
                    case 97: {
                        this.state = 83;
                        return true;
                    }
                }
                break;
            }
            case 83: {
                switch (current) {
                    case 115: {
                        this.state = 84;
                        return true;
                    }
                }
                break;
            }
            case 84: {
                switch (current) {
                    case 104: {
                        this.state = 85;
                        return true;
                    }
                }
                break;
            }
            case 85: {
                switch (current) {
                    case 59: {
                        this.match = "\u2216";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 86: {
                switch (current) {
                    case 118: {
                        this.state = 87;
                        return true;
                    }
                    case 119: {
                        this.state = 88;
                        return true;
                    }
                }
                break;
            }
            case 87: {
                switch (current) {
                    case 59: {
                        this.match = "\u2ae7";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 88: {
                switch (current) {
                    case 101: {
                        this.state = 89;
                        return true;
                    }
                }
                break;
            }
            case 89: {
                switch (current) {
                    case 100: {
                        this.state = 90;
                        return true;
                    }
                }
                break;
            }
            case 90: {
                switch (current) {
                    case 59: {
                        this.match = "\u2306";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 91: {
                switch (current) {
                    case 121: {
                        this.state = 92;
                        return true;
                    }
                }
                break;
            }
            case 92: {
                switch (current) {
                    case 59: {
                        this.match = "\u0411";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 93: {
                switch (current) {
                    case 99: {
                        this.state = 94;
                        return true;
                    }
                    case 114: {
                        this.state = 99;
                        return true;
                    }
                    case 116: {
                        this.state = 107;
                        return true;
                    }
                }
                break;
            }
            case 94: {
                switch (current) {
                    case 97: {
                        this.state = 95;
                        return true;
                    }
                }
                break;
            }
            case 95: {
                switch (current) {
                    case 117: {
                        this.state = 96;
                        return true;
                    }
                }
                break;
            }
            case 96: {
                switch (current) {
                    case 115: {
                        this.state = 97;
                        return true;
                    }
                }
                break;
            }
            case 97: {
                switch (current) {
                    case 101: {
                        this.state = 98;
                        return true;
                    }
                }
                break;
            }
            case 98: {
                switch (current) {
                    case 59: {
                        this.match = "\u2235";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 99: {
                switch (current) {
                    case 110: {
                        this.state = 100;
                        return true;
                    }
                }
                break;
            }
            case 100: {
                switch (current) {
                    case 111: {
                        this.state = 101;
                        return true;
                    }
                }
                break;
            }
            case 101: {
                switch (current) {
                    case 117: {
                        this.state = 102;
                        return true;
                    }
                }
                break;
            }
            case 102: {
                switch (current) {
                    case 108: {
                        this.state = 103;
                        return true;
                    }
                }
                break;
            }
            case 103: {
                switch (current) {
                    case 108: {
                        this.state = 104;
                        return true;
                    }
                }
                break;
            }
            case 104: {
                switch (current) {
                    case 105: {
                        this.state = 105;
                        return true;
                    }
                }
                break;
            }
            case 105: {
                switch (current) {
                    case 115: {
                        this.state = 106;
                        return true;
                    }
                }
                break;
            }
            case 106: {
                switch (current) {
                    case 59: {
                        this.match = "\u212c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 107: {
                switch (current) {
                    case 97: {
                        this.state = 108;
                        return true;
                    }
                }
                break;
            }
            case 108: {
                switch (current) {
                    case 59: {
                        this.match = "\u0392";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 109: {
                switch (current) {
                    case 114: {
                        this.state = 110;
                        return true;
                    }
                }
                break;
            }
            case 110: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd05";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 111: {
                switch (current) {
                    case 112: {
                        this.state = 112;
                        return true;
                    }
                }
                break;
            }
            case 112: {
                switch (current) {
                    case 102: {
                        this.state = 113;
                        return true;
                    }
                }
                break;
            }
            case 113: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd39";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 114: {
                switch (current) {
                    case 101: {
                        this.state = 115;
                        return true;
                    }
                }
                break;
            }
            case 115: {
                switch (current) {
                    case 118: {
                        this.state = 116;
                        return true;
                    }
                }
                break;
            }
            case 116: {
                switch (current) {
                    case 101: {
                        this.state = 117;
                        return true;
                    }
                }
                break;
            }
            case 117: {
                switch (current) {
                    case 59: {
                        this.match = "\u02d8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 118: {
                switch (current) {
                    case 99: {
                        this.state = 119;
                        return true;
                    }
                }
                break;
            }
            case 119: {
                switch (current) {
                    case 114: {
                        this.state = 120;
                        return true;
                    }
                }
                break;
            }
            case 120: {
                switch (current) {
                    case 59: {
                        this.match = "\u212c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 121: {
                switch (current) {
                    case 109: {
                        this.state = 122;
                        return true;
                    }
                }
                break;
            }
            case 122: {
                switch (current) {
                    case 112: {
                        this.state = 123;
                        return true;
                    }
                }
                break;
            }
            case 123: {
                switch (current) {
                    case 101: {
                        this.state = 124;
                        return true;
                    }
                }
                break;
            }
            case 124: {
                switch (current) {
                    case 113: {
                        this.state = 125;
                        return true;
                    }
                }
                break;
            }
            case 125: {
                switch (current) {
                    case 59: {
                        this.match = "\u224e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 126: {
                switch (current) {
                    case 72: {
                        this.state = 127;
                        return true;
                    }
                    case 79: {
                        this.state = 130;
                        return true;
                    }
                    case 97: {
                        this.state = 133;
                        return true;
                    }
                    case 99: {
                        this.state = 161;
                        return true;
                    }
                    case 100: {
                        this.state = 178;
                        return true;
                    }
                    case 101: {
                        this.state = 181;
                        return true;
                    }
                    case 102: {
                        this.state = 194;
                        return true;
                    }
                    case 104: {
                        this.state = 196;
                        return true;
                    }
                    case 105: {
                        this.state = 198;
                        return true;
                    }
                    case 108: {
                        this.state = 220;
                        return true;
                    }
                    case 111: {
                        this.state = 266;
                        return true;
                    }
                    case 114: {
                        this.state = 330;
                        return true;
                    }
                    case 115: {
                        this.state = 334;
                        return true;
                    }
                    case 117: {
                        this.state = 337;
                        return true;
                    }
                }
                break;
            }
            case 127: {
                switch (current) {
                    case 99: {
                        this.state = 128;
                        return true;
                    }
                }
                break;
            }
            case 128: {
                switch (current) {
                    case 121: {
                        this.state = 129;
                        return true;
                    }
                }
                break;
            }
            case 129: {
                switch (current) {
                    case 59: {
                        this.match = "\u0427";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 130: {
                switch (current) {
                    case 80: {
                        this.state = 131;
                        return true;
                    }
                }
                break;
            }
            case 131: {
                switch (current) {
                    case 89: {
                        this.match = "\u00a9";
                        this.matchLength = this.consumedCount;
                        this.state = 132;
                        return true;
                    }
                }
                break;
            }
            case 132: {
                switch (current) {
                    case 59: {
                        this.match = "\u00a9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 133: {
                switch (current) {
                    case 99: {
                        this.state = 134;
                        return true;
                    }
                    case 112: {
                        this.state = 138;
                        return true;
                    }
                    case 121: {
                        this.state = 156;
                        return true;
                    }
                }
                break;
            }
            case 134: {
                switch (current) {
                    case 117: {
                        this.state = 135;
                        return true;
                    }
                }
                break;
            }
            case 135: {
                switch (current) {
                    case 116: {
                        this.state = 136;
                        return true;
                    }
                }
                break;
            }
            case 136: {
                switch (current) {
                    case 101: {
                        this.state = 137;
                        return true;
                    }
                }
                break;
            }
            case 137: {
                switch (current) {
                    case 59: {
                        this.match = "\u0106";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 138: {
                switch (current) {
                    case 59: {
                        this.match = "\u22d2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 105: {
                        this.state = 139;
                        return true;
                    }
                }
                break;
            }
            case 139: {
                switch (current) {
                    case 116: {
                        this.state = 140;
                        return true;
                    }
                }
                break;
            }
            case 140: {
                switch (current) {
                    case 97: {
                        this.state = 141;
                        return true;
                    }
                }
                break;
            }
            case 141: {
                switch (current) {
                    case 108: {
                        this.state = 142;
                        return true;
                    }
                }
                break;
            }
            case 142: {
                switch (current) {
                    case 68: {
                        this.state = 143;
                        return true;
                    }
                }
                break;
            }
            case 143: {
                switch (current) {
                    case 105: {
                        this.state = 144;
                        return true;
                    }
                }
                break;
            }
            case 144: {
                switch (current) {
                    case 102: {
                        this.state = 145;
                        return true;
                    }
                }
                break;
            }
            case 145: {
                switch (current) {
                    case 102: {
                        this.state = 146;
                        return true;
                    }
                }
                break;
            }
            case 146: {
                switch (current) {
                    case 101: {
                        this.state = 147;
                        return true;
                    }
                }
                break;
            }
            case 147: {
                switch (current) {
                    case 114: {
                        this.state = 148;
                        return true;
                    }
                }
                break;
            }
            case 148: {
                switch (current) {
                    case 101: {
                        this.state = 149;
                        return true;
                    }
                }
                break;
            }
            case 149: {
                switch (current) {
                    case 110: {
                        this.state = 150;
                        return true;
                    }
                }
                break;
            }
            case 150: {
                switch (current) {
                    case 116: {
                        this.state = 151;
                        return true;
                    }
                }
                break;
            }
            case 151: {
                switch (current) {
                    case 105: {
                        this.state = 152;
                        return true;
                    }
                }
                break;
            }
            case 152: {
                switch (current) {
                    case 97: {
                        this.state = 153;
                        return true;
                    }
                }
                break;
            }
            case 153: {
                switch (current) {
                    case 108: {
                        this.state = 154;
                        return true;
                    }
                }
                break;
            }
            case 154: {
                switch (current) {
                    case 68: {
                        this.state = 155;
                        return true;
                    }
                }
                break;
            }
            case 155: {
                switch (current) {
                    case 59: {
                        this.match = "\u2145";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 156: {
                switch (current) {
                    case 108: {
                        this.state = 157;
                        return true;
                    }
                }
                break;
            }
            case 157: {
                switch (current) {
                    case 101: {
                        this.state = 158;
                        return true;
                    }
                }
                break;
            }
            case 158: {
                switch (current) {
                    case 121: {
                        this.state = 159;
                        return true;
                    }
                }
                break;
            }
            case 159: {
                switch (current) {
                    case 115: {
                        this.state = 160;
                        return true;
                    }
                }
                break;
            }
            case 160: {
                switch (current) {
                    case 59: {
                        this.match = "\u212d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 161: {
                switch (current) {
                    case 97: {
                        this.state = 162;
                        return true;
                    }
                    case 101: {
                        this.state = 166;
                        return true;
                    }
                    case 105: {
                        this.state = 170;
                        return true;
                    }
                    case 111: {
                        this.state = 173;
                        return true;
                    }
                }
                break;
            }
            case 162: {
                switch (current) {
                    case 114: {
                        this.state = 163;
                        return true;
                    }
                }
                break;
            }
            case 163: {
                switch (current) {
                    case 111: {
                        this.state = 164;
                        return true;
                    }
                }
                break;
            }
            case 164: {
                switch (current) {
                    case 110: {
                        this.state = 165;
                        return true;
                    }
                }
                break;
            }
            case 165: {
                switch (current) {
                    case 59: {
                        this.match = "\u010c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 166: {
                switch (current) {
                    case 100: {
                        this.state = 167;
                        return true;
                    }
                }
                break;
            }
            case 167: {
                switch (current) {
                    case 105: {
                        this.state = 168;
                        return true;
                    }
                }
                break;
            }
            case 168: {
                switch (current) {
                    case 108: {
                        this.match = "\u00c7";
                        this.matchLength = this.consumedCount;
                        this.state = 169;
                        return true;
                    }
                }
                break;
            }
            case 169: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c7";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 170: {
                switch (current) {
                    case 114: {
                        this.state = 171;
                        return true;
                    }
                }
                break;
            }
            case 171: {
                switch (current) {
                    case 99: {
                        this.state = 172;
                        return true;
                    }
                }
                break;
            }
            case 172: {
                switch (current) {
                    case 59: {
                        this.match = "\u0108";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 173: {
                switch (current) {
                    case 110: {
                        this.state = 174;
                        return true;
                    }
                }
                break;
            }
            case 174: {
                switch (current) {
                    case 105: {
                        this.state = 175;
                        return true;
                    }
                }
                break;
            }
            case 175: {
                switch (current) {
                    case 110: {
                        this.state = 176;
                        return true;
                    }
                }
                break;
            }
            case 176: {
                switch (current) {
                    case 116: {
                        this.state = 177;
                        return true;
                    }
                }
                break;
            }
            case 177: {
                switch (current) {
                    case 59: {
                        this.match = "\u2230";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 178: {
                switch (current) {
                    case 111: {
                        this.state = 179;
                        return true;
                    }
                }
                break;
            }
            case 179: {
                switch (current) {
                    case 116: {
                        this.state = 180;
                        return true;
                    }
                }
                break;
            }
            case 180: {
                switch (current) {
                    case 59: {
                        this.match = "\u010a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 181: {
                switch (current) {
                    case 100: {
                        this.state = 182;
                        return true;
                    }
                    case 110: {
                        this.state = 187;
                        return true;
                    }
                }
                break;
            }
            case 182: {
                switch (current) {
                    case 105: {
                        this.state = 183;
                        return true;
                    }
                }
                break;
            }
            case 183: {
                switch (current) {
                    case 108: {
                        this.state = 184;
                        return true;
                    }
                }
                break;
            }
            case 184: {
                switch (current) {
                    case 108: {
                        this.state = 185;
                        return true;
                    }
                }
                break;
            }
            case 185: {
                switch (current) {
                    case 97: {
                        this.state = 186;
                        return true;
                    }
                }
                break;
            }
            case 186: {
                switch (current) {
                    case 59: {
                        this.match = "\u00b8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 187: {
                switch (current) {
                    case 116: {
                        this.state = 188;
                        return true;
                    }
                }
                break;
            }
            case 188: {
                switch (current) {
                    case 101: {
                        this.state = 189;
                        return true;
                    }
                }
                break;
            }
            case 189: {
                switch (current) {
                    case 114: {
                        this.state = 190;
                        return true;
                    }
                }
                break;
            }
            case 190: {
                switch (current) {
                    case 68: {
                        this.state = 191;
                        return true;
                    }
                }
                break;
            }
            case 191: {
                switch (current) {
                    case 111: {
                        this.state = 192;
                        return true;
                    }
                }
                break;
            }
            case 192: {
                switch (current) {
                    case 116: {
                        this.state = 193;
                        return true;
                    }
                }
                break;
            }
            case 193: {
                switch (current) {
                    case 59: {
                        this.match = "\u00b7";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 194: {
                switch (current) {
                    case 114: {
                        this.state = 195;
                        return true;
                    }
                }
                break;
            }
            case 195: {
                switch (current) {
                    case 59: {
                        this.match = "\u212d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 196: {
                switch (current) {
                    case 105: {
                        this.state = 197;
                        return true;
                    }
                }
                break;
            }
            case 197: {
                switch (current) {
                    case 59: {
                        this.match = "\u03a7";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 198: {
                switch (current) {
                    case 114: {
                        this.state = 199;
                        return true;
                    }
                }
                break;
            }
            case 199: {
                switch (current) {
                    case 99: {
                        this.state = 200;
                        return true;
                    }
                }
                break;
            }
            case 200: {
                switch (current) {
                    case 108: {
                        this.state = 201;
                        return true;
                    }
                }
                break;
            }
            case 201: {
                switch (current) {
                    case 101: {
                        this.state = 202;
                        return true;
                    }
                }
                break;
            }
            case 202: {
                switch (current) {
                    case 68: {
                        this.state = 203;
                        return true;
                    }
                    case 77: {
                        this.state = 206;
                        return true;
                    }
                    case 80: {
                        this.state = 211;
                        return true;
                    }
                    case 84: {
                        this.state = 215;
                        return true;
                    }
                }
                break;
            }
            case 203: {
                switch (current) {
                    case 111: {
                        this.state = 204;
                        return true;
                    }
                }
                break;
            }
            case 204: {
                switch (current) {
                    case 116: {
                        this.state = 205;
                        return true;
                    }
                }
                break;
            }
            case 205: {
                switch (current) {
                    case 59: {
                        this.match = "\u2299";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 206: {
                switch (current) {
                    case 105: {
                        this.state = 207;
                        return true;
                    }
                }
                break;
            }
            case 207: {
                switch (current) {
                    case 110: {
                        this.state = 208;
                        return true;
                    }
                }
                break;
            }
            case 208: {
                switch (current) {
                    case 117: {
                        this.state = 209;
                        return true;
                    }
                }
                break;
            }
            case 209: {
                switch (current) {
                    case 115: {
                        this.state = 210;
                        return true;
                    }
                }
                break;
            }
            case 210: {
                switch (current) {
                    case 59: {
                        this.match = "\u2296";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 211: {
                switch (current) {
                    case 108: {
                        this.state = 212;
                        return true;
                    }
                }
                break;
            }
            case 212: {
                switch (current) {
                    case 117: {
                        this.state = 213;
                        return true;
                    }
                }
                break;
            }
            case 213: {
                switch (current) {
                    case 115: {
                        this.state = 214;
                        return true;
                    }
                }
                break;
            }
            case 214: {
                switch (current) {
                    case 59: {
                        this.match = "\u2295";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 215: {
                switch (current) {
                    case 105: {
                        this.state = 216;
                        return true;
                    }
                }
                break;
            }
            case 216: {
                switch (current) {
                    case 109: {
                        this.state = 217;
                        return true;
                    }
                }
                break;
            }
            case 217: {
                switch (current) {
                    case 101: {
                        this.state = 218;
                        return true;
                    }
                }
                break;
            }
            case 218: {
                switch (current) {
                    case 115: {
                        this.state = 219;
                        return true;
                    }
                }
                break;
            }
            case 219: {
                switch (current) {
                    case 59: {
                        this.match = "\u2297";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 220: {
                switch (current) {
                    case 111: {
                        this.state = 221;
                        return true;
                    }
                }
                break;
            }
            case 221: {
                switch (current) {
                    case 99: {
                        this.state = 222;
                        return true;
                    }
                    case 115: {
                        this.state = 243;
                        return true;
                    }
                }
                break;
            }
            case 222: {
                switch (current) {
                    case 107: {
                        this.state = 223;
                        return true;
                    }
                }
                break;
            }
            case 223: {
                switch (current) {
                    case 119: {
                        this.state = 224;
                        return true;
                    }
                }
                break;
            }
            case 224: {
                switch (current) {
                    case 105: {
                        this.state = 225;
                        return true;
                    }
                }
                break;
            }
            case 225: {
                switch (current) {
                    case 115: {
                        this.state = 226;
                        return true;
                    }
                }
                break;
            }
            case 226: {
                switch (current) {
                    case 101: {
                        this.state = 227;
                        return true;
                    }
                }
                break;
            }
            case 227: {
                switch (current) {
                    case 67: {
                        this.state = 228;
                        return true;
                    }
                }
                break;
            }
            case 228: {
                switch (current) {
                    case 111: {
                        this.state = 229;
                        return true;
                    }
                }
                break;
            }
            case 229: {
                switch (current) {
                    case 110: {
                        this.state = 230;
                        return true;
                    }
                }
                break;
            }
            case 230: {
                switch (current) {
                    case 116: {
                        this.state = 231;
                        return true;
                    }
                }
                break;
            }
            case 231: {
                switch (current) {
                    case 111: {
                        this.state = 232;
                        return true;
                    }
                }
                break;
            }
            case 232: {
                switch (current) {
                    case 117: {
                        this.state = 233;
                        return true;
                    }
                }
                break;
            }
            case 233: {
                switch (current) {
                    case 114: {
                        this.state = 234;
                        return true;
                    }
                }
                break;
            }
            case 234: {
                switch (current) {
                    case 73: {
                        this.state = 235;
                        return true;
                    }
                }
                break;
            }
            case 235: {
                switch (current) {
                    case 110: {
                        this.state = 236;
                        return true;
                    }
                }
                break;
            }
            case 236: {
                switch (current) {
                    case 116: {
                        this.state = 237;
                        return true;
                    }
                }
                break;
            }
            case 237: {
                switch (current) {
                    case 101: {
                        this.state = 238;
                        return true;
                    }
                }
                break;
            }
            case 238: {
                switch (current) {
                    case 103: {
                        this.state = 239;
                        return true;
                    }
                }
                break;
            }
            case 239: {
                switch (current) {
                    case 114: {
                        this.state = 240;
                        return true;
                    }
                }
                break;
            }
            case 240: {
                switch (current) {
                    case 97: {
                        this.state = 241;
                        return true;
                    }
                }
                break;
            }
            case 241: {
                switch (current) {
                    case 108: {
                        this.state = 242;
                        return true;
                    }
                }
                break;
            }
            case 242: {
                switch (current) {
                    case 59: {
                        this.match = "\u2232";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 243: {
                switch (current) {
                    case 101: {
                        this.state = 244;
                        return true;
                    }
                }
                break;
            }
            case 244: {
                switch (current) {
                    case 67: {
                        this.state = 245;
                        return true;
                    }
                }
                break;
            }
            case 245: {
                switch (current) {
                    case 117: {
                        this.state = 246;
                        return true;
                    }
                }
                break;
            }
            case 246: {
                switch (current) {
                    case 114: {
                        this.state = 247;
                        return true;
                    }
                }
                break;
            }
            case 247: {
                switch (current) {
                    case 108: {
                        this.state = 248;
                        return true;
                    }
                }
                break;
            }
            case 248: {
                switch (current) {
                    case 121: {
                        this.state = 249;
                        return true;
                    }
                }
                break;
            }
            case 249: {
                switch (current) {
                    case 68: {
                        this.state = 250;
                        return true;
                    }
                    case 81: {
                        this.state = 261;
                        return true;
                    }
                }
                break;
            }
            case 250: {
                switch (current) {
                    case 111: {
                        this.state = 251;
                        return true;
                    }
                }
                break;
            }
            case 251: {
                switch (current) {
                    case 117: {
                        this.state = 252;
                        return true;
                    }
                }
                break;
            }
            case 252: {
                switch (current) {
                    case 98: {
                        this.state = 253;
                        return true;
                    }
                }
                break;
            }
            case 253: {
                switch (current) {
                    case 108: {
                        this.state = 254;
                        return true;
                    }
                }
                break;
            }
            case 254: {
                switch (current) {
                    case 101: {
                        this.state = 255;
                        return true;
                    }
                }
                break;
            }
            case 255: {
                switch (current) {
                    case 81: {
                        this.state = 256;
                        return true;
                    }
                }
                break;
            }
            case 256: {
                switch (current) {
                    case 117: {
                        this.state = 257;
                        return true;
                    }
                }
                break;
            }
            case 257: {
                switch (current) {
                    case 111: {
                        this.state = 258;
                        return true;
                    }
                }
                break;
            }
            case 258: {
                switch (current) {
                    case 116: {
                        this.state = 259;
                        return true;
                    }
                }
                break;
            }
            case 259: {
                switch (current) {
                    case 101: {
                        this.state = 260;
                        return true;
                    }
                }
                break;
            }
            case 260: {
                switch (current) {
                    case 59: {
                        this.match = "\u201d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 261: {
                switch (current) {
                    case 117: {
                        this.state = 262;
                        return true;
                    }
                }
                break;
            }
            case 262: {
                switch (current) {
                    case 111: {
                        this.state = 263;
                        return true;
                    }
                }
                break;
            }
            case 263: {
                switch (current) {
                    case 116: {
                        this.state = 264;
                        return true;
                    }
                }
                break;
            }
            case 264: {
                switch (current) {
                    case 101: {
                        this.state = 265;
                        return true;
                    }
                }
                break;
            }
            case 265: {
                switch (current) {
                    case 59: {
                        this.match = "\u2019";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 266: {
                switch (current) {
                    case 108: {
                        this.state = 267;
                        return true;
                    }
                    case 110: {
                        this.state = 271;
                        return true;
                    }
                    case 112: {
                        this.state = 293;
                        return true;
                    }
                    case 117: {
                        this.state = 301;
                        return true;
                    }
                }
                break;
            }
            case 267: {
                switch (current) {
                    case 111: {
                        this.state = 268;
                        return true;
                    }
                }
                break;
            }
            case 268: {
                switch (current) {
                    case 110: {
                        this.state = 269;
                        return true;
                    }
                }
                break;
            }
            case 269: {
                switch (current) {
                    case 59: {
                        this.match = "\u2237";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 270;
                        return true;
                    }
                }
                break;
            }
            case 270: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a74";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 271: {
                switch (current) {
                    case 103: {
                        this.state = 272;
                        return true;
                    }
                    case 105: {
                        this.state = 278;
                        return true;
                    }
                    case 116: {
                        this.state = 281;
                        return true;
                    }
                }
                break;
            }
            case 272: {
                switch (current) {
                    case 114: {
                        this.state = 273;
                        return true;
                    }
                }
                break;
            }
            case 273: {
                switch (current) {
                    case 117: {
                        this.state = 274;
                        return true;
                    }
                }
                break;
            }
            case 274: {
                switch (current) {
                    case 101: {
                        this.state = 275;
                        return true;
                    }
                }
                break;
            }
            case 275: {
                switch (current) {
                    case 110: {
                        this.state = 276;
                        return true;
                    }
                }
                break;
            }
            case 276: {
                switch (current) {
                    case 116: {
                        this.state = 277;
                        return true;
                    }
                }
                break;
            }
            case 277: {
                switch (current) {
                    case 59: {
                        this.match = "\u2261";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 278: {
                switch (current) {
                    case 110: {
                        this.state = 279;
                        return true;
                    }
                }
                break;
            }
            case 279: {
                switch (current) {
                    case 116: {
                        this.state = 280;
                        return true;
                    }
                }
                break;
            }
            case 280: {
                switch (current) {
                    case 59: {
                        this.match = "\u222f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 281: {
                switch (current) {
                    case 111: {
                        this.state = 282;
                        return true;
                    }
                }
                break;
            }
            case 282: {
                switch (current) {
                    case 117: {
                        this.state = 283;
                        return true;
                    }
                }
                break;
            }
            case 283: {
                switch (current) {
                    case 114: {
                        this.state = 284;
                        return true;
                    }
                }
                break;
            }
            case 284: {
                switch (current) {
                    case 73: {
                        this.state = 285;
                        return true;
                    }
                }
                break;
            }
            case 285: {
                switch (current) {
                    case 110: {
                        this.state = 286;
                        return true;
                    }
                }
                break;
            }
            case 286: {
                switch (current) {
                    case 116: {
                        this.state = 287;
                        return true;
                    }
                }
                break;
            }
            case 287: {
                switch (current) {
                    case 101: {
                        this.state = 288;
                        return true;
                    }
                }
                break;
            }
            case 288: {
                switch (current) {
                    case 103: {
                        this.state = 289;
                        return true;
                    }
                }
                break;
            }
            case 289: {
                switch (current) {
                    case 114: {
                        this.state = 290;
                        return true;
                    }
                }
                break;
            }
            case 290: {
                switch (current) {
                    case 97: {
                        this.state = 291;
                        return true;
                    }
                }
                break;
            }
            case 291: {
                switch (current) {
                    case 108: {
                        this.state = 292;
                        return true;
                    }
                }
                break;
            }
            case 292: {
                switch (current) {
                    case 59: {
                        this.match = "\u222e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 293: {
                switch (current) {
                    case 102: {
                        this.state = 294;
                        return true;
                    }
                    case 114: {
                        this.state = 295;
                        return true;
                    }
                }
                break;
            }
            case 294: {
                switch (current) {
                    case 59: {
                        this.match = "\u2102";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 295: {
                switch (current) {
                    case 111: {
                        this.state = 296;
                        return true;
                    }
                }
                break;
            }
            case 296: {
                switch (current) {
                    case 100: {
                        this.state = 297;
                        return true;
                    }
                }
                break;
            }
            case 297: {
                switch (current) {
                    case 117: {
                        this.state = 298;
                        return true;
                    }
                }
                break;
            }
            case 298: {
                switch (current) {
                    case 99: {
                        this.state = 299;
                        return true;
                    }
                }
                break;
            }
            case 299: {
                switch (current) {
                    case 116: {
                        this.state = 300;
                        return true;
                    }
                }
                break;
            }
            case 300: {
                switch (current) {
                    case 59: {
                        this.match = "\u2210";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 301: {
                switch (current) {
                    case 110: {
                        this.state = 302;
                        return true;
                    }
                }
                break;
            }
            case 302: {
                switch (current) {
                    case 116: {
                        this.state = 303;
                        return true;
                    }
                }
                break;
            }
            case 303: {
                switch (current) {
                    case 101: {
                        this.state = 304;
                        return true;
                    }
                }
                break;
            }
            case 304: {
                switch (current) {
                    case 114: {
                        this.state = 305;
                        return true;
                    }
                }
                break;
            }
            case 305: {
                switch (current) {
                    case 67: {
                        this.state = 306;
                        return true;
                    }
                }
                break;
            }
            case 306: {
                switch (current) {
                    case 108: {
                        this.state = 307;
                        return true;
                    }
                }
                break;
            }
            case 307: {
                switch (current) {
                    case 111: {
                        this.state = 308;
                        return true;
                    }
                }
                break;
            }
            case 308: {
                switch (current) {
                    case 99: {
                        this.state = 309;
                        return true;
                    }
                }
                break;
            }
            case 309: {
                switch (current) {
                    case 107: {
                        this.state = 310;
                        return true;
                    }
                }
                break;
            }
            case 310: {
                switch (current) {
                    case 119: {
                        this.state = 311;
                        return true;
                    }
                }
                break;
            }
            case 311: {
                switch (current) {
                    case 105: {
                        this.state = 312;
                        return true;
                    }
                }
                break;
            }
            case 312: {
                switch (current) {
                    case 115: {
                        this.state = 313;
                        return true;
                    }
                }
                break;
            }
            case 313: {
                switch (current) {
                    case 101: {
                        this.state = 314;
                        return true;
                    }
                }
                break;
            }
            case 314: {
                switch (current) {
                    case 67: {
                        this.state = 315;
                        return true;
                    }
                }
                break;
            }
            case 315: {
                switch (current) {
                    case 111: {
                        this.state = 316;
                        return true;
                    }
                }
                break;
            }
            case 316: {
                switch (current) {
                    case 110: {
                        this.state = 317;
                        return true;
                    }
                }
                break;
            }
            case 317: {
                switch (current) {
                    case 116: {
                        this.state = 318;
                        return true;
                    }
                }
                break;
            }
            case 318: {
                switch (current) {
                    case 111: {
                        this.state = 319;
                        return true;
                    }
                }
                break;
            }
            case 319: {
                switch (current) {
                    case 117: {
                        this.state = 320;
                        return true;
                    }
                }
                break;
            }
            case 320: {
                switch (current) {
                    case 114: {
                        this.state = 321;
                        return true;
                    }
                }
                break;
            }
            case 321: {
                switch (current) {
                    case 73: {
                        this.state = 322;
                        return true;
                    }
                }
                break;
            }
            case 322: {
                switch (current) {
                    case 110: {
                        this.state = 323;
                        return true;
                    }
                }
                break;
            }
            case 323: {
                switch (current) {
                    case 116: {
                        this.state = 324;
                        return true;
                    }
                }
                break;
            }
            case 324: {
                switch (current) {
                    case 101: {
                        this.state = 325;
                        return true;
                    }
                }
                break;
            }
            case 325: {
                switch (current) {
                    case 103: {
                        this.state = 326;
                        return true;
                    }
                }
                break;
            }
            case 326: {
                switch (current) {
                    case 114: {
                        this.state = 327;
                        return true;
                    }
                }
                break;
            }
            case 327: {
                switch (current) {
                    case 97: {
                        this.state = 328;
                        return true;
                    }
                }
                break;
            }
            case 328: {
                switch (current) {
                    case 108: {
                        this.state = 329;
                        return true;
                    }
                }
                break;
            }
            case 329: {
                switch (current) {
                    case 59: {
                        this.match = "\u2233";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 330: {
                switch (current) {
                    case 111: {
                        this.state = 331;
                        return true;
                    }
                }
                break;
            }
            case 331: {
                switch (current) {
                    case 115: {
                        this.state = 332;
                        return true;
                    }
                }
                break;
            }
            case 332: {
                switch (current) {
                    case 115: {
                        this.state = 333;
                        return true;
                    }
                }
                break;
            }
            case 333: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a2f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 334: {
                switch (current) {
                    case 99: {
                        this.state = 335;
                        return true;
                    }
                }
                break;
            }
            case 335: {
                switch (current) {
                    case 114: {
                        this.state = 336;
                        return true;
                    }
                }
                break;
            }
            case 336: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udc9e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 337: {
                switch (current) {
                    case 112: {
                        this.state = 338;
                        return true;
                    }
                }
                break;
            }
            case 338: {
                switch (current) {
                    case 59: {
                        this.match = "\u22d3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 67: {
                        this.state = 339;
                        return true;
                    }
                }
                break;
            }
            case 339: {
                switch (current) {
                    case 97: {
                        this.state = 340;
                        return true;
                    }
                }
                break;
            }
            case 340: {
                switch (current) {
                    case 112: {
                        this.state = 341;
                        return true;
                    }
                }
                break;
            }
            case 341: {
                switch (current) {
                    case 59: {
                        this.match = "\u224d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 342: {
                switch (current) {
                    case 68: {
                        this.state = 343;
                        return true;
                    }
                    case 74: {
                        this.state = 350;
                        return true;
                    }
                    case 83: {
                        this.state = 353;
                        return true;
                    }
                    case 90: {
                        this.state = 356;
                        return true;
                    }
                    case 97: {
                        this.state = 359;
                        return true;
                    }
                    case 99: {
                        this.state = 369;
                        return true;
                    }
                    case 101: {
                        this.state = 375;
                        return true;
                    }
                    case 102: {
                        this.state = 379;
                        return true;
                    }
                    case 105: {
                        this.state = 381;
                        return true;
                    }
                    case 111: {
                        this.state = 433;
                        return true;
                    }
                    case 115: {
                        this.state = 659;
                        return true;
                    }
                }
                break;
            }
            case 343: {
                switch (current) {
                    case 59: {
                        this.match = "\u2145";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 111: {
                        this.state = 344;
                        return true;
                    }
                }
                break;
            }
            case 344: {
                switch (current) {
                    case 116: {
                        this.state = 345;
                        return true;
                    }
                }
                break;
            }
            case 345: {
                switch (current) {
                    case 114: {
                        this.state = 346;
                        return true;
                    }
                }
                break;
            }
            case 346: {
                switch (current) {
                    case 97: {
                        this.state = 347;
                        return true;
                    }
                }
                break;
            }
            case 347: {
                switch (current) {
                    case 104: {
                        this.state = 348;
                        return true;
                    }
                }
                break;
            }
            case 348: {
                switch (current) {
                    case 100: {
                        this.state = 349;
                        return true;
                    }
                }
                break;
            }
            case 349: {
                switch (current) {
                    case 59: {
                        this.match = "\u2911";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 350: {
                switch (current) {
                    case 99: {
                        this.state = 351;
                        return true;
                    }
                }
                break;
            }
            case 351: {
                switch (current) {
                    case 121: {
                        this.state = 352;
                        return true;
                    }
                }
                break;
            }
            case 352: {
                switch (current) {
                    case 59: {
                        this.match = "\u0402";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 353: {
                switch (current) {
                    case 99: {
                        this.state = 354;
                        return true;
                    }
                }
                break;
            }
            case 354: {
                switch (current) {
                    case 121: {
                        this.state = 355;
                        return true;
                    }
                }
                break;
            }
            case 355: {
                switch (current) {
                    case 59: {
                        this.match = "\u0405";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 356: {
                switch (current) {
                    case 99: {
                        this.state = 357;
                        return true;
                    }
                }
                break;
            }
            case 357: {
                switch (current) {
                    case 121: {
                        this.state = 358;
                        return true;
                    }
                }
                break;
            }
            case 358: {
                switch (current) {
                    case 59: {
                        this.match = "\u040f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 359: {
                switch (current) {
                    case 103: {
                        this.state = 360;
                        return true;
                    }
                    case 114: {
                        this.state = 364;
                        return true;
                    }
                    case 115: {
                        this.state = 366;
                        return true;
                    }
                }
                break;
            }
            case 360: {
                switch (current) {
                    case 103: {
                        this.state = 361;
                        return true;
                    }
                }
                break;
            }
            case 361: {
                switch (current) {
                    case 101: {
                        this.state = 362;
                        return true;
                    }
                }
                break;
            }
            case 362: {
                switch (current) {
                    case 114: {
                        this.state = 363;
                        return true;
                    }
                }
                break;
            }
            case 363: {
                switch (current) {
                    case 59: {
                        this.match = "\u2021";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 364: {
                switch (current) {
                    case 114: {
                        this.state = 365;
                        return true;
                    }
                }
                break;
            }
            case 365: {
                switch (current) {
                    case 59: {
                        this.match = "\u21a1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 366: {
                switch (current) {
                    case 104: {
                        this.state = 367;
                        return true;
                    }
                }
                break;
            }
            case 367: {
                switch (current) {
                    case 118: {
                        this.state = 368;
                        return true;
                    }
                }
                break;
            }
            case 368: {
                switch (current) {
                    case 59: {
                        this.match = "\u2ae4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 369: {
                switch (current) {
                    case 97: {
                        this.state = 370;
                        return true;
                    }
                    case 121: {
                        this.state = 374;
                        return true;
                    }
                }
                break;
            }
            case 370: {
                switch (current) {
                    case 114: {
                        this.state = 371;
                        return true;
                    }
                }
                break;
            }
            case 371: {
                switch (current) {
                    case 111: {
                        this.state = 372;
                        return true;
                    }
                }
                break;
            }
            case 372: {
                switch (current) {
                    case 110: {
                        this.state = 373;
                        return true;
                    }
                }
                break;
            }
            case 373: {
                switch (current) {
                    case 59: {
                        this.match = "\u010e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 374: {
                switch (current) {
                    case 59: {
                        this.match = "\u0414";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 375: {
                switch (current) {
                    case 108: {
                        this.state = 376;
                        return true;
                    }
                }
                break;
            }
            case 376: {
                switch (current) {
                    case 59: {
                        this.match = "\u2207";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 116: {
                        this.state = 377;
                        return true;
                    }
                }
                break;
            }
            case 377: {
                switch (current) {
                    case 97: {
                        this.state = 378;
                        return true;
                    }
                }
                break;
            }
            case 378: {
                switch (current) {
                    case 59: {
                        this.match = "\u0394";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 379: {
                switch (current) {
                    case 114: {
                        this.state = 380;
                        return true;
                    }
                }
                break;
            }
            case 380: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd07";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 381: {
                switch (current) {
                    case 97: {
                        this.state = 382;
                        return true;
                    }
                    case 102: {
                        this.state = 422;
                        return true;
                    }
                }
                break;
            }
            case 382: {
                switch (current) {
                    case 99: {
                        this.state = 383;
                        return true;
                    }
                    case 109: {
                        this.state = 418;
                        return true;
                    }
                }
                break;
            }
            case 383: {
                switch (current) {
                    case 114: {
                        this.state = 384;
                        return true;
                    }
                }
                break;
            }
            case 384: {
                switch (current) {
                    case 105: {
                        this.state = 385;
                        return true;
                    }
                }
                break;
            }
            case 385: {
                switch (current) {
                    case 116: {
                        this.state = 386;
                        return true;
                    }
                }
                break;
            }
            case 386: {
                switch (current) {
                    case 105: {
                        this.state = 387;
                        return true;
                    }
                }
                break;
            }
            case 387: {
                switch (current) {
                    case 99: {
                        this.state = 388;
                        return true;
                    }
                }
                break;
            }
            case 388: {
                switch (current) {
                    case 97: {
                        this.state = 389;
                        return true;
                    }
                }
                break;
            }
            case 389: {
                switch (current) {
                    case 108: {
                        this.state = 390;
                        return true;
                    }
                }
                break;
            }
            case 390: {
                switch (current) {
                    case 65: {
                        this.state = 391;
                        return true;
                    }
                    case 68: {
                        this.state = 396;
                        return true;
                    }
                    case 71: {
                        this.state = 408;
                        return true;
                    }
                    case 84: {
                        this.state = 413;
                        return true;
                    }
                }
                break;
            }
            case 391: {
                switch (current) {
                    case 99: {
                        this.state = 392;
                        return true;
                    }
                }
                break;
            }
            case 392: {
                switch (current) {
                    case 117: {
                        this.state = 393;
                        return true;
                    }
                }
                break;
            }
            case 393: {
                switch (current) {
                    case 116: {
                        this.state = 394;
                        return true;
                    }
                }
                break;
            }
            case 394: {
                switch (current) {
                    case 101: {
                        this.state = 395;
                        return true;
                    }
                }
                break;
            }
            case 395: {
                switch (current) {
                    case 59: {
                        this.match = "\u00b4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 396: {
                switch (current) {
                    case 111: {
                        this.state = 397;
                        return true;
                    }
                }
                break;
            }
            case 397: {
                switch (current) {
                    case 116: {
                        this.state = 398;
                        return true;
                    }
                    case 117: {
                        this.state = 399;
                        return true;
                    }
                }
                break;
            }
            case 398: {
                switch (current) {
                    case 59: {
                        this.match = "\u02d9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 399: {
                switch (current) {
                    case 98: {
                        this.state = 400;
                        return true;
                    }
                }
                break;
            }
            case 400: {
                switch (current) {
                    case 108: {
                        this.state = 401;
                        return true;
                    }
                }
                break;
            }
            case 401: {
                switch (current) {
                    case 101: {
                        this.state = 402;
                        return true;
                    }
                }
                break;
            }
            case 402: {
                switch (current) {
                    case 65: {
                        this.state = 403;
                        return true;
                    }
                }
                break;
            }
            case 403: {
                switch (current) {
                    case 99: {
                        this.state = 404;
                        return true;
                    }
                }
                break;
            }
            case 404: {
                switch (current) {
                    case 117: {
                        this.state = 405;
                        return true;
                    }
                }
                break;
            }
            case 405: {
                switch (current) {
                    case 116: {
                        this.state = 406;
                        return true;
                    }
                }
                break;
            }
            case 406: {
                switch (current) {
                    case 101: {
                        this.state = 407;
                        return true;
                    }
                }
                break;
            }
            case 407: {
                switch (current) {
                    case 59: {
                        this.match = "\u02dd";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 408: {
                switch (current) {
                    case 114: {
                        this.state = 409;
                        return true;
                    }
                }
                break;
            }
            case 409: {
                switch (current) {
                    case 97: {
                        this.state = 410;
                        return true;
                    }
                }
                break;
            }
            case 410: {
                switch (current) {
                    case 118: {
                        this.state = 411;
                        return true;
                    }
                }
                break;
            }
            case 411: {
                switch (current) {
                    case 101: {
                        this.state = 412;
                        return true;
                    }
                }
                break;
            }
            case 412: {
                switch (current) {
                    case 59: {
                        this.match = "`";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 413: {
                switch (current) {
                    case 105: {
                        this.state = 414;
                        return true;
                    }
                }
                break;
            }
            case 414: {
                switch (current) {
                    case 108: {
                        this.state = 415;
                        return true;
                    }
                }
                break;
            }
            case 415: {
                switch (current) {
                    case 100: {
                        this.state = 416;
                        return true;
                    }
                }
                break;
            }
            case 416: {
                switch (current) {
                    case 101: {
                        this.state = 417;
                        return true;
                    }
                }
                break;
            }
            case 417: {
                switch (current) {
                    case 59: {
                        this.match = "\u02dc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 418: {
                switch (current) {
                    case 111: {
                        this.state = 419;
                        return true;
                    }
                }
                break;
            }
            case 419: {
                switch (current) {
                    case 110: {
                        this.state = 420;
                        return true;
                    }
                }
                break;
            }
            case 420: {
                switch (current) {
                    case 100: {
                        this.state = 421;
                        return true;
                    }
                }
                break;
            }
            case 421: {
                switch (current) {
                    case 59: {
                        this.match = "\u22c4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 422: {
                switch (current) {
                    case 102: {
                        this.state = 423;
                        return true;
                    }
                }
                break;
            }
            case 423: {
                switch (current) {
                    case 101: {
                        this.state = 424;
                        return true;
                    }
                }
                break;
            }
            case 424: {
                switch (current) {
                    case 114: {
                        this.state = 425;
                        return true;
                    }
                }
                break;
            }
            case 425: {
                switch (current) {
                    case 101: {
                        this.state = 426;
                        return true;
                    }
                }
                break;
            }
            case 426: {
                switch (current) {
                    case 110: {
                        this.state = 427;
                        return true;
                    }
                }
                break;
            }
            case 427: {
                switch (current) {
                    case 116: {
                        this.state = 428;
                        return true;
                    }
                }
                break;
            }
            case 428: {
                switch (current) {
                    case 105: {
                        this.state = 429;
                        return true;
                    }
                }
                break;
            }
            case 429: {
                switch (current) {
                    case 97: {
                        this.state = 430;
                        return true;
                    }
                }
                break;
            }
            case 430: {
                switch (current) {
                    case 108: {
                        this.state = 431;
                        return true;
                    }
                }
                break;
            }
            case 431: {
                switch (current) {
                    case 68: {
                        this.state = 432;
                        return true;
                    }
                }
                break;
            }
            case 432: {
                switch (current) {
                    case 59: {
                        this.match = "\u2146";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 433: {
                switch (current) {
                    case 112: {
                        this.state = 434;
                        return true;
                    }
                    case 116: {
                        this.state = 436;
                        return true;
                    }
                    case 117: {
                        this.state = 445;
                        return true;
                    }
                    case 119: {
                        this.state = 568;
                        return true;
                    }
                }
                break;
            }
            case 434: {
                switch (current) {
                    case 102: {
                        this.state = 435;
                        return true;
                    }
                }
                break;
            }
            case 435: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd3b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 436: {
                switch (current) {
                    case 59: {
                        this.match = "\u00a8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 68: {
                        this.state = 437;
                        return true;
                    }
                    case 69: {
                        this.state = 440;
                        return true;
                    }
                }
                break;
            }
            case 437: {
                switch (current) {
                    case 111: {
                        this.state = 438;
                        return true;
                    }
                }
                break;
            }
            case 438: {
                switch (current) {
                    case 116: {
                        this.state = 439;
                        return true;
                    }
                }
                break;
            }
            case 439: {
                switch (current) {
                    case 59: {
                        this.match = "\u20dc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 440: {
                switch (current) {
                    case 113: {
                        this.state = 441;
                        return true;
                    }
                }
                break;
            }
            case 441: {
                switch (current) {
                    case 117: {
                        this.state = 442;
                        return true;
                    }
                }
                break;
            }
            case 442: {
                switch (current) {
                    case 97: {
                        this.state = 443;
                        return true;
                    }
                }
                break;
            }
            case 443: {
                switch (current) {
                    case 108: {
                        this.state = 444;
                        return true;
                    }
                }
                break;
            }
            case 444: {
                switch (current) {
                    case 59: {
                        this.match = "\u2250";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 445: {
                switch (current) {
                    case 98: {
                        this.state = 446;
                        return true;
                    }
                }
                break;
            }
            case 446: {
                switch (current) {
                    case 108: {
                        this.state = 447;
                        return true;
                    }
                }
                break;
            }
            case 447: {
                switch (current) {
                    case 101: {
                        this.state = 448;
                        return true;
                    }
                }
                break;
            }
            case 448: {
                switch (current) {
                    case 67: {
                        this.state = 449;
                        return true;
                    }
                    case 68: {
                        this.state = 464;
                        return true;
                    }
                    case 76: {
                        this.state = 474;
                        return true;
                    }
                    case 82: {
                        this.state = 528;
                        return true;
                    }
                    case 85: {
                        this.state = 541;
                        return true;
                    }
                    case 86: {
                        this.state = 557;
                        return true;
                    }
                }
                break;
            }
            case 449: {
                switch (current) {
                    case 111: {
                        this.state = 450;
                        return true;
                    }
                }
                break;
            }
            case 450: {
                switch (current) {
                    case 110: {
                        this.state = 451;
                        return true;
                    }
                }
                break;
            }
            case 451: {
                switch (current) {
                    case 116: {
                        this.state = 452;
                        return true;
                    }
                }
                break;
            }
            case 452: {
                switch (current) {
                    case 111: {
                        this.state = 453;
                        return true;
                    }
                }
                break;
            }
            case 453: {
                switch (current) {
                    case 117: {
                        this.state = 454;
                        return true;
                    }
                }
                break;
            }
            case 454: {
                switch (current) {
                    case 114: {
                        this.state = 455;
                        return true;
                    }
                }
                break;
            }
            case 455: {
                switch (current) {
                    case 73: {
                        this.state = 456;
                        return true;
                    }
                }
                break;
            }
            case 456: {
                switch (current) {
                    case 110: {
                        this.state = 457;
                        return true;
                    }
                }
                break;
            }
            case 457: {
                switch (current) {
                    case 116: {
                        this.state = 458;
                        return true;
                    }
                }
                break;
            }
            case 458: {
                switch (current) {
                    case 101: {
                        this.state = 459;
                        return true;
                    }
                }
                break;
            }
            case 459: {
                switch (current) {
                    case 103: {
                        this.state = 460;
                        return true;
                    }
                }
                break;
            }
            case 460: {
                switch (current) {
                    case 114: {
                        this.state = 461;
                        return true;
                    }
                }
                break;
            }
            case 461: {
                switch (current) {
                    case 97: {
                        this.state = 462;
                        return true;
                    }
                }
                break;
            }
            case 462: {
                switch (current) {
                    case 108: {
                        this.state = 463;
                        return true;
                    }
                }
                break;
            }
            case 463: {
                switch (current) {
                    case 59: {
                        this.match = "\u222f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 464: {
                switch (current) {
                    case 111: {
                        this.state = 465;
                        return true;
                    }
                }
                break;
            }
            case 465: {
                switch (current) {
                    case 116: {
                        this.state = 466;
                        return true;
                    }
                    case 119: {
                        this.state = 467;
                        return true;
                    }
                }
                break;
            }
            case 466: {
                switch (current) {
                    case 59: {
                        this.match = "\u00a8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 467: {
                switch (current) {
                    case 110: {
                        this.state = 468;
                        return true;
                    }
                }
                break;
            }
            case 468: {
                switch (current) {
                    case 65: {
                        this.state = 469;
                        return true;
                    }
                }
                break;
            }
            case 469: {
                switch (current) {
                    case 114: {
                        this.state = 470;
                        return true;
                    }
                }
                break;
            }
            case 470: {
                switch (current) {
                    case 114: {
                        this.state = 471;
                        return true;
                    }
                }
                break;
            }
            case 471: {
                switch (current) {
                    case 111: {
                        this.state = 472;
                        return true;
                    }
                }
                break;
            }
            case 472: {
                switch (current) {
                    case 119: {
                        this.state = 473;
                        return true;
                    }
                }
                break;
            }
            case 473: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 474: {
                switch (current) {
                    case 101: {
                        this.state = 475;
                        return true;
                    }
                    case 111: {
                        this.state = 496;
                        return true;
                    }
                }
                break;
            }
            case 475: {
                switch (current) {
                    case 102: {
                        this.state = 476;
                        return true;
                    }
                }
                break;
            }
            case 476: {
                switch (current) {
                    case 116: {
                        this.state = 477;
                        return true;
                    }
                }
                break;
            }
            case 477: {
                switch (current) {
                    case 65: {
                        this.state = 478;
                        return true;
                    }
                    case 82: {
                        this.state = 483;
                        return true;
                    }
                    case 84: {
                        this.state = 493;
                        return true;
                    }
                }
                break;
            }
            case 478: {
                switch (current) {
                    case 114: {
                        this.state = 479;
                        return true;
                    }
                }
                break;
            }
            case 479: {
                switch (current) {
                    case 114: {
                        this.state = 480;
                        return true;
                    }
                }
                break;
            }
            case 480: {
                switch (current) {
                    case 111: {
                        this.state = 481;
                        return true;
                    }
                }
                break;
            }
            case 481: {
                switch (current) {
                    case 119: {
                        this.state = 482;
                        return true;
                    }
                }
                break;
            }
            case 482: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 483: {
                switch (current) {
                    case 105: {
                        this.state = 484;
                        return true;
                    }
                }
                break;
            }
            case 484: {
                switch (current) {
                    case 103: {
                        this.state = 485;
                        return true;
                    }
                }
                break;
            }
            case 485: {
                switch (current) {
                    case 104: {
                        this.state = 486;
                        return true;
                    }
                }
                break;
            }
            case 486: {
                switch (current) {
                    case 116: {
                        this.state = 487;
                        return true;
                    }
                }
                break;
            }
            case 487: {
                switch (current) {
                    case 65: {
                        this.state = 488;
                        return true;
                    }
                }
                break;
            }
            case 488: {
                switch (current) {
                    case 114: {
                        this.state = 489;
                        return true;
                    }
                }
                break;
            }
            case 489: {
                switch (current) {
                    case 114: {
                        this.state = 490;
                        return true;
                    }
                }
                break;
            }
            case 490: {
                switch (current) {
                    case 111: {
                        this.state = 491;
                        return true;
                    }
                }
                break;
            }
            case 491: {
                switch (current) {
                    case 119: {
                        this.state = 492;
                        return true;
                    }
                }
                break;
            }
            case 492: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 493: {
                switch (current) {
                    case 101: {
                        this.state = 494;
                        return true;
                    }
                }
                break;
            }
            case 494: {
                switch (current) {
                    case 101: {
                        this.state = 495;
                        return true;
                    }
                }
                break;
            }
            case 495: {
                switch (current) {
                    case 59: {
                        this.match = "\u2ae4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 496: {
                switch (current) {
                    case 110: {
                        this.state = 497;
                        return true;
                    }
                }
                break;
            }
            case 497: {
                switch (current) {
                    case 103: {
                        this.state = 498;
                        return true;
                    }
                }
                break;
            }
            case 498: {
                switch (current) {
                    case 76: {
                        this.state = 499;
                        return true;
                    }
                    case 82: {
                        this.state = 518;
                        return true;
                    }
                }
                break;
            }
            case 499: {
                switch (current) {
                    case 101: {
                        this.state = 500;
                        return true;
                    }
                }
                break;
            }
            case 500: {
                switch (current) {
                    case 102: {
                        this.state = 501;
                        return true;
                    }
                }
                break;
            }
            case 501: {
                switch (current) {
                    case 116: {
                        this.state = 502;
                        return true;
                    }
                }
                break;
            }
            case 502: {
                switch (current) {
                    case 65: {
                        this.state = 503;
                        return true;
                    }
                    case 82: {
                        this.state = 508;
                        return true;
                    }
                }
                break;
            }
            case 503: {
                switch (current) {
                    case 114: {
                        this.state = 504;
                        return true;
                    }
                }
                break;
            }
            case 504: {
                switch (current) {
                    case 114: {
                        this.state = 505;
                        return true;
                    }
                }
                break;
            }
            case 505: {
                switch (current) {
                    case 111: {
                        this.state = 506;
                        return true;
                    }
                }
                break;
            }
            case 506: {
                switch (current) {
                    case 119: {
                        this.state = 507;
                        return true;
                    }
                }
                break;
            }
            case 507: {
                switch (current) {
                    case 59: {
                        this.match = "\u27f8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 508: {
                switch (current) {
                    case 105: {
                        this.state = 509;
                        return true;
                    }
                }
                break;
            }
            case 509: {
                switch (current) {
                    case 103: {
                        this.state = 510;
                        return true;
                    }
                }
                break;
            }
            case 510: {
                switch (current) {
                    case 104: {
                        this.state = 511;
                        return true;
                    }
                }
                break;
            }
            case 511: {
                switch (current) {
                    case 116: {
                        this.state = 512;
                        return true;
                    }
                }
                break;
            }
            case 512: {
                switch (current) {
                    case 65: {
                        this.state = 513;
                        return true;
                    }
                }
                break;
            }
            case 513: {
                switch (current) {
                    case 114: {
                        this.state = 514;
                        return true;
                    }
                }
                break;
            }
            case 514: {
                switch (current) {
                    case 114: {
                        this.state = 515;
                        return true;
                    }
                }
                break;
            }
            case 515: {
                switch (current) {
                    case 111: {
                        this.state = 516;
                        return true;
                    }
                }
                break;
            }
            case 516: {
                switch (current) {
                    case 119: {
                        this.state = 517;
                        return true;
                    }
                }
                break;
            }
            case 517: {
                switch (current) {
                    case 59: {
                        this.match = "\u27fa";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 518: {
                switch (current) {
                    case 105: {
                        this.state = 519;
                        return true;
                    }
                }
                break;
            }
            case 519: {
                switch (current) {
                    case 103: {
                        this.state = 520;
                        return true;
                    }
                }
                break;
            }
            case 520: {
                switch (current) {
                    case 104: {
                        this.state = 521;
                        return true;
                    }
                }
                break;
            }
            case 521: {
                switch (current) {
                    case 116: {
                        this.state = 522;
                        return true;
                    }
                }
                break;
            }
            case 522: {
                switch (current) {
                    case 65: {
                        this.state = 523;
                        return true;
                    }
                }
                break;
            }
            case 523: {
                switch (current) {
                    case 114: {
                        this.state = 524;
                        return true;
                    }
                }
                break;
            }
            case 524: {
                switch (current) {
                    case 114: {
                        this.state = 525;
                        return true;
                    }
                }
                break;
            }
            case 525: {
                switch (current) {
                    case 111: {
                        this.state = 526;
                        return true;
                    }
                }
                break;
            }
            case 526: {
                switch (current) {
                    case 119: {
                        this.state = 527;
                        return true;
                    }
                }
                break;
            }
            case 527: {
                switch (current) {
                    case 59: {
                        this.match = "\u27f9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 528: {
                switch (current) {
                    case 105: {
                        this.state = 529;
                        return true;
                    }
                }
                break;
            }
            case 529: {
                switch (current) {
                    case 103: {
                        this.state = 530;
                        return true;
                    }
                }
                break;
            }
            case 530: {
                switch (current) {
                    case 104: {
                        this.state = 531;
                        return true;
                    }
                }
                break;
            }
            case 531: {
                switch (current) {
                    case 116: {
                        this.state = 532;
                        return true;
                    }
                }
                break;
            }
            case 532: {
                switch (current) {
                    case 65: {
                        this.state = 533;
                        return true;
                    }
                    case 84: {
                        this.state = 538;
                        return true;
                    }
                }
                break;
            }
            case 533: {
                switch (current) {
                    case 114: {
                        this.state = 534;
                        return true;
                    }
                }
                break;
            }
            case 534: {
                switch (current) {
                    case 114: {
                        this.state = 535;
                        return true;
                    }
                }
                break;
            }
            case 535: {
                switch (current) {
                    case 111: {
                        this.state = 536;
                        return true;
                    }
                }
                break;
            }
            case 536: {
                switch (current) {
                    case 119: {
                        this.state = 537;
                        return true;
                    }
                }
                break;
            }
            case 537: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 538: {
                switch (current) {
                    case 101: {
                        this.state = 539;
                        return true;
                    }
                }
                break;
            }
            case 539: {
                switch (current) {
                    case 101: {
                        this.state = 540;
                        return true;
                    }
                }
                break;
            }
            case 540: {
                switch (current) {
                    case 59: {
                        this.match = "\u22a8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 541: {
                switch (current) {
                    case 112: {
                        this.state = 542;
                        return true;
                    }
                }
                break;
            }
            case 542: {
                switch (current) {
                    case 65: {
                        this.state = 543;
                        return true;
                    }
                    case 68: {
                        this.state = 548;
                        return true;
                    }
                }
                break;
            }
            case 543: {
                switch (current) {
                    case 114: {
                        this.state = 544;
                        return true;
                    }
                }
                break;
            }
            case 544: {
                switch (current) {
                    case 114: {
                        this.state = 545;
                        return true;
                    }
                }
                break;
            }
            case 545: {
                switch (current) {
                    case 111: {
                        this.state = 546;
                        return true;
                    }
                }
                break;
            }
            case 546: {
                switch (current) {
                    case 119: {
                        this.state = 547;
                        return true;
                    }
                }
                break;
            }
            case 547: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 548: {
                switch (current) {
                    case 111: {
                        this.state = 549;
                        return true;
                    }
                }
                break;
            }
            case 549: {
                switch (current) {
                    case 119: {
                        this.state = 550;
                        return true;
                    }
                }
                break;
            }
            case 550: {
                switch (current) {
                    case 110: {
                        this.state = 551;
                        return true;
                    }
                }
                break;
            }
            case 551: {
                switch (current) {
                    case 65: {
                        this.state = 552;
                        return true;
                    }
                }
                break;
            }
            case 552: {
                switch (current) {
                    case 114: {
                        this.state = 553;
                        return true;
                    }
                }
                break;
            }
            case 553: {
                switch (current) {
                    case 114: {
                        this.state = 554;
                        return true;
                    }
                }
                break;
            }
            case 554: {
                switch (current) {
                    case 111: {
                        this.state = 555;
                        return true;
                    }
                }
                break;
            }
            case 555: {
                switch (current) {
                    case 119: {
                        this.state = 556;
                        return true;
                    }
                }
                break;
            }
            case 556: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 557: {
                switch (current) {
                    case 101: {
                        this.state = 558;
                        return true;
                    }
                }
                break;
            }
            case 558: {
                switch (current) {
                    case 114: {
                        this.state = 559;
                        return true;
                    }
                }
                break;
            }
            case 559: {
                switch (current) {
                    case 116: {
                        this.state = 560;
                        return true;
                    }
                }
                break;
            }
            case 560: {
                switch (current) {
                    case 105: {
                        this.state = 561;
                        return true;
                    }
                }
                break;
            }
            case 561: {
                switch (current) {
                    case 99: {
                        this.state = 562;
                        return true;
                    }
                }
                break;
            }
            case 562: {
                switch (current) {
                    case 97: {
                        this.state = 563;
                        return true;
                    }
                }
                break;
            }
            case 563: {
                switch (current) {
                    case 108: {
                        this.state = 564;
                        return true;
                    }
                }
                break;
            }
            case 564: {
                switch (current) {
                    case 66: {
                        this.state = 565;
                        return true;
                    }
                }
                break;
            }
            case 565: {
                switch (current) {
                    case 97: {
                        this.state = 566;
                        return true;
                    }
                }
                break;
            }
            case 566: {
                switch (current) {
                    case 114: {
                        this.state = 567;
                        return true;
                    }
                }
                break;
            }
            case 567: {
                switch (current) {
                    case 59: {
                        this.match = "\u2225";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 568: {
                switch (current) {
                    case 110: {
                        this.state = 569;
                        return true;
                    }
                }
                break;
            }
            case 569: {
                switch (current) {
                    case 65: {
                        this.state = 570;
                        return true;
                    }
                    case 66: {
                        this.state = 585;
                        return true;
                    }
                    case 76: {
                        this.state = 590;
                        return true;
                    }
                    case 82: {
                        this.state = 623;
                        return true;
                    }
                    case 84: {
                        this.state = 646;
                        return true;
                    }
                    case 97: {
                        this.state = 654;
                        return true;
                    }
                }
                break;
            }
            case 570: {
                switch (current) {
                    case 114: {
                        this.state = 571;
                        return true;
                    }
                }
                break;
            }
            case 571: {
                switch (current) {
                    case 114: {
                        this.state = 572;
                        return true;
                    }
                }
                break;
            }
            case 572: {
                switch (current) {
                    case 111: {
                        this.state = 573;
                        return true;
                    }
                }
                break;
            }
            case 573: {
                switch (current) {
                    case 119: {
                        this.state = 574;
                        return true;
                    }
                }
                break;
            }
            case 574: {
                switch (current) {
                    case 59: {
                        this.match = "\u2193";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 575;
                        return true;
                    }
                    case 85: {
                        this.state = 578;
                        return true;
                    }
                }
                break;
            }
            case 575: {
                switch (current) {
                    case 97: {
                        this.state = 576;
                        return true;
                    }
                }
                break;
            }
            case 576: {
                switch (current) {
                    case 114: {
                        this.state = 577;
                        return true;
                    }
                }
                break;
            }
            case 577: {
                switch (current) {
                    case 59: {
                        this.match = "\u2913";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 578: {
                switch (current) {
                    case 112: {
                        this.state = 579;
                        return true;
                    }
                }
                break;
            }
            case 579: {
                switch (current) {
                    case 65: {
                        this.state = 580;
                        return true;
                    }
                }
                break;
            }
            case 580: {
                switch (current) {
                    case 114: {
                        this.state = 581;
                        return true;
                    }
                }
                break;
            }
            case 581: {
                switch (current) {
                    case 114: {
                        this.state = 582;
                        return true;
                    }
                }
                break;
            }
            case 582: {
                switch (current) {
                    case 111: {
                        this.state = 583;
                        return true;
                    }
                }
                break;
            }
            case 583: {
                switch (current) {
                    case 119: {
                        this.state = 584;
                        return true;
                    }
                }
                break;
            }
            case 584: {
                switch (current) {
                    case 59: {
                        this.match = "\u21f5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 585: {
                switch (current) {
                    case 114: {
                        this.state = 586;
                        return true;
                    }
                }
                break;
            }
            case 586: {
                switch (current) {
                    case 101: {
                        this.state = 587;
                        return true;
                    }
                }
                break;
            }
            case 587: {
                switch (current) {
                    case 118: {
                        this.state = 588;
                        return true;
                    }
                }
                break;
            }
            case 588: {
                switch (current) {
                    case 101: {
                        this.state = 589;
                        return true;
                    }
                }
                break;
            }
            case 589: {
                switch (current) {
                    case 59: {
                        this.match = "\u0311";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 590: {
                switch (current) {
                    case 101: {
                        this.state = 591;
                        return true;
                    }
                }
                break;
            }
            case 591: {
                switch (current) {
                    case 102: {
                        this.state = 592;
                        return true;
                    }
                }
                break;
            }
            case 592: {
                switch (current) {
                    case 116: {
                        this.state = 593;
                        return true;
                    }
                }
                break;
            }
            case 593: {
                switch (current) {
                    case 82: {
                        this.state = 594;
                        return true;
                    }
                    case 84: {
                        this.state = 605;
                        return true;
                    }
                    case 86: {
                        this.state = 614;
                        return true;
                    }
                }
                break;
            }
            case 594: {
                switch (current) {
                    case 105: {
                        this.state = 595;
                        return true;
                    }
                }
                break;
            }
            case 595: {
                switch (current) {
                    case 103: {
                        this.state = 596;
                        return true;
                    }
                }
                break;
            }
            case 596: {
                switch (current) {
                    case 104: {
                        this.state = 597;
                        return true;
                    }
                }
                break;
            }
            case 597: {
                switch (current) {
                    case 116: {
                        this.state = 598;
                        return true;
                    }
                }
                break;
            }
            case 598: {
                switch (current) {
                    case 86: {
                        this.state = 599;
                        return true;
                    }
                }
                break;
            }
            case 599: {
                switch (current) {
                    case 101: {
                        this.state = 600;
                        return true;
                    }
                }
                break;
            }
            case 600: {
                switch (current) {
                    case 99: {
                        this.state = 601;
                        return true;
                    }
                }
                break;
            }
            case 601: {
                switch (current) {
                    case 116: {
                        this.state = 602;
                        return true;
                    }
                }
                break;
            }
            case 602: {
                switch (current) {
                    case 111: {
                        this.state = 603;
                        return true;
                    }
                }
                break;
            }
            case 603: {
                switch (current) {
                    case 114: {
                        this.state = 604;
                        return true;
                    }
                }
                break;
            }
            case 604: {
                switch (current) {
                    case 59: {
                        this.match = "\u2950";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 605: {
                switch (current) {
                    case 101: {
                        this.state = 606;
                        return true;
                    }
                }
                break;
            }
            case 606: {
                switch (current) {
                    case 101: {
                        this.state = 607;
                        return true;
                    }
                }
                break;
            }
            case 607: {
                switch (current) {
                    case 86: {
                        this.state = 608;
                        return true;
                    }
                }
                break;
            }
            case 608: {
                switch (current) {
                    case 101: {
                        this.state = 609;
                        return true;
                    }
                }
                break;
            }
            case 609: {
                switch (current) {
                    case 99: {
                        this.state = 610;
                        return true;
                    }
                }
                break;
            }
            case 610: {
                switch (current) {
                    case 116: {
                        this.state = 611;
                        return true;
                    }
                }
                break;
            }
            case 611: {
                switch (current) {
                    case 111: {
                        this.state = 612;
                        return true;
                    }
                }
                break;
            }
            case 612: {
                switch (current) {
                    case 114: {
                        this.state = 613;
                        return true;
                    }
                }
                break;
            }
            case 613: {
                switch (current) {
                    case 59: {
                        this.match = "\u295e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 614: {
                switch (current) {
                    case 101: {
                        this.state = 615;
                        return true;
                    }
                }
                break;
            }
            case 615: {
                switch (current) {
                    case 99: {
                        this.state = 616;
                        return true;
                    }
                }
                break;
            }
            case 616: {
                switch (current) {
                    case 116: {
                        this.state = 617;
                        return true;
                    }
                }
                break;
            }
            case 617: {
                switch (current) {
                    case 111: {
                        this.state = 618;
                        return true;
                    }
                }
                break;
            }
            case 618: {
                switch (current) {
                    case 114: {
                        this.state = 619;
                        return true;
                    }
                }
                break;
            }
            case 619: {
                switch (current) {
                    case 59: {
                        this.match = "\u21bd";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 620;
                        return true;
                    }
                }
                break;
            }
            case 620: {
                switch (current) {
                    case 97: {
                        this.state = 621;
                        return true;
                    }
                }
                break;
            }
            case 621: {
                switch (current) {
                    case 114: {
                        this.state = 622;
                        return true;
                    }
                }
                break;
            }
            case 622: {
                switch (current) {
                    case 59: {
                        this.match = "\u2956";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 623: {
                switch (current) {
                    case 105: {
                        this.state = 624;
                        return true;
                    }
                }
                break;
            }
            case 624: {
                switch (current) {
                    case 103: {
                        this.state = 625;
                        return true;
                    }
                }
                break;
            }
            case 625: {
                switch (current) {
                    case 104: {
                        this.state = 626;
                        return true;
                    }
                }
                break;
            }
            case 626: {
                switch (current) {
                    case 116: {
                        this.state = 627;
                        return true;
                    }
                }
                break;
            }
            case 627: {
                switch (current) {
                    case 84: {
                        this.state = 628;
                        return true;
                    }
                    case 86: {
                        this.state = 637;
                        return true;
                    }
                }
                break;
            }
            case 628: {
                switch (current) {
                    case 101: {
                        this.state = 629;
                        return true;
                    }
                }
                break;
            }
            case 629: {
                switch (current) {
                    case 101: {
                        this.state = 630;
                        return true;
                    }
                }
                break;
            }
            case 630: {
                switch (current) {
                    case 86: {
                        this.state = 631;
                        return true;
                    }
                }
                break;
            }
            case 631: {
                switch (current) {
                    case 101: {
                        this.state = 632;
                        return true;
                    }
                }
                break;
            }
            case 632: {
                switch (current) {
                    case 99: {
                        this.state = 633;
                        return true;
                    }
                }
                break;
            }
            case 633: {
                switch (current) {
                    case 116: {
                        this.state = 634;
                        return true;
                    }
                }
                break;
            }
            case 634: {
                switch (current) {
                    case 111: {
                        this.state = 635;
                        return true;
                    }
                }
                break;
            }
            case 635: {
                switch (current) {
                    case 114: {
                        this.state = 636;
                        return true;
                    }
                }
                break;
            }
            case 636: {
                switch (current) {
                    case 59: {
                        this.match = "\u295f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 637: {
                switch (current) {
                    case 101: {
                        this.state = 638;
                        return true;
                    }
                }
                break;
            }
            case 638: {
                switch (current) {
                    case 99: {
                        this.state = 639;
                        return true;
                    }
                }
                break;
            }
            case 639: {
                switch (current) {
                    case 116: {
                        this.state = 640;
                        return true;
                    }
                }
                break;
            }
            case 640: {
                switch (current) {
                    case 111: {
                        this.state = 641;
                        return true;
                    }
                }
                break;
            }
            case 641: {
                switch (current) {
                    case 114: {
                        this.state = 642;
                        return true;
                    }
                }
                break;
            }
            case 642: {
                switch (current) {
                    case 59: {
                        this.match = "\u21c1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 643;
                        return true;
                    }
                }
                break;
            }
            case 643: {
                switch (current) {
                    case 97: {
                        this.state = 644;
                        return true;
                    }
                }
                break;
            }
            case 644: {
                switch (current) {
                    case 114: {
                        this.state = 645;
                        return true;
                    }
                }
                break;
            }
            case 645: {
                switch (current) {
                    case 59: {
                        this.match = "\u2957";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 646: {
                switch (current) {
                    case 101: {
                        this.state = 647;
                        return true;
                    }
                }
                break;
            }
            case 647: {
                switch (current) {
                    case 101: {
                        this.state = 648;
                        return true;
                    }
                }
                break;
            }
            case 648: {
                switch (current) {
                    case 59: {
                        this.match = "\u22a4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 65: {
                        this.state = 649;
                        return true;
                    }
                }
                break;
            }
            case 649: {
                switch (current) {
                    case 114: {
                        this.state = 650;
                        return true;
                    }
                }
                break;
            }
            case 650: {
                switch (current) {
                    case 114: {
                        this.state = 651;
                        return true;
                    }
                }
                break;
            }
            case 651: {
                switch (current) {
                    case 111: {
                        this.state = 652;
                        return true;
                    }
                }
                break;
            }
            case 652: {
                switch (current) {
                    case 119: {
                        this.state = 653;
                        return true;
                    }
                }
                break;
            }
            case 653: {
                switch (current) {
                    case 59: {
                        this.match = "\u21a7";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 654: {
                switch (current) {
                    case 114: {
                        this.state = 655;
                        return true;
                    }
                }
                break;
            }
            case 655: {
                switch (current) {
                    case 114: {
                        this.state = 656;
                        return true;
                    }
                }
                break;
            }
            case 656: {
                switch (current) {
                    case 111: {
                        this.state = 657;
                        return true;
                    }
                }
                break;
            }
            case 657: {
                switch (current) {
                    case 119: {
                        this.state = 658;
                        return true;
                    }
                }
                break;
            }
            case 658: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 659: {
                switch (current) {
                    case 99: {
                        this.state = 660;
                        return true;
                    }
                    case 116: {
                        this.state = 662;
                        return true;
                    }
                }
                break;
            }
            case 660: {
                switch (current) {
                    case 114: {
                        this.state = 661;
                        return true;
                    }
                }
                break;
            }
            case 661: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udc9f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 662: {
                switch (current) {
                    case 114: {
                        this.state = 663;
                        return true;
                    }
                }
                break;
            }
            case 663: {
                switch (current) {
                    case 111: {
                        this.state = 664;
                        return true;
                    }
                }
                break;
            }
            case 664: {
                switch (current) {
                    case 107: {
                        this.state = 665;
                        return true;
                    }
                }
                break;
            }
            case 665: {
                switch (current) {
                    case 59: {
                        this.match = "\u0110";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 666: {
                switch (current) {
                    case 78: {
                        this.state = 667;
                        return true;
                    }
                    case 84: {
                        this.state = 669;
                        return true;
                    }
                    case 97: {
                        this.state = 671;
                        return true;
                    }
                    case 99: {
                        this.state = 676;
                        return true;
                    }
                    case 100: {
                        this.state = 685;
                        return true;
                    }
                    case 102: {
                        this.state = 688;
                        return true;
                    }
                    case 103: {
                        this.state = 690;
                        return true;
                    }
                    case 108: {
                        this.state = 695;
                        return true;
                    }
                    case 109: {
                        this.state = 701;
                        return true;
                    }
                    case 111: {
                        this.state = 734;
                        return true;
                    }
                    case 112: {
                        this.state = 740;
                        return true;
                    }
                    case 113: {
                        this.state = 746;
                        return true;
                    }
                    case 115: {
                        this.state = 763;
                        return true;
                    }
                    case 116: {
                        this.state = 768;
                        return true;
                    }
                    case 117: {
                        this.state = 770;
                        return true;
                    }
                    case 120: {
                        this.state = 773;
                        return true;
                    }
                }
                break;
            }
            case 667: {
                switch (current) {
                    case 71: {
                        this.state = 668;
                        return true;
                    }
                }
                break;
            }
            case 668: {
                switch (current) {
                    case 59: {
                        this.match = "\u014a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 669: {
                switch (current) {
                    case 72: {
                        this.match = "\u00d0";
                        this.matchLength = this.consumedCount;
                        this.state = 670;
                        return true;
                    }
                }
                break;
            }
            case 670: {
                switch (current) {
                    case 59: {
                        this.match = "\u00d0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 671: {
                switch (current) {
                    case 99: {
                        this.state = 672;
                        return true;
                    }
                }
                break;
            }
            case 672: {
                switch (current) {
                    case 117: {
                        this.state = 673;
                        return true;
                    }
                }
                break;
            }
            case 673: {
                switch (current) {
                    case 116: {
                        this.state = 674;
                        return true;
                    }
                }
                break;
            }
            case 674: {
                switch (current) {
                    case 101: {
                        this.match = "\u00c9";
                        this.matchLength = this.consumedCount;
                        this.state = 675;
                        return true;
                    }
                }
                break;
            }
            case 675: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 676: {
                switch (current) {
                    case 97: {
                        this.state = 677;
                        return true;
                    }
                    case 105: {
                        this.state = 681;
                        return true;
                    }
                    case 121: {
                        this.state = 684;
                        return true;
                    }
                }
                break;
            }
            case 677: {
                switch (current) {
                    case 114: {
                        this.state = 678;
                        return true;
                    }
                }
                break;
            }
            case 678: {
                switch (current) {
                    case 111: {
                        this.state = 679;
                        return true;
                    }
                }
                break;
            }
            case 679: {
                switch (current) {
                    case 110: {
                        this.state = 680;
                        return true;
                    }
                }
                break;
            }
            case 680: {
                switch (current) {
                    case 59: {
                        this.match = "\u011a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 681: {
                switch (current) {
                    case 114: {
                        this.state = 682;
                        return true;
                    }
                }
                break;
            }
            case 682: {
                switch (current) {
                    case 99: {
                        this.match = "\u00ca";
                        this.matchLength = this.consumedCount;
                        this.state = 683;
                        return true;
                    }
                }
                break;
            }
            case 683: {
                switch (current) {
                    case 59: {
                        this.match = "\u00ca";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 684: {
                switch (current) {
                    case 59: {
                        this.match = "\u042d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 685: {
                switch (current) {
                    case 111: {
                        this.state = 686;
                        return true;
                    }
                }
                break;
            }
            case 686: {
                switch (current) {
                    case 116: {
                        this.state = 687;
                        return true;
                    }
                }
                break;
            }
            case 687: {
                switch (current) {
                    case 59: {
                        this.match = "\u0116";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 688: {
                switch (current) {
                    case 114: {
                        this.state = 689;
                        return true;
                    }
                }
                break;
            }
            case 689: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd08";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 690: {
                switch (current) {
                    case 114: {
                        this.state = 691;
                        return true;
                    }
                }
                break;
            }
            case 691: {
                switch (current) {
                    case 97: {
                        this.state = 692;
                        return true;
                    }
                }
                break;
            }
            case 692: {
                switch (current) {
                    case 118: {
                        this.state = 693;
                        return true;
                    }
                }
                break;
            }
            case 693: {
                switch (current) {
                    case 101: {
                        this.match = "\u00c8";
                        this.matchLength = this.consumedCount;
                        this.state = 694;
                        return true;
                    }
                }
                break;
            }
            case 694: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 695: {
                switch (current) {
                    case 101: {
                        this.state = 696;
                        return true;
                    }
                }
                break;
            }
            case 696: {
                switch (current) {
                    case 109: {
                        this.state = 697;
                        return true;
                    }
                }
                break;
            }
            case 697: {
                switch (current) {
                    case 101: {
                        this.state = 698;
                        return true;
                    }
                }
                break;
            }
            case 698: {
                switch (current) {
                    case 110: {
                        this.state = 699;
                        return true;
                    }
                }
                break;
            }
            case 699: {
                switch (current) {
                    case 116: {
                        this.state = 700;
                        return true;
                    }
                }
                break;
            }
            case 700: {
                switch (current) {
                    case 59: {
                        this.match = "\u2208";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 701: {
                switch (current) {
                    case 97: {
                        this.state = 702;
                        return true;
                    }
                    case 112: {
                        this.state = 705;
                        return true;
                    }
                }
                break;
            }
            case 702: {
                switch (current) {
                    case 99: {
                        this.state = 703;
                        return true;
                    }
                }
                break;
            }
            case 703: {
                switch (current) {
                    case 114: {
                        this.state = 704;
                        return true;
                    }
                }
                break;
            }
            case 704: {
                switch (current) {
                    case 59: {
                        this.match = "\u0112";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 705: {
                switch (current) {
                    case 116: {
                        this.state = 706;
                        return true;
                    }
                }
                break;
            }
            case 706: {
                switch (current) {
                    case 121: {
                        this.state = 707;
                        return true;
                    }
                }
                break;
            }
            case 707: {
                switch (current) {
                    case 83: {
                        this.state = 708;
                        return true;
                    }
                    case 86: {
                        this.state = 719;
                        return true;
                    }
                }
                break;
            }
            case 708: {
                switch (current) {
                    case 109: {
                        this.state = 709;
                        return true;
                    }
                }
                break;
            }
            case 709: {
                switch (current) {
                    case 97: {
                        this.state = 710;
                        return true;
                    }
                }
                break;
            }
            case 710: {
                switch (current) {
                    case 108: {
                        this.state = 711;
                        return true;
                    }
                }
                break;
            }
            case 711: {
                switch (current) {
                    case 108: {
                        this.state = 712;
                        return true;
                    }
                }
                break;
            }
            case 712: {
                switch (current) {
                    case 83: {
                        this.state = 713;
                        return true;
                    }
                }
                break;
            }
            case 713: {
                switch (current) {
                    case 113: {
                        this.state = 714;
                        return true;
                    }
                }
                break;
            }
            case 714: {
                switch (current) {
                    case 117: {
                        this.state = 715;
                        return true;
                    }
                }
                break;
            }
            case 715: {
                switch (current) {
                    case 97: {
                        this.state = 716;
                        return true;
                    }
                }
                break;
            }
            case 716: {
                switch (current) {
                    case 114: {
                        this.state = 717;
                        return true;
                    }
                }
                break;
            }
            case 717: {
                switch (current) {
                    case 101: {
                        this.state = 718;
                        return true;
                    }
                }
                break;
            }
            case 718: {
                switch (current) {
                    case 59: {
                        this.match = "\u25fb";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 719: {
                switch (current) {
                    case 101: {
                        this.state = 720;
                        return true;
                    }
                }
                break;
            }
            case 720: {
                switch (current) {
                    case 114: {
                        this.state = 721;
                        return true;
                    }
                }
                break;
            }
            case 721: {
                switch (current) {
                    case 121: {
                        this.state = 722;
                        return true;
                    }
                }
                break;
            }
            case 722: {
                switch (current) {
                    case 83: {
                        this.state = 723;
                        return true;
                    }
                }
                break;
            }
            case 723: {
                switch (current) {
                    case 109: {
                        this.state = 724;
                        return true;
                    }
                }
                break;
            }
            case 724: {
                switch (current) {
                    case 97: {
                        this.state = 725;
                        return true;
                    }
                }
                break;
            }
            case 725: {
                switch (current) {
                    case 108: {
                        this.state = 726;
                        return true;
                    }
                }
                break;
            }
            case 726: {
                switch (current) {
                    case 108: {
                        this.state = 727;
                        return true;
                    }
                }
                break;
            }
            case 727: {
                switch (current) {
                    case 83: {
                        this.state = 728;
                        return true;
                    }
                }
                break;
            }
            case 728: {
                switch (current) {
                    case 113: {
                        this.state = 729;
                        return true;
                    }
                }
                break;
            }
            case 729: {
                switch (current) {
                    case 117: {
                        this.state = 730;
                        return true;
                    }
                }
                break;
            }
            case 730: {
                switch (current) {
                    case 97: {
                        this.state = 731;
                        return true;
                    }
                }
                break;
            }
            case 731: {
                switch (current) {
                    case 114: {
                        this.state = 732;
                        return true;
                    }
                }
                break;
            }
            case 732: {
                switch (current) {
                    case 101: {
                        this.state = 733;
                        return true;
                    }
                }
                break;
            }
            case 733: {
                switch (current) {
                    case 59: {
                        this.match = "\u25ab";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 734: {
                switch (current) {
                    case 103: {
                        this.state = 735;
                        return true;
                    }
                    case 112: {
                        this.state = 738;
                        return true;
                    }
                }
                break;
            }
            case 735: {
                switch (current) {
                    case 111: {
                        this.state = 736;
                        return true;
                    }
                }
                break;
            }
            case 736: {
                switch (current) {
                    case 110: {
                        this.state = 737;
                        return true;
                    }
                }
                break;
            }
            case 737: {
                switch (current) {
                    case 59: {
                        this.match = "\u0118";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 738: {
                switch (current) {
                    case 102: {
                        this.state = 739;
                        return true;
                    }
                }
                break;
            }
            case 739: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd3c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 740: {
                switch (current) {
                    case 115: {
                        this.state = 741;
                        return true;
                    }
                }
                break;
            }
            case 741: {
                switch (current) {
                    case 105: {
                        this.state = 742;
                        return true;
                    }
                }
                break;
            }
            case 742: {
                switch (current) {
                    case 108: {
                        this.state = 743;
                        return true;
                    }
                }
                break;
            }
            case 743: {
                switch (current) {
                    case 111: {
                        this.state = 744;
                        return true;
                    }
                }
                break;
            }
            case 744: {
                switch (current) {
                    case 110: {
                        this.state = 745;
                        return true;
                    }
                }
                break;
            }
            case 745: {
                switch (current) {
                    case 59: {
                        this.match = "\u0395";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 746: {
                switch (current) {
                    case 117: {
                        this.state = 747;
                        return true;
                    }
                }
                break;
            }
            case 747: {
                switch (current) {
                    case 97: {
                        this.state = 748;
                        return true;
                    }
                    case 105: {
                        this.state = 755;
                        return true;
                    }
                }
                break;
            }
            case 748: {
                switch (current) {
                    case 108: {
                        this.state = 749;
                        return true;
                    }
                }
                break;
            }
            case 749: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a75";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 84: {
                        this.state = 750;
                        return true;
                    }
                }
                break;
            }
            case 750: {
                switch (current) {
                    case 105: {
                        this.state = 751;
                        return true;
                    }
                }
                break;
            }
            case 751: {
                switch (current) {
                    case 108: {
                        this.state = 752;
                        return true;
                    }
                }
                break;
            }
            case 752: {
                switch (current) {
                    case 100: {
                        this.state = 753;
                        return true;
                    }
                }
                break;
            }
            case 753: {
                switch (current) {
                    case 101: {
                        this.state = 754;
                        return true;
                    }
                }
                break;
            }
            case 754: {
                switch (current) {
                    case 59: {
                        this.match = "\u2242";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 755: {
                switch (current) {
                    case 108: {
                        this.state = 756;
                        return true;
                    }
                }
                break;
            }
            case 756: {
                switch (current) {
                    case 105: {
                        this.state = 757;
                        return true;
                    }
                }
                break;
            }
            case 757: {
                switch (current) {
                    case 98: {
                        this.state = 758;
                        return true;
                    }
                }
                break;
            }
            case 758: {
                switch (current) {
                    case 114: {
                        this.state = 759;
                        return true;
                    }
                }
                break;
            }
            case 759: {
                switch (current) {
                    case 105: {
                        this.state = 760;
                        return true;
                    }
                }
                break;
            }
            case 760: {
                switch (current) {
                    case 117: {
                        this.state = 761;
                        return true;
                    }
                }
                break;
            }
            case 761: {
                switch (current) {
                    case 109: {
                        this.state = 762;
                        return true;
                    }
                }
                break;
            }
            case 762: {
                switch (current) {
                    case 59: {
                        this.match = "\u21cc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 763: {
                switch (current) {
                    case 99: {
                        this.state = 764;
                        return true;
                    }
                    case 105: {
                        this.state = 766;
                        return true;
                    }
                }
                break;
            }
            case 764: {
                switch (current) {
                    case 114: {
                        this.state = 765;
                        return true;
                    }
                }
                break;
            }
            case 765: {
                switch (current) {
                    case 59: {
                        this.match = "\u2130";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 766: {
                switch (current) {
                    case 109: {
                        this.state = 767;
                        return true;
                    }
                }
                break;
            }
            case 767: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a73";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 768: {
                switch (current) {
                    case 97: {
                        this.state = 769;
                        return true;
                    }
                }
                break;
            }
            case 769: {
                switch (current) {
                    case 59: {
                        this.match = "\u0397";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 770: {
                switch (current) {
                    case 109: {
                        this.state = 771;
                        return true;
                    }
                }
                break;
            }
            case 771: {
                switch (current) {
                    case 108: {
                        this.match = "\u00cb";
                        this.matchLength = this.consumedCount;
                        this.state = 772;
                        return true;
                    }
                }
                break;
            }
            case 772: {
                switch (current) {
                    case 59: {
                        this.match = "\u00cb";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 773: {
                switch (current) {
                    case 105: {
                        this.state = 774;
                        return true;
                    }
                    case 112: {
                        this.state = 778;
                        return true;
                    }
                }
                break;
            }
            case 774: {
                switch (current) {
                    case 115: {
                        this.state = 775;
                        return true;
                    }
                }
                break;
            }
            case 775: {
                switch (current) {
                    case 116: {
                        this.state = 776;
                        return true;
                    }
                }
                break;
            }
            case 776: {
                switch (current) {
                    case 115: {
                        this.state = 777;
                        return true;
                    }
                }
                break;
            }
            case 777: {
                switch (current) {
                    case 59: {
                        this.match = "\u2203";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 778: {
                switch (current) {
                    case 111: {
                        this.state = 779;
                        return true;
                    }
                }
                break;
            }
            case 779: {
                switch (current) {
                    case 110: {
                        this.state = 780;
                        return true;
                    }
                }
                break;
            }
            case 780: {
                switch (current) {
                    case 101: {
                        this.state = 781;
                        return true;
                    }
                }
                break;
            }
            case 781: {
                switch (current) {
                    case 110: {
                        this.state = 782;
                        return true;
                    }
                }
                break;
            }
            case 782: {
                switch (current) {
                    case 116: {
                        this.state = 783;
                        return true;
                    }
                }
                break;
            }
            case 783: {
                switch (current) {
                    case 105: {
                        this.state = 784;
                        return true;
                    }
                }
                break;
            }
            case 784: {
                switch (current) {
                    case 97: {
                        this.state = 785;
                        return true;
                    }
                }
                break;
            }
            case 785: {
                switch (current) {
                    case 108: {
                        this.state = 786;
                        return true;
                    }
                }
                break;
            }
            case 786: {
                switch (current) {
                    case 69: {
                        this.state = 787;
                        return true;
                    }
                }
                break;
            }
            case 787: {
                switch (current) {
                    case 59: {
                        this.match = "\u2147";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 788: {
                switch (current) {
                    case 99: {
                        this.state = 789;
                        return true;
                    }
                    case 102: {
                        this.state = 791;
                        return true;
                    }
                    case 105: {
                        this.state = 793;
                        return true;
                    }
                    case 111: {
                        this.state = 824;
                        return true;
                    }
                    case 115: {
                        this.state = 839;
                        return true;
                    }
                }
                break;
            }
            case 789: {
                switch (current) {
                    case 121: {
                        this.state = 790;
                        return true;
                    }
                }
                break;
            }
            case 790: {
                switch (current) {
                    case 59: {
                        this.match = "\u0424";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 791: {
                switch (current) {
                    case 114: {
                        this.state = 792;
                        return true;
                    }
                }
                break;
            }
            case 792: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd09";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 793: {
                switch (current) {
                    case 108: {
                        this.state = 794;
                        return true;
                    }
                }
                break;
            }
            case 794: {
                switch (current) {
                    case 108: {
                        this.state = 795;
                        return true;
                    }
                }
                break;
            }
            case 795: {
                switch (current) {
                    case 101: {
                        this.state = 796;
                        return true;
                    }
                }
                break;
            }
            case 796: {
                switch (current) {
                    case 100: {
                        this.state = 797;
                        return true;
                    }
                }
                break;
            }
            case 797: {
                switch (current) {
                    case 83: {
                        this.state = 798;
                        return true;
                    }
                    case 86: {
                        this.state = 809;
                        return true;
                    }
                }
                break;
            }
            case 798: {
                switch (current) {
                    case 109: {
                        this.state = 799;
                        return true;
                    }
                }
                break;
            }
            case 799: {
                switch (current) {
                    case 97: {
                        this.state = 800;
                        return true;
                    }
                }
                break;
            }
            case 800: {
                switch (current) {
                    case 108: {
                        this.state = 801;
                        return true;
                    }
                }
                break;
            }
            case 801: {
                switch (current) {
                    case 108: {
                        this.state = 802;
                        return true;
                    }
                }
                break;
            }
            case 802: {
                switch (current) {
                    case 83: {
                        this.state = 803;
                        return true;
                    }
                }
                break;
            }
            case 803: {
                switch (current) {
                    case 113: {
                        this.state = 804;
                        return true;
                    }
                }
                break;
            }
            case 804: {
                switch (current) {
                    case 117: {
                        this.state = 805;
                        return true;
                    }
                }
                break;
            }
            case 805: {
                switch (current) {
                    case 97: {
                        this.state = 806;
                        return true;
                    }
                }
                break;
            }
            case 806: {
                switch (current) {
                    case 114: {
                        this.state = 807;
                        return true;
                    }
                }
                break;
            }
            case 807: {
                switch (current) {
                    case 101: {
                        this.state = 808;
                        return true;
                    }
                }
                break;
            }
            case 808: {
                switch (current) {
                    case 59: {
                        this.match = "\u25fc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 809: {
                switch (current) {
                    case 101: {
                        this.state = 810;
                        return true;
                    }
                }
                break;
            }
            case 810: {
                switch (current) {
                    case 114: {
                        this.state = 811;
                        return true;
                    }
                }
                break;
            }
            case 811: {
                switch (current) {
                    case 121: {
                        this.state = 812;
                        return true;
                    }
                }
                break;
            }
            case 812: {
                switch (current) {
                    case 83: {
                        this.state = 813;
                        return true;
                    }
                }
                break;
            }
            case 813: {
                switch (current) {
                    case 109: {
                        this.state = 814;
                        return true;
                    }
                }
                break;
            }
            case 814: {
                switch (current) {
                    case 97: {
                        this.state = 815;
                        return true;
                    }
                }
                break;
            }
            case 815: {
                switch (current) {
                    case 108: {
                        this.state = 816;
                        return true;
                    }
                }
                break;
            }
            case 816: {
                switch (current) {
                    case 108: {
                        this.state = 817;
                        return true;
                    }
                }
                break;
            }
            case 817: {
                switch (current) {
                    case 83: {
                        this.state = 818;
                        return true;
                    }
                }
                break;
            }
            case 818: {
                switch (current) {
                    case 113: {
                        this.state = 819;
                        return true;
                    }
                }
                break;
            }
            case 819: {
                switch (current) {
                    case 117: {
                        this.state = 820;
                        return true;
                    }
                }
                break;
            }
            case 820: {
                switch (current) {
                    case 97: {
                        this.state = 821;
                        return true;
                    }
                }
                break;
            }
            case 821: {
                switch (current) {
                    case 114: {
                        this.state = 822;
                        return true;
                    }
                }
                break;
            }
            case 822: {
                switch (current) {
                    case 101: {
                        this.state = 823;
                        return true;
                    }
                }
                break;
            }
            case 823: {
                switch (current) {
                    case 59: {
                        this.match = "\u25aa";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 824: {
                switch (current) {
                    case 112: {
                        this.state = 825;
                        return true;
                    }
                    case 114: {
                        this.state = 827;
                        return true;
                    }
                    case 117: {
                        this.state = 831;
                        return true;
                    }
                }
                break;
            }
            case 825: {
                switch (current) {
                    case 102: {
                        this.state = 826;
                        return true;
                    }
                }
                break;
            }
            case 826: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd3d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 827: {
                switch (current) {
                    case 65: {
                        this.state = 828;
                        return true;
                    }
                }
                break;
            }
            case 828: {
                switch (current) {
                    case 108: {
                        this.state = 829;
                        return true;
                    }
                }
                break;
            }
            case 829: {
                switch (current) {
                    case 108: {
                        this.state = 830;
                        return true;
                    }
                }
                break;
            }
            case 830: {
                switch (current) {
                    case 59: {
                        this.match = "\u2200";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 831: {
                switch (current) {
                    case 114: {
                        this.state = 832;
                        return true;
                    }
                }
                break;
            }
            case 832: {
                switch (current) {
                    case 105: {
                        this.state = 833;
                        return true;
                    }
                }
                break;
            }
            case 833: {
                switch (current) {
                    case 101: {
                        this.state = 834;
                        return true;
                    }
                }
                break;
            }
            case 834: {
                switch (current) {
                    case 114: {
                        this.state = 835;
                        return true;
                    }
                }
                break;
            }
            case 835: {
                switch (current) {
                    case 116: {
                        this.state = 836;
                        return true;
                    }
                }
                break;
            }
            case 836: {
                switch (current) {
                    case 114: {
                        this.state = 837;
                        return true;
                    }
                }
                break;
            }
            case 837: {
                switch (current) {
                    case 102: {
                        this.state = 838;
                        return true;
                    }
                }
                break;
            }
            case 838: {
                switch (current) {
                    case 59: {
                        this.match = "\u2131";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 839: {
                switch (current) {
                    case 99: {
                        this.state = 840;
                        return true;
                    }
                }
                break;
            }
            case 840: {
                switch (current) {
                    case 114: {
                        this.state = 841;
                        return true;
                    }
                }
                break;
            }
            case 841: {
                switch (current) {
                    case 59: {
                        this.match = "\u2131";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 842: {
                switch (current) {
                    case 74: {
                        this.state = 843;
                        return true;
                    }
                    case 84: {
                        this.match = ">";
                        this.matchLength = this.consumedCount;
                        this.state = 846;
                        return true;
                    }
                    case 97: {
                        this.state = 847;
                        return true;
                    }
                    case 98: {
                        this.state = 852;
                        return true;
                    }
                    case 99: {
                        this.state = 857;
                        return true;
                    }
                    case 100: {
                        this.state = 866;
                        return true;
                    }
                    case 102: {
                        this.state = 869;
                        return true;
                    }
                    case 103: {
                        this.state = 871;
                        return true;
                    }
                    case 111: {
                        this.state = 872;
                        return true;
                    }
                    case 114: {
                        this.state = 875;
                        return true;
                    }
                    case 115: {
                        this.state = 925;
                        return true;
                    }
                    case 116: {
                        this.state = 928;
                        return true;
                    }
                }
                break;
            }
            case 843: {
                switch (current) {
                    case 99: {
                        this.state = 844;
                        return true;
                    }
                }
                break;
            }
            case 844: {
                switch (current) {
                    case 121: {
                        this.state = 845;
                        return true;
                    }
                }
                break;
            }
            case 845: {
                switch (current) {
                    case 59: {
                        this.match = "\u0403";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 846: {
                switch (current) {
                    case 59: {
                        this.match = ">";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 847: {
                switch (current) {
                    case 109: {
                        this.state = 848;
                        return true;
                    }
                }
                break;
            }
            case 848: {
                switch (current) {
                    case 109: {
                        this.state = 849;
                        return true;
                    }
                }
                break;
            }
            case 849: {
                switch (current) {
                    case 97: {
                        this.state = 850;
                        return true;
                    }
                }
                break;
            }
            case 850: {
                switch (current) {
                    case 59: {
                        this.match = "\u0393";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 100: {
                        this.state = 851;
                        return true;
                    }
                }
                break;
            }
            case 851: {
                switch (current) {
                    case 59: {
                        this.match = "\u03dc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 852: {
                switch (current) {
                    case 114: {
                        this.state = 853;
                        return true;
                    }
                }
                break;
            }
            case 853: {
                switch (current) {
                    case 101: {
                        this.state = 854;
                        return true;
                    }
                }
                break;
            }
            case 854: {
                switch (current) {
                    case 118: {
                        this.state = 855;
                        return true;
                    }
                }
                break;
            }
            case 855: {
                switch (current) {
                    case 101: {
                        this.state = 856;
                        return true;
                    }
                }
                break;
            }
            case 856: {
                switch (current) {
                    case 59: {
                        this.match = "\u011e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 857: {
                switch (current) {
                    case 101: {
                        this.state = 858;
                        return true;
                    }
                    case 105: {
                        this.state = 862;
                        return true;
                    }
                    case 121: {
                        this.state = 865;
                        return true;
                    }
                }
                break;
            }
            case 858: {
                switch (current) {
                    case 100: {
                        this.state = 859;
                        return true;
                    }
                }
                break;
            }
            case 859: {
                switch (current) {
                    case 105: {
                        this.state = 860;
                        return true;
                    }
                }
                break;
            }
            case 860: {
                switch (current) {
                    case 108: {
                        this.state = 861;
                        return true;
                    }
                }
                break;
            }
            case 861: {
                switch (current) {
                    case 59: {
                        this.match = "\u0122";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 862: {
                switch (current) {
                    case 114: {
                        this.state = 863;
                        return true;
                    }
                }
                break;
            }
            case 863: {
                switch (current) {
                    case 99: {
                        this.state = 864;
                        return true;
                    }
                }
                break;
            }
            case 864: {
                switch (current) {
                    case 59: {
                        this.match = "\u011c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 865: {
                switch (current) {
                    case 59: {
                        this.match = "\u0413";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 866: {
                switch (current) {
                    case 111: {
                        this.state = 867;
                        return true;
                    }
                }
                break;
            }
            case 867: {
                switch (current) {
                    case 116: {
                        this.state = 868;
                        return true;
                    }
                }
                break;
            }
            case 868: {
                switch (current) {
                    case 59: {
                        this.match = "\u0120";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 869: {
                switch (current) {
                    case 114: {
                        this.state = 870;
                        return true;
                    }
                }
                break;
            }
            case 870: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd0a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 871: {
                switch (current) {
                    case 59: {
                        this.match = "\u22d9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 872: {
                switch (current) {
                    case 112: {
                        this.state = 873;
                        return true;
                    }
                }
                break;
            }
            case 873: {
                switch (current) {
                    case 102: {
                        this.state = 874;
                        return true;
                    }
                }
                break;
            }
            case 874: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd3e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 875: {
                switch (current) {
                    case 101: {
                        this.state = 876;
                        return true;
                    }
                }
                break;
            }
            case 876: {
                switch (current) {
                    case 97: {
                        this.state = 877;
                        return true;
                    }
                }
                break;
            }
            case 877: {
                switch (current) {
                    case 116: {
                        this.state = 878;
                        return true;
                    }
                }
                break;
            }
            case 878: {
                switch (current) {
                    case 101: {
                        this.state = 879;
                        return true;
                    }
                }
                break;
            }
            case 879: {
                switch (current) {
                    case 114: {
                        this.state = 880;
                        return true;
                    }
                }
                break;
            }
            case 880: {
                switch (current) {
                    case 69: {
                        this.state = 881;
                        return true;
                    }
                    case 70: {
                        this.state = 890;
                        return true;
                    }
                    case 71: {
                        this.state = 899;
                        return true;
                    }
                    case 76: {
                        this.state = 906;
                        return true;
                    }
                    case 83: {
                        this.state = 910;
                        return true;
                    }
                    case 84: {
                        this.state = 920;
                        return true;
                    }
                }
                break;
            }
            case 881: {
                switch (current) {
                    case 113: {
                        this.state = 882;
                        return true;
                    }
                }
                break;
            }
            case 882: {
                switch (current) {
                    case 117: {
                        this.state = 883;
                        return true;
                    }
                }
                break;
            }
            case 883: {
                switch (current) {
                    case 97: {
                        this.state = 884;
                        return true;
                    }
                }
                break;
            }
            case 884: {
                switch (current) {
                    case 108: {
                        this.state = 885;
                        return true;
                    }
                }
                break;
            }
            case 885: {
                switch (current) {
                    case 59: {
                        this.match = "\u2265";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 76: {
                        this.state = 886;
                        return true;
                    }
                }
                break;
            }
            case 886: {
                switch (current) {
                    case 101: {
                        this.state = 887;
                        return true;
                    }
                }
                break;
            }
            case 887: {
                switch (current) {
                    case 115: {
                        this.state = 888;
                        return true;
                    }
                }
                break;
            }
            case 888: {
                switch (current) {
                    case 115: {
                        this.state = 889;
                        return true;
                    }
                }
                break;
            }
            case 889: {
                switch (current) {
                    case 59: {
                        this.match = "\u22db";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 890: {
                switch (current) {
                    case 117: {
                        this.state = 891;
                        return true;
                    }
                }
                break;
            }
            case 891: {
                switch (current) {
                    case 108: {
                        this.state = 892;
                        return true;
                    }
                }
                break;
            }
            case 892: {
                switch (current) {
                    case 108: {
                        this.state = 893;
                        return true;
                    }
                }
                break;
            }
            case 893: {
                switch (current) {
                    case 69: {
                        this.state = 894;
                        return true;
                    }
                }
                break;
            }
            case 894: {
                switch (current) {
                    case 113: {
                        this.state = 895;
                        return true;
                    }
                }
                break;
            }
            case 895: {
                switch (current) {
                    case 117: {
                        this.state = 896;
                        return true;
                    }
                }
                break;
            }
            case 896: {
                switch (current) {
                    case 97: {
                        this.state = 897;
                        return true;
                    }
                }
                break;
            }
            case 897: {
                switch (current) {
                    case 108: {
                        this.state = 898;
                        return true;
                    }
                }
                break;
            }
            case 898: {
                switch (current) {
                    case 59: {
                        this.match = "\u2267";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 899: {
                switch (current) {
                    case 114: {
                        this.state = 900;
                        return true;
                    }
                }
                break;
            }
            case 900: {
                switch (current) {
                    case 101: {
                        this.state = 901;
                        return true;
                    }
                }
                break;
            }
            case 901: {
                switch (current) {
                    case 97: {
                        this.state = 902;
                        return true;
                    }
                }
                break;
            }
            case 902: {
                switch (current) {
                    case 116: {
                        this.state = 903;
                        return true;
                    }
                }
                break;
            }
            case 903: {
                switch (current) {
                    case 101: {
                        this.state = 904;
                        return true;
                    }
                }
                break;
            }
            case 904: {
                switch (current) {
                    case 114: {
                        this.state = 905;
                        return true;
                    }
                }
                break;
            }
            case 905: {
                switch (current) {
                    case 59: {
                        this.match = "\u2aa2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 906: {
                switch (current) {
                    case 101: {
                        this.state = 907;
                        return true;
                    }
                }
                break;
            }
            case 907: {
                switch (current) {
                    case 115: {
                        this.state = 908;
                        return true;
                    }
                }
                break;
            }
            case 908: {
                switch (current) {
                    case 115: {
                        this.state = 909;
                        return true;
                    }
                }
                break;
            }
            case 909: {
                switch (current) {
                    case 59: {
                        this.match = "\u2277";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 910: {
                switch (current) {
                    case 108: {
                        this.state = 911;
                        return true;
                    }
                }
                break;
            }
            case 911: {
                switch (current) {
                    case 97: {
                        this.state = 912;
                        return true;
                    }
                }
                break;
            }
            case 912: {
                switch (current) {
                    case 110: {
                        this.state = 913;
                        return true;
                    }
                }
                break;
            }
            case 913: {
                switch (current) {
                    case 116: {
                        this.state = 914;
                        return true;
                    }
                }
                break;
            }
            case 914: {
                switch (current) {
                    case 69: {
                        this.state = 915;
                        return true;
                    }
                }
                break;
            }
            case 915: {
                switch (current) {
                    case 113: {
                        this.state = 916;
                        return true;
                    }
                }
                break;
            }
            case 916: {
                switch (current) {
                    case 117: {
                        this.state = 917;
                        return true;
                    }
                }
                break;
            }
            case 917: {
                switch (current) {
                    case 97: {
                        this.state = 918;
                        return true;
                    }
                }
                break;
            }
            case 918: {
                switch (current) {
                    case 108: {
                        this.state = 919;
                        return true;
                    }
                }
                break;
            }
            case 919: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a7e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 920: {
                switch (current) {
                    case 105: {
                        this.state = 921;
                        return true;
                    }
                }
                break;
            }
            case 921: {
                switch (current) {
                    case 108: {
                        this.state = 922;
                        return true;
                    }
                }
                break;
            }
            case 922: {
                switch (current) {
                    case 100: {
                        this.state = 923;
                        return true;
                    }
                }
                break;
            }
            case 923: {
                switch (current) {
                    case 101: {
                        this.state = 924;
                        return true;
                    }
                }
                break;
            }
            case 924: {
                switch (current) {
                    case 59: {
                        this.match = "\u2273";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 925: {
                switch (current) {
                    case 99: {
                        this.state = 926;
                        return true;
                    }
                }
                break;
            }
            case 926: {
                switch (current) {
                    case 114: {
                        this.state = 927;
                        return true;
                    }
                }
                break;
            }
            case 927: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udca2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 928: {
                switch (current) {
                    case 59: {
                        this.match = "\u226b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 929: {
                switch (current) {
                    case 65: {
                        this.state = 930;
                        return true;
                    }
                    case 97: {
                        this.state = 935;
                        return true;
                    }
                    case 99: {
                        this.state = 940;
                        return true;
                    }
                    case 102: {
                        this.state = 944;
                        return true;
                    }
                    case 105: {
                        this.state = 946;
                        return true;
                    }
                    case 111: {
                        this.state = 957;
                        return true;
                    }
                    case 115: {
                        this.state = 972;
                        return true;
                    }
                    case 117: {
                        this.state = 979;
                        return true;
                    }
                }
                break;
            }
            case 930: {
                switch (current) {
                    case 82: {
                        this.state = 931;
                        return true;
                    }
                }
                break;
            }
            case 931: {
                switch (current) {
                    case 68: {
                        this.state = 932;
                        return true;
                    }
                }
                break;
            }
            case 932: {
                switch (current) {
                    case 99: {
                        this.state = 933;
                        return true;
                    }
                }
                break;
            }
            case 933: {
                switch (current) {
                    case 121: {
                        this.state = 934;
                        return true;
                    }
                }
                break;
            }
            case 934: {
                switch (current) {
                    case 59: {
                        this.match = "\u042a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 935: {
                switch (current) {
                    case 99: {
                        this.state = 936;
                        return true;
                    }
                    case 116: {
                        this.state = 939;
                        return true;
                    }
                }
                break;
            }
            case 936: {
                switch (current) {
                    case 101: {
                        this.state = 937;
                        return true;
                    }
                }
                break;
            }
            case 937: {
                switch (current) {
                    case 107: {
                        this.state = 938;
                        return true;
                    }
                }
                break;
            }
            case 938: {
                switch (current) {
                    case 59: {
                        this.match = "\u02c7";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 939: {
                switch (current) {
                    case 59: {
                        this.match = "^";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 940: {
                switch (current) {
                    case 105: {
                        this.state = 941;
                        return true;
                    }
                }
                break;
            }
            case 941: {
                switch (current) {
                    case 114: {
                        this.state = 942;
                        return true;
                    }
                }
                break;
            }
            case 942: {
                switch (current) {
                    case 99: {
                        this.state = 943;
                        return true;
                    }
                }
                break;
            }
            case 943: {
                switch (current) {
                    case 59: {
                        this.match = "\u0124";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 944: {
                switch (current) {
                    case 114: {
                        this.state = 945;
                        return true;
                    }
                }
                break;
            }
            case 945: {
                switch (current) {
                    case 59: {
                        this.match = "\u210c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 946: {
                switch (current) {
                    case 108: {
                        this.state = 947;
                        return true;
                    }
                }
                break;
            }
            case 947: {
                switch (current) {
                    case 98: {
                        this.state = 948;
                        return true;
                    }
                }
                break;
            }
            case 948: {
                switch (current) {
                    case 101: {
                        this.state = 949;
                        return true;
                    }
                }
                break;
            }
            case 949: {
                switch (current) {
                    case 114: {
                        this.state = 950;
                        return true;
                    }
                }
                break;
            }
            case 950: {
                switch (current) {
                    case 116: {
                        this.state = 951;
                        return true;
                    }
                }
                break;
            }
            case 951: {
                switch (current) {
                    case 83: {
                        this.state = 952;
                        return true;
                    }
                }
                break;
            }
            case 952: {
                switch (current) {
                    case 112: {
                        this.state = 953;
                        return true;
                    }
                }
                break;
            }
            case 953: {
                switch (current) {
                    case 97: {
                        this.state = 954;
                        return true;
                    }
                }
                break;
            }
            case 954: {
                switch (current) {
                    case 99: {
                        this.state = 955;
                        return true;
                    }
                }
                break;
            }
            case 955: {
                switch (current) {
                    case 101: {
                        this.state = 956;
                        return true;
                    }
                }
                break;
            }
            case 956: {
                switch (current) {
                    case 59: {
                        this.match = "\u210b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 957: {
                switch (current) {
                    case 112: {
                        this.state = 958;
                        return true;
                    }
                    case 114: {
                        this.state = 960;
                        return true;
                    }
                }
                break;
            }
            case 958: {
                switch (current) {
                    case 102: {
                        this.state = 959;
                        return true;
                    }
                }
                break;
            }
            case 959: {
                switch (current) {
                    case 59: {
                        this.match = "\u210d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 960: {
                switch (current) {
                    case 105: {
                        this.state = 961;
                        return true;
                    }
                }
                break;
            }
            case 961: {
                switch (current) {
                    case 122: {
                        this.state = 962;
                        return true;
                    }
                }
                break;
            }
            case 962: {
                switch (current) {
                    case 111: {
                        this.state = 963;
                        return true;
                    }
                }
                break;
            }
            case 963: {
                switch (current) {
                    case 110: {
                        this.state = 964;
                        return true;
                    }
                }
                break;
            }
            case 964: {
                switch (current) {
                    case 116: {
                        this.state = 965;
                        return true;
                    }
                }
                break;
            }
            case 965: {
                switch (current) {
                    case 97: {
                        this.state = 966;
                        return true;
                    }
                }
                break;
            }
            case 966: {
                switch (current) {
                    case 108: {
                        this.state = 967;
                        return true;
                    }
                }
                break;
            }
            case 967: {
                switch (current) {
                    case 76: {
                        this.state = 968;
                        return true;
                    }
                }
                break;
            }
            case 968: {
                switch (current) {
                    case 105: {
                        this.state = 969;
                        return true;
                    }
                }
                break;
            }
            case 969: {
                switch (current) {
                    case 110: {
                        this.state = 970;
                        return true;
                    }
                }
                break;
            }
            case 970: {
                switch (current) {
                    case 101: {
                        this.state = 971;
                        return true;
                    }
                }
                break;
            }
            case 971: {
                switch (current) {
                    case 59: {
                        this.match = "\u2500";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 972: {
                switch (current) {
                    case 99: {
                        this.state = 973;
                        return true;
                    }
                    case 116: {
                        this.state = 975;
                        return true;
                    }
                }
                break;
            }
            case 973: {
                switch (current) {
                    case 114: {
                        this.state = 974;
                        return true;
                    }
                }
                break;
            }
            case 974: {
                switch (current) {
                    case 59: {
                        this.match = "\u210b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 975: {
                switch (current) {
                    case 114: {
                        this.state = 976;
                        return true;
                    }
                }
                break;
            }
            case 976: {
                switch (current) {
                    case 111: {
                        this.state = 977;
                        return true;
                    }
                }
                break;
            }
            case 977: {
                switch (current) {
                    case 107: {
                        this.state = 978;
                        return true;
                    }
                }
                break;
            }
            case 978: {
                switch (current) {
                    case 59: {
                        this.match = "\u0126";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 979: {
                switch (current) {
                    case 109: {
                        this.state = 980;
                        return true;
                    }
                }
                break;
            }
            case 980: {
                switch (current) {
                    case 112: {
                        this.state = 981;
                        return true;
                    }
                }
                break;
            }
            case 981: {
                switch (current) {
                    case 68: {
                        this.state = 982;
                        return true;
                    }
                    case 69: {
                        this.state = 990;
                        return true;
                    }
                }
                break;
            }
            case 982: {
                switch (current) {
                    case 111: {
                        this.state = 983;
                        return true;
                    }
                }
                break;
            }
            case 983: {
                switch (current) {
                    case 119: {
                        this.state = 984;
                        return true;
                    }
                }
                break;
            }
            case 984: {
                switch (current) {
                    case 110: {
                        this.state = 985;
                        return true;
                    }
                }
                break;
            }
            case 985: {
                switch (current) {
                    case 72: {
                        this.state = 986;
                        return true;
                    }
                }
                break;
            }
            case 986: {
                switch (current) {
                    case 117: {
                        this.state = 987;
                        return true;
                    }
                }
                break;
            }
            case 987: {
                switch (current) {
                    case 109: {
                        this.state = 988;
                        return true;
                    }
                }
                break;
            }
            case 988: {
                switch (current) {
                    case 112: {
                        this.state = 989;
                        return true;
                    }
                }
                break;
            }
            case 989: {
                switch (current) {
                    case 59: {
                        this.match = "\u224e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 990: {
                switch (current) {
                    case 113: {
                        this.state = 991;
                        return true;
                    }
                }
                break;
            }
            case 991: {
                switch (current) {
                    case 117: {
                        this.state = 992;
                        return true;
                    }
                }
                break;
            }
            case 992: {
                switch (current) {
                    case 97: {
                        this.state = 993;
                        return true;
                    }
                }
                break;
            }
            case 993: {
                switch (current) {
                    case 108: {
                        this.state = 994;
                        return true;
                    }
                }
                break;
            }
            case 994: {
                switch (current) {
                    case 59: {
                        this.match = "\u224f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 995: {
                switch (current) {
                    case 69: {
                        this.state = 996;
                        return true;
                    }
                    case 74: {
                        this.state = 999;
                        return true;
                    }
                    case 79: {
                        this.state = 1003;
                        return true;
                    }
                    case 97: {
                        this.state = 1006;
                        return true;
                    }
                    case 99: {
                        this.state = 1011;
                        return true;
                    }
                    case 100: {
                        this.state = 1016;
                        return true;
                    }
                    case 102: {
                        this.state = 1019;
                        return true;
                    }
                    case 103: {
                        this.state = 1021;
                        return true;
                    }
                    case 109: {
                        this.state = 1026;
                        return true;
                    }
                    case 110: {
                        this.state = 1042;
                        return true;
                    }
                    case 111: {
                        this.state = 1074;
                        return true;
                    }
                    case 115: {
                        this.state = 1082;
                        return true;
                    }
                    case 116: {
                        this.state = 1085;
                        return true;
                    }
                    case 117: {
                        this.state = 1090;
                        return true;
                    }
                }
                break;
            }
            case 996: {
                switch (current) {
                    case 99: {
                        this.state = 997;
                        return true;
                    }
                }
                break;
            }
            case 997: {
                switch (current) {
                    case 121: {
                        this.state = 998;
                        return true;
                    }
                }
                break;
            }
            case 998: {
                switch (current) {
                    case 59: {
                        this.match = "\u0415";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 999: {
                switch (current) {
                    case 108: {
                        this.state = 1000;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    private boolean parse2(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 1000: {
                switch (current) {
                    case 105: {
                        this.state = 1001;
                        return true;
                    }
                }
                break;
            }
            case 1001: {
                switch (current) {
                    case 103: {
                        this.state = 1002;
                        return true;
                    }
                }
                break;
            }
            case 1002: {
                switch (current) {
                    case 59: {
                        this.match = "\u0132";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1003: {
                switch (current) {
                    case 99: {
                        this.state = 1004;
                        return true;
                    }
                }
                break;
            }
            case 1004: {
                switch (current) {
                    case 121: {
                        this.state = 1005;
                        return true;
                    }
                }
                break;
            }
            case 1005: {
                switch (current) {
                    case 59: {
                        this.match = "\u0401";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1006: {
                switch (current) {
                    case 99: {
                        this.state = 1007;
                        return true;
                    }
                }
                break;
            }
            case 1007: {
                switch (current) {
                    case 117: {
                        this.state = 1008;
                        return true;
                    }
                }
                break;
            }
            case 1008: {
                switch (current) {
                    case 116: {
                        this.state = 1009;
                        return true;
                    }
                }
                break;
            }
            case 1009: {
                switch (current) {
                    case 101: {
                        this.match = "\u00cd";
                        this.matchLength = this.consumedCount;
                        this.state = 1010;
                        return true;
                    }
                }
                break;
            }
            case 1010: {
                switch (current) {
                    case 59: {
                        this.match = "\u00cd";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1011: {
                switch (current) {
                    case 105: {
                        this.state = 1012;
                        return true;
                    }
                    case 121: {
                        this.state = 1015;
                        return true;
                    }
                }
                break;
            }
            case 1012: {
                switch (current) {
                    case 114: {
                        this.state = 1013;
                        return true;
                    }
                }
                break;
            }
            case 1013: {
                switch (current) {
                    case 99: {
                        this.match = "\u00ce";
                        this.matchLength = this.consumedCount;
                        this.state = 1014;
                        return true;
                    }
                }
                break;
            }
            case 1014: {
                switch (current) {
                    case 59: {
                        this.match = "\u00ce";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1015: {
                switch (current) {
                    case 59: {
                        this.match = "\u0418";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1016: {
                switch (current) {
                    case 111: {
                        this.state = 1017;
                        return true;
                    }
                }
                break;
            }
            case 1017: {
                switch (current) {
                    case 116: {
                        this.state = 1018;
                        return true;
                    }
                }
                break;
            }
            case 1018: {
                switch (current) {
                    case 59: {
                        this.match = "\u0130";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1019: {
                switch (current) {
                    case 114: {
                        this.state = 1020;
                        return true;
                    }
                }
                break;
            }
            case 1020: {
                switch (current) {
                    case 59: {
                        this.match = "\u2111";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1021: {
                switch (current) {
                    case 114: {
                        this.state = 1022;
                        return true;
                    }
                }
                break;
            }
            case 1022: {
                switch (current) {
                    case 97: {
                        this.state = 1023;
                        return true;
                    }
                }
                break;
            }
            case 1023: {
                switch (current) {
                    case 118: {
                        this.state = 1024;
                        return true;
                    }
                }
                break;
            }
            case 1024: {
                switch (current) {
                    case 101: {
                        this.match = "\u00cc";
                        this.matchLength = this.consumedCount;
                        this.state = 1025;
                        return true;
                    }
                }
                break;
            }
            case 1025: {
                switch (current) {
                    case 59: {
                        this.match = "\u00cc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1026: {
                switch (current) {
                    case 59: {
                        this.match = "\u2111";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 97: {
                        this.state = 1027;
                        return true;
                    }
                    case 112: {
                        this.state = 1037;
                        return true;
                    }
                }
                break;
            }
            case 1027: {
                switch (current) {
                    case 99: {
                        this.state = 1028;
                        return true;
                    }
                    case 103: {
                        this.state = 1030;
                        return true;
                    }
                }
                break;
            }
            case 1028: {
                switch (current) {
                    case 114: {
                        this.state = 1029;
                        return true;
                    }
                }
                break;
            }
            case 1029: {
                switch (current) {
                    case 59: {
                        this.match = "\u012a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1030: {
                switch (current) {
                    case 105: {
                        this.state = 1031;
                        return true;
                    }
                }
                break;
            }
            case 1031: {
                switch (current) {
                    case 110: {
                        this.state = 1032;
                        return true;
                    }
                }
                break;
            }
            case 1032: {
                switch (current) {
                    case 97: {
                        this.state = 1033;
                        return true;
                    }
                }
                break;
            }
            case 1033: {
                switch (current) {
                    case 114: {
                        this.state = 1034;
                        return true;
                    }
                }
                break;
            }
            case 1034: {
                switch (current) {
                    case 121: {
                        this.state = 1035;
                        return true;
                    }
                }
                break;
            }
            case 1035: {
                switch (current) {
                    case 73: {
                        this.state = 1036;
                        return true;
                    }
                }
                break;
            }
            case 1036: {
                switch (current) {
                    case 59: {
                        this.match = "\u2148";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1037: {
                switch (current) {
                    case 108: {
                        this.state = 1038;
                        return true;
                    }
                }
                break;
            }
            case 1038: {
                switch (current) {
                    case 105: {
                        this.state = 1039;
                        return true;
                    }
                }
                break;
            }
            case 1039: {
                switch (current) {
                    case 101: {
                        this.state = 1040;
                        return true;
                    }
                }
                break;
            }
            case 1040: {
                switch (current) {
                    case 115: {
                        this.state = 1041;
                        return true;
                    }
                }
                break;
            }
            case 1041: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1042: {
                switch (current) {
                    case 116: {
                        this.state = 1043;
                        return true;
                    }
                    case 118: {
                        this.state = 1057;
                        return true;
                    }
                }
                break;
            }
            case 1043: {
                switch (current) {
                    case 59: {
                        this.match = "\u222c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 1044;
                        return true;
                    }
                }
                break;
            }
            case 1044: {
                switch (current) {
                    case 103: {
                        this.state = 1045;
                        return true;
                    }
                    case 114: {
                        this.state = 1049;
                        return true;
                    }
                }
                break;
            }
            case 1045: {
                switch (current) {
                    case 114: {
                        this.state = 1046;
                        return true;
                    }
                }
                break;
            }
            case 1046: {
                switch (current) {
                    case 97: {
                        this.state = 1047;
                        return true;
                    }
                }
                break;
            }
            case 1047: {
                switch (current) {
                    case 108: {
                        this.state = 1048;
                        return true;
                    }
                }
                break;
            }
            case 1048: {
                switch (current) {
                    case 59: {
                        this.match = "\u222b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1049: {
                switch (current) {
                    case 115: {
                        this.state = 1050;
                        return true;
                    }
                }
                break;
            }
            case 1050: {
                switch (current) {
                    case 101: {
                        this.state = 1051;
                        return true;
                    }
                }
                break;
            }
            case 1051: {
                switch (current) {
                    case 99: {
                        this.state = 1052;
                        return true;
                    }
                }
                break;
            }
            case 1052: {
                switch (current) {
                    case 116: {
                        this.state = 1053;
                        return true;
                    }
                }
                break;
            }
            case 1053: {
                switch (current) {
                    case 105: {
                        this.state = 1054;
                        return true;
                    }
                }
                break;
            }
            case 1054: {
                switch (current) {
                    case 111: {
                        this.state = 1055;
                        return true;
                    }
                }
                break;
            }
            case 1055: {
                switch (current) {
                    case 110: {
                        this.state = 1056;
                        return true;
                    }
                }
                break;
            }
            case 1056: {
                switch (current) {
                    case 59: {
                        this.match = "\u22c2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1057: {
                switch (current) {
                    case 105: {
                        this.state = 1058;
                        return true;
                    }
                }
                break;
            }
            case 1058: {
                switch (current) {
                    case 115: {
                        this.state = 1059;
                        return true;
                    }
                }
                break;
            }
            case 1059: {
                switch (current) {
                    case 105: {
                        this.state = 1060;
                        return true;
                    }
                }
                break;
            }
            case 1060: {
                switch (current) {
                    case 98: {
                        this.state = 1061;
                        return true;
                    }
                }
                break;
            }
            case 1061: {
                switch (current) {
                    case 108: {
                        this.state = 1062;
                        return true;
                    }
                }
                break;
            }
            case 1062: {
                switch (current) {
                    case 101: {
                        this.state = 1063;
                        return true;
                    }
                }
                break;
            }
            case 1063: {
                switch (current) {
                    case 67: {
                        this.state = 1064;
                        return true;
                    }
                    case 84: {
                        this.state = 1069;
                        return true;
                    }
                }
                break;
            }
            case 1064: {
                switch (current) {
                    case 111: {
                        this.state = 1065;
                        return true;
                    }
                }
                break;
            }
            case 1065: {
                switch (current) {
                    case 109: {
                        this.state = 1066;
                        return true;
                    }
                }
                break;
            }
            case 1066: {
                switch (current) {
                    case 109: {
                        this.state = 1067;
                        return true;
                    }
                }
                break;
            }
            case 1067: {
                switch (current) {
                    case 97: {
                        this.state = 1068;
                        return true;
                    }
                }
                break;
            }
            case 1068: {
                switch (current) {
                    case 59: {
                        this.match = "\u2063";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1069: {
                switch (current) {
                    case 105: {
                        this.state = 1070;
                        return true;
                    }
                }
                break;
            }
            case 1070: {
                switch (current) {
                    case 109: {
                        this.state = 1071;
                        return true;
                    }
                }
                break;
            }
            case 1071: {
                switch (current) {
                    case 101: {
                        this.state = 1072;
                        return true;
                    }
                }
                break;
            }
            case 1072: {
                switch (current) {
                    case 115: {
                        this.state = 1073;
                        return true;
                    }
                }
                break;
            }
            case 1073: {
                switch (current) {
                    case 59: {
                        this.match = "\u2062";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1074: {
                switch (current) {
                    case 103: {
                        this.state = 1075;
                        return true;
                    }
                    case 112: {
                        this.state = 1078;
                        return true;
                    }
                    case 116: {
                        this.state = 1080;
                        return true;
                    }
                }
                break;
            }
            case 1075: {
                switch (current) {
                    case 111: {
                        this.state = 1076;
                        return true;
                    }
                }
                break;
            }
            case 1076: {
                switch (current) {
                    case 110: {
                        this.state = 1077;
                        return true;
                    }
                }
                break;
            }
            case 1077: {
                switch (current) {
                    case 59: {
                        this.match = "\u012e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1078: {
                switch (current) {
                    case 102: {
                        this.state = 1079;
                        return true;
                    }
                }
                break;
            }
            case 1079: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd40";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1080: {
                switch (current) {
                    case 97: {
                        this.state = 1081;
                        return true;
                    }
                }
                break;
            }
            case 1081: {
                switch (current) {
                    case 59: {
                        this.match = "\u0399";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1082: {
                switch (current) {
                    case 99: {
                        this.state = 1083;
                        return true;
                    }
                }
                break;
            }
            case 1083: {
                switch (current) {
                    case 114: {
                        this.state = 1084;
                        return true;
                    }
                }
                break;
            }
            case 1084: {
                switch (current) {
                    case 59: {
                        this.match = "\u2110";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1085: {
                switch (current) {
                    case 105: {
                        this.state = 1086;
                        return true;
                    }
                }
                break;
            }
            case 1086: {
                switch (current) {
                    case 108: {
                        this.state = 1087;
                        return true;
                    }
                }
                break;
            }
            case 1087: {
                switch (current) {
                    case 100: {
                        this.state = 1088;
                        return true;
                    }
                }
                break;
            }
            case 1088: {
                switch (current) {
                    case 101: {
                        this.state = 1089;
                        return true;
                    }
                }
                break;
            }
            case 1089: {
                switch (current) {
                    case 59: {
                        this.match = "\u0128";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1090: {
                switch (current) {
                    case 107: {
                        this.state = 1091;
                        return true;
                    }
                    case 109: {
                        this.state = 1094;
                        return true;
                    }
                }
                break;
            }
            case 1091: {
                switch (current) {
                    case 99: {
                        this.state = 1092;
                        return true;
                    }
                }
                break;
            }
            case 1092: {
                switch (current) {
                    case 121: {
                        this.state = 1093;
                        return true;
                    }
                }
                break;
            }
            case 1093: {
                switch (current) {
                    case 59: {
                        this.match = "\u0406";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1094: {
                switch (current) {
                    case 108: {
                        this.match = "\u00cf";
                        this.matchLength = this.consumedCount;
                        this.state = 1095;
                        return true;
                    }
                }
                break;
            }
            case 1095: {
                switch (current) {
                    case 59: {
                        this.match = "\u00cf";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1096: {
                switch (current) {
                    case 99: {
                        this.state = 1097;
                        return true;
                    }
                    case 102: {
                        this.state = 1102;
                        return true;
                    }
                    case 111: {
                        this.state = 1104;
                        return true;
                    }
                    case 115: {
                        this.state = 1107;
                        return true;
                    }
                    case 117: {
                        this.state = 1114;
                        return true;
                    }
                }
                break;
            }
            case 1097: {
                switch (current) {
                    case 105: {
                        this.state = 1098;
                        return true;
                    }
                    case 121: {
                        this.state = 1101;
                        return true;
                    }
                }
                break;
            }
            case 1098: {
                switch (current) {
                    case 114: {
                        this.state = 1099;
                        return true;
                    }
                }
                break;
            }
            case 1099: {
                switch (current) {
                    case 99: {
                        this.state = 1100;
                        return true;
                    }
                }
                break;
            }
            case 1100: {
                switch (current) {
                    case 59: {
                        this.match = "\u0134";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1101: {
                switch (current) {
                    case 59: {
                        this.match = "\u0419";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1102: {
                switch (current) {
                    case 114: {
                        this.state = 1103;
                        return true;
                    }
                }
                break;
            }
            case 1103: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd0d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1104: {
                switch (current) {
                    case 112: {
                        this.state = 1105;
                        return true;
                    }
                }
                break;
            }
            case 1105: {
                switch (current) {
                    case 102: {
                        this.state = 1106;
                        return true;
                    }
                }
                break;
            }
            case 1106: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd41";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1107: {
                switch (current) {
                    case 99: {
                        this.state = 1108;
                        return true;
                    }
                    case 101: {
                        this.state = 1110;
                        return true;
                    }
                }
                break;
            }
            case 1108: {
                switch (current) {
                    case 114: {
                        this.state = 1109;
                        return true;
                    }
                }
                break;
            }
            case 1109: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udca5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1110: {
                switch (current) {
                    case 114: {
                        this.state = 1111;
                        return true;
                    }
                }
                break;
            }
            case 1111: {
                switch (current) {
                    case 99: {
                        this.state = 1112;
                        return true;
                    }
                }
                break;
            }
            case 1112: {
                switch (current) {
                    case 121: {
                        this.state = 1113;
                        return true;
                    }
                }
                break;
            }
            case 1113: {
                switch (current) {
                    case 59: {
                        this.match = "\u0408";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1114: {
                switch (current) {
                    case 107: {
                        this.state = 1115;
                        return true;
                    }
                }
                break;
            }
            case 1115: {
                switch (current) {
                    case 99: {
                        this.state = 1116;
                        return true;
                    }
                }
                break;
            }
            case 1116: {
                switch (current) {
                    case 121: {
                        this.state = 1117;
                        return true;
                    }
                }
                break;
            }
            case 1117: {
                switch (current) {
                    case 59: {
                        this.match = "\u0404";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1118: {
                switch (current) {
                    case 72: {
                        this.state = 1119;
                        return true;
                    }
                    case 74: {
                        this.state = 1122;
                        return true;
                    }
                    case 97: {
                        this.state = 1125;
                        return true;
                    }
                    case 99: {
                        this.state = 1129;
                        return true;
                    }
                    case 102: {
                        this.state = 1135;
                        return true;
                    }
                    case 111: {
                        this.state = 1137;
                        return true;
                    }
                    case 115: {
                        this.state = 1140;
                        return true;
                    }
                }
                break;
            }
            case 1119: {
                switch (current) {
                    case 99: {
                        this.state = 1120;
                        return true;
                    }
                }
                break;
            }
            case 1120: {
                switch (current) {
                    case 121: {
                        this.state = 1121;
                        return true;
                    }
                }
                break;
            }
            case 1121: {
                switch (current) {
                    case 59: {
                        this.match = "\u0425";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1122: {
                switch (current) {
                    case 99: {
                        this.state = 1123;
                        return true;
                    }
                }
                break;
            }
            case 1123: {
                switch (current) {
                    case 121: {
                        this.state = 1124;
                        return true;
                    }
                }
                break;
            }
            case 1124: {
                switch (current) {
                    case 59: {
                        this.match = "\u040c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1125: {
                switch (current) {
                    case 112: {
                        this.state = 1126;
                        return true;
                    }
                }
                break;
            }
            case 1126: {
                switch (current) {
                    case 112: {
                        this.state = 1127;
                        return true;
                    }
                }
                break;
            }
            case 1127: {
                switch (current) {
                    case 97: {
                        this.state = 1128;
                        return true;
                    }
                }
                break;
            }
            case 1128: {
                switch (current) {
                    case 59: {
                        this.match = "\u039a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1129: {
                switch (current) {
                    case 101: {
                        this.state = 1130;
                        return true;
                    }
                    case 121: {
                        this.state = 1134;
                        return true;
                    }
                }
                break;
            }
            case 1130: {
                switch (current) {
                    case 100: {
                        this.state = 1131;
                        return true;
                    }
                }
                break;
            }
            case 1131: {
                switch (current) {
                    case 105: {
                        this.state = 1132;
                        return true;
                    }
                }
                break;
            }
            case 1132: {
                switch (current) {
                    case 108: {
                        this.state = 1133;
                        return true;
                    }
                }
                break;
            }
            case 1133: {
                switch (current) {
                    case 59: {
                        this.match = "\u0136";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1134: {
                switch (current) {
                    case 59: {
                        this.match = "\u041a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1135: {
                switch (current) {
                    case 114: {
                        this.state = 1136;
                        return true;
                    }
                }
                break;
            }
            case 1136: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd0e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1137: {
                switch (current) {
                    case 112: {
                        this.state = 1138;
                        return true;
                    }
                }
                break;
            }
            case 1138: {
                switch (current) {
                    case 102: {
                        this.state = 1139;
                        return true;
                    }
                }
                break;
            }
            case 1139: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd42";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1140: {
                switch (current) {
                    case 99: {
                        this.state = 1141;
                        return true;
                    }
                }
                break;
            }
            case 1141: {
                switch (current) {
                    case 114: {
                        this.state = 1142;
                        return true;
                    }
                }
                break;
            }
            case 1142: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udca6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1143: {
                switch (current) {
                    case 74: {
                        this.state = 1144;
                        return true;
                    }
                    case 84: {
                        this.match = "<";
                        this.matchLength = this.consumedCount;
                        this.state = 1147;
                        return true;
                    }
                    case 97: {
                        this.state = 1148;
                        return true;
                    }
                    case 99: {
                        this.state = 1169;
                        return true;
                    }
                    case 101: {
                        this.state = 1179;
                        return true;
                    }
                    case 102: {
                        this.state = 1404;
                        return true;
                    }
                    case 108: {
                        this.state = 1406;
                        return true;
                    }
                    case 109: {
                        this.state = 1415;
                        return true;
                    }
                    case 111: {
                        this.state = 1420;
                        return true;
                    }
                    case 115: {
                        this.state = 1505;
                        return true;
                    }
                    case 116: {
                        this.state = 1513;
                        return true;
                    }
                }
                break;
            }
            case 1144: {
                switch (current) {
                    case 99: {
                        this.state = 1145;
                        return true;
                    }
                }
                break;
            }
            case 1145: {
                switch (current) {
                    case 121: {
                        this.state = 1146;
                        return true;
                    }
                }
                break;
            }
            case 1146: {
                switch (current) {
                    case 59: {
                        this.match = "\u0409";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1147: {
                switch (current) {
                    case 59: {
                        this.match = "<";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1148: {
                switch (current) {
                    case 99: {
                        this.state = 1149;
                        return true;
                    }
                    case 109: {
                        this.state = 1153;
                        return true;
                    }
                    case 110: {
                        this.state = 1157;
                        return true;
                    }
                    case 112: {
                        this.state = 1159;
                        return true;
                    }
                    case 114: {
                        this.state = 1167;
                        return true;
                    }
                }
                break;
            }
            case 1149: {
                switch (current) {
                    case 117: {
                        this.state = 1150;
                        return true;
                    }
                }
                break;
            }
            case 1150: {
                switch (current) {
                    case 116: {
                        this.state = 1151;
                        return true;
                    }
                }
                break;
            }
            case 1151: {
                switch (current) {
                    case 101: {
                        this.state = 1152;
                        return true;
                    }
                }
                break;
            }
            case 1152: {
                switch (current) {
                    case 59: {
                        this.match = "\u0139";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1153: {
                switch (current) {
                    case 98: {
                        this.state = 1154;
                        return true;
                    }
                }
                break;
            }
            case 1154: {
                switch (current) {
                    case 100: {
                        this.state = 1155;
                        return true;
                    }
                }
                break;
            }
            case 1155: {
                switch (current) {
                    case 97: {
                        this.state = 1156;
                        return true;
                    }
                }
                break;
            }
            case 1156: {
                switch (current) {
                    case 59: {
                        this.match = "\u039b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1157: {
                switch (current) {
                    case 103: {
                        this.state = 1158;
                        return true;
                    }
                }
                break;
            }
            case 1158: {
                switch (current) {
                    case 59: {
                        this.match = "\u27ea";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1159: {
                switch (current) {
                    case 108: {
                        this.state = 1160;
                        return true;
                    }
                }
                break;
            }
            case 1160: {
                switch (current) {
                    case 97: {
                        this.state = 1161;
                        return true;
                    }
                }
                break;
            }
            case 1161: {
                switch (current) {
                    case 99: {
                        this.state = 1162;
                        return true;
                    }
                }
                break;
            }
            case 1162: {
                switch (current) {
                    case 101: {
                        this.state = 1163;
                        return true;
                    }
                }
                break;
            }
            case 1163: {
                switch (current) {
                    case 116: {
                        this.state = 1164;
                        return true;
                    }
                }
                break;
            }
            case 1164: {
                switch (current) {
                    case 114: {
                        this.state = 1165;
                        return true;
                    }
                }
                break;
            }
            case 1165: {
                switch (current) {
                    case 102: {
                        this.state = 1166;
                        return true;
                    }
                }
                break;
            }
            case 1166: {
                switch (current) {
                    case 59: {
                        this.match = "\u2112";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1167: {
                switch (current) {
                    case 114: {
                        this.state = 1168;
                        return true;
                    }
                }
                break;
            }
            case 1168: {
                switch (current) {
                    case 59: {
                        this.match = "\u219e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1169: {
                switch (current) {
                    case 97: {
                        this.state = 1170;
                        return true;
                    }
                    case 101: {
                        this.state = 1174;
                        return true;
                    }
                    case 121: {
                        this.state = 1178;
                        return true;
                    }
                }
                break;
            }
            case 1170: {
                switch (current) {
                    case 114: {
                        this.state = 1171;
                        return true;
                    }
                }
                break;
            }
            case 1171: {
                switch (current) {
                    case 111: {
                        this.state = 1172;
                        return true;
                    }
                }
                break;
            }
            case 1172: {
                switch (current) {
                    case 110: {
                        this.state = 1173;
                        return true;
                    }
                }
                break;
            }
            case 1173: {
                switch (current) {
                    case 59: {
                        this.match = "\u013d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1174: {
                switch (current) {
                    case 100: {
                        this.state = 1175;
                        return true;
                    }
                }
                break;
            }
            case 1175: {
                switch (current) {
                    case 105: {
                        this.state = 1176;
                        return true;
                    }
                }
                break;
            }
            case 1176: {
                switch (current) {
                    case 108: {
                        this.state = 1177;
                        return true;
                    }
                }
                break;
            }
            case 1177: {
                switch (current) {
                    case 59: {
                        this.match = "\u013b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1178: {
                switch (current) {
                    case 59: {
                        this.match = "\u041b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1179: {
                switch (current) {
                    case 102: {
                        this.state = 1180;
                        return true;
                    }
                    case 115: {
                        this.state = 1355;
                        return true;
                    }
                }
                break;
            }
            case 1180: {
                switch (current) {
                    case 116: {
                        this.state = 1181;
                        return true;
                    }
                }
                break;
            }
            case 1181: {
                switch (current) {
                    case 65: {
                        this.state = 1182;
                        return true;
                    }
                    case 67: {
                        this.state = 1211;
                        return true;
                    }
                    case 68: {
                        this.state = 1218;
                        return true;
                    }
                    case 70: {
                        this.state = 1251;
                        return true;
                    }
                    case 82: {
                        this.state = 1256;
                        return true;
                    }
                    case 84: {
                        this.state = 1272;
                        return true;
                    }
                    case 85: {
                        this.state = 1301;
                        return true;
                    }
                    case 86: {
                        this.state = 1331;
                        return true;
                    }
                    case 97: {
                        this.state = 1340;
                        return true;
                    }
                    case 114: {
                        this.state = 1345;
                        return true;
                    }
                }
                break;
            }
            case 1182: {
                switch (current) {
                    case 110: {
                        this.state = 1183;
                        return true;
                    }
                    case 114: {
                        this.state = 1194;
                        return true;
                    }
                }
                break;
            }
            case 1183: {
                switch (current) {
                    case 103: {
                        this.state = 1184;
                        return true;
                    }
                }
                break;
            }
            case 1184: {
                switch (current) {
                    case 108: {
                        this.state = 1185;
                        return true;
                    }
                }
                break;
            }
            case 1185: {
                switch (current) {
                    case 101: {
                        this.state = 1186;
                        return true;
                    }
                }
                break;
            }
            case 1186: {
                switch (current) {
                    case 66: {
                        this.state = 1187;
                        return true;
                    }
                }
                break;
            }
            case 1187: {
                switch (current) {
                    case 114: {
                        this.state = 1188;
                        return true;
                    }
                }
                break;
            }
            case 1188: {
                switch (current) {
                    case 97: {
                        this.state = 1189;
                        return true;
                    }
                }
                break;
            }
            case 1189: {
                switch (current) {
                    case 99: {
                        this.state = 1190;
                        return true;
                    }
                }
                break;
            }
            case 1190: {
                switch (current) {
                    case 107: {
                        this.state = 1191;
                        return true;
                    }
                }
                break;
            }
            case 1191: {
                switch (current) {
                    case 101: {
                        this.state = 1192;
                        return true;
                    }
                }
                break;
            }
            case 1192: {
                switch (current) {
                    case 116: {
                        this.state = 1193;
                        return true;
                    }
                }
                break;
            }
            case 1193: {
                switch (current) {
                    case 59: {
                        this.match = "\u27e8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1194: {
                switch (current) {
                    case 114: {
                        this.state = 1195;
                        return true;
                    }
                }
                break;
            }
            case 1195: {
                switch (current) {
                    case 111: {
                        this.state = 1196;
                        return true;
                    }
                }
                break;
            }
            case 1196: {
                switch (current) {
                    case 119: {
                        this.state = 1197;
                        return true;
                    }
                }
                break;
            }
            case 1197: {
                switch (current) {
                    case 59: {
                        this.match = "\u2190";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1198;
                        return true;
                    }
                    case 82: {
                        this.state = 1201;
                        return true;
                    }
                }
                break;
            }
            case 1198: {
                switch (current) {
                    case 97: {
                        this.state = 1199;
                        return true;
                    }
                }
                break;
            }
            case 1199: {
                switch (current) {
                    case 114: {
                        this.state = 1200;
                        return true;
                    }
                }
                break;
            }
            case 1200: {
                switch (current) {
                    case 59: {
                        this.match = "\u21e4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1201: {
                switch (current) {
                    case 105: {
                        this.state = 1202;
                        return true;
                    }
                }
                break;
            }
            case 1202: {
                switch (current) {
                    case 103: {
                        this.state = 1203;
                        return true;
                    }
                }
                break;
            }
            case 1203: {
                switch (current) {
                    case 104: {
                        this.state = 1204;
                        return true;
                    }
                }
                break;
            }
            case 1204: {
                switch (current) {
                    case 116: {
                        this.state = 1205;
                        return true;
                    }
                }
                break;
            }
            case 1205: {
                switch (current) {
                    case 65: {
                        this.state = 1206;
                        return true;
                    }
                }
                break;
            }
            case 1206: {
                switch (current) {
                    case 114: {
                        this.state = 1207;
                        return true;
                    }
                }
                break;
            }
            case 1207: {
                switch (current) {
                    case 114: {
                        this.state = 1208;
                        return true;
                    }
                }
                break;
            }
            case 1208: {
                switch (current) {
                    case 111: {
                        this.state = 1209;
                        return true;
                    }
                }
                break;
            }
            case 1209: {
                switch (current) {
                    case 119: {
                        this.state = 1210;
                        return true;
                    }
                }
                break;
            }
            case 1210: {
                switch (current) {
                    case 59: {
                        this.match = "\u21c6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1211: {
                switch (current) {
                    case 101: {
                        this.state = 1212;
                        return true;
                    }
                }
                break;
            }
            case 1212: {
                switch (current) {
                    case 105: {
                        this.state = 1213;
                        return true;
                    }
                }
                break;
            }
            case 1213: {
                switch (current) {
                    case 108: {
                        this.state = 1214;
                        return true;
                    }
                }
                break;
            }
            case 1214: {
                switch (current) {
                    case 105: {
                        this.state = 1215;
                        return true;
                    }
                }
                break;
            }
            case 1215: {
                switch (current) {
                    case 110: {
                        this.state = 1216;
                        return true;
                    }
                }
                break;
            }
            case 1216: {
                switch (current) {
                    case 103: {
                        this.state = 1217;
                        return true;
                    }
                }
                break;
            }
            case 1217: {
                switch (current) {
                    case 59: {
                        this.match = "\u2308";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1218: {
                switch (current) {
                    case 111: {
                        this.state = 1219;
                        return true;
                    }
                }
                break;
            }
            case 1219: {
                switch (current) {
                    case 117: {
                        this.state = 1220;
                        return true;
                    }
                    case 119: {
                        this.state = 1231;
                        return true;
                    }
                }
                break;
            }
            case 1220: {
                switch (current) {
                    case 98: {
                        this.state = 1221;
                        return true;
                    }
                }
                break;
            }
            case 1221: {
                switch (current) {
                    case 108: {
                        this.state = 1222;
                        return true;
                    }
                }
                break;
            }
            case 1222: {
                switch (current) {
                    case 101: {
                        this.state = 1223;
                        return true;
                    }
                }
                break;
            }
            case 1223: {
                switch (current) {
                    case 66: {
                        this.state = 1224;
                        return true;
                    }
                }
                break;
            }
            case 1224: {
                switch (current) {
                    case 114: {
                        this.state = 1225;
                        return true;
                    }
                }
                break;
            }
            case 1225: {
                switch (current) {
                    case 97: {
                        this.state = 1226;
                        return true;
                    }
                }
                break;
            }
            case 1226: {
                switch (current) {
                    case 99: {
                        this.state = 1227;
                        return true;
                    }
                }
                break;
            }
            case 1227: {
                switch (current) {
                    case 107: {
                        this.state = 1228;
                        return true;
                    }
                }
                break;
            }
            case 1228: {
                switch (current) {
                    case 101: {
                        this.state = 1229;
                        return true;
                    }
                }
                break;
            }
            case 1229: {
                switch (current) {
                    case 116: {
                        this.state = 1230;
                        return true;
                    }
                }
                break;
            }
            case 1230: {
                switch (current) {
                    case 59: {
                        this.match = "\u27e6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1231: {
                switch (current) {
                    case 110: {
                        this.state = 1232;
                        return true;
                    }
                }
                break;
            }
            case 1232: {
                switch (current) {
                    case 84: {
                        this.state = 1233;
                        return true;
                    }
                    case 86: {
                        this.state = 1242;
                        return true;
                    }
                }
                break;
            }
            case 1233: {
                switch (current) {
                    case 101: {
                        this.state = 1234;
                        return true;
                    }
                }
                break;
            }
            case 1234: {
                switch (current) {
                    case 101: {
                        this.state = 1235;
                        return true;
                    }
                }
                break;
            }
            case 1235: {
                switch (current) {
                    case 86: {
                        this.state = 1236;
                        return true;
                    }
                }
                break;
            }
            case 1236: {
                switch (current) {
                    case 101: {
                        this.state = 1237;
                        return true;
                    }
                }
                break;
            }
            case 1237: {
                switch (current) {
                    case 99: {
                        this.state = 1238;
                        return true;
                    }
                }
                break;
            }
            case 1238: {
                switch (current) {
                    case 116: {
                        this.state = 1239;
                        return true;
                    }
                }
                break;
            }
            case 1239: {
                switch (current) {
                    case 111: {
                        this.state = 1240;
                        return true;
                    }
                }
                break;
            }
            case 1240: {
                switch (current) {
                    case 114: {
                        this.state = 1241;
                        return true;
                    }
                }
                break;
            }
            case 1241: {
                switch (current) {
                    case 59: {
                        this.match = "\u2961";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1242: {
                switch (current) {
                    case 101: {
                        this.state = 1243;
                        return true;
                    }
                }
                break;
            }
            case 1243: {
                switch (current) {
                    case 99: {
                        this.state = 1244;
                        return true;
                    }
                }
                break;
            }
            case 1244: {
                switch (current) {
                    case 116: {
                        this.state = 1245;
                        return true;
                    }
                }
                break;
            }
            case 1245: {
                switch (current) {
                    case 111: {
                        this.state = 1246;
                        return true;
                    }
                }
                break;
            }
            case 1246: {
                switch (current) {
                    case 114: {
                        this.state = 1247;
                        return true;
                    }
                }
                break;
            }
            case 1247: {
                switch (current) {
                    case 59: {
                        this.match = "\u21c3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1248;
                        return true;
                    }
                }
                break;
            }
            case 1248: {
                switch (current) {
                    case 97: {
                        this.state = 1249;
                        return true;
                    }
                }
                break;
            }
            case 1249: {
                switch (current) {
                    case 114: {
                        this.state = 1250;
                        return true;
                    }
                }
                break;
            }
            case 1250: {
                switch (current) {
                    case 59: {
                        this.match = "\u2959";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1251: {
                switch (current) {
                    case 108: {
                        this.state = 1252;
                        return true;
                    }
                }
                break;
            }
            case 1252: {
                switch (current) {
                    case 111: {
                        this.state = 1253;
                        return true;
                    }
                }
                break;
            }
            case 1253: {
                switch (current) {
                    case 111: {
                        this.state = 1254;
                        return true;
                    }
                }
                break;
            }
            case 1254: {
                switch (current) {
                    case 114: {
                        this.state = 1255;
                        return true;
                    }
                }
                break;
            }
            case 1255: {
                switch (current) {
                    case 59: {
                        this.match = "\u230a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1256: {
                switch (current) {
                    case 105: {
                        this.state = 1257;
                        return true;
                    }
                }
                break;
            }
            case 1257: {
                switch (current) {
                    case 103: {
                        this.state = 1258;
                        return true;
                    }
                }
                break;
            }
            case 1258: {
                switch (current) {
                    case 104: {
                        this.state = 1259;
                        return true;
                    }
                }
                break;
            }
            case 1259: {
                switch (current) {
                    case 116: {
                        this.state = 1260;
                        return true;
                    }
                }
                break;
            }
            case 1260: {
                switch (current) {
                    case 65: {
                        this.state = 1261;
                        return true;
                    }
                    case 86: {
                        this.state = 1266;
                        return true;
                    }
                }
                break;
            }
            case 1261: {
                switch (current) {
                    case 114: {
                        this.state = 1262;
                        return true;
                    }
                }
                break;
            }
            case 1262: {
                switch (current) {
                    case 114: {
                        this.state = 1263;
                        return true;
                    }
                }
                break;
            }
            case 1263: {
                switch (current) {
                    case 111: {
                        this.state = 1264;
                        return true;
                    }
                }
                break;
            }
            case 1264: {
                switch (current) {
                    case 119: {
                        this.state = 1265;
                        return true;
                    }
                }
                break;
            }
            case 1265: {
                switch (current) {
                    case 59: {
                        this.match = "\u2194";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1266: {
                switch (current) {
                    case 101: {
                        this.state = 1267;
                        return true;
                    }
                }
                break;
            }
            case 1267: {
                switch (current) {
                    case 99: {
                        this.state = 1268;
                        return true;
                    }
                }
                break;
            }
            case 1268: {
                switch (current) {
                    case 116: {
                        this.state = 1269;
                        return true;
                    }
                }
                break;
            }
            case 1269: {
                switch (current) {
                    case 111: {
                        this.state = 1270;
                        return true;
                    }
                }
                break;
            }
            case 1270: {
                switch (current) {
                    case 114: {
                        this.state = 1271;
                        return true;
                    }
                }
                break;
            }
            case 1271: {
                switch (current) {
                    case 59: {
                        this.match = "\u294e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1272: {
                switch (current) {
                    case 101: {
                        this.state = 1273;
                        return true;
                    }
                    case 114: {
                        this.state = 1286;
                        return true;
                    }
                }
                break;
            }
            case 1273: {
                switch (current) {
                    case 101: {
                        this.state = 1274;
                        return true;
                    }
                }
                break;
            }
            case 1274: {
                switch (current) {
                    case 59: {
                        this.match = "\u22a3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 65: {
                        this.state = 1275;
                        return true;
                    }
                    case 86: {
                        this.state = 1280;
                        return true;
                    }
                }
                break;
            }
            case 1275: {
                switch (current) {
                    case 114: {
                        this.state = 1276;
                        return true;
                    }
                }
                break;
            }
            case 1276: {
                switch (current) {
                    case 114: {
                        this.state = 1277;
                        return true;
                    }
                }
                break;
            }
            case 1277: {
                switch (current) {
                    case 111: {
                        this.state = 1278;
                        return true;
                    }
                }
                break;
            }
            case 1278: {
                switch (current) {
                    case 119: {
                        this.state = 1279;
                        return true;
                    }
                }
                break;
            }
            case 1279: {
                switch (current) {
                    case 59: {
                        this.match = "\u21a4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1280: {
                switch (current) {
                    case 101: {
                        this.state = 1281;
                        return true;
                    }
                }
                break;
            }
            case 1281: {
                switch (current) {
                    case 99: {
                        this.state = 1282;
                        return true;
                    }
                }
                break;
            }
            case 1282: {
                switch (current) {
                    case 116: {
                        this.state = 1283;
                        return true;
                    }
                }
                break;
            }
            case 1283: {
                switch (current) {
                    case 111: {
                        this.state = 1284;
                        return true;
                    }
                }
                break;
            }
            case 1284: {
                switch (current) {
                    case 114: {
                        this.state = 1285;
                        return true;
                    }
                }
                break;
            }
            case 1285: {
                switch (current) {
                    case 59: {
                        this.match = "\u295a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1286: {
                switch (current) {
                    case 105: {
                        this.state = 1287;
                        return true;
                    }
                }
                break;
            }
            case 1287: {
                switch (current) {
                    case 97: {
                        this.state = 1288;
                        return true;
                    }
                }
                break;
            }
            case 1288: {
                switch (current) {
                    case 110: {
                        this.state = 1289;
                        return true;
                    }
                }
                break;
            }
            case 1289: {
                switch (current) {
                    case 103: {
                        this.state = 1290;
                        return true;
                    }
                }
                break;
            }
            case 1290: {
                switch (current) {
                    case 108: {
                        this.state = 1291;
                        return true;
                    }
                }
                break;
            }
            case 1291: {
                switch (current) {
                    case 101: {
                        this.state = 1292;
                        return true;
                    }
                }
                break;
            }
            case 1292: {
                switch (current) {
                    case 59: {
                        this.match = "\u22b2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1293;
                        return true;
                    }
                    case 69: {
                        this.state = 1296;
                        return true;
                    }
                }
                break;
            }
            case 1293: {
                switch (current) {
                    case 97: {
                        this.state = 1294;
                        return true;
                    }
                }
                break;
            }
            case 1294: {
                switch (current) {
                    case 114: {
                        this.state = 1295;
                        return true;
                    }
                }
                break;
            }
            case 1295: {
                switch (current) {
                    case 59: {
                        this.match = "\u29cf";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1296: {
                switch (current) {
                    case 113: {
                        this.state = 1297;
                        return true;
                    }
                }
                break;
            }
            case 1297: {
                switch (current) {
                    case 117: {
                        this.state = 1298;
                        return true;
                    }
                }
                break;
            }
            case 1298: {
                switch (current) {
                    case 97: {
                        this.state = 1299;
                        return true;
                    }
                }
                break;
            }
            case 1299: {
                switch (current) {
                    case 108: {
                        this.state = 1300;
                        return true;
                    }
                }
                break;
            }
            case 1300: {
                switch (current) {
                    case 59: {
                        this.match = "\u22b4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1301: {
                switch (current) {
                    case 112: {
                        this.state = 1302;
                        return true;
                    }
                }
                break;
            }
            case 1302: {
                switch (current) {
                    case 68: {
                        this.state = 1303;
                        return true;
                    }
                    case 84: {
                        this.state = 1313;
                        return true;
                    }
                    case 86: {
                        this.state = 1322;
                        return true;
                    }
                }
                break;
            }
            case 1303: {
                switch (current) {
                    case 111: {
                        this.state = 1304;
                        return true;
                    }
                }
                break;
            }
            case 1304: {
                switch (current) {
                    case 119: {
                        this.state = 1305;
                        return true;
                    }
                }
                break;
            }
            case 1305: {
                switch (current) {
                    case 110: {
                        this.state = 1306;
                        return true;
                    }
                }
                break;
            }
            case 1306: {
                switch (current) {
                    case 86: {
                        this.state = 1307;
                        return true;
                    }
                }
                break;
            }
            case 1307: {
                switch (current) {
                    case 101: {
                        this.state = 1308;
                        return true;
                    }
                }
                break;
            }
            case 1308: {
                switch (current) {
                    case 99: {
                        this.state = 1309;
                        return true;
                    }
                }
                break;
            }
            case 1309: {
                switch (current) {
                    case 116: {
                        this.state = 1310;
                        return true;
                    }
                }
                break;
            }
            case 1310: {
                switch (current) {
                    case 111: {
                        this.state = 1311;
                        return true;
                    }
                }
                break;
            }
            case 1311: {
                switch (current) {
                    case 114: {
                        this.state = 1312;
                        return true;
                    }
                }
                break;
            }
            case 1312: {
                switch (current) {
                    case 59: {
                        this.match = "\u2951";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1313: {
                switch (current) {
                    case 101: {
                        this.state = 1314;
                        return true;
                    }
                }
                break;
            }
            case 1314: {
                switch (current) {
                    case 101: {
                        this.state = 1315;
                        return true;
                    }
                }
                break;
            }
            case 1315: {
                switch (current) {
                    case 86: {
                        this.state = 1316;
                        return true;
                    }
                }
                break;
            }
            case 1316: {
                switch (current) {
                    case 101: {
                        this.state = 1317;
                        return true;
                    }
                }
                break;
            }
            case 1317: {
                switch (current) {
                    case 99: {
                        this.state = 1318;
                        return true;
                    }
                }
                break;
            }
            case 1318: {
                switch (current) {
                    case 116: {
                        this.state = 1319;
                        return true;
                    }
                }
                break;
            }
            case 1319: {
                switch (current) {
                    case 111: {
                        this.state = 1320;
                        return true;
                    }
                }
                break;
            }
            case 1320: {
                switch (current) {
                    case 114: {
                        this.state = 1321;
                        return true;
                    }
                }
                break;
            }
            case 1321: {
                switch (current) {
                    case 59: {
                        this.match = "\u2960";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1322: {
                switch (current) {
                    case 101: {
                        this.state = 1323;
                        return true;
                    }
                }
                break;
            }
            case 1323: {
                switch (current) {
                    case 99: {
                        this.state = 1324;
                        return true;
                    }
                }
                break;
            }
            case 1324: {
                switch (current) {
                    case 116: {
                        this.state = 1325;
                        return true;
                    }
                }
                break;
            }
            case 1325: {
                switch (current) {
                    case 111: {
                        this.state = 1326;
                        return true;
                    }
                }
                break;
            }
            case 1326: {
                switch (current) {
                    case 114: {
                        this.state = 1327;
                        return true;
                    }
                }
                break;
            }
            case 1327: {
                switch (current) {
                    case 59: {
                        this.match = "\u21bf";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1328;
                        return true;
                    }
                }
                break;
            }
            case 1328: {
                switch (current) {
                    case 97: {
                        this.state = 1329;
                        return true;
                    }
                }
                break;
            }
            case 1329: {
                switch (current) {
                    case 114: {
                        this.state = 1330;
                        return true;
                    }
                }
                break;
            }
            case 1330: {
                switch (current) {
                    case 59: {
                        this.match = "\u2958";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1331: {
                switch (current) {
                    case 101: {
                        this.state = 1332;
                        return true;
                    }
                }
                break;
            }
            case 1332: {
                switch (current) {
                    case 99: {
                        this.state = 1333;
                        return true;
                    }
                }
                break;
            }
            case 1333: {
                switch (current) {
                    case 116: {
                        this.state = 1334;
                        return true;
                    }
                }
                break;
            }
            case 1334: {
                switch (current) {
                    case 111: {
                        this.state = 1335;
                        return true;
                    }
                }
                break;
            }
            case 1335: {
                switch (current) {
                    case 114: {
                        this.state = 1336;
                        return true;
                    }
                }
                break;
            }
            case 1336: {
                switch (current) {
                    case 59: {
                        this.match = "\u21bc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1337;
                        return true;
                    }
                }
                break;
            }
            case 1337: {
                switch (current) {
                    case 97: {
                        this.state = 1338;
                        return true;
                    }
                }
                break;
            }
            case 1338: {
                switch (current) {
                    case 114: {
                        this.state = 1339;
                        return true;
                    }
                }
                break;
            }
            case 1339: {
                switch (current) {
                    case 59: {
                        this.match = "\u2952";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1340: {
                switch (current) {
                    case 114: {
                        this.state = 1341;
                        return true;
                    }
                }
                break;
            }
            case 1341: {
                switch (current) {
                    case 114: {
                        this.state = 1342;
                        return true;
                    }
                }
                break;
            }
            case 1342: {
                switch (current) {
                    case 111: {
                        this.state = 1343;
                        return true;
                    }
                }
                break;
            }
            case 1343: {
                switch (current) {
                    case 119: {
                        this.state = 1344;
                        return true;
                    }
                }
                break;
            }
            case 1344: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1345: {
                switch (current) {
                    case 105: {
                        this.state = 1346;
                        return true;
                    }
                }
                break;
            }
            case 1346: {
                switch (current) {
                    case 103: {
                        this.state = 1347;
                        return true;
                    }
                }
                break;
            }
            case 1347: {
                switch (current) {
                    case 104: {
                        this.state = 1348;
                        return true;
                    }
                }
                break;
            }
            case 1348: {
                switch (current) {
                    case 116: {
                        this.state = 1349;
                        return true;
                    }
                }
                break;
            }
            case 1349: {
                switch (current) {
                    case 97: {
                        this.state = 1350;
                        return true;
                    }
                }
                break;
            }
            case 1350: {
                switch (current) {
                    case 114: {
                        this.state = 1351;
                        return true;
                    }
                }
                break;
            }
            case 1351: {
                switch (current) {
                    case 114: {
                        this.state = 1352;
                        return true;
                    }
                }
                break;
            }
            case 1352: {
                switch (current) {
                    case 111: {
                        this.state = 1353;
                        return true;
                    }
                }
                break;
            }
            case 1353: {
                switch (current) {
                    case 119: {
                        this.state = 1354;
                        return true;
                    }
                }
                break;
            }
            case 1354: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1355: {
                switch (current) {
                    case 115: {
                        this.state = 1356;
                        return true;
                    }
                }
                break;
            }
            case 1356: {
                switch (current) {
                    case 69: {
                        this.state = 1357;
                        return true;
                    }
                    case 70: {
                        this.state = 1369;
                        return true;
                    }
                    case 71: {
                        this.state = 1378;
                        return true;
                    }
                    case 76: {
                        this.state = 1385;
                        return true;
                    }
                    case 83: {
                        this.state = 1389;
                        return true;
                    }
                    case 84: {
                        this.state = 1399;
                        return true;
                    }
                }
                break;
            }
            case 1357: {
                switch (current) {
                    case 113: {
                        this.state = 1358;
                        return true;
                    }
                }
                break;
            }
            case 1358: {
                switch (current) {
                    case 117: {
                        this.state = 1359;
                        return true;
                    }
                }
                break;
            }
            case 1359: {
                switch (current) {
                    case 97: {
                        this.state = 1360;
                        return true;
                    }
                }
                break;
            }
            case 1360: {
                switch (current) {
                    case 108: {
                        this.state = 1361;
                        return true;
                    }
                }
                break;
            }
            case 1361: {
                switch (current) {
                    case 71: {
                        this.state = 1362;
                        return true;
                    }
                }
                break;
            }
            case 1362: {
                switch (current) {
                    case 114: {
                        this.state = 1363;
                        return true;
                    }
                }
                break;
            }
            case 1363: {
                switch (current) {
                    case 101: {
                        this.state = 1364;
                        return true;
                    }
                }
                break;
            }
            case 1364: {
                switch (current) {
                    case 97: {
                        this.state = 1365;
                        return true;
                    }
                }
                break;
            }
            case 1365: {
                switch (current) {
                    case 116: {
                        this.state = 1366;
                        return true;
                    }
                }
                break;
            }
            case 1366: {
                switch (current) {
                    case 101: {
                        this.state = 1367;
                        return true;
                    }
                }
                break;
            }
            case 1367: {
                switch (current) {
                    case 114: {
                        this.state = 1368;
                        return true;
                    }
                }
                break;
            }
            case 1368: {
                switch (current) {
                    case 59: {
                        this.match = "\u22da";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1369: {
                switch (current) {
                    case 117: {
                        this.state = 1370;
                        return true;
                    }
                }
                break;
            }
            case 1370: {
                switch (current) {
                    case 108: {
                        this.state = 1371;
                        return true;
                    }
                }
                break;
            }
            case 1371: {
                switch (current) {
                    case 108: {
                        this.state = 1372;
                        return true;
                    }
                }
                break;
            }
            case 1372: {
                switch (current) {
                    case 69: {
                        this.state = 1373;
                        return true;
                    }
                }
                break;
            }
            case 1373: {
                switch (current) {
                    case 113: {
                        this.state = 1374;
                        return true;
                    }
                }
                break;
            }
            case 1374: {
                switch (current) {
                    case 117: {
                        this.state = 1375;
                        return true;
                    }
                }
                break;
            }
            case 1375: {
                switch (current) {
                    case 97: {
                        this.state = 1376;
                        return true;
                    }
                }
                break;
            }
            case 1376: {
                switch (current) {
                    case 108: {
                        this.state = 1377;
                        return true;
                    }
                }
                break;
            }
            case 1377: {
                switch (current) {
                    case 59: {
                        this.match = "\u2266";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1378: {
                switch (current) {
                    case 114: {
                        this.state = 1379;
                        return true;
                    }
                }
                break;
            }
            case 1379: {
                switch (current) {
                    case 101: {
                        this.state = 1380;
                        return true;
                    }
                }
                break;
            }
            case 1380: {
                switch (current) {
                    case 97: {
                        this.state = 1381;
                        return true;
                    }
                }
                break;
            }
            case 1381: {
                switch (current) {
                    case 116: {
                        this.state = 1382;
                        return true;
                    }
                }
                break;
            }
            case 1382: {
                switch (current) {
                    case 101: {
                        this.state = 1383;
                        return true;
                    }
                }
                break;
            }
            case 1383: {
                switch (current) {
                    case 114: {
                        this.state = 1384;
                        return true;
                    }
                }
                break;
            }
            case 1384: {
                switch (current) {
                    case 59: {
                        this.match = "\u2276";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1385: {
                switch (current) {
                    case 101: {
                        this.state = 1386;
                        return true;
                    }
                }
                break;
            }
            case 1386: {
                switch (current) {
                    case 115: {
                        this.state = 1387;
                        return true;
                    }
                }
                break;
            }
            case 1387: {
                switch (current) {
                    case 115: {
                        this.state = 1388;
                        return true;
                    }
                }
                break;
            }
            case 1388: {
                switch (current) {
                    case 59: {
                        this.match = "\u2aa1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1389: {
                switch (current) {
                    case 108: {
                        this.state = 1390;
                        return true;
                    }
                }
                break;
            }
            case 1390: {
                switch (current) {
                    case 97: {
                        this.state = 1391;
                        return true;
                    }
                }
                break;
            }
            case 1391: {
                switch (current) {
                    case 110: {
                        this.state = 1392;
                        return true;
                    }
                }
                break;
            }
            case 1392: {
                switch (current) {
                    case 116: {
                        this.state = 1393;
                        return true;
                    }
                }
                break;
            }
            case 1393: {
                switch (current) {
                    case 69: {
                        this.state = 1394;
                        return true;
                    }
                }
                break;
            }
            case 1394: {
                switch (current) {
                    case 113: {
                        this.state = 1395;
                        return true;
                    }
                }
                break;
            }
            case 1395: {
                switch (current) {
                    case 117: {
                        this.state = 1396;
                        return true;
                    }
                }
                break;
            }
            case 1396: {
                switch (current) {
                    case 97: {
                        this.state = 1397;
                        return true;
                    }
                }
                break;
            }
            case 1397: {
                switch (current) {
                    case 108: {
                        this.state = 1398;
                        return true;
                    }
                }
                break;
            }
            case 1398: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a7d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1399: {
                switch (current) {
                    case 105: {
                        this.state = 1400;
                        return true;
                    }
                }
                break;
            }
            case 1400: {
                switch (current) {
                    case 108: {
                        this.state = 1401;
                        return true;
                    }
                }
                break;
            }
            case 1401: {
                switch (current) {
                    case 100: {
                        this.state = 1402;
                        return true;
                    }
                }
                break;
            }
            case 1402: {
                switch (current) {
                    case 101: {
                        this.state = 1403;
                        return true;
                    }
                }
                break;
            }
            case 1403: {
                switch (current) {
                    case 59: {
                        this.match = "\u2272";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1404: {
                switch (current) {
                    case 114: {
                        this.state = 1405;
                        return true;
                    }
                }
                break;
            }
            case 1405: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd0f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1406: {
                switch (current) {
                    case 59: {
                        this.match = "\u22d8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 1407;
                        return true;
                    }
                }
                break;
            }
            case 1407: {
                switch (current) {
                    case 102: {
                        this.state = 1408;
                        return true;
                    }
                }
                break;
            }
            case 1408: {
                switch (current) {
                    case 116: {
                        this.state = 1409;
                        return true;
                    }
                }
                break;
            }
            case 1409: {
                switch (current) {
                    case 97: {
                        this.state = 1410;
                        return true;
                    }
                }
                break;
            }
            case 1410: {
                switch (current) {
                    case 114: {
                        this.state = 1411;
                        return true;
                    }
                }
                break;
            }
            case 1411: {
                switch (current) {
                    case 114: {
                        this.state = 1412;
                        return true;
                    }
                }
                break;
            }
            case 1412: {
                switch (current) {
                    case 111: {
                        this.state = 1413;
                        return true;
                    }
                }
                break;
            }
            case 1413: {
                switch (current) {
                    case 119: {
                        this.state = 1414;
                        return true;
                    }
                }
                break;
            }
            case 1414: {
                switch (current) {
                    case 59: {
                        this.match = "\u21da";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1415: {
                switch (current) {
                    case 105: {
                        this.state = 1416;
                        return true;
                    }
                }
                break;
            }
            case 1416: {
                switch (current) {
                    case 100: {
                        this.state = 1417;
                        return true;
                    }
                }
                break;
            }
            case 1417: {
                switch (current) {
                    case 111: {
                        this.state = 1418;
                        return true;
                    }
                }
                break;
            }
            case 1418: {
                switch (current) {
                    case 116: {
                        this.state = 1419;
                        return true;
                    }
                }
                break;
            }
            case 1419: {
                switch (current) {
                    case 59: {
                        this.match = "\u013f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1420: {
                switch (current) {
                    case 110: {
                        this.state = 1421;
                        return true;
                    }
                    case 112: {
                        this.state = 1481;
                        return true;
                    }
                    case 119: {
                        this.state = 1483;
                        return true;
                    }
                }
                break;
            }
            case 1421: {
                switch (current) {
                    case 103: {
                        this.state = 1422;
                        return true;
                    }
                }
                break;
            }
            case 1422: {
                switch (current) {
                    case 76: {
                        this.state = 1423;
                        return true;
                    }
                    case 82: {
                        this.state = 1442;
                        return true;
                    }
                    case 108: {
                        this.state = 1452;
                        return true;
                    }
                    case 114: {
                        this.state = 1471;
                        return true;
                    }
                }
                break;
            }
            case 1423: {
                switch (current) {
                    case 101: {
                        this.state = 1424;
                        return true;
                    }
                }
                break;
            }
            case 1424: {
                switch (current) {
                    case 102: {
                        this.state = 1425;
                        return true;
                    }
                }
                break;
            }
            case 1425: {
                switch (current) {
                    case 116: {
                        this.state = 1426;
                        return true;
                    }
                }
                break;
            }
            case 1426: {
                switch (current) {
                    case 65: {
                        this.state = 1427;
                        return true;
                    }
                    case 82: {
                        this.state = 1432;
                        return true;
                    }
                }
                break;
            }
            case 1427: {
                switch (current) {
                    case 114: {
                        this.state = 1428;
                        return true;
                    }
                }
                break;
            }
            case 1428: {
                switch (current) {
                    case 114: {
                        this.state = 1429;
                        return true;
                    }
                }
                break;
            }
            case 1429: {
                switch (current) {
                    case 111: {
                        this.state = 1430;
                        return true;
                    }
                }
                break;
            }
            case 1430: {
                switch (current) {
                    case 119: {
                        this.state = 1431;
                        return true;
                    }
                }
                break;
            }
            case 1431: {
                switch (current) {
                    case 59: {
                        this.match = "\u27f5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1432: {
                switch (current) {
                    case 105: {
                        this.state = 1433;
                        return true;
                    }
                }
                break;
            }
            case 1433: {
                switch (current) {
                    case 103: {
                        this.state = 1434;
                        return true;
                    }
                }
                break;
            }
            case 1434: {
                switch (current) {
                    case 104: {
                        this.state = 1435;
                        return true;
                    }
                }
                break;
            }
            case 1435: {
                switch (current) {
                    case 116: {
                        this.state = 1436;
                        return true;
                    }
                }
                break;
            }
            case 1436: {
                switch (current) {
                    case 65: {
                        this.state = 1437;
                        return true;
                    }
                }
                break;
            }
            case 1437: {
                switch (current) {
                    case 114: {
                        this.state = 1438;
                        return true;
                    }
                }
                break;
            }
            case 1438: {
                switch (current) {
                    case 114: {
                        this.state = 1439;
                        return true;
                    }
                }
                break;
            }
            case 1439: {
                switch (current) {
                    case 111: {
                        this.state = 1440;
                        return true;
                    }
                }
                break;
            }
            case 1440: {
                switch (current) {
                    case 119: {
                        this.state = 1441;
                        return true;
                    }
                }
                break;
            }
            case 1441: {
                switch (current) {
                    case 59: {
                        this.match = "\u27f7";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1442: {
                switch (current) {
                    case 105: {
                        this.state = 1443;
                        return true;
                    }
                }
                break;
            }
            case 1443: {
                switch (current) {
                    case 103: {
                        this.state = 1444;
                        return true;
                    }
                }
                break;
            }
            case 1444: {
                switch (current) {
                    case 104: {
                        this.state = 1445;
                        return true;
                    }
                }
                break;
            }
            case 1445: {
                switch (current) {
                    case 116: {
                        this.state = 1446;
                        return true;
                    }
                }
                break;
            }
            case 1446: {
                switch (current) {
                    case 65: {
                        this.state = 1447;
                        return true;
                    }
                }
                break;
            }
            case 1447: {
                switch (current) {
                    case 114: {
                        this.state = 1448;
                        return true;
                    }
                }
                break;
            }
            case 1448: {
                switch (current) {
                    case 114: {
                        this.state = 1449;
                        return true;
                    }
                }
                break;
            }
            case 1449: {
                switch (current) {
                    case 111: {
                        this.state = 1450;
                        return true;
                    }
                }
                break;
            }
            case 1450: {
                switch (current) {
                    case 119: {
                        this.state = 1451;
                        return true;
                    }
                }
                break;
            }
            case 1451: {
                switch (current) {
                    case 59: {
                        this.match = "\u27f6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1452: {
                switch (current) {
                    case 101: {
                        this.state = 1453;
                        return true;
                    }
                }
                break;
            }
            case 1453: {
                switch (current) {
                    case 102: {
                        this.state = 1454;
                        return true;
                    }
                }
                break;
            }
            case 1454: {
                switch (current) {
                    case 116: {
                        this.state = 1455;
                        return true;
                    }
                }
                break;
            }
            case 1455: {
                switch (current) {
                    case 97: {
                        this.state = 1456;
                        return true;
                    }
                    case 114: {
                        this.state = 1461;
                        return true;
                    }
                }
                break;
            }
            case 1456: {
                switch (current) {
                    case 114: {
                        this.state = 1457;
                        return true;
                    }
                }
                break;
            }
            case 1457: {
                switch (current) {
                    case 114: {
                        this.state = 1458;
                        return true;
                    }
                }
                break;
            }
            case 1458: {
                switch (current) {
                    case 111: {
                        this.state = 1459;
                        return true;
                    }
                }
                break;
            }
            case 1459: {
                switch (current) {
                    case 119: {
                        this.state = 1460;
                        return true;
                    }
                }
                break;
            }
            case 1460: {
                switch (current) {
                    case 59: {
                        this.match = "\u27f8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1461: {
                switch (current) {
                    case 105: {
                        this.state = 1462;
                        return true;
                    }
                }
                break;
            }
            case 1462: {
                switch (current) {
                    case 103: {
                        this.state = 1463;
                        return true;
                    }
                }
                break;
            }
            case 1463: {
                switch (current) {
                    case 104: {
                        this.state = 1464;
                        return true;
                    }
                }
                break;
            }
            case 1464: {
                switch (current) {
                    case 116: {
                        this.state = 1465;
                        return true;
                    }
                }
                break;
            }
            case 1465: {
                switch (current) {
                    case 97: {
                        this.state = 1466;
                        return true;
                    }
                }
                break;
            }
            case 1466: {
                switch (current) {
                    case 114: {
                        this.state = 1467;
                        return true;
                    }
                }
                break;
            }
            case 1467: {
                switch (current) {
                    case 114: {
                        this.state = 1468;
                        return true;
                    }
                }
                break;
            }
            case 1468: {
                switch (current) {
                    case 111: {
                        this.state = 1469;
                        return true;
                    }
                }
                break;
            }
            case 1469: {
                switch (current) {
                    case 119: {
                        this.state = 1470;
                        return true;
                    }
                }
                break;
            }
            case 1470: {
                switch (current) {
                    case 59: {
                        this.match = "\u27fa";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1471: {
                switch (current) {
                    case 105: {
                        this.state = 1472;
                        return true;
                    }
                }
                break;
            }
            case 1472: {
                switch (current) {
                    case 103: {
                        this.state = 1473;
                        return true;
                    }
                }
                break;
            }
            case 1473: {
                switch (current) {
                    case 104: {
                        this.state = 1474;
                        return true;
                    }
                }
                break;
            }
            case 1474: {
                switch (current) {
                    case 116: {
                        this.state = 1475;
                        return true;
                    }
                }
                break;
            }
            case 1475: {
                switch (current) {
                    case 97: {
                        this.state = 1476;
                        return true;
                    }
                }
                break;
            }
            case 1476: {
                switch (current) {
                    case 114: {
                        this.state = 1477;
                        return true;
                    }
                }
                break;
            }
            case 1477: {
                switch (current) {
                    case 114: {
                        this.state = 1478;
                        return true;
                    }
                }
                break;
            }
            case 1478: {
                switch (current) {
                    case 111: {
                        this.state = 1479;
                        return true;
                    }
                }
                break;
            }
            case 1479: {
                switch (current) {
                    case 119: {
                        this.state = 1480;
                        return true;
                    }
                }
                break;
            }
            case 1480: {
                switch (current) {
                    case 59: {
                        this.match = "\u27f9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1481: {
                switch (current) {
                    case 102: {
                        this.state = 1482;
                        return true;
                    }
                }
                break;
            }
            case 1482: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd43";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1483: {
                switch (current) {
                    case 101: {
                        this.state = 1484;
                        return true;
                    }
                }
                break;
            }
            case 1484: {
                switch (current) {
                    case 114: {
                        this.state = 1485;
                        return true;
                    }
                }
                break;
            }
            case 1485: {
                switch (current) {
                    case 76: {
                        this.state = 1486;
                        return true;
                    }
                    case 82: {
                        this.state = 1495;
                        return true;
                    }
                }
                break;
            }
            case 1486: {
                switch (current) {
                    case 101: {
                        this.state = 1487;
                        return true;
                    }
                }
                break;
            }
            case 1487: {
                switch (current) {
                    case 102: {
                        this.state = 1488;
                        return true;
                    }
                }
                break;
            }
            case 1488: {
                switch (current) {
                    case 116: {
                        this.state = 1489;
                        return true;
                    }
                }
                break;
            }
            case 1489: {
                switch (current) {
                    case 65: {
                        this.state = 1490;
                        return true;
                    }
                }
                break;
            }
            case 1490: {
                switch (current) {
                    case 114: {
                        this.state = 1491;
                        return true;
                    }
                }
                break;
            }
            case 1491: {
                switch (current) {
                    case 114: {
                        this.state = 1492;
                        return true;
                    }
                }
                break;
            }
            case 1492: {
                switch (current) {
                    case 111: {
                        this.state = 1493;
                        return true;
                    }
                }
                break;
            }
            case 1493: {
                switch (current) {
                    case 119: {
                        this.state = 1494;
                        return true;
                    }
                }
                break;
            }
            case 1494: {
                switch (current) {
                    case 59: {
                        this.match = "\u2199";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1495: {
                switch (current) {
                    case 105: {
                        this.state = 1496;
                        return true;
                    }
                }
                break;
            }
            case 1496: {
                switch (current) {
                    case 103: {
                        this.state = 1497;
                        return true;
                    }
                }
                break;
            }
            case 1497: {
                switch (current) {
                    case 104: {
                        this.state = 1498;
                        return true;
                    }
                }
                break;
            }
            case 1498: {
                switch (current) {
                    case 116: {
                        this.state = 1499;
                        return true;
                    }
                }
                break;
            }
            case 1499: {
                switch (current) {
                    case 65: {
                        this.state = 1500;
                        return true;
                    }
                }
                break;
            }
            case 1500: {
                switch (current) {
                    case 114: {
                        this.state = 1501;
                        return true;
                    }
                }
                break;
            }
            case 1501: {
                switch (current) {
                    case 114: {
                        this.state = 1502;
                        return true;
                    }
                }
                break;
            }
            case 1502: {
                switch (current) {
                    case 111: {
                        this.state = 1503;
                        return true;
                    }
                }
                break;
            }
            case 1503: {
                switch (current) {
                    case 119: {
                        this.state = 1504;
                        return true;
                    }
                }
                break;
            }
            case 1504: {
                switch (current) {
                    case 59: {
                        this.match = "\u2198";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1505: {
                switch (current) {
                    case 99: {
                        this.state = 1506;
                        return true;
                    }
                    case 104: {
                        this.state = 1508;
                        return true;
                    }
                    case 116: {
                        this.state = 1509;
                        return true;
                    }
                }
                break;
            }
            case 1506: {
                switch (current) {
                    case 114: {
                        this.state = 1507;
                        return true;
                    }
                }
                break;
            }
            case 1507: {
                switch (current) {
                    case 59: {
                        this.match = "\u2112";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1508: {
                switch (current) {
                    case 59: {
                        this.match = "\u21b0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1509: {
                switch (current) {
                    case 114: {
                        this.state = 1510;
                        return true;
                    }
                }
                break;
            }
            case 1510: {
                switch (current) {
                    case 111: {
                        this.state = 1511;
                        return true;
                    }
                }
                break;
            }
            case 1511: {
                switch (current) {
                    case 107: {
                        this.state = 1512;
                        return true;
                    }
                }
                break;
            }
            case 1512: {
                switch (current) {
                    case 59: {
                        this.match = "\u0141";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1513: {
                switch (current) {
                    case 59: {
                        this.match = "\u226a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1514: {
                switch (current) {
                    case 97: {
                        this.state = 1515;
                        return true;
                    }
                    case 99: {
                        this.state = 1517;
                        return true;
                    }
                    case 101: {
                        this.state = 1519;
                        return true;
                    }
                    case 102: {
                        this.state = 1536;
                        return true;
                    }
                    case 105: {
                        this.state = 1538;
                        return true;
                    }
                    case 111: {
                        this.state = 1546;
                        return true;
                    }
                    case 115: {
                        this.state = 1549;
                        return true;
                    }
                    case 117: {
                        this.state = 1552;
                        return true;
                    }
                }
                break;
            }
            case 1515: {
                switch (current) {
                    case 112: {
                        this.state = 1516;
                        return true;
                    }
                }
                break;
            }
            case 1516: {
                switch (current) {
                    case 59: {
                        this.match = "\u2905";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1517: {
                switch (current) {
                    case 121: {
                        this.state = 1518;
                        return true;
                    }
                }
                break;
            }
            case 1518: {
                switch (current) {
                    case 59: {
                        this.match = "\u041c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1519: {
                switch (current) {
                    case 100: {
                        this.state = 1520;
                        return true;
                    }
                    case 108: {
                        this.state = 1529;
                        return true;
                    }
                }
                break;
            }
            case 1520: {
                switch (current) {
                    case 105: {
                        this.state = 1521;
                        return true;
                    }
                }
                break;
            }
            case 1521: {
                switch (current) {
                    case 117: {
                        this.state = 1522;
                        return true;
                    }
                }
                break;
            }
            case 1522: {
                switch (current) {
                    case 109: {
                        this.state = 1523;
                        return true;
                    }
                }
                break;
            }
            case 1523: {
                switch (current) {
                    case 83: {
                        this.state = 1524;
                        return true;
                    }
                }
                break;
            }
            case 1524: {
                switch (current) {
                    case 112: {
                        this.state = 1525;
                        return true;
                    }
                }
                break;
            }
            case 1525: {
                switch (current) {
                    case 97: {
                        this.state = 1526;
                        return true;
                    }
                }
                break;
            }
            case 1526: {
                switch (current) {
                    case 99: {
                        this.state = 1527;
                        return true;
                    }
                }
                break;
            }
            case 1527: {
                switch (current) {
                    case 101: {
                        this.state = 1528;
                        return true;
                    }
                }
                break;
            }
            case 1528: {
                switch (current) {
                    case 59: {
                        this.match = "\u205f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1529: {
                switch (current) {
                    case 108: {
                        this.state = 1530;
                        return true;
                    }
                }
                break;
            }
            case 1530: {
                switch (current) {
                    case 105: {
                        this.state = 1531;
                        return true;
                    }
                }
                break;
            }
            case 1531: {
                switch (current) {
                    case 110: {
                        this.state = 1532;
                        return true;
                    }
                }
                break;
            }
            case 1532: {
                switch (current) {
                    case 116: {
                        this.state = 1533;
                        return true;
                    }
                }
                break;
            }
            case 1533: {
                switch (current) {
                    case 114: {
                        this.state = 1534;
                        return true;
                    }
                }
                break;
            }
            case 1534: {
                switch (current) {
                    case 102: {
                        this.state = 1535;
                        return true;
                    }
                }
                break;
            }
            case 1535: {
                switch (current) {
                    case 59: {
                        this.match = "\u2133";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1536: {
                switch (current) {
                    case 114: {
                        this.state = 1537;
                        return true;
                    }
                }
                break;
            }
            case 1537: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd10";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1538: {
                switch (current) {
                    case 110: {
                        this.state = 1539;
                        return true;
                    }
                }
                break;
            }
            case 1539: {
                switch (current) {
                    case 117: {
                        this.state = 1540;
                        return true;
                    }
                }
                break;
            }
            case 1540: {
                switch (current) {
                    case 115: {
                        this.state = 1541;
                        return true;
                    }
                }
                break;
            }
            case 1541: {
                switch (current) {
                    case 80: {
                        this.state = 1542;
                        return true;
                    }
                }
                break;
            }
            case 1542: {
                switch (current) {
                    case 108: {
                        this.state = 1543;
                        return true;
                    }
                }
                break;
            }
            case 1543: {
                switch (current) {
                    case 117: {
                        this.state = 1544;
                        return true;
                    }
                }
                break;
            }
            case 1544: {
                switch (current) {
                    case 115: {
                        this.state = 1545;
                        return true;
                    }
                }
                break;
            }
            case 1545: {
                switch (current) {
                    case 59: {
                        this.match = "\u2213";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1546: {
                switch (current) {
                    case 112: {
                        this.state = 1547;
                        return true;
                    }
                }
                break;
            }
            case 1547: {
                switch (current) {
                    case 102: {
                        this.state = 1548;
                        return true;
                    }
                }
                break;
            }
            case 1548: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd44";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1549: {
                switch (current) {
                    case 99: {
                        this.state = 1550;
                        return true;
                    }
                }
                break;
            }
            case 1550: {
                switch (current) {
                    case 114: {
                        this.state = 1551;
                        return true;
                    }
                }
                break;
            }
            case 1551: {
                switch (current) {
                    case 59: {
                        this.match = "\u2133";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1552: {
                switch (current) {
                    case 59: {
                        this.match = "\u039c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1553: {
                switch (current) {
                    case 74: {
                        this.state = 1554;
                        return true;
                    }
                    case 97: {
                        this.state = 1557;
                        return true;
                    }
                    case 99: {
                        this.state = 1562;
                        return true;
                    }
                    case 101: {
                        this.state = 1572;
                        return true;
                    }
                    case 102: {
                        this.state = 1650;
                        return true;
                    }
                    case 111: {
                        this.state = 1652;
                        return true;
                    }
                    case 115: {
                        this.state = 2055;
                        return true;
                    }
                    case 116: {
                        this.state = 2058;
                        return true;
                    }
                    case 117: {
                        this.state = 2063;
                        return true;
                    }
                }
                break;
            }
            case 1554: {
                switch (current) {
                    case 99: {
                        this.state = 1555;
                        return true;
                    }
                }
                break;
            }
            case 1555: {
                switch (current) {
                    case 121: {
                        this.state = 1556;
                        return true;
                    }
                }
                break;
            }
            case 1556: {
                switch (current) {
                    case 59: {
                        this.match = "\u040a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1557: {
                switch (current) {
                    case 99: {
                        this.state = 1558;
                        return true;
                    }
                }
                break;
            }
            case 1558: {
                switch (current) {
                    case 117: {
                        this.state = 1559;
                        return true;
                    }
                }
                break;
            }
            case 1559: {
                switch (current) {
                    case 116: {
                        this.state = 1560;
                        return true;
                    }
                }
                break;
            }
            case 1560: {
                switch (current) {
                    case 101: {
                        this.state = 1561;
                        return true;
                    }
                }
                break;
            }
            case 1561: {
                switch (current) {
                    case 59: {
                        this.match = "\u0143";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1562: {
                switch (current) {
                    case 97: {
                        this.state = 1563;
                        return true;
                    }
                    case 101: {
                        this.state = 1567;
                        return true;
                    }
                    case 121: {
                        this.state = 1571;
                        return true;
                    }
                }
                break;
            }
            case 1563: {
                switch (current) {
                    case 114: {
                        this.state = 1564;
                        return true;
                    }
                }
                break;
            }
            case 1564: {
                switch (current) {
                    case 111: {
                        this.state = 1565;
                        return true;
                    }
                }
                break;
            }
            case 1565: {
                switch (current) {
                    case 110: {
                        this.state = 1566;
                        return true;
                    }
                }
                break;
            }
            case 1566: {
                switch (current) {
                    case 59: {
                        this.match = "\u0147";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1567: {
                switch (current) {
                    case 100: {
                        this.state = 1568;
                        return true;
                    }
                }
                break;
            }
            case 1568: {
                switch (current) {
                    case 105: {
                        this.state = 1569;
                        return true;
                    }
                }
                break;
            }
            case 1569: {
                switch (current) {
                    case 108: {
                        this.state = 1570;
                        return true;
                    }
                }
                break;
            }
            case 1570: {
                switch (current) {
                    case 59: {
                        this.match = "\u0145";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1571: {
                switch (current) {
                    case 59: {
                        this.match = "\u041d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1572: {
                switch (current) {
                    case 103: {
                        this.state = 1573;
                        return true;
                    }
                    case 115: {
                        this.state = 1619;
                        return true;
                    }
                    case 119: {
                        this.state = 1645;
                        return true;
                    }
                }
                break;
            }
            case 1573: {
                switch (current) {
                    case 97: {
                        this.state = 1574;
                        return true;
                    }
                }
                break;
            }
            case 1574: {
                switch (current) {
                    case 116: {
                        this.state = 1575;
                        return true;
                    }
                }
                break;
            }
            case 1575: {
                switch (current) {
                    case 105: {
                        this.state = 1576;
                        return true;
                    }
                }
                break;
            }
            case 1576: {
                switch (current) {
                    case 118: {
                        this.state = 1577;
                        return true;
                    }
                }
                break;
            }
            case 1577: {
                switch (current) {
                    case 101: {
                        this.state = 1578;
                        return true;
                    }
                }
                break;
            }
            case 1578: {
                switch (current) {
                    case 77: {
                        this.state = 1579;
                        return true;
                    }
                    case 84: {
                        this.state = 1590;
                        return true;
                    }
                    case 86: {
                        this.state = 1606;
                        return true;
                    }
                }
                break;
            }
            case 1579: {
                switch (current) {
                    case 101: {
                        this.state = 1580;
                        return true;
                    }
                }
                break;
            }
            case 1580: {
                switch (current) {
                    case 100: {
                        this.state = 1581;
                        return true;
                    }
                }
                break;
            }
            case 1581: {
                switch (current) {
                    case 105: {
                        this.state = 1582;
                        return true;
                    }
                }
                break;
            }
            case 1582: {
                switch (current) {
                    case 117: {
                        this.state = 1583;
                        return true;
                    }
                }
                break;
            }
            case 1583: {
                switch (current) {
                    case 109: {
                        this.state = 1584;
                        return true;
                    }
                }
                break;
            }
            case 1584: {
                switch (current) {
                    case 83: {
                        this.state = 1585;
                        return true;
                    }
                }
                break;
            }
            case 1585: {
                switch (current) {
                    case 112: {
                        this.state = 1586;
                        return true;
                    }
                }
                break;
            }
            case 1586: {
                switch (current) {
                    case 97: {
                        this.state = 1587;
                        return true;
                    }
                }
                break;
            }
            case 1587: {
                switch (current) {
                    case 99: {
                        this.state = 1588;
                        return true;
                    }
                }
                break;
            }
            case 1588: {
                switch (current) {
                    case 101: {
                        this.state = 1589;
                        return true;
                    }
                }
                break;
            }
            case 1589: {
                switch (current) {
                    case 59: {
                        this.match = "\u200b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1590: {
                switch (current) {
                    case 104: {
                        this.state = 1591;
                        return true;
                    }
                }
                break;
            }
            case 1591: {
                switch (current) {
                    case 105: {
                        this.state = 1592;
                        return true;
                    }
                }
                break;
            }
            case 1592: {
                switch (current) {
                    case 99: {
                        this.state = 1593;
                        return true;
                    }
                    case 110: {
                        this.state = 1600;
                        return true;
                    }
                }
                break;
            }
            case 1593: {
                switch (current) {
                    case 107: {
                        this.state = 1594;
                        return true;
                    }
                }
                break;
            }
            case 1594: {
                switch (current) {
                    case 83: {
                        this.state = 1595;
                        return true;
                    }
                }
                break;
            }
            case 1595: {
                switch (current) {
                    case 112: {
                        this.state = 1596;
                        return true;
                    }
                }
                break;
            }
            case 1596: {
                switch (current) {
                    case 97: {
                        this.state = 1597;
                        return true;
                    }
                }
                break;
            }
            case 1597: {
                switch (current) {
                    case 99: {
                        this.state = 1598;
                        return true;
                    }
                }
                break;
            }
            case 1598: {
                switch (current) {
                    case 101: {
                        this.state = 1599;
                        return true;
                    }
                }
                break;
            }
            case 1599: {
                switch (current) {
                    case 59: {
                        this.match = "\u200b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1600: {
                switch (current) {
                    case 83: {
                        this.state = 1601;
                        return true;
                    }
                }
                break;
            }
            case 1601: {
                switch (current) {
                    case 112: {
                        this.state = 1602;
                        return true;
                    }
                }
                break;
            }
            case 1602: {
                switch (current) {
                    case 97: {
                        this.state = 1603;
                        return true;
                    }
                }
                break;
            }
            case 1603: {
                switch (current) {
                    case 99: {
                        this.state = 1604;
                        return true;
                    }
                }
                break;
            }
            case 1604: {
                switch (current) {
                    case 101: {
                        this.state = 1605;
                        return true;
                    }
                }
                break;
            }
            case 1605: {
                switch (current) {
                    case 59: {
                        this.match = "\u200b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1606: {
                switch (current) {
                    case 101: {
                        this.state = 1607;
                        return true;
                    }
                }
                break;
            }
            case 1607: {
                switch (current) {
                    case 114: {
                        this.state = 1608;
                        return true;
                    }
                }
                break;
            }
            case 1608: {
                switch (current) {
                    case 121: {
                        this.state = 1609;
                        return true;
                    }
                }
                break;
            }
            case 1609: {
                switch (current) {
                    case 84: {
                        this.state = 1610;
                        return true;
                    }
                }
                break;
            }
            case 1610: {
                switch (current) {
                    case 104: {
                        this.state = 1611;
                        return true;
                    }
                }
                break;
            }
            case 1611: {
                switch (current) {
                    case 105: {
                        this.state = 1612;
                        return true;
                    }
                }
                break;
            }
            case 1612: {
                switch (current) {
                    case 110: {
                        this.state = 1613;
                        return true;
                    }
                }
                break;
            }
            case 1613: {
                switch (current) {
                    case 83: {
                        this.state = 1614;
                        return true;
                    }
                }
                break;
            }
            case 1614: {
                switch (current) {
                    case 112: {
                        this.state = 1615;
                        return true;
                    }
                }
                break;
            }
            case 1615: {
                switch (current) {
                    case 97: {
                        this.state = 1616;
                        return true;
                    }
                }
                break;
            }
            case 1616: {
                switch (current) {
                    case 99: {
                        this.state = 1617;
                        return true;
                    }
                }
                break;
            }
            case 1617: {
                switch (current) {
                    case 101: {
                        this.state = 1618;
                        return true;
                    }
                }
                break;
            }
            case 1618: {
                switch (current) {
                    case 59: {
                        this.match = "\u200b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1619: {
                switch (current) {
                    case 116: {
                        this.state = 1620;
                        return true;
                    }
                }
                break;
            }
            case 1620: {
                switch (current) {
                    case 101: {
                        this.state = 1621;
                        return true;
                    }
                }
                break;
            }
            case 1621: {
                switch (current) {
                    case 100: {
                        this.state = 1622;
                        return true;
                    }
                }
                break;
            }
            case 1622: {
                switch (current) {
                    case 71: {
                        this.state = 1623;
                        return true;
                    }
                    case 76: {
                        this.state = 1637;
                        return true;
                    }
                }
                break;
            }
            case 1623: {
                switch (current) {
                    case 114: {
                        this.state = 1624;
                        return true;
                    }
                }
                break;
            }
            case 1624: {
                switch (current) {
                    case 101: {
                        this.state = 1625;
                        return true;
                    }
                }
                break;
            }
            case 1625: {
                switch (current) {
                    case 97: {
                        this.state = 1626;
                        return true;
                    }
                }
                break;
            }
            case 1626: {
                switch (current) {
                    case 116: {
                        this.state = 1627;
                        return true;
                    }
                }
                break;
            }
            case 1627: {
                switch (current) {
                    case 101: {
                        this.state = 1628;
                        return true;
                    }
                }
                break;
            }
            case 1628: {
                switch (current) {
                    case 114: {
                        this.state = 1629;
                        return true;
                    }
                }
                break;
            }
            case 1629: {
                switch (current) {
                    case 71: {
                        this.state = 1630;
                        return true;
                    }
                }
                break;
            }
            case 1630: {
                switch (current) {
                    case 114: {
                        this.state = 1631;
                        return true;
                    }
                }
                break;
            }
            case 1631: {
                switch (current) {
                    case 101: {
                        this.state = 1632;
                        return true;
                    }
                }
                break;
            }
            case 1632: {
                switch (current) {
                    case 97: {
                        this.state = 1633;
                        return true;
                    }
                }
                break;
            }
            case 1633: {
                switch (current) {
                    case 116: {
                        this.state = 1634;
                        return true;
                    }
                }
                break;
            }
            case 1634: {
                switch (current) {
                    case 101: {
                        this.state = 1635;
                        return true;
                    }
                }
                break;
            }
            case 1635: {
                switch (current) {
                    case 114: {
                        this.state = 1636;
                        return true;
                    }
                }
                break;
            }
            case 1636: {
                switch (current) {
                    case 59: {
                        this.match = "\u226b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1637: {
                switch (current) {
                    case 101: {
                        this.state = 1638;
                        return true;
                    }
                }
                break;
            }
            case 1638: {
                switch (current) {
                    case 115: {
                        this.state = 1639;
                        return true;
                    }
                }
                break;
            }
            case 1639: {
                switch (current) {
                    case 115: {
                        this.state = 1640;
                        return true;
                    }
                }
                break;
            }
            case 1640: {
                switch (current) {
                    case 76: {
                        this.state = 1641;
                        return true;
                    }
                }
                break;
            }
            case 1641: {
                switch (current) {
                    case 101: {
                        this.state = 1642;
                        return true;
                    }
                }
                break;
            }
            case 1642: {
                switch (current) {
                    case 115: {
                        this.state = 1643;
                        return true;
                    }
                }
                break;
            }
            case 1643: {
                switch (current) {
                    case 115: {
                        this.state = 1644;
                        return true;
                    }
                }
                break;
            }
            case 1644: {
                switch (current) {
                    case 59: {
                        this.match = "\u226a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1645: {
                switch (current) {
                    case 76: {
                        this.state = 1646;
                        return true;
                    }
                }
                break;
            }
            case 1646: {
                switch (current) {
                    case 105: {
                        this.state = 1647;
                        return true;
                    }
                }
                break;
            }
            case 1647: {
                switch (current) {
                    case 110: {
                        this.state = 1648;
                        return true;
                    }
                }
                break;
            }
            case 1648: {
                switch (current) {
                    case 101: {
                        this.state = 1649;
                        return true;
                    }
                }
                break;
            }
            case 1649: {
                switch (current) {
                    case 59: {
                        this.match = "\n";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1650: {
                switch (current) {
                    case 114: {
                        this.state = 1651;
                        return true;
                    }
                }
                break;
            }
            case 1651: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd11";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1652: {
                switch (current) {
                    case 66: {
                        this.state = 1653;
                        return true;
                    }
                    case 110: {
                        this.state = 1658;
                        return true;
                    }
                    case 112: {
                        this.state = 1672;
                        return true;
                    }
                    case 116: {
                        this.state = 1674;
                        return true;
                    }
                }
                break;
            }
            case 1653: {
                switch (current) {
                    case 114: {
                        this.state = 1654;
                        return true;
                    }
                }
                break;
            }
            case 1654: {
                switch (current) {
                    case 101: {
                        this.state = 1655;
                        return true;
                    }
                }
                break;
            }
            case 1655: {
                switch (current) {
                    case 97: {
                        this.state = 1656;
                        return true;
                    }
                }
                break;
            }
            case 1656: {
                switch (current) {
                    case 107: {
                        this.state = 1657;
                        return true;
                    }
                }
                break;
            }
            case 1657: {
                switch (current) {
                    case 59: {
                        this.match = "\u2060";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1658: {
                switch (current) {
                    case 66: {
                        this.state = 1659;
                        return true;
                    }
                }
                break;
            }
            case 1659: {
                switch (current) {
                    case 114: {
                        this.state = 1660;
                        return true;
                    }
                }
                break;
            }
            case 1660: {
                switch (current) {
                    case 101: {
                        this.state = 1661;
                        return true;
                    }
                }
                break;
            }
            case 1661: {
                switch (current) {
                    case 97: {
                        this.state = 1662;
                        return true;
                    }
                }
                break;
            }
            case 1662: {
                switch (current) {
                    case 107: {
                        this.state = 1663;
                        return true;
                    }
                }
                break;
            }
            case 1663: {
                switch (current) {
                    case 105: {
                        this.state = 1664;
                        return true;
                    }
                }
                break;
            }
            case 1664: {
                switch (current) {
                    case 110: {
                        this.state = 1665;
                        return true;
                    }
                }
                break;
            }
            case 1665: {
                switch (current) {
                    case 103: {
                        this.state = 1666;
                        return true;
                    }
                }
                break;
            }
            case 1666: {
                switch (current) {
                    case 83: {
                        this.state = 1667;
                        return true;
                    }
                }
                break;
            }
            case 1667: {
                switch (current) {
                    case 112: {
                        this.state = 1668;
                        return true;
                    }
                }
                break;
            }
            case 1668: {
                switch (current) {
                    case 97: {
                        this.state = 1669;
                        return true;
                    }
                }
                break;
            }
            case 1669: {
                switch (current) {
                    case 99: {
                        this.state = 1670;
                        return true;
                    }
                }
                break;
            }
            case 1670: {
                switch (current) {
                    case 101: {
                        this.state = 1671;
                        return true;
                    }
                }
                break;
            }
            case 1671: {
                switch (current) {
                    case 59: {
                        this.match = "\u00a0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1672: {
                switch (current) {
                    case 102: {
                        this.state = 1673;
                        return true;
                    }
                }
                break;
            }
            case 1673: {
                switch (current) {
                    case 59: {
                        this.match = "\u2115";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1674: {
                switch (current) {
                    case 59: {
                        this.match = "\u2aec";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 67: {
                        this.state = 1675;
                        return true;
                    }
                    case 68: {
                        this.state = 1689;
                        return true;
                    }
                    case 69: {
                        this.state = 1706;
                        return true;
                    }
                    case 71: {
                        this.state = 1727;
                        return true;
                    }
                    case 72: {
                        this.state = 1780;
                        return true;
                    }
                    case 76: {
                        this.state = 1801;
                        return true;
                    }
                    case 78: {
                        this.state = 1860;
                        return true;
                    }
                    case 80: {
                        this.state = 1888;
                        return true;
                    }
                    case 82: {
                        this.state = 1911;
                        return true;
                    }
                    case 83: {
                        this.state = 1945;
                        return true;
                    }
                    case 84: {
                        this.state = 2020;
                        return true;
                    }
                    case 86: {
                        this.state = 2044;
                        return true;
                    }
                }
                break;
            }
            case 1675: {
                switch (current) {
                    case 111: {
                        this.state = 1676;
                        return true;
                    }
                    case 117: {
                        this.state = 1684;
                        return true;
                    }
                }
                break;
            }
            case 1676: {
                switch (current) {
                    case 110: {
                        this.state = 1677;
                        return true;
                    }
                }
                break;
            }
            case 1677: {
                switch (current) {
                    case 103: {
                        this.state = 1678;
                        return true;
                    }
                }
                break;
            }
            case 1678: {
                switch (current) {
                    case 114: {
                        this.state = 1679;
                        return true;
                    }
                }
                break;
            }
            case 1679: {
                switch (current) {
                    case 117: {
                        this.state = 1680;
                        return true;
                    }
                }
                break;
            }
            case 1680: {
                switch (current) {
                    case 101: {
                        this.state = 1681;
                        return true;
                    }
                }
                break;
            }
            case 1681: {
                switch (current) {
                    case 110: {
                        this.state = 1682;
                        return true;
                    }
                }
                break;
            }
            case 1682: {
                switch (current) {
                    case 116: {
                        this.state = 1683;
                        return true;
                    }
                }
                break;
            }
            case 1683: {
                switch (current) {
                    case 59: {
                        this.match = "\u2262";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1684: {
                switch (current) {
                    case 112: {
                        this.state = 1685;
                        return true;
                    }
                }
                break;
            }
            case 1685: {
                switch (current) {
                    case 67: {
                        this.state = 1686;
                        return true;
                    }
                }
                break;
            }
            case 1686: {
                switch (current) {
                    case 97: {
                        this.state = 1687;
                        return true;
                    }
                }
                break;
            }
            case 1687: {
                switch (current) {
                    case 112: {
                        this.state = 1688;
                        return true;
                    }
                }
                break;
            }
            case 1688: {
                switch (current) {
                    case 59: {
                        this.match = "\u226d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1689: {
                switch (current) {
                    case 111: {
                        this.state = 1690;
                        return true;
                    }
                }
                break;
            }
            case 1690: {
                switch (current) {
                    case 117: {
                        this.state = 1691;
                        return true;
                    }
                }
                break;
            }
            case 1691: {
                switch (current) {
                    case 98: {
                        this.state = 1692;
                        return true;
                    }
                }
                break;
            }
            case 1692: {
                switch (current) {
                    case 108: {
                        this.state = 1693;
                        return true;
                    }
                }
                break;
            }
            case 1693: {
                switch (current) {
                    case 101: {
                        this.state = 1694;
                        return true;
                    }
                }
                break;
            }
            case 1694: {
                switch (current) {
                    case 86: {
                        this.state = 1695;
                        return true;
                    }
                }
                break;
            }
            case 1695: {
                switch (current) {
                    case 101: {
                        this.state = 1696;
                        return true;
                    }
                }
                break;
            }
            case 1696: {
                switch (current) {
                    case 114: {
                        this.state = 1697;
                        return true;
                    }
                }
                break;
            }
            case 1697: {
                switch (current) {
                    case 116: {
                        this.state = 1698;
                        return true;
                    }
                }
                break;
            }
            case 1698: {
                switch (current) {
                    case 105: {
                        this.state = 1699;
                        return true;
                    }
                }
                break;
            }
            case 1699: {
                switch (current) {
                    case 99: {
                        this.state = 1700;
                        return true;
                    }
                }
                break;
            }
            case 1700: {
                switch (current) {
                    case 97: {
                        this.state = 1701;
                        return true;
                    }
                }
                break;
            }
            case 1701: {
                switch (current) {
                    case 108: {
                        this.state = 1702;
                        return true;
                    }
                }
                break;
            }
            case 1702: {
                switch (current) {
                    case 66: {
                        this.state = 1703;
                        return true;
                    }
                }
                break;
            }
            case 1703: {
                switch (current) {
                    case 97: {
                        this.state = 1704;
                        return true;
                    }
                }
                break;
            }
            case 1704: {
                switch (current) {
                    case 114: {
                        this.state = 1705;
                        return true;
                    }
                }
                break;
            }
            case 1705: {
                switch (current) {
                    case 59: {
                        this.match = "\u2226";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1706: {
                switch (current) {
                    case 108: {
                        this.state = 1707;
                        return true;
                    }
                    case 113: {
                        this.state = 1713;
                        return true;
                    }
                    case 120: {
                        this.state = 1722;
                        return true;
                    }
                }
                break;
            }
            case 1707: {
                switch (current) {
                    case 101: {
                        this.state = 1708;
                        return true;
                    }
                }
                break;
            }
            case 1708: {
                switch (current) {
                    case 109: {
                        this.state = 1709;
                        return true;
                    }
                }
                break;
            }
            case 1709: {
                switch (current) {
                    case 101: {
                        this.state = 1710;
                        return true;
                    }
                }
                break;
            }
            case 1710: {
                switch (current) {
                    case 110: {
                        this.state = 1711;
                        return true;
                    }
                }
                break;
            }
            case 1711: {
                switch (current) {
                    case 116: {
                        this.state = 1712;
                        return true;
                    }
                }
                break;
            }
            case 1712: {
                switch (current) {
                    case 59: {
                        this.match = "\u2209";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1713: {
                switch (current) {
                    case 117: {
                        this.state = 1714;
                        return true;
                    }
                }
                break;
            }
            case 1714: {
                switch (current) {
                    case 97: {
                        this.state = 1715;
                        return true;
                    }
                }
                break;
            }
            case 1715: {
                switch (current) {
                    case 108: {
                        this.state = 1716;
                        return true;
                    }
                }
                break;
            }
            case 1716: {
                switch (current) {
                    case 59: {
                        this.match = "\u2260";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 84: {
                        this.state = 1717;
                        return true;
                    }
                }
                break;
            }
            case 1717: {
                switch (current) {
                    case 105: {
                        this.state = 1718;
                        return true;
                    }
                }
                break;
            }
            case 1718: {
                switch (current) {
                    case 108: {
                        this.state = 1719;
                        return true;
                    }
                }
                break;
            }
            case 1719: {
                switch (current) {
                    case 100: {
                        this.state = 1720;
                        return true;
                    }
                }
                break;
            }
            case 1720: {
                switch (current) {
                    case 101: {
                        this.state = 1721;
                        return true;
                    }
                }
                break;
            }
            case 1721: {
                switch (current) {
                    case 59: {
                        this.match = "\u2242\u0338";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1722: {
                switch (current) {
                    case 105: {
                        this.state = 1723;
                        return true;
                    }
                }
                break;
            }
            case 1723: {
                switch (current) {
                    case 115: {
                        this.state = 1724;
                        return true;
                    }
                }
                break;
            }
            case 1724: {
                switch (current) {
                    case 116: {
                        this.state = 1725;
                        return true;
                    }
                }
                break;
            }
            case 1725: {
                switch (current) {
                    case 115: {
                        this.state = 1726;
                        return true;
                    }
                }
                break;
            }
            case 1726: {
                switch (current) {
                    case 59: {
                        this.match = "\u2204";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1727: {
                switch (current) {
                    case 114: {
                        this.state = 1728;
                        return true;
                    }
                }
                break;
            }
            case 1728: {
                switch (current) {
                    case 101: {
                        this.state = 1729;
                        return true;
                    }
                }
                break;
            }
            case 1729: {
                switch (current) {
                    case 97: {
                        this.state = 1730;
                        return true;
                    }
                }
                break;
            }
            case 1730: {
                switch (current) {
                    case 116: {
                        this.state = 1731;
                        return true;
                    }
                }
                break;
            }
            case 1731: {
                switch (current) {
                    case 101: {
                        this.state = 1732;
                        return true;
                    }
                }
                break;
            }
            case 1732: {
                switch (current) {
                    case 114: {
                        this.state = 1733;
                        return true;
                    }
                }
                break;
            }
            case 1733: {
                switch (current) {
                    case 59: {
                        this.match = "\u226f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1734;
                        return true;
                    }
                    case 70: {
                        this.state = 1739;
                        return true;
                    }
                    case 71: {
                        this.state = 1750;
                        return true;
                    }
                    case 76: {
                        this.state = 1759;
                        return true;
                    }
                    case 83: {
                        this.state = 1763;
                        return true;
                    }
                    case 84: {
                        this.state = 1775;
                        return true;
                    }
                }
                break;
            }
            case 1734: {
                switch (current) {
                    case 113: {
                        this.state = 1735;
                        return true;
                    }
                }
                break;
            }
            case 1735: {
                switch (current) {
                    case 117: {
                        this.state = 1736;
                        return true;
                    }
                }
                break;
            }
            case 1736: {
                switch (current) {
                    case 97: {
                        this.state = 1737;
                        return true;
                    }
                }
                break;
            }
            case 1737: {
                switch (current) {
                    case 108: {
                        this.state = 1738;
                        return true;
                    }
                }
                break;
            }
            case 1738: {
                switch (current) {
                    case 59: {
                        this.match = "\u2271";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1739: {
                switch (current) {
                    case 117: {
                        this.state = 1740;
                        return true;
                    }
                }
                break;
            }
            case 1740: {
                switch (current) {
                    case 108: {
                        this.state = 1741;
                        return true;
                    }
                }
                break;
            }
            case 1741: {
                switch (current) {
                    case 108: {
                        this.state = 1742;
                        return true;
                    }
                }
                break;
            }
            case 1742: {
                switch (current) {
                    case 69: {
                        this.state = 1743;
                        return true;
                    }
                }
                break;
            }
            case 1743: {
                switch (current) {
                    case 113: {
                        this.state = 1744;
                        return true;
                    }
                }
                break;
            }
            case 1744: {
                switch (current) {
                    case 117: {
                        this.state = 1745;
                        return true;
                    }
                }
                break;
            }
            case 1745: {
                switch (current) {
                    case 97: {
                        this.state = 1746;
                        return true;
                    }
                }
                break;
            }
            case 1746: {
                switch (current) {
                    case 108: {
                        this.state = 1747;
                        return true;
                    }
                }
                break;
            }
            case 1747: {
                switch (current) {
                    case 59: {
                        this.state = 1748;
                        return true;
                    }
                }
                break;
            }
            case 1748: {
                switch (current) {
                    case 8807: {
                        this.state = 1749;
                        return true;
                    }
                }
                break;
            }
            case 1749: {
                switch (current) {
                    case 824: {
                        this.match = "";
                        this.matchLength = this.consumedCount;
                        return false;
                    }
                }
                break;
            }
            case 1750: {
                switch (current) {
                    case 114: {
                        this.state = 1751;
                        return true;
                    }
                }
                break;
            }
            case 1751: {
                switch (current) {
                    case 101: {
                        this.state = 1752;
                        return true;
                    }
                }
                break;
            }
            case 1752: {
                switch (current) {
                    case 97: {
                        this.state = 1753;
                        return true;
                    }
                }
                break;
            }
            case 1753: {
                switch (current) {
                    case 116: {
                        this.state = 1754;
                        return true;
                    }
                }
                break;
            }
            case 1754: {
                switch (current) {
                    case 101: {
                        this.state = 1755;
                        return true;
                    }
                }
                break;
            }
            case 1755: {
                switch (current) {
                    case 114: {
                        this.state = 1756;
                        return true;
                    }
                }
                break;
            }
            case 1756: {
                switch (current) {
                    case 59: {
                        this.state = 1757;
                        return true;
                    }
                }
                break;
            }
            case 1757: {
                switch (current) {
                    case 8811: {
                        this.state = 1758;
                        return true;
                    }
                }
                break;
            }
            case 1758: {
                switch (current) {
                    case 824: {
                        this.match = "";
                        this.matchLength = this.consumedCount;
                        return false;
                    }
                }
                break;
            }
            case 1759: {
                switch (current) {
                    case 101: {
                        this.state = 1760;
                        return true;
                    }
                }
                break;
            }
            case 1760: {
                switch (current) {
                    case 115: {
                        this.state = 1761;
                        return true;
                    }
                }
                break;
            }
            case 1761: {
                switch (current) {
                    case 115: {
                        this.state = 1762;
                        return true;
                    }
                }
                break;
            }
            case 1762: {
                switch (current) {
                    case 59: {
                        this.match = "\u2279";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1763: {
                switch (current) {
                    case 108: {
                        this.state = 1764;
                        return true;
                    }
                }
                break;
            }
            case 1764: {
                switch (current) {
                    case 97: {
                        this.state = 1765;
                        return true;
                    }
                }
                break;
            }
            case 1765: {
                switch (current) {
                    case 110: {
                        this.state = 1766;
                        return true;
                    }
                }
                break;
            }
            case 1766: {
                switch (current) {
                    case 116: {
                        this.state = 1767;
                        return true;
                    }
                }
                break;
            }
            case 1767: {
                switch (current) {
                    case 69: {
                        this.state = 1768;
                        return true;
                    }
                }
                break;
            }
            case 1768: {
                switch (current) {
                    case 113: {
                        this.state = 1769;
                        return true;
                    }
                }
                break;
            }
            case 1769: {
                switch (current) {
                    case 117: {
                        this.state = 1770;
                        return true;
                    }
                }
                break;
            }
            case 1770: {
                switch (current) {
                    case 97: {
                        this.state = 1771;
                        return true;
                    }
                }
                break;
            }
            case 1771: {
                switch (current) {
                    case 108: {
                        this.state = 1772;
                        return true;
                    }
                }
                break;
            }
            case 1772: {
                switch (current) {
                    case 59: {
                        this.state = 1773;
                        return true;
                    }
                }
                break;
            }
            case 1773: {
                switch (current) {
                    case 10878: {
                        this.state = 1774;
                        return true;
                    }
                }
                break;
            }
            case 1774: {
                switch (current) {
                    case 824: {
                        this.match = "";
                        this.matchLength = this.consumedCount;
                        return false;
                    }
                }
                break;
            }
            case 1775: {
                switch (current) {
                    case 105: {
                        this.state = 1776;
                        return true;
                    }
                }
                break;
            }
            case 1776: {
                switch (current) {
                    case 108: {
                        this.state = 1777;
                        return true;
                    }
                }
                break;
            }
            case 1777: {
                switch (current) {
                    case 100: {
                        this.state = 1778;
                        return true;
                    }
                }
                break;
            }
            case 1778: {
                switch (current) {
                    case 101: {
                        this.state = 1779;
                        return true;
                    }
                }
                break;
            }
            case 1779: {
                switch (current) {
                    case 59: {
                        this.match = "\u2275";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1780: {
                switch (current) {
                    case 117: {
                        this.state = 1781;
                        return true;
                    }
                }
                break;
            }
            case 1781: {
                switch (current) {
                    case 109: {
                        this.state = 1782;
                        return true;
                    }
                }
                break;
            }
            case 1782: {
                switch (current) {
                    case 112: {
                        this.state = 1783;
                        return true;
                    }
                }
                break;
            }
            case 1783: {
                switch (current) {
                    case 68: {
                        this.state = 1784;
                        return true;
                    }
                    case 69: {
                        this.state = 1794;
                        return true;
                    }
                }
                break;
            }
            case 1784: {
                switch (current) {
                    case 111: {
                        this.state = 1785;
                        return true;
                    }
                }
                break;
            }
            case 1785: {
                switch (current) {
                    case 119: {
                        this.state = 1786;
                        return true;
                    }
                }
                break;
            }
            case 1786: {
                switch (current) {
                    case 110: {
                        this.state = 1787;
                        return true;
                    }
                }
                break;
            }
            case 1787: {
                switch (current) {
                    case 72: {
                        this.state = 1788;
                        return true;
                    }
                }
                break;
            }
            case 1788: {
                switch (current) {
                    case 117: {
                        this.state = 1789;
                        return true;
                    }
                }
                break;
            }
            case 1789: {
                switch (current) {
                    case 109: {
                        this.state = 1790;
                        return true;
                    }
                }
                break;
            }
            case 1790: {
                switch (current) {
                    case 112: {
                        this.state = 1791;
                        return true;
                    }
                }
                break;
            }
            case 1791: {
                switch (current) {
                    case 59: {
                        this.state = 1792;
                        return true;
                    }
                }
                break;
            }
            case 1792: {
                switch (current) {
                    case 8782: {
                        this.state = 1793;
                        return true;
                    }
                }
                break;
            }
            case 1793: {
                switch (current) {
                    case 824: {
                        this.match = "";
                        this.matchLength = this.consumedCount;
                        return false;
                    }
                }
                break;
            }
            case 1794: {
                switch (current) {
                    case 113: {
                        this.state = 1795;
                        return true;
                    }
                }
                break;
            }
            case 1795: {
                switch (current) {
                    case 117: {
                        this.state = 1796;
                        return true;
                    }
                }
                break;
            }
            case 1796: {
                switch (current) {
                    case 97: {
                        this.state = 1797;
                        return true;
                    }
                }
                break;
            }
            case 1797: {
                switch (current) {
                    case 108: {
                        this.state = 1798;
                        return true;
                    }
                }
                break;
            }
            case 1798: {
                switch (current) {
                    case 59: {
                        this.state = 1799;
                        return true;
                    }
                }
                break;
            }
            case 1799: {
                switch (current) {
                    case 8783: {
                        this.state = 1800;
                        return true;
                    }
                }
                break;
            }
            case 1800: {
                switch (current) {
                    case 824: {
                        this.match = "";
                        this.matchLength = this.consumedCount;
                        return false;
                    }
                }
                break;
            }
            case 1801: {
                switch (current) {
                    case 101: {
                        this.state = 1802;
                        return true;
                    }
                }
                break;
            }
            case 1802: {
                switch (current) {
                    case 102: {
                        this.state = 1803;
                        return true;
                    }
                    case 115: {
                        this.state = 1823;
                        return true;
                    }
                }
                break;
            }
            case 1803: {
                switch (current) {
                    case 116: {
                        this.state = 1804;
                        return true;
                    }
                }
                break;
            }
            case 1804: {
                switch (current) {
                    case 84: {
                        this.state = 1805;
                        return true;
                    }
                }
                break;
            }
            case 1805: {
                switch (current) {
                    case 114: {
                        this.state = 1806;
                        return true;
                    }
                }
                break;
            }
            case 1806: {
                switch (current) {
                    case 105: {
                        this.state = 1807;
                        return true;
                    }
                }
                break;
            }
            case 1807: {
                switch (current) {
                    case 97: {
                        this.state = 1808;
                        return true;
                    }
                }
                break;
            }
            case 1808: {
                switch (current) {
                    case 110: {
                        this.state = 1809;
                        return true;
                    }
                }
                break;
            }
            case 1809: {
                switch (current) {
                    case 103: {
                        this.state = 1810;
                        return true;
                    }
                }
                break;
            }
            case 1810: {
                switch (current) {
                    case 108: {
                        this.state = 1811;
                        return true;
                    }
                }
                break;
            }
            case 1811: {
                switch (current) {
                    case 101: {
                        this.state = 1812;
                        return true;
                    }
                }
                break;
            }
            case 1812: {
                switch (current) {
                    case 59: {
                        this.match = "\u22ea";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1813;
                        return true;
                    }
                    case 69: {
                        this.state = 1818;
                        return true;
                    }
                }
                break;
            }
            case 1813: {
                switch (current) {
                    case 97: {
                        this.state = 1814;
                        return true;
                    }
                }
                break;
            }
            case 1814: {
                switch (current) {
                    case 114: {
                        this.state = 1815;
                        return true;
                    }
                }
                break;
            }
            case 1815: {
                switch (current) {
                    case 59: {
                        this.state = 1816;
                        return true;
                    }
                }
                break;
            }
            case 1816: {
                switch (current) {
                    case 10703: {
                        this.state = 1817;
                        return true;
                    }
                }
                break;
            }
            case 1817: {
                switch (current) {
                    case 824: {
                        this.match = "";
                        this.matchLength = this.consumedCount;
                        return false;
                    }
                }
                break;
            }
            case 1818: {
                switch (current) {
                    case 113: {
                        this.state = 1819;
                        return true;
                    }
                }
                break;
            }
            case 1819: {
                switch (current) {
                    case 117: {
                        this.state = 1820;
                        return true;
                    }
                }
                break;
            }
            case 1820: {
                switch (current) {
                    case 97: {
                        this.state = 1821;
                        return true;
                    }
                }
                break;
            }
            case 1821: {
                switch (current) {
                    case 108: {
                        this.state = 1822;
                        return true;
                    }
                }
                break;
            }
            case 1822: {
                switch (current) {
                    case 59: {
                        this.match = "\u22ec";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1823: {
                switch (current) {
                    case 115: {
                        this.state = 1824;
                        return true;
                    }
                }
                break;
            }
            case 1824: {
                switch (current) {
                    case 59: {
                        this.match = "\u226e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1825;
                        return true;
                    }
                    case 71: {
                        this.state = 1830;
                        return true;
                    }
                    case 76: {
                        this.state = 1837;
                        return true;
                    }
                    case 83: {
                        this.state = 1843;
                        return true;
                    }
                    case 84: {
                        this.state = 1855;
                        return true;
                    }
                }
                break;
            }
            case 1825: {
                switch (current) {
                    case 113: {
                        this.state = 1826;
                        return true;
                    }
                }
                break;
            }
            case 1826: {
                switch (current) {
                    case 117: {
                        this.state = 1827;
                        return true;
                    }
                }
                break;
            }
            case 1827: {
                switch (current) {
                    case 97: {
                        this.state = 1828;
                        return true;
                    }
                }
                break;
            }
            case 1828: {
                switch (current) {
                    case 108: {
                        this.state = 1829;
                        return true;
                    }
                }
                break;
            }
            case 1829: {
                switch (current) {
                    case 59: {
                        this.match = "\u2270";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1830: {
                switch (current) {
                    case 114: {
                        this.state = 1831;
                        return true;
                    }
                }
                break;
            }
            case 1831: {
                switch (current) {
                    case 101: {
                        this.state = 1832;
                        return true;
                    }
                }
                break;
            }
            case 1832: {
                switch (current) {
                    case 97: {
                        this.state = 1833;
                        return true;
                    }
                }
                break;
            }
            case 1833: {
                switch (current) {
                    case 116: {
                        this.state = 1834;
                        return true;
                    }
                }
                break;
            }
            case 1834: {
                switch (current) {
                    case 101: {
                        this.state = 1835;
                        return true;
                    }
                }
                break;
            }
            case 1835: {
                switch (current) {
                    case 114: {
                        this.state = 1836;
                        return true;
                    }
                }
                break;
            }
            case 1836: {
                switch (current) {
                    case 59: {
                        this.match = "\u2278";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1837: {
                switch (current) {
                    case 101: {
                        this.state = 1838;
                        return true;
                    }
                }
                break;
            }
            case 1838: {
                switch (current) {
                    case 115: {
                        this.state = 1839;
                        return true;
                    }
                }
                break;
            }
            case 1839: {
                switch (current) {
                    case 115: {
                        this.state = 1840;
                        return true;
                    }
                }
                break;
            }
            case 1840: {
                switch (current) {
                    case 59: {
                        this.state = 1841;
                        return true;
                    }
                }
                break;
            }
            case 1841: {
                switch (current) {
                    case 8810: {
                        this.state = 1842;
                        return true;
                    }
                }
                break;
            }
            case 1842: {
                switch (current) {
                    case 824: {
                        this.match = "";
                        this.matchLength = this.consumedCount;
                        return false;
                    }
                }
                break;
            }
            case 1843: {
                switch (current) {
                    case 108: {
                        this.state = 1844;
                        return true;
                    }
                }
                break;
            }
            case 1844: {
                switch (current) {
                    case 97: {
                        this.state = 1845;
                        return true;
                    }
                }
                break;
            }
            case 1845: {
                switch (current) {
                    case 110: {
                        this.state = 1846;
                        return true;
                    }
                }
                break;
            }
            case 1846: {
                switch (current) {
                    case 116: {
                        this.state = 1847;
                        return true;
                    }
                }
                break;
            }
            case 1847: {
                switch (current) {
                    case 69: {
                        this.state = 1848;
                        return true;
                    }
                }
                break;
            }
            case 1848: {
                switch (current) {
                    case 113: {
                        this.state = 1849;
                        return true;
                    }
                }
                break;
            }
            case 1849: {
                switch (current) {
                    case 117: {
                        this.state = 1850;
                        return true;
                    }
                }
                break;
            }
            case 1850: {
                switch (current) {
                    case 97: {
                        this.state = 1851;
                        return true;
                    }
                }
                break;
            }
            case 1851: {
                switch (current) {
                    case 108: {
                        this.state = 1852;
                        return true;
                    }
                }
                break;
            }
            case 1852: {
                switch (current) {
                    case 59: {
                        this.state = 1853;
                        return true;
                    }
                }
                break;
            }
            case 1853: {
                switch (current) {
                    case 10877: {
                        this.state = 1854;
                        return true;
                    }
                }
                break;
            }
            case 1854: {
                switch (current) {
                    case 824: {
                        this.match = "";
                        this.matchLength = this.consumedCount;
                        return false;
                    }
                }
                break;
            }
            case 1855: {
                switch (current) {
                    case 105: {
                        this.state = 1856;
                        return true;
                    }
                }
                break;
            }
            case 1856: {
                switch (current) {
                    case 108: {
                        this.state = 1857;
                        return true;
                    }
                }
                break;
            }
            case 1857: {
                switch (current) {
                    case 100: {
                        this.state = 1858;
                        return true;
                    }
                }
                break;
            }
            case 1858: {
                switch (current) {
                    case 101: {
                        this.state = 1859;
                        return true;
                    }
                }
                break;
            }
            case 1859: {
                switch (current) {
                    case 59: {
                        this.match = "\u2274";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1860: {
                switch (current) {
                    case 101: {
                        this.state = 1861;
                        return true;
                    }
                }
                break;
            }
            case 1861: {
                switch (current) {
                    case 115: {
                        this.state = 1862;
                        return true;
                    }
                }
                break;
            }
            case 1862: {
                switch (current) {
                    case 116: {
                        this.state = 1863;
                        return true;
                    }
                }
                break;
            }
            case 1863: {
                switch (current) {
                    case 101: {
                        this.state = 1864;
                        return true;
                    }
                }
                break;
            }
            case 1864: {
                switch (current) {
                    case 100: {
                        this.state = 1865;
                        return true;
                    }
                }
                break;
            }
            case 1865: {
                switch (current) {
                    case 71: {
                        this.state = 1866;
                        return true;
                    }
                    case 76: {
                        this.state = 1880;
                        return true;
                    }
                }
                break;
            }
            case 1866: {
                switch (current) {
                    case 114: {
                        this.state = 1867;
                        return true;
                    }
                }
                break;
            }
            case 1867: {
                switch (current) {
                    case 101: {
                        this.state = 1868;
                        return true;
                    }
                }
                break;
            }
            case 1868: {
                switch (current) {
                    case 97: {
                        this.state = 1869;
                        return true;
                    }
                }
                break;
            }
            case 1869: {
                switch (current) {
                    case 116: {
                        this.state = 1870;
                        return true;
                    }
                }
                break;
            }
            case 1870: {
                switch (current) {
                    case 101: {
                        this.state = 1871;
                        return true;
                    }
                }
                break;
            }
            case 1871: {
                switch (current) {
                    case 114: {
                        this.state = 1872;
                        return true;
                    }
                }
                break;
            }
            case 1872: {
                switch (current) {
                    case 71: {
                        this.state = 1873;
                        return true;
                    }
                }
                break;
            }
            case 1873: {
                switch (current) {
                    case 114: {
                        this.state = 1874;
                        return true;
                    }
                }
                break;
            }
            case 1874: {
                switch (current) {
                    case 101: {
                        this.state = 1875;
                        return true;
                    }
                }
                break;
            }
            case 1875: {
                switch (current) {
                    case 97: {
                        this.state = 1876;
                        return true;
                    }
                }
                break;
            }
            case 1876: {
                switch (current) {
                    case 116: {
                        this.state = 1877;
                        return true;
                    }
                }
                break;
            }
            case 1877: {
                switch (current) {
                    case 101: {
                        this.state = 1878;
                        return true;
                    }
                }
                break;
            }
            case 1878: {
                switch (current) {
                    case 114: {
                        this.state = 1879;
                        return true;
                    }
                }
                break;
            }
            case 1879: {
                switch (current) {
                    case 59: {
                        this.match = "\u2aa2\u0338";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1880: {
                switch (current) {
                    case 101: {
                        this.state = 1881;
                        return true;
                    }
                }
                break;
            }
            case 1881: {
                switch (current) {
                    case 115: {
                        this.state = 1882;
                        return true;
                    }
                }
                break;
            }
            case 1882: {
                switch (current) {
                    case 115: {
                        this.state = 1883;
                        return true;
                    }
                }
                break;
            }
            case 1883: {
                switch (current) {
                    case 76: {
                        this.state = 1884;
                        return true;
                    }
                }
                break;
            }
            case 1884: {
                switch (current) {
                    case 101: {
                        this.state = 1885;
                        return true;
                    }
                }
                break;
            }
            case 1885: {
                switch (current) {
                    case 115: {
                        this.state = 1886;
                        return true;
                    }
                }
                break;
            }
            case 1886: {
                switch (current) {
                    case 115: {
                        this.state = 1887;
                        return true;
                    }
                }
                break;
            }
            case 1887: {
                switch (current) {
                    case 59: {
                        this.match = "\u2aa1\u0338";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1888: {
                switch (current) {
                    case 114: {
                        this.state = 1889;
                        return true;
                    }
                }
                break;
            }
            case 1889: {
                switch (current) {
                    case 101: {
                        this.state = 1890;
                        return true;
                    }
                }
                break;
            }
            case 1890: {
                switch (current) {
                    case 99: {
                        this.state = 1891;
                        return true;
                    }
                }
                break;
            }
            case 1891: {
                switch (current) {
                    case 101: {
                        this.state = 1892;
                        return true;
                    }
                }
                break;
            }
            case 1892: {
                switch (current) {
                    case 100: {
                        this.state = 1893;
                        return true;
                    }
                }
                break;
            }
            case 1893: {
                switch (current) {
                    case 101: {
                        this.state = 1894;
                        return true;
                    }
                }
                break;
            }
            case 1894: {
                switch (current) {
                    case 115: {
                        this.state = 1895;
                        return true;
                    }
                }
                break;
            }
            case 1895: {
                switch (current) {
                    case 59: {
                        this.match = "\u2280";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1896;
                        return true;
                    }
                    case 83: {
                        this.state = 1901;
                        return true;
                    }
                }
                break;
            }
            case 1896: {
                switch (current) {
                    case 113: {
                        this.state = 1897;
                        return true;
                    }
                }
                break;
            }
            case 1897: {
                switch (current) {
                    case 117: {
                        this.state = 1898;
                        return true;
                    }
                }
                break;
            }
            case 1898: {
                switch (current) {
                    case 97: {
                        this.state = 1899;
                        return true;
                    }
                }
                break;
            }
            case 1899: {
                switch (current) {
                    case 108: {
                        this.state = 1900;
                        return true;
                    }
                }
                break;
            }
            case 1900: {
                switch (current) {
                    case 59: {
                        this.match = "\u2aaf\u0338";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1901: {
                switch (current) {
                    case 108: {
                        this.state = 1902;
                        return true;
                    }
                }
                break;
            }
            case 1902: {
                switch (current) {
                    case 97: {
                        this.state = 1903;
                        return true;
                    }
                }
                break;
            }
            case 1903: {
                switch (current) {
                    case 110: {
                        this.state = 1904;
                        return true;
                    }
                }
                break;
            }
            case 1904: {
                switch (current) {
                    case 116: {
                        this.state = 1905;
                        return true;
                    }
                }
                break;
            }
            case 1905: {
                switch (current) {
                    case 69: {
                        this.state = 1906;
                        return true;
                    }
                }
                break;
            }
            case 1906: {
                switch (current) {
                    case 113: {
                        this.state = 1907;
                        return true;
                    }
                }
                break;
            }
            case 1907: {
                switch (current) {
                    case 117: {
                        this.state = 1908;
                        return true;
                    }
                }
                break;
            }
            case 1908: {
                switch (current) {
                    case 97: {
                        this.state = 1909;
                        return true;
                    }
                }
                break;
            }
            case 1909: {
                switch (current) {
                    case 108: {
                        this.state = 1910;
                        return true;
                    }
                }
                break;
            }
            case 1910: {
                switch (current) {
                    case 59: {
                        this.match = "\u22e0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1911: {
                switch (current) {
                    case 101: {
                        this.state = 1912;
                        return true;
                    }
                    case 105: {
                        this.state = 1925;
                        return true;
                    }
                }
                break;
            }
            case 1912: {
                switch (current) {
                    case 118: {
                        this.state = 1913;
                        return true;
                    }
                }
                break;
            }
            case 1913: {
                switch (current) {
                    case 101: {
                        this.state = 1914;
                        return true;
                    }
                }
                break;
            }
            case 1914: {
                switch (current) {
                    case 114: {
                        this.state = 1915;
                        return true;
                    }
                }
                break;
            }
            case 1915: {
                switch (current) {
                    case 115: {
                        this.state = 1916;
                        return true;
                    }
                }
                break;
            }
            case 1916: {
                switch (current) {
                    case 101: {
                        this.state = 1917;
                        return true;
                    }
                }
                break;
            }
            case 1917: {
                switch (current) {
                    case 69: {
                        this.state = 1918;
                        return true;
                    }
                }
                break;
            }
            case 1918: {
                switch (current) {
                    case 108: {
                        this.state = 1919;
                        return true;
                    }
                }
                break;
            }
            case 1919: {
                switch (current) {
                    case 101: {
                        this.state = 1920;
                        return true;
                    }
                }
                break;
            }
            case 1920: {
                switch (current) {
                    case 109: {
                        this.state = 1921;
                        return true;
                    }
                }
                break;
            }
            case 1921: {
                switch (current) {
                    case 101: {
                        this.state = 1922;
                        return true;
                    }
                }
                break;
            }
            case 1922: {
                switch (current) {
                    case 110: {
                        this.state = 1923;
                        return true;
                    }
                }
                break;
            }
            case 1923: {
                switch (current) {
                    case 116: {
                        this.state = 1924;
                        return true;
                    }
                }
                break;
            }
            case 1924: {
                switch (current) {
                    case 59: {
                        this.match = "\u220c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1925: {
                switch (current) {
                    case 103: {
                        this.state = 1926;
                        return true;
                    }
                }
                break;
            }
            case 1926: {
                switch (current) {
                    case 104: {
                        this.state = 1927;
                        return true;
                    }
                }
                break;
            }
            case 1927: {
                switch (current) {
                    case 116: {
                        this.state = 1928;
                        return true;
                    }
                }
                break;
            }
            case 1928: {
                switch (current) {
                    case 84: {
                        this.state = 1929;
                        return true;
                    }
                }
                break;
            }
            case 1929: {
                switch (current) {
                    case 114: {
                        this.state = 1930;
                        return true;
                    }
                }
                break;
            }
            case 1930: {
                switch (current) {
                    case 105: {
                        this.state = 1931;
                        return true;
                    }
                }
                break;
            }
            case 1931: {
                switch (current) {
                    case 97: {
                        this.state = 1932;
                        return true;
                    }
                }
                break;
            }
            case 1932: {
                switch (current) {
                    case 110: {
                        this.state = 1933;
                        return true;
                    }
                }
                break;
            }
            case 1933: {
                switch (current) {
                    case 103: {
                        this.state = 1934;
                        return true;
                    }
                }
                break;
            }
            case 1934: {
                switch (current) {
                    case 108: {
                        this.state = 1935;
                        return true;
                    }
                }
                break;
            }
            case 1935: {
                switch (current) {
                    case 101: {
                        this.state = 1936;
                        return true;
                    }
                }
                break;
            }
            case 1936: {
                switch (current) {
                    case 59: {
                        this.match = "\u22eb";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 1937;
                        return true;
                    }
                    case 69: {
                        this.state = 1940;
                        return true;
                    }
                }
                break;
            }
            case 1937: {
                switch (current) {
                    case 97: {
                        this.state = 1938;
                        return true;
                    }
                }
                break;
            }
            case 1938: {
                switch (current) {
                    case 114: {
                        this.state = 1939;
                        return true;
                    }
                }
                break;
            }
            case 1939: {
                switch (current) {
                    case 59: {
                        this.match = "\u29d0\u0338";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1940: {
                switch (current) {
                    case 113: {
                        this.state = 1941;
                        return true;
                    }
                }
                break;
            }
            case 1941: {
                switch (current) {
                    case 117: {
                        this.state = 1942;
                        return true;
                    }
                }
                break;
            }
            case 1942: {
                switch (current) {
                    case 97: {
                        this.state = 1943;
                        return true;
                    }
                }
                break;
            }
            case 1943: {
                switch (current) {
                    case 108: {
                        this.state = 1944;
                        return true;
                    }
                }
                break;
            }
            case 1944: {
                switch (current) {
                    case 59: {
                        this.match = "\u22ed";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1945: {
                switch (current) {
                    case 113: {
                        this.state = 1946;
                        return true;
                    }
                    case 117: {
                        this.state = 1973;
                        return true;
                    }
                }
                break;
            }
            case 1946: {
                switch (current) {
                    case 117: {
                        this.state = 1947;
                        return true;
                    }
                }
                break;
            }
            case 1947: {
                switch (current) {
                    case 97: {
                        this.state = 1948;
                        return true;
                    }
                }
                break;
            }
            case 1948: {
                switch (current) {
                    case 114: {
                        this.state = 1949;
                        return true;
                    }
                }
                break;
            }
            case 1949: {
                switch (current) {
                    case 101: {
                        this.state = 1950;
                        return true;
                    }
                }
                break;
            }
            case 1950: {
                switch (current) {
                    case 83: {
                        this.state = 1951;
                        return true;
                    }
                }
                break;
            }
            case 1951: {
                switch (current) {
                    case 117: {
                        this.state = 1952;
                        return true;
                    }
                }
                break;
            }
            case 1952: {
                switch (current) {
                    case 98: {
                        this.state = 1953;
                        return true;
                    }
                    case 112: {
                        this.state = 1962;
                        return true;
                    }
                }
                break;
            }
            case 1953: {
                switch (current) {
                    case 115: {
                        this.state = 1954;
                        return true;
                    }
                }
                break;
            }
            case 1954: {
                switch (current) {
                    case 101: {
                        this.state = 1955;
                        return true;
                    }
                }
                break;
            }
            case 1955: {
                switch (current) {
                    case 116: {
                        this.state = 1956;
                        return true;
                    }
                }
                break;
            }
            case 1956: {
                switch (current) {
                    case 59: {
                        this.match = "\u228f\u0338";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1957;
                        return true;
                    }
                }
                break;
            }
            case 1957: {
                switch (current) {
                    case 113: {
                        this.state = 1958;
                        return true;
                    }
                }
                break;
            }
            case 1958: {
                switch (current) {
                    case 117: {
                        this.state = 1959;
                        return true;
                    }
                }
                break;
            }
            case 1959: {
                switch (current) {
                    case 97: {
                        this.state = 1960;
                        return true;
                    }
                }
                break;
            }
            case 1960: {
                switch (current) {
                    case 108: {
                        this.state = 1961;
                        return true;
                    }
                }
                break;
            }
            case 1961: {
                switch (current) {
                    case 59: {
                        this.match = "\u22e2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1962: {
                switch (current) {
                    case 101: {
                        this.state = 1963;
                        return true;
                    }
                }
                break;
            }
            case 1963: {
                switch (current) {
                    case 114: {
                        this.state = 1964;
                        return true;
                    }
                }
                break;
            }
            case 1964: {
                switch (current) {
                    case 115: {
                        this.state = 1965;
                        return true;
                    }
                }
                break;
            }
            case 1965: {
                switch (current) {
                    case 101: {
                        this.state = 1966;
                        return true;
                    }
                }
                break;
            }
            case 1966: {
                switch (current) {
                    case 116: {
                        this.state = 1967;
                        return true;
                    }
                }
                break;
            }
            case 1967: {
                switch (current) {
                    case 59: {
                        this.match = "\u2290\u0338";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1968;
                        return true;
                    }
                }
                break;
            }
            case 1968: {
                switch (current) {
                    case 113: {
                        this.state = 1969;
                        return true;
                    }
                }
                break;
            }
            case 1969: {
                switch (current) {
                    case 117: {
                        this.state = 1970;
                        return true;
                    }
                }
                break;
            }
            case 1970: {
                switch (current) {
                    case 97: {
                        this.state = 1971;
                        return true;
                    }
                }
                break;
            }
            case 1971: {
                switch (current) {
                    case 108: {
                        this.state = 1972;
                        return true;
                    }
                }
                break;
            }
            case 1972: {
                switch (current) {
                    case 59: {
                        this.match = "\u22e3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1973: {
                switch (current) {
                    case 98: {
                        this.state = 1974;
                        return true;
                    }
                    case 99: {
                        this.state = 1983;
                        return true;
                    }
                    case 112: {
                        this.state = 2009;
                        return true;
                    }
                }
                break;
            }
            case 1974: {
                switch (current) {
                    case 115: {
                        this.state = 1975;
                        return true;
                    }
                }
                break;
            }
            case 1975: {
                switch (current) {
                    case 101: {
                        this.state = 1976;
                        return true;
                    }
                }
                break;
            }
            case 1976: {
                switch (current) {
                    case 116: {
                        this.state = 1977;
                        return true;
                    }
                }
                break;
            }
            case 1977: {
                switch (current) {
                    case 59: {
                        this.match = "\u2282\u20d2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1978;
                        return true;
                    }
                }
                break;
            }
            case 1978: {
                switch (current) {
                    case 113: {
                        this.state = 1979;
                        return true;
                    }
                }
                break;
            }
            case 1979: {
                switch (current) {
                    case 117: {
                        this.state = 1980;
                        return true;
                    }
                }
                break;
            }
            case 1980: {
                switch (current) {
                    case 97: {
                        this.state = 1981;
                        return true;
                    }
                }
                break;
            }
            case 1981: {
                switch (current) {
                    case 108: {
                        this.state = 1982;
                        return true;
                    }
                }
                break;
            }
            case 1982: {
                switch (current) {
                    case 59: {
                        this.match = "\u2288";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1983: {
                switch (current) {
                    case 99: {
                        this.state = 1984;
                        return true;
                    }
                }
                break;
            }
            case 1984: {
                switch (current) {
                    case 101: {
                        this.state = 1985;
                        return true;
                    }
                }
                break;
            }
            case 1985: {
                switch (current) {
                    case 101: {
                        this.state = 1986;
                        return true;
                    }
                }
                break;
            }
            case 1986: {
                switch (current) {
                    case 100: {
                        this.state = 1987;
                        return true;
                    }
                }
                break;
            }
            case 1987: {
                switch (current) {
                    case 115: {
                        this.state = 1988;
                        return true;
                    }
                }
                break;
            }
            case 1988: {
                switch (current) {
                    case 59: {
                        this.match = "\u2281";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 1989;
                        return true;
                    }
                    case 83: {
                        this.state = 1994;
                        return true;
                    }
                    case 84: {
                        this.state = 2004;
                        return true;
                    }
                }
                break;
            }
            case 1989: {
                switch (current) {
                    case 113: {
                        this.state = 1990;
                        return true;
                    }
                }
                break;
            }
            case 1990: {
                switch (current) {
                    case 117: {
                        this.state = 1991;
                        return true;
                    }
                }
                break;
            }
            case 1991: {
                switch (current) {
                    case 97: {
                        this.state = 1992;
                        return true;
                    }
                }
                break;
            }
            case 1992: {
                switch (current) {
                    case 108: {
                        this.state = 1993;
                        return true;
                    }
                }
                break;
            }
            case 1993: {
                switch (current) {
                    case 59: {
                        this.match = "\u2ab0\u0338";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 1994: {
                switch (current) {
                    case 108: {
                        this.state = 1995;
                        return true;
                    }
                }
                break;
            }
            case 1995: {
                switch (current) {
                    case 97: {
                        this.state = 1996;
                        return true;
                    }
                }
                break;
            }
            case 1996: {
                switch (current) {
                    case 110: {
                        this.state = 1997;
                        return true;
                    }
                }
                break;
            }
            case 1997: {
                switch (current) {
                    case 116: {
                        this.state = 1998;
                        return true;
                    }
                }
                break;
            }
            case 1998: {
                switch (current) {
                    case 69: {
                        this.state = 1999;
                        return true;
                    }
                }
                break;
            }
            case 1999: {
                switch (current) {
                    case 113: {
                        this.state = 2000;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    private boolean parse3(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 2000: {
                switch (current) {
                    case 117: {
                        this.state = 2001;
                        return true;
                    }
                }
                break;
            }
            case 2001: {
                switch (current) {
                    case 97: {
                        this.state = 2002;
                        return true;
                    }
                }
                break;
            }
            case 2002: {
                switch (current) {
                    case 108: {
                        this.state = 2003;
                        return true;
                    }
                }
                break;
            }
            case 2003: {
                switch (current) {
                    case 59: {
                        this.match = "\u22e1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2004: {
                switch (current) {
                    case 105: {
                        this.state = 2005;
                        return true;
                    }
                }
                break;
            }
            case 2005: {
                switch (current) {
                    case 108: {
                        this.state = 2006;
                        return true;
                    }
                }
                break;
            }
            case 2006: {
                switch (current) {
                    case 100: {
                        this.state = 2007;
                        return true;
                    }
                }
                break;
            }
            case 2007: {
                switch (current) {
                    case 101: {
                        this.state = 2008;
                        return true;
                    }
                }
                break;
            }
            case 2008: {
                switch (current) {
                    case 59: {
                        this.match = "\u227f\u0338";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2009: {
                switch (current) {
                    case 101: {
                        this.state = 2010;
                        return true;
                    }
                }
                break;
            }
            case 2010: {
                switch (current) {
                    case 114: {
                        this.state = 2011;
                        return true;
                    }
                }
                break;
            }
            case 2011: {
                switch (current) {
                    case 115: {
                        this.state = 2012;
                        return true;
                    }
                }
                break;
            }
            case 2012: {
                switch (current) {
                    case 101: {
                        this.state = 2013;
                        return true;
                    }
                }
                break;
            }
            case 2013: {
                switch (current) {
                    case 116: {
                        this.state = 2014;
                        return true;
                    }
                }
                break;
            }
            case 2014: {
                switch (current) {
                    case 59: {
                        this.match = "\u2283\u20d2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2015;
                        return true;
                    }
                }
                break;
            }
            case 2015: {
                switch (current) {
                    case 113: {
                        this.state = 2016;
                        return true;
                    }
                }
                break;
            }
            case 2016: {
                switch (current) {
                    case 117: {
                        this.state = 2017;
                        return true;
                    }
                }
                break;
            }
            case 2017: {
                switch (current) {
                    case 97: {
                        this.state = 2018;
                        return true;
                    }
                }
                break;
            }
            case 2018: {
                switch (current) {
                    case 108: {
                        this.state = 2019;
                        return true;
                    }
                }
                break;
            }
            case 2019: {
                switch (current) {
                    case 59: {
                        this.match = "\u2289";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2020: {
                switch (current) {
                    case 105: {
                        this.state = 2021;
                        return true;
                    }
                }
                break;
            }
            case 2021: {
                switch (current) {
                    case 108: {
                        this.state = 2022;
                        return true;
                    }
                }
                break;
            }
            case 2022: {
                switch (current) {
                    case 100: {
                        this.state = 2023;
                        return true;
                    }
                }
                break;
            }
            case 2023: {
                switch (current) {
                    case 101: {
                        this.state = 2024;
                        return true;
                    }
                }
                break;
            }
            case 2024: {
                switch (current) {
                    case 59: {
                        this.match = "\u2241";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2025;
                        return true;
                    }
                    case 70: {
                        this.state = 2030;
                        return true;
                    }
                    case 84: {
                        this.state = 2039;
                        return true;
                    }
                }
                break;
            }
            case 2025: {
                switch (current) {
                    case 113: {
                        this.state = 2026;
                        return true;
                    }
                }
                break;
            }
            case 2026: {
                switch (current) {
                    case 117: {
                        this.state = 2027;
                        return true;
                    }
                }
                break;
            }
            case 2027: {
                switch (current) {
                    case 97: {
                        this.state = 2028;
                        return true;
                    }
                }
                break;
            }
            case 2028: {
                switch (current) {
                    case 108: {
                        this.state = 2029;
                        return true;
                    }
                }
                break;
            }
            case 2029: {
                switch (current) {
                    case 59: {
                        this.match = "\u2244";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2030: {
                switch (current) {
                    case 117: {
                        this.state = 2031;
                        return true;
                    }
                }
                break;
            }
            case 2031: {
                switch (current) {
                    case 108: {
                        this.state = 2032;
                        return true;
                    }
                }
                break;
            }
            case 2032: {
                switch (current) {
                    case 108: {
                        this.state = 2033;
                        return true;
                    }
                }
                break;
            }
            case 2033: {
                switch (current) {
                    case 69: {
                        this.state = 2034;
                        return true;
                    }
                }
                break;
            }
            case 2034: {
                switch (current) {
                    case 113: {
                        this.state = 2035;
                        return true;
                    }
                }
                break;
            }
            case 2035: {
                switch (current) {
                    case 117: {
                        this.state = 2036;
                        return true;
                    }
                }
                break;
            }
            case 2036: {
                switch (current) {
                    case 97: {
                        this.state = 2037;
                        return true;
                    }
                }
                break;
            }
            case 2037: {
                switch (current) {
                    case 108: {
                        this.state = 2038;
                        return true;
                    }
                }
                break;
            }
            case 2038: {
                switch (current) {
                    case 59: {
                        this.match = "\u2247";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2039: {
                switch (current) {
                    case 105: {
                        this.state = 2040;
                        return true;
                    }
                }
                break;
            }
            case 2040: {
                switch (current) {
                    case 108: {
                        this.state = 2041;
                        return true;
                    }
                }
                break;
            }
            case 2041: {
                switch (current) {
                    case 100: {
                        this.state = 2042;
                        return true;
                    }
                }
                break;
            }
            case 2042: {
                switch (current) {
                    case 101: {
                        this.state = 2043;
                        return true;
                    }
                }
                break;
            }
            case 2043: {
                switch (current) {
                    case 59: {
                        this.match = "\u2249";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2044: {
                switch (current) {
                    case 101: {
                        this.state = 2045;
                        return true;
                    }
                }
                break;
            }
            case 2045: {
                switch (current) {
                    case 114: {
                        this.state = 2046;
                        return true;
                    }
                }
                break;
            }
            case 2046: {
                switch (current) {
                    case 116: {
                        this.state = 2047;
                        return true;
                    }
                }
                break;
            }
            case 2047: {
                switch (current) {
                    case 105: {
                        this.state = 2048;
                        return true;
                    }
                }
                break;
            }
            case 2048: {
                switch (current) {
                    case 99: {
                        this.state = 2049;
                        return true;
                    }
                }
                break;
            }
            case 2049: {
                switch (current) {
                    case 97: {
                        this.state = 2050;
                        return true;
                    }
                }
                break;
            }
            case 2050: {
                switch (current) {
                    case 108: {
                        this.state = 2051;
                        return true;
                    }
                }
                break;
            }
            case 2051: {
                switch (current) {
                    case 66: {
                        this.state = 2052;
                        return true;
                    }
                }
                break;
            }
            case 2052: {
                switch (current) {
                    case 97: {
                        this.state = 2053;
                        return true;
                    }
                }
                break;
            }
            case 2053: {
                switch (current) {
                    case 114: {
                        this.state = 2054;
                        return true;
                    }
                }
                break;
            }
            case 2054: {
                switch (current) {
                    case 59: {
                        this.match = "\u2224";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2055: {
                switch (current) {
                    case 99: {
                        this.state = 2056;
                        return true;
                    }
                }
                break;
            }
            case 2056: {
                switch (current) {
                    case 114: {
                        this.state = 2057;
                        return true;
                    }
                }
                break;
            }
            case 2057: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udca9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2058: {
                switch (current) {
                    case 105: {
                        this.state = 2059;
                        return true;
                    }
                }
                break;
            }
            case 2059: {
                switch (current) {
                    case 108: {
                        this.state = 2060;
                        return true;
                    }
                }
                break;
            }
            case 2060: {
                switch (current) {
                    case 100: {
                        this.state = 2061;
                        return true;
                    }
                }
                break;
            }
            case 2061: {
                switch (current) {
                    case 101: {
                        this.match = "\u00d1";
                        this.matchLength = this.consumedCount;
                        this.state = 2062;
                        return true;
                    }
                }
                break;
            }
            case 2062: {
                switch (current) {
                    case 59: {
                        this.match = "\u00d1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2063: {
                switch (current) {
                    case 59: {
                        this.match = "\u039d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2064: {
                switch (current) {
                    case 69: {
                        this.state = 2065;
                        return true;
                    }
                    case 97: {
                        this.state = 2069;
                        return true;
                    }
                    case 99: {
                        this.state = 2074;
                        return true;
                    }
                    case 100: {
                        this.state = 2079;
                        return true;
                    }
                    case 102: {
                        this.state = 2084;
                        return true;
                    }
                    case 103: {
                        this.state = 2086;
                        return true;
                    }
                    case 109: {
                        this.state = 2091;
                        return true;
                    }
                    case 111: {
                        this.state = 2103;
                        return true;
                    }
                    case 112: {
                        this.state = 2106;
                        return true;
                    }
                    case 114: {
                        this.state = 2130;
                        return true;
                    }
                    case 115: {
                        this.state = 2131;
                        return true;
                    }
                    case 116: {
                        this.state = 2138;
                        return true;
                    }
                    case 117: {
                        this.state = 2146;
                        return true;
                    }
                    case 118: {
                        this.state = 2149;
                        return true;
                    }
                }
                break;
            }
            case 2065: {
                switch (current) {
                    case 108: {
                        this.state = 2066;
                        return true;
                    }
                }
                break;
            }
            case 2066: {
                switch (current) {
                    case 105: {
                        this.state = 2067;
                        return true;
                    }
                }
                break;
            }
            case 2067: {
                switch (current) {
                    case 103: {
                        this.state = 2068;
                        return true;
                    }
                }
                break;
            }
            case 2068: {
                switch (current) {
                    case 59: {
                        this.match = "\u0152";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2069: {
                switch (current) {
                    case 99: {
                        this.state = 2070;
                        return true;
                    }
                }
                break;
            }
            case 2070: {
                switch (current) {
                    case 117: {
                        this.state = 2071;
                        return true;
                    }
                }
                break;
            }
            case 2071: {
                switch (current) {
                    case 116: {
                        this.state = 2072;
                        return true;
                    }
                }
                break;
            }
            case 2072: {
                switch (current) {
                    case 101: {
                        this.match = "\u00d3";
                        this.matchLength = this.consumedCount;
                        this.state = 2073;
                        return true;
                    }
                }
                break;
            }
            case 2073: {
                switch (current) {
                    case 59: {
                        this.match = "\u00d3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2074: {
                switch (current) {
                    case 105: {
                        this.state = 2075;
                        return true;
                    }
                    case 121: {
                        this.state = 2078;
                        return true;
                    }
                }
                break;
            }
            case 2075: {
                switch (current) {
                    case 114: {
                        this.state = 2076;
                        return true;
                    }
                }
                break;
            }
            case 2076: {
                switch (current) {
                    case 99: {
                        this.match = "\u00d4";
                        this.matchLength = this.consumedCount;
                        this.state = 2077;
                        return true;
                    }
                }
                break;
            }
            case 2077: {
                switch (current) {
                    case 59: {
                        this.match = "\u00d4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2078: {
                switch (current) {
                    case 59: {
                        this.match = "\u041e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2079: {
                switch (current) {
                    case 98: {
                        this.state = 2080;
                        return true;
                    }
                }
                break;
            }
            case 2080: {
                switch (current) {
                    case 108: {
                        this.state = 2081;
                        return true;
                    }
                }
                break;
            }
            case 2081: {
                switch (current) {
                    case 97: {
                        this.state = 2082;
                        return true;
                    }
                }
                break;
            }
            case 2082: {
                switch (current) {
                    case 99: {
                        this.state = 2083;
                        return true;
                    }
                }
                break;
            }
            case 2083: {
                switch (current) {
                    case 59: {
                        this.match = "\u0150";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2084: {
                switch (current) {
                    case 114: {
                        this.state = 2085;
                        return true;
                    }
                }
                break;
            }
            case 2085: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd12";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2086: {
                switch (current) {
                    case 114: {
                        this.state = 2087;
                        return true;
                    }
                }
                break;
            }
            case 2087: {
                switch (current) {
                    case 97: {
                        this.state = 2088;
                        return true;
                    }
                }
                break;
            }
            case 2088: {
                switch (current) {
                    case 118: {
                        this.state = 2089;
                        return true;
                    }
                }
                break;
            }
            case 2089: {
                switch (current) {
                    case 101: {
                        this.match = "\u00d2";
                        this.matchLength = this.consumedCount;
                        this.state = 2090;
                        return true;
                    }
                }
                break;
            }
            case 2090: {
                switch (current) {
                    case 59: {
                        this.match = "\u00d2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2091: {
                switch (current) {
                    case 97: {
                        this.state = 2092;
                        return true;
                    }
                    case 101: {
                        this.state = 2095;
                        return true;
                    }
                    case 105: {
                        this.state = 2098;
                        return true;
                    }
                }
                break;
            }
            case 2092: {
                switch (current) {
                    case 99: {
                        this.state = 2093;
                        return true;
                    }
                }
                break;
            }
            case 2093: {
                switch (current) {
                    case 114: {
                        this.state = 2094;
                        return true;
                    }
                }
                break;
            }
            case 2094: {
                switch (current) {
                    case 59: {
                        this.match = "\u014c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2095: {
                switch (current) {
                    case 103: {
                        this.state = 2096;
                        return true;
                    }
                }
                break;
            }
            case 2096: {
                switch (current) {
                    case 97: {
                        this.state = 2097;
                        return true;
                    }
                }
                break;
            }
            case 2097: {
                switch (current) {
                    case 59: {
                        this.match = "\u03a9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2098: {
                switch (current) {
                    case 99: {
                        this.state = 2099;
                        return true;
                    }
                }
                break;
            }
            case 2099: {
                switch (current) {
                    case 114: {
                        this.state = 2100;
                        return true;
                    }
                }
                break;
            }
            case 2100: {
                switch (current) {
                    case 111: {
                        this.state = 2101;
                        return true;
                    }
                }
                break;
            }
            case 2101: {
                switch (current) {
                    case 110: {
                        this.state = 2102;
                        return true;
                    }
                }
                break;
            }
            case 2102: {
                switch (current) {
                    case 59: {
                        this.match = "\u039f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2103: {
                switch (current) {
                    case 112: {
                        this.state = 2104;
                        return true;
                    }
                }
                break;
            }
            case 2104: {
                switch (current) {
                    case 102: {
                        this.state = 2105;
                        return true;
                    }
                }
                break;
            }
            case 2105: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd46";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2106: {
                switch (current) {
                    case 101: {
                        this.state = 2107;
                        return true;
                    }
                }
                break;
            }
            case 2107: {
                switch (current) {
                    case 110: {
                        this.state = 2108;
                        return true;
                    }
                }
                break;
            }
            case 2108: {
                switch (current) {
                    case 67: {
                        this.state = 2109;
                        return true;
                    }
                }
                break;
            }
            case 2109: {
                switch (current) {
                    case 117: {
                        this.state = 2110;
                        return true;
                    }
                }
                break;
            }
            case 2110: {
                switch (current) {
                    case 114: {
                        this.state = 2111;
                        return true;
                    }
                }
                break;
            }
            case 2111: {
                switch (current) {
                    case 108: {
                        this.state = 2112;
                        return true;
                    }
                }
                break;
            }
            case 2112: {
                switch (current) {
                    case 121: {
                        this.state = 2113;
                        return true;
                    }
                }
                break;
            }
            case 2113: {
                switch (current) {
                    case 68: {
                        this.state = 2114;
                        return true;
                    }
                    case 81: {
                        this.state = 2125;
                        return true;
                    }
                }
                break;
            }
            case 2114: {
                switch (current) {
                    case 111: {
                        this.state = 2115;
                        return true;
                    }
                }
                break;
            }
            case 2115: {
                switch (current) {
                    case 117: {
                        this.state = 2116;
                        return true;
                    }
                }
                break;
            }
            case 2116: {
                switch (current) {
                    case 98: {
                        this.state = 2117;
                        return true;
                    }
                }
                break;
            }
            case 2117: {
                switch (current) {
                    case 108: {
                        this.state = 2118;
                        return true;
                    }
                }
                break;
            }
            case 2118: {
                switch (current) {
                    case 101: {
                        this.state = 2119;
                        return true;
                    }
                }
                break;
            }
            case 2119: {
                switch (current) {
                    case 81: {
                        this.state = 2120;
                        return true;
                    }
                }
                break;
            }
            case 2120: {
                switch (current) {
                    case 117: {
                        this.state = 2121;
                        return true;
                    }
                }
                break;
            }
            case 2121: {
                switch (current) {
                    case 111: {
                        this.state = 2122;
                        return true;
                    }
                }
                break;
            }
            case 2122: {
                switch (current) {
                    case 116: {
                        this.state = 2123;
                        return true;
                    }
                }
                break;
            }
            case 2123: {
                switch (current) {
                    case 101: {
                        this.state = 2124;
                        return true;
                    }
                }
                break;
            }
            case 2124: {
                switch (current) {
                    case 59: {
                        this.match = "\u201c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2125: {
                switch (current) {
                    case 117: {
                        this.state = 2126;
                        return true;
                    }
                }
                break;
            }
            case 2126: {
                switch (current) {
                    case 111: {
                        this.state = 2127;
                        return true;
                    }
                }
                break;
            }
            case 2127: {
                switch (current) {
                    case 116: {
                        this.state = 2128;
                        return true;
                    }
                }
                break;
            }
            case 2128: {
                switch (current) {
                    case 101: {
                        this.state = 2129;
                        return true;
                    }
                }
                break;
            }
            case 2129: {
                switch (current) {
                    case 59: {
                        this.match = "\u2018";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2130: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a54";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2131: {
                switch (current) {
                    case 99: {
                        this.state = 2132;
                        return true;
                    }
                    case 108: {
                        this.state = 2134;
                        return true;
                    }
                }
                break;
            }
            case 2132: {
                switch (current) {
                    case 114: {
                        this.state = 2133;
                        return true;
                    }
                }
                break;
            }
            case 2133: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcaa";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2134: {
                switch (current) {
                    case 97: {
                        this.state = 2135;
                        return true;
                    }
                }
                break;
            }
            case 2135: {
                switch (current) {
                    case 115: {
                        this.state = 2136;
                        return true;
                    }
                }
                break;
            }
            case 2136: {
                switch (current) {
                    case 104: {
                        this.match = "\u00d8";
                        this.matchLength = this.consumedCount;
                        this.state = 2137;
                        return true;
                    }
                }
                break;
            }
            case 2137: {
                switch (current) {
                    case 59: {
                        this.match = "\u00d8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2138: {
                switch (current) {
                    case 105: {
                        this.state = 2139;
                        return true;
                    }
                }
                break;
            }
            case 2139: {
                switch (current) {
                    case 108: {
                        this.state = 2140;
                        return true;
                    }
                    case 109: {
                        this.state = 2143;
                        return true;
                    }
                }
                break;
            }
            case 2140: {
                switch (current) {
                    case 100: {
                        this.state = 2141;
                        return true;
                    }
                }
                break;
            }
            case 2141: {
                switch (current) {
                    case 101: {
                        this.match = "\u00d5";
                        this.matchLength = this.consumedCount;
                        this.state = 2142;
                        return true;
                    }
                }
                break;
            }
            case 2142: {
                switch (current) {
                    case 59: {
                        this.match = "\u00d5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2143: {
                switch (current) {
                    case 101: {
                        this.state = 2144;
                        return true;
                    }
                }
                break;
            }
            case 2144: {
                switch (current) {
                    case 115: {
                        this.state = 2145;
                        return true;
                    }
                }
                break;
            }
            case 2145: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a37";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2146: {
                switch (current) {
                    case 109: {
                        this.state = 2147;
                        return true;
                    }
                }
                break;
            }
            case 2147: {
                switch (current) {
                    case 108: {
                        this.match = "\u00d6";
                        this.matchLength = this.consumedCount;
                        this.state = 2148;
                        return true;
                    }
                }
                break;
            }
            case 2148: {
                switch (current) {
                    case 59: {
                        this.match = "\u00d6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2149: {
                switch (current) {
                    case 101: {
                        this.state = 2150;
                        return true;
                    }
                }
                break;
            }
            case 2150: {
                switch (current) {
                    case 114: {
                        this.state = 2151;
                        return true;
                    }
                }
                break;
            }
            case 2151: {
                switch (current) {
                    case 66: {
                        this.state = 2152;
                        return true;
                    }
                    case 80: {
                        this.state = 2162;
                        return true;
                    }
                }
                break;
            }
            case 2152: {
                switch (current) {
                    case 97: {
                        this.state = 2153;
                        return true;
                    }
                    case 114: {
                        this.state = 2155;
                        return true;
                    }
                }
                break;
            }
            case 2153: {
                switch (current) {
                    case 114: {
                        this.state = 2154;
                        return true;
                    }
                }
                break;
            }
            case 2154: {
                switch (current) {
                    case 59: {
                        this.match = "\u203e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2155: {
                switch (current) {
                    case 97: {
                        this.state = 2156;
                        return true;
                    }
                }
                break;
            }
            case 2156: {
                switch (current) {
                    case 99: {
                        this.state = 2157;
                        return true;
                    }
                }
                break;
            }
            case 2157: {
                switch (current) {
                    case 101: {
                        this.state = 2158;
                        return true;
                    }
                    case 107: {
                        this.state = 2159;
                        return true;
                    }
                }
                break;
            }
            case 2158: {
                switch (current) {
                    case 59: {
                        this.match = "\u23de";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2159: {
                switch (current) {
                    case 101: {
                        this.state = 2160;
                        return true;
                    }
                }
                break;
            }
            case 2160: {
                switch (current) {
                    case 116: {
                        this.state = 2161;
                        return true;
                    }
                }
                break;
            }
            case 2161: {
                switch (current) {
                    case 59: {
                        this.match = "\u23b4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2162: {
                switch (current) {
                    case 97: {
                        this.state = 2163;
                        return true;
                    }
                }
                break;
            }
            case 2163: {
                switch (current) {
                    case 114: {
                        this.state = 2164;
                        return true;
                    }
                }
                break;
            }
            case 2164: {
                switch (current) {
                    case 101: {
                        this.state = 2165;
                        return true;
                    }
                }
                break;
            }
            case 2165: {
                switch (current) {
                    case 110: {
                        this.state = 2166;
                        return true;
                    }
                }
                break;
            }
            case 2166: {
                switch (current) {
                    case 116: {
                        this.state = 2167;
                        return true;
                    }
                }
                break;
            }
            case 2167: {
                switch (current) {
                    case 104: {
                        this.state = 2168;
                        return true;
                    }
                }
                break;
            }
            case 2168: {
                switch (current) {
                    case 101: {
                        this.state = 2169;
                        return true;
                    }
                }
                break;
            }
            case 2169: {
                switch (current) {
                    case 115: {
                        this.state = 2170;
                        return true;
                    }
                }
                break;
            }
            case 2170: {
                switch (current) {
                    case 105: {
                        this.state = 2171;
                        return true;
                    }
                }
                break;
            }
            case 2171: {
                switch (current) {
                    case 115: {
                        this.state = 2172;
                        return true;
                    }
                }
                break;
            }
            case 2172: {
                switch (current) {
                    case 59: {
                        this.match = "\u23dc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2173: {
                switch (current) {
                    case 97: {
                        this.state = 2174;
                        return true;
                    }
                    case 99: {
                        this.state = 2181;
                        return true;
                    }
                    case 102: {
                        this.state = 2183;
                        return true;
                    }
                    case 104: {
                        this.state = 2185;
                        return true;
                    }
                    case 105: {
                        this.state = 2187;
                        return true;
                    }
                    case 108: {
                        this.state = 2188;
                        return true;
                    }
                    case 111: {
                        this.state = 2196;
                        return true;
                    }
                    case 114: {
                        this.state = 2210;
                        return true;
                    }
                    case 115: {
                        this.state = 2254;
                        return true;
                    }
                }
                break;
            }
            case 2174: {
                switch (current) {
                    case 114: {
                        this.state = 2175;
                        return true;
                    }
                }
                break;
            }
            case 2175: {
                switch (current) {
                    case 116: {
                        this.state = 2176;
                        return true;
                    }
                }
                break;
            }
            case 2176: {
                switch (current) {
                    case 105: {
                        this.state = 2177;
                        return true;
                    }
                }
                break;
            }
            case 2177: {
                switch (current) {
                    case 97: {
                        this.state = 2178;
                        return true;
                    }
                }
                break;
            }
            case 2178: {
                switch (current) {
                    case 108: {
                        this.state = 2179;
                        return true;
                    }
                }
                break;
            }
            case 2179: {
                switch (current) {
                    case 68: {
                        this.state = 2180;
                        return true;
                    }
                }
                break;
            }
            case 2180: {
                switch (current) {
                    case 59: {
                        this.match = "\u2202";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2181: {
                switch (current) {
                    case 121: {
                        this.state = 2182;
                        return true;
                    }
                }
                break;
            }
            case 2182: {
                switch (current) {
                    case 59: {
                        this.match = "\u041f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2183: {
                switch (current) {
                    case 114: {
                        this.state = 2184;
                        return true;
                    }
                }
                break;
            }
            case 2184: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd13";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2185: {
                switch (current) {
                    case 105: {
                        this.state = 2186;
                        return true;
                    }
                }
                break;
            }
            case 2186: {
                switch (current) {
                    case 59: {
                        this.match = "\u03a6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2187: {
                switch (current) {
                    case 59: {
                        this.match = "\u03a0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2188: {
                switch (current) {
                    case 117: {
                        this.state = 2189;
                        return true;
                    }
                }
                break;
            }
            case 2189: {
                switch (current) {
                    case 115: {
                        this.state = 2190;
                        return true;
                    }
                }
                break;
            }
            case 2190: {
                switch (current) {
                    case 77: {
                        this.state = 2191;
                        return true;
                    }
                }
                break;
            }
            case 2191: {
                switch (current) {
                    case 105: {
                        this.state = 2192;
                        return true;
                    }
                }
                break;
            }
            case 2192: {
                switch (current) {
                    case 110: {
                        this.state = 2193;
                        return true;
                    }
                }
                break;
            }
            case 2193: {
                switch (current) {
                    case 117: {
                        this.state = 2194;
                        return true;
                    }
                }
                break;
            }
            case 2194: {
                switch (current) {
                    case 115: {
                        this.state = 2195;
                        return true;
                    }
                }
                break;
            }
            case 2195: {
                switch (current) {
                    case 59: {
                        this.match = "\u00b1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2196: {
                switch (current) {
                    case 105: {
                        this.state = 2197;
                        return true;
                    }
                    case 112: {
                        this.state = 2208;
                        return true;
                    }
                }
                break;
            }
            case 2197: {
                switch (current) {
                    case 110: {
                        this.state = 2198;
                        return true;
                    }
                }
                break;
            }
            case 2198: {
                switch (current) {
                    case 99: {
                        this.state = 2199;
                        return true;
                    }
                }
                break;
            }
            case 2199: {
                switch (current) {
                    case 97: {
                        this.state = 2200;
                        return true;
                    }
                }
                break;
            }
            case 2200: {
                switch (current) {
                    case 114: {
                        this.state = 2201;
                        return true;
                    }
                }
                break;
            }
            case 2201: {
                switch (current) {
                    case 101: {
                        this.state = 2202;
                        return true;
                    }
                }
                break;
            }
            case 2202: {
                switch (current) {
                    case 112: {
                        this.state = 2203;
                        return true;
                    }
                }
                break;
            }
            case 2203: {
                switch (current) {
                    case 108: {
                        this.state = 2204;
                        return true;
                    }
                }
                break;
            }
            case 2204: {
                switch (current) {
                    case 97: {
                        this.state = 2205;
                        return true;
                    }
                }
                break;
            }
            case 2205: {
                switch (current) {
                    case 110: {
                        this.state = 2206;
                        return true;
                    }
                }
                break;
            }
            case 2206: {
                switch (current) {
                    case 101: {
                        this.state = 2207;
                        return true;
                    }
                }
                break;
            }
            case 2207: {
                switch (current) {
                    case 59: {
                        this.match = "\u210c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2208: {
                switch (current) {
                    case 102: {
                        this.state = 2209;
                        return true;
                    }
                }
                break;
            }
            case 2209: {
                switch (current) {
                    case 59: {
                        this.match = "\u2119";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2210: {
                switch (current) {
                    case 59: {
                        this.match = "\u2abb";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 2211;
                        return true;
                    }
                    case 105: {
                        this.state = 2237;
                        return true;
                    }
                    case 111: {
                        this.state = 2240;
                        return true;
                    }
                }
                break;
            }
            case 2211: {
                switch (current) {
                    case 99: {
                        this.state = 2212;
                        return true;
                    }
                }
                break;
            }
            case 2212: {
                switch (current) {
                    case 101: {
                        this.state = 2213;
                        return true;
                    }
                }
                break;
            }
            case 2213: {
                switch (current) {
                    case 100: {
                        this.state = 2214;
                        return true;
                    }
                }
                break;
            }
            case 2214: {
                switch (current) {
                    case 101: {
                        this.state = 2215;
                        return true;
                    }
                }
                break;
            }
            case 2215: {
                switch (current) {
                    case 115: {
                        this.state = 2216;
                        return true;
                    }
                }
                break;
            }
            case 2216: {
                switch (current) {
                    case 59: {
                        this.match = "\u227a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2217;
                        return true;
                    }
                    case 83: {
                        this.state = 2222;
                        return true;
                    }
                    case 84: {
                        this.state = 2232;
                        return true;
                    }
                }
                break;
            }
            case 2217: {
                switch (current) {
                    case 113: {
                        this.state = 2218;
                        return true;
                    }
                }
                break;
            }
            case 2218: {
                switch (current) {
                    case 117: {
                        this.state = 2219;
                        return true;
                    }
                }
                break;
            }
            case 2219: {
                switch (current) {
                    case 97: {
                        this.state = 2220;
                        return true;
                    }
                }
                break;
            }
            case 2220: {
                switch (current) {
                    case 108: {
                        this.state = 2221;
                        return true;
                    }
                }
                break;
            }
            case 2221: {
                switch (current) {
                    case 59: {
                        this.match = "\u2aaf";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2222: {
                switch (current) {
                    case 108: {
                        this.state = 2223;
                        return true;
                    }
                }
                break;
            }
            case 2223: {
                switch (current) {
                    case 97: {
                        this.state = 2224;
                        return true;
                    }
                }
                break;
            }
            case 2224: {
                switch (current) {
                    case 110: {
                        this.state = 2225;
                        return true;
                    }
                }
                break;
            }
            case 2225: {
                switch (current) {
                    case 116: {
                        this.state = 2226;
                        return true;
                    }
                }
                break;
            }
            case 2226: {
                switch (current) {
                    case 69: {
                        this.state = 2227;
                        return true;
                    }
                }
                break;
            }
            case 2227: {
                switch (current) {
                    case 113: {
                        this.state = 2228;
                        return true;
                    }
                }
                break;
            }
            case 2228: {
                switch (current) {
                    case 117: {
                        this.state = 2229;
                        return true;
                    }
                }
                break;
            }
            case 2229: {
                switch (current) {
                    case 97: {
                        this.state = 2230;
                        return true;
                    }
                }
                break;
            }
            case 2230: {
                switch (current) {
                    case 108: {
                        this.state = 2231;
                        return true;
                    }
                }
                break;
            }
            case 2231: {
                switch (current) {
                    case 59: {
                        this.match = "\u227c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2232: {
                switch (current) {
                    case 105: {
                        this.state = 2233;
                        return true;
                    }
                }
                break;
            }
            case 2233: {
                switch (current) {
                    case 108: {
                        this.state = 2234;
                        return true;
                    }
                }
                break;
            }
            case 2234: {
                switch (current) {
                    case 100: {
                        this.state = 2235;
                        return true;
                    }
                }
                break;
            }
            case 2235: {
                switch (current) {
                    case 101: {
                        this.state = 2236;
                        return true;
                    }
                }
                break;
            }
            case 2236: {
                switch (current) {
                    case 59: {
                        this.match = "\u227e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2237: {
                switch (current) {
                    case 109: {
                        this.state = 2238;
                        return true;
                    }
                }
                break;
            }
            case 2238: {
                switch (current) {
                    case 101: {
                        this.state = 2239;
                        return true;
                    }
                }
                break;
            }
            case 2239: {
                switch (current) {
                    case 59: {
                        this.match = "\u2033";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2240: {
                switch (current) {
                    case 100: {
                        this.state = 2241;
                        return true;
                    }
                    case 112: {
                        this.state = 2245;
                        return true;
                    }
                }
                break;
            }
            case 2241: {
                switch (current) {
                    case 117: {
                        this.state = 2242;
                        return true;
                    }
                }
                break;
            }
            case 2242: {
                switch (current) {
                    case 99: {
                        this.state = 2243;
                        return true;
                    }
                }
                break;
            }
            case 2243: {
                switch (current) {
                    case 116: {
                        this.state = 2244;
                        return true;
                    }
                }
                break;
            }
            case 2244: {
                switch (current) {
                    case 59: {
                        this.match = "\u220f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2245: {
                switch (current) {
                    case 111: {
                        this.state = 2246;
                        return true;
                    }
                }
                break;
            }
            case 2246: {
                switch (current) {
                    case 114: {
                        this.state = 2247;
                        return true;
                    }
                }
                break;
            }
            case 2247: {
                switch (current) {
                    case 116: {
                        this.state = 2248;
                        return true;
                    }
                }
                break;
            }
            case 2248: {
                switch (current) {
                    case 105: {
                        this.state = 2249;
                        return true;
                    }
                }
                break;
            }
            case 2249: {
                switch (current) {
                    case 111: {
                        this.state = 2250;
                        return true;
                    }
                }
                break;
            }
            case 2250: {
                switch (current) {
                    case 110: {
                        this.state = 2251;
                        return true;
                    }
                }
                break;
            }
            case 2251: {
                switch (current) {
                    case 59: {
                        this.match = "\u2237";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 97: {
                        this.state = 2252;
                        return true;
                    }
                }
                break;
            }
            case 2252: {
                switch (current) {
                    case 108: {
                        this.state = 2253;
                        return true;
                    }
                }
                break;
            }
            case 2253: {
                switch (current) {
                    case 59: {
                        this.match = "\u221d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2254: {
                switch (current) {
                    case 99: {
                        this.state = 2255;
                        return true;
                    }
                    case 105: {
                        this.state = 2257;
                        return true;
                    }
                }
                break;
            }
            case 2255: {
                switch (current) {
                    case 114: {
                        this.state = 2256;
                        return true;
                    }
                }
                break;
            }
            case 2256: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcab";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2257: {
                switch (current) {
                    case 59: {
                        this.match = "\u03a8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2258: {
                switch (current) {
                    case 85: {
                        this.state = 2259;
                        return true;
                    }
                    case 102: {
                        this.state = 2262;
                        return true;
                    }
                    case 111: {
                        this.state = 2264;
                        return true;
                    }
                    case 115: {
                        this.state = 2267;
                        return true;
                    }
                }
                break;
            }
            case 2259: {
                switch (current) {
                    case 79: {
                        this.state = 2260;
                        return true;
                    }
                }
                break;
            }
            case 2260: {
                switch (current) {
                    case 84: {
                        this.match = "\"";
                        this.matchLength = this.consumedCount;
                        this.state = 2261;
                        return true;
                    }
                }
                break;
            }
            case 2261: {
                switch (current) {
                    case 59: {
                        this.match = "\"";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2262: {
                switch (current) {
                    case 114: {
                        this.state = 2263;
                        return true;
                    }
                }
                break;
            }
            case 2263: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd14";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2264: {
                switch (current) {
                    case 112: {
                        this.state = 2265;
                        return true;
                    }
                }
                break;
            }
            case 2265: {
                switch (current) {
                    case 102: {
                        this.state = 2266;
                        return true;
                    }
                }
                break;
            }
            case 2266: {
                switch (current) {
                    case 59: {
                        this.match = "\u211a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2267: {
                switch (current) {
                    case 99: {
                        this.state = 2268;
                        return true;
                    }
                }
                break;
            }
            case 2268: {
                switch (current) {
                    case 114: {
                        this.state = 2269;
                        return true;
                    }
                }
                break;
            }
            case 2269: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcac";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2270: {
                switch (current) {
                    case 66: {
                        this.state = 2271;
                        return true;
                    }
                    case 69: {
                        this.state = 2275;
                        return true;
                    }
                    case 97: {
                        this.state = 2277;
                        return true;
                    }
                    case 99: {
                        this.state = 2288;
                        return true;
                    }
                    case 101: {
                        this.state = 2298;
                        return true;
                    }
                    case 102: {
                        this.state = 2334;
                        return true;
                    }
                    case 104: {
                        this.state = 2336;
                        return true;
                    }
                    case 105: {
                        this.state = 2338;
                        return true;
                    }
                    case 111: {
                        this.state = 2488;
                        return true;
                    }
                    case 114: {
                        this.state = 2501;
                        return true;
                    }
                    case 115: {
                        this.state = 2511;
                        return true;
                    }
                    case 117: {
                        this.state = 2515;
                        return true;
                    }
                }
                break;
            }
            case 2271: {
                switch (current) {
                    case 97: {
                        this.state = 2272;
                        return true;
                    }
                }
                break;
            }
            case 2272: {
                switch (current) {
                    case 114: {
                        this.state = 2273;
                        return true;
                    }
                }
                break;
            }
            case 2273: {
                switch (current) {
                    case 114: {
                        this.state = 2274;
                        return true;
                    }
                }
                break;
            }
            case 2274: {
                switch (current) {
                    case 59: {
                        this.match = "\u2910";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2275: {
                switch (current) {
                    case 71: {
                        this.match = "\u00ae";
                        this.matchLength = this.consumedCount;
                        this.state = 2276;
                        return true;
                    }
                }
                break;
            }
            case 2276: {
                switch (current) {
                    case 59: {
                        this.match = "\u00ae";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2277: {
                switch (current) {
                    case 99: {
                        this.state = 2278;
                        return true;
                    }
                    case 110: {
                        this.state = 2282;
                        return true;
                    }
                    case 114: {
                        this.state = 2284;
                        return true;
                    }
                }
                break;
            }
            case 2278: {
                switch (current) {
                    case 117: {
                        this.state = 2279;
                        return true;
                    }
                }
                break;
            }
            case 2279: {
                switch (current) {
                    case 116: {
                        this.state = 2280;
                        return true;
                    }
                }
                break;
            }
            case 2280: {
                switch (current) {
                    case 101: {
                        this.state = 2281;
                        return true;
                    }
                }
                break;
            }
            case 2281: {
                switch (current) {
                    case 59: {
                        this.match = "\u0154";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2282: {
                switch (current) {
                    case 103: {
                        this.state = 2283;
                        return true;
                    }
                }
                break;
            }
            case 2283: {
                switch (current) {
                    case 59: {
                        this.match = "\u27eb";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2284: {
                switch (current) {
                    case 114: {
                        this.state = 2285;
                        return true;
                    }
                }
                break;
            }
            case 2285: {
                switch (current) {
                    case 59: {
                        this.match = "\u21a0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 116: {
                        this.state = 2286;
                        return true;
                    }
                }
                break;
            }
            case 2286: {
                switch (current) {
                    case 108: {
                        this.state = 2287;
                        return true;
                    }
                }
                break;
            }
            case 2287: {
                switch (current) {
                    case 59: {
                        this.match = "\u2916";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2288: {
                switch (current) {
                    case 97: {
                        this.state = 2289;
                        return true;
                    }
                    case 101: {
                        this.state = 2293;
                        return true;
                    }
                    case 121: {
                        this.state = 2297;
                        return true;
                    }
                }
                break;
            }
            case 2289: {
                switch (current) {
                    case 114: {
                        this.state = 2290;
                        return true;
                    }
                }
                break;
            }
            case 2290: {
                switch (current) {
                    case 111: {
                        this.state = 2291;
                        return true;
                    }
                }
                break;
            }
            case 2291: {
                switch (current) {
                    case 110: {
                        this.state = 2292;
                        return true;
                    }
                }
                break;
            }
            case 2292: {
                switch (current) {
                    case 59: {
                        this.match = "\u0158";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2293: {
                switch (current) {
                    case 100: {
                        this.state = 2294;
                        return true;
                    }
                }
                break;
            }
            case 2294: {
                switch (current) {
                    case 105: {
                        this.state = 2295;
                        return true;
                    }
                }
                break;
            }
            case 2295: {
                switch (current) {
                    case 108: {
                        this.state = 2296;
                        return true;
                    }
                }
                break;
            }
            case 2296: {
                switch (current) {
                    case 59: {
                        this.match = "\u0156";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2297: {
                switch (current) {
                    case 59: {
                        this.match = "\u0420";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2298: {
                switch (current) {
                    case 59: {
                        this.match = "\u211c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 118: {
                        this.state = 2299;
                        return true;
                    }
                }
                break;
            }
            case 2299: {
                switch (current) {
                    case 101: {
                        this.state = 2300;
                        return true;
                    }
                }
                break;
            }
            case 2300: {
                switch (current) {
                    case 114: {
                        this.state = 2301;
                        return true;
                    }
                }
                break;
            }
            case 2301: {
                switch (current) {
                    case 115: {
                        this.state = 2302;
                        return true;
                    }
                }
                break;
            }
            case 2302: {
                switch (current) {
                    case 101: {
                        this.state = 2303;
                        return true;
                    }
                }
                break;
            }
            case 2303: {
                switch (current) {
                    case 69: {
                        this.state = 2304;
                        return true;
                    }
                    case 85: {
                        this.state = 2321;
                        return true;
                    }
                }
                break;
            }
            case 2304: {
                switch (current) {
                    case 108: {
                        this.state = 2305;
                        return true;
                    }
                    case 113: {
                        this.state = 2311;
                        return true;
                    }
                }
                break;
            }
            case 2305: {
                switch (current) {
                    case 101: {
                        this.state = 2306;
                        return true;
                    }
                }
                break;
            }
            case 2306: {
                switch (current) {
                    case 109: {
                        this.state = 2307;
                        return true;
                    }
                }
                break;
            }
            case 2307: {
                switch (current) {
                    case 101: {
                        this.state = 2308;
                        return true;
                    }
                }
                break;
            }
            case 2308: {
                switch (current) {
                    case 110: {
                        this.state = 2309;
                        return true;
                    }
                }
                break;
            }
            case 2309: {
                switch (current) {
                    case 116: {
                        this.state = 2310;
                        return true;
                    }
                }
                break;
            }
            case 2310: {
                switch (current) {
                    case 59: {
                        this.match = "\u220b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2311: {
                switch (current) {
                    case 117: {
                        this.state = 2312;
                        return true;
                    }
                }
                break;
            }
            case 2312: {
                switch (current) {
                    case 105: {
                        this.state = 2313;
                        return true;
                    }
                }
                break;
            }
            case 2313: {
                switch (current) {
                    case 108: {
                        this.state = 2314;
                        return true;
                    }
                }
                break;
            }
            case 2314: {
                switch (current) {
                    case 105: {
                        this.state = 2315;
                        return true;
                    }
                }
                break;
            }
            case 2315: {
                switch (current) {
                    case 98: {
                        this.state = 2316;
                        return true;
                    }
                }
                break;
            }
            case 2316: {
                switch (current) {
                    case 114: {
                        this.state = 2317;
                        return true;
                    }
                }
                break;
            }
            case 2317: {
                switch (current) {
                    case 105: {
                        this.state = 2318;
                        return true;
                    }
                }
                break;
            }
            case 2318: {
                switch (current) {
                    case 117: {
                        this.state = 2319;
                        return true;
                    }
                }
                break;
            }
            case 2319: {
                switch (current) {
                    case 109: {
                        this.state = 2320;
                        return true;
                    }
                }
                break;
            }
            case 2320: {
                switch (current) {
                    case 59: {
                        this.match = "\u21cb";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2321: {
                switch (current) {
                    case 112: {
                        this.state = 2322;
                        return true;
                    }
                }
                break;
            }
            case 2322: {
                switch (current) {
                    case 69: {
                        this.state = 2323;
                        return true;
                    }
                }
                break;
            }
            case 2323: {
                switch (current) {
                    case 113: {
                        this.state = 2324;
                        return true;
                    }
                }
                break;
            }
            case 2324: {
                switch (current) {
                    case 117: {
                        this.state = 2325;
                        return true;
                    }
                }
                break;
            }
            case 2325: {
                switch (current) {
                    case 105: {
                        this.state = 2326;
                        return true;
                    }
                }
                break;
            }
            case 2326: {
                switch (current) {
                    case 108: {
                        this.state = 2327;
                        return true;
                    }
                }
                break;
            }
            case 2327: {
                switch (current) {
                    case 105: {
                        this.state = 2328;
                        return true;
                    }
                }
                break;
            }
            case 2328: {
                switch (current) {
                    case 98: {
                        this.state = 2329;
                        return true;
                    }
                }
                break;
            }
            case 2329: {
                switch (current) {
                    case 114: {
                        this.state = 2330;
                        return true;
                    }
                }
                break;
            }
            case 2330: {
                switch (current) {
                    case 105: {
                        this.state = 2331;
                        return true;
                    }
                }
                break;
            }
            case 2331: {
                switch (current) {
                    case 117: {
                        this.state = 2332;
                        return true;
                    }
                }
                break;
            }
            case 2332: {
                switch (current) {
                    case 109: {
                        this.state = 2333;
                        return true;
                    }
                }
                break;
            }
            case 2333: {
                switch (current) {
                    case 59: {
                        this.match = "\u296f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2334: {
                switch (current) {
                    case 114: {
                        this.state = 2335;
                        return true;
                    }
                }
                break;
            }
            case 2335: {
                switch (current) {
                    case 59: {
                        this.match = "\u211c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2336: {
                switch (current) {
                    case 111: {
                        this.state = 2337;
                        return true;
                    }
                }
                break;
            }
            case 2337: {
                switch (current) {
                    case 59: {
                        this.match = "\u03a1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2338: {
                switch (current) {
                    case 103: {
                        this.state = 2339;
                        return true;
                    }
                }
                break;
            }
            case 2339: {
                switch (current) {
                    case 104: {
                        this.state = 2340;
                        return true;
                    }
                }
                break;
            }
            case 2340: {
                switch (current) {
                    case 116: {
                        this.state = 2341;
                        return true;
                    }
                }
                break;
            }
            case 2341: {
                switch (current) {
                    case 65: {
                        this.state = 2342;
                        return true;
                    }
                    case 67: {
                        this.state = 2370;
                        return true;
                    }
                    case 68: {
                        this.state = 2377;
                        return true;
                    }
                    case 70: {
                        this.state = 2410;
                        return true;
                    }
                    case 84: {
                        this.state = 2415;
                        return true;
                    }
                    case 85: {
                        this.state = 2444;
                        return true;
                    }
                    case 86: {
                        this.state = 2474;
                        return true;
                    }
                    case 97: {
                        this.state = 2483;
                        return true;
                    }
                }
                break;
            }
            case 2342: {
                switch (current) {
                    case 110: {
                        this.state = 2343;
                        return true;
                    }
                    case 114: {
                        this.state = 2354;
                        return true;
                    }
                }
                break;
            }
            case 2343: {
                switch (current) {
                    case 103: {
                        this.state = 2344;
                        return true;
                    }
                }
                break;
            }
            case 2344: {
                switch (current) {
                    case 108: {
                        this.state = 2345;
                        return true;
                    }
                }
                break;
            }
            case 2345: {
                switch (current) {
                    case 101: {
                        this.state = 2346;
                        return true;
                    }
                }
                break;
            }
            case 2346: {
                switch (current) {
                    case 66: {
                        this.state = 2347;
                        return true;
                    }
                }
                break;
            }
            case 2347: {
                switch (current) {
                    case 114: {
                        this.state = 2348;
                        return true;
                    }
                }
                break;
            }
            case 2348: {
                switch (current) {
                    case 97: {
                        this.state = 2349;
                        return true;
                    }
                }
                break;
            }
            case 2349: {
                switch (current) {
                    case 99: {
                        this.state = 2350;
                        return true;
                    }
                }
                break;
            }
            case 2350: {
                switch (current) {
                    case 107: {
                        this.state = 2351;
                        return true;
                    }
                }
                break;
            }
            case 2351: {
                switch (current) {
                    case 101: {
                        this.state = 2352;
                        return true;
                    }
                }
                break;
            }
            case 2352: {
                switch (current) {
                    case 116: {
                        this.state = 2353;
                        return true;
                    }
                }
                break;
            }
            case 2353: {
                switch (current) {
                    case 59: {
                        this.match = "\u27e9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2354: {
                switch (current) {
                    case 114: {
                        this.state = 2355;
                        return true;
                    }
                }
                break;
            }
            case 2355: {
                switch (current) {
                    case 111: {
                        this.state = 2356;
                        return true;
                    }
                }
                break;
            }
            case 2356: {
                switch (current) {
                    case 119: {
                        this.state = 2357;
                        return true;
                    }
                }
                break;
            }
            case 2357: {
                switch (current) {
                    case 59: {
                        this.match = "\u2192";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 2358;
                        return true;
                    }
                    case 76: {
                        this.state = 2361;
                        return true;
                    }
                }
                break;
            }
            case 2358: {
                switch (current) {
                    case 97: {
                        this.state = 2359;
                        return true;
                    }
                }
                break;
            }
            case 2359: {
                switch (current) {
                    case 114: {
                        this.state = 2360;
                        return true;
                    }
                }
                break;
            }
            case 2360: {
                switch (current) {
                    case 59: {
                        this.match = "\u21e5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2361: {
                switch (current) {
                    case 101: {
                        this.state = 2362;
                        return true;
                    }
                }
                break;
            }
            case 2362: {
                switch (current) {
                    case 102: {
                        this.state = 2363;
                        return true;
                    }
                }
                break;
            }
            case 2363: {
                switch (current) {
                    case 116: {
                        this.state = 2364;
                        return true;
                    }
                }
                break;
            }
            case 2364: {
                switch (current) {
                    case 65: {
                        this.state = 2365;
                        return true;
                    }
                }
                break;
            }
            case 2365: {
                switch (current) {
                    case 114: {
                        this.state = 2366;
                        return true;
                    }
                }
                break;
            }
            case 2366: {
                switch (current) {
                    case 114: {
                        this.state = 2367;
                        return true;
                    }
                }
                break;
            }
            case 2367: {
                switch (current) {
                    case 111: {
                        this.state = 2368;
                        return true;
                    }
                }
                break;
            }
            case 2368: {
                switch (current) {
                    case 119: {
                        this.state = 2369;
                        return true;
                    }
                }
                break;
            }
            case 2369: {
                switch (current) {
                    case 59: {
                        this.match = "\u21c4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2370: {
                switch (current) {
                    case 101: {
                        this.state = 2371;
                        return true;
                    }
                }
                break;
            }
            case 2371: {
                switch (current) {
                    case 105: {
                        this.state = 2372;
                        return true;
                    }
                }
                break;
            }
            case 2372: {
                switch (current) {
                    case 108: {
                        this.state = 2373;
                        return true;
                    }
                }
                break;
            }
            case 2373: {
                switch (current) {
                    case 105: {
                        this.state = 2374;
                        return true;
                    }
                }
                break;
            }
            case 2374: {
                switch (current) {
                    case 110: {
                        this.state = 2375;
                        return true;
                    }
                }
                break;
            }
            case 2375: {
                switch (current) {
                    case 103: {
                        this.state = 2376;
                        return true;
                    }
                }
                break;
            }
            case 2376: {
                switch (current) {
                    case 59: {
                        this.match = "\u2309";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2377: {
                switch (current) {
                    case 111: {
                        this.state = 2378;
                        return true;
                    }
                }
                break;
            }
            case 2378: {
                switch (current) {
                    case 117: {
                        this.state = 2379;
                        return true;
                    }
                    case 119: {
                        this.state = 2390;
                        return true;
                    }
                }
                break;
            }
            case 2379: {
                switch (current) {
                    case 98: {
                        this.state = 2380;
                        return true;
                    }
                }
                break;
            }
            case 2380: {
                switch (current) {
                    case 108: {
                        this.state = 2381;
                        return true;
                    }
                }
                break;
            }
            case 2381: {
                switch (current) {
                    case 101: {
                        this.state = 2382;
                        return true;
                    }
                }
                break;
            }
            case 2382: {
                switch (current) {
                    case 66: {
                        this.state = 2383;
                        return true;
                    }
                }
                break;
            }
            case 2383: {
                switch (current) {
                    case 114: {
                        this.state = 2384;
                        return true;
                    }
                }
                break;
            }
            case 2384: {
                switch (current) {
                    case 97: {
                        this.state = 2385;
                        return true;
                    }
                }
                break;
            }
            case 2385: {
                switch (current) {
                    case 99: {
                        this.state = 2386;
                        return true;
                    }
                }
                break;
            }
            case 2386: {
                switch (current) {
                    case 107: {
                        this.state = 2387;
                        return true;
                    }
                }
                break;
            }
            case 2387: {
                switch (current) {
                    case 101: {
                        this.state = 2388;
                        return true;
                    }
                }
                break;
            }
            case 2388: {
                switch (current) {
                    case 116: {
                        this.state = 2389;
                        return true;
                    }
                }
                break;
            }
            case 2389: {
                switch (current) {
                    case 59: {
                        this.match = "\u27e7";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2390: {
                switch (current) {
                    case 110: {
                        this.state = 2391;
                        return true;
                    }
                }
                break;
            }
            case 2391: {
                switch (current) {
                    case 84: {
                        this.state = 2392;
                        return true;
                    }
                    case 86: {
                        this.state = 2401;
                        return true;
                    }
                }
                break;
            }
            case 2392: {
                switch (current) {
                    case 101: {
                        this.state = 2393;
                        return true;
                    }
                }
                break;
            }
            case 2393: {
                switch (current) {
                    case 101: {
                        this.state = 2394;
                        return true;
                    }
                }
                break;
            }
            case 2394: {
                switch (current) {
                    case 86: {
                        this.state = 2395;
                        return true;
                    }
                }
                break;
            }
            case 2395: {
                switch (current) {
                    case 101: {
                        this.state = 2396;
                        return true;
                    }
                }
                break;
            }
            case 2396: {
                switch (current) {
                    case 99: {
                        this.state = 2397;
                        return true;
                    }
                }
                break;
            }
            case 2397: {
                switch (current) {
                    case 116: {
                        this.state = 2398;
                        return true;
                    }
                }
                break;
            }
            case 2398: {
                switch (current) {
                    case 111: {
                        this.state = 2399;
                        return true;
                    }
                }
                break;
            }
            case 2399: {
                switch (current) {
                    case 114: {
                        this.state = 2400;
                        return true;
                    }
                }
                break;
            }
            case 2400: {
                switch (current) {
                    case 59: {
                        this.match = "\u295d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2401: {
                switch (current) {
                    case 101: {
                        this.state = 2402;
                        return true;
                    }
                }
                break;
            }
            case 2402: {
                switch (current) {
                    case 99: {
                        this.state = 2403;
                        return true;
                    }
                }
                break;
            }
            case 2403: {
                switch (current) {
                    case 116: {
                        this.state = 2404;
                        return true;
                    }
                }
                break;
            }
            case 2404: {
                switch (current) {
                    case 111: {
                        this.state = 2405;
                        return true;
                    }
                }
                break;
            }
            case 2405: {
                switch (current) {
                    case 114: {
                        this.state = 2406;
                        return true;
                    }
                }
                break;
            }
            case 2406: {
                switch (current) {
                    case 59: {
                        this.match = "\u21c2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 2407;
                        return true;
                    }
                }
                break;
            }
            case 2407: {
                switch (current) {
                    case 97: {
                        this.state = 2408;
                        return true;
                    }
                }
                break;
            }
            case 2408: {
                switch (current) {
                    case 114: {
                        this.state = 2409;
                        return true;
                    }
                }
                break;
            }
            case 2409: {
                switch (current) {
                    case 59: {
                        this.match = "\u2955";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2410: {
                switch (current) {
                    case 108: {
                        this.state = 2411;
                        return true;
                    }
                }
                break;
            }
            case 2411: {
                switch (current) {
                    case 111: {
                        this.state = 2412;
                        return true;
                    }
                }
                break;
            }
            case 2412: {
                switch (current) {
                    case 111: {
                        this.state = 2413;
                        return true;
                    }
                }
                break;
            }
            case 2413: {
                switch (current) {
                    case 114: {
                        this.state = 2414;
                        return true;
                    }
                }
                break;
            }
            case 2414: {
                switch (current) {
                    case 59: {
                        this.match = "\u230b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2415: {
                switch (current) {
                    case 101: {
                        this.state = 2416;
                        return true;
                    }
                    case 114: {
                        this.state = 2429;
                        return true;
                    }
                }
                break;
            }
            case 2416: {
                switch (current) {
                    case 101: {
                        this.state = 2417;
                        return true;
                    }
                }
                break;
            }
            case 2417: {
                switch (current) {
                    case 59: {
                        this.match = "\u22a2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 65: {
                        this.state = 2418;
                        return true;
                    }
                    case 86: {
                        this.state = 2423;
                        return true;
                    }
                }
                break;
            }
            case 2418: {
                switch (current) {
                    case 114: {
                        this.state = 2419;
                        return true;
                    }
                }
                break;
            }
            case 2419: {
                switch (current) {
                    case 114: {
                        this.state = 2420;
                        return true;
                    }
                }
                break;
            }
            case 2420: {
                switch (current) {
                    case 111: {
                        this.state = 2421;
                        return true;
                    }
                }
                break;
            }
            case 2421: {
                switch (current) {
                    case 119: {
                        this.state = 2422;
                        return true;
                    }
                }
                break;
            }
            case 2422: {
                switch (current) {
                    case 59: {
                        this.match = "\u21a6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2423: {
                switch (current) {
                    case 101: {
                        this.state = 2424;
                        return true;
                    }
                }
                break;
            }
            case 2424: {
                switch (current) {
                    case 99: {
                        this.state = 2425;
                        return true;
                    }
                }
                break;
            }
            case 2425: {
                switch (current) {
                    case 116: {
                        this.state = 2426;
                        return true;
                    }
                }
                break;
            }
            case 2426: {
                switch (current) {
                    case 111: {
                        this.state = 2427;
                        return true;
                    }
                }
                break;
            }
            case 2427: {
                switch (current) {
                    case 114: {
                        this.state = 2428;
                        return true;
                    }
                }
                break;
            }
            case 2428: {
                switch (current) {
                    case 59: {
                        this.match = "\u295b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2429: {
                switch (current) {
                    case 105: {
                        this.state = 2430;
                        return true;
                    }
                }
                break;
            }
            case 2430: {
                switch (current) {
                    case 97: {
                        this.state = 2431;
                        return true;
                    }
                }
                break;
            }
            case 2431: {
                switch (current) {
                    case 110: {
                        this.state = 2432;
                        return true;
                    }
                }
                break;
            }
            case 2432: {
                switch (current) {
                    case 103: {
                        this.state = 2433;
                        return true;
                    }
                }
                break;
            }
            case 2433: {
                switch (current) {
                    case 108: {
                        this.state = 2434;
                        return true;
                    }
                }
                break;
            }
            case 2434: {
                switch (current) {
                    case 101: {
                        this.state = 2435;
                        return true;
                    }
                }
                break;
            }
            case 2435: {
                switch (current) {
                    case 59: {
                        this.match = "\u22b3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 2436;
                        return true;
                    }
                    case 69: {
                        this.state = 2439;
                        return true;
                    }
                }
                break;
            }
            case 2436: {
                switch (current) {
                    case 97: {
                        this.state = 2437;
                        return true;
                    }
                }
                break;
            }
            case 2437: {
                switch (current) {
                    case 114: {
                        this.state = 2438;
                        return true;
                    }
                }
                break;
            }
            case 2438: {
                switch (current) {
                    case 59: {
                        this.match = "\u29d0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2439: {
                switch (current) {
                    case 113: {
                        this.state = 2440;
                        return true;
                    }
                }
                break;
            }
            case 2440: {
                switch (current) {
                    case 117: {
                        this.state = 2441;
                        return true;
                    }
                }
                break;
            }
            case 2441: {
                switch (current) {
                    case 97: {
                        this.state = 2442;
                        return true;
                    }
                }
                break;
            }
            case 2442: {
                switch (current) {
                    case 108: {
                        this.state = 2443;
                        return true;
                    }
                }
                break;
            }
            case 2443: {
                switch (current) {
                    case 59: {
                        this.match = "\u22b5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2444: {
                switch (current) {
                    case 112: {
                        this.state = 2445;
                        return true;
                    }
                }
                break;
            }
            case 2445: {
                switch (current) {
                    case 68: {
                        this.state = 2446;
                        return true;
                    }
                    case 84: {
                        this.state = 2456;
                        return true;
                    }
                    case 86: {
                        this.state = 2465;
                        return true;
                    }
                }
                break;
            }
            case 2446: {
                switch (current) {
                    case 111: {
                        this.state = 2447;
                        return true;
                    }
                }
                break;
            }
            case 2447: {
                switch (current) {
                    case 119: {
                        this.state = 2448;
                        return true;
                    }
                }
                break;
            }
            case 2448: {
                switch (current) {
                    case 110: {
                        this.state = 2449;
                        return true;
                    }
                }
                break;
            }
            case 2449: {
                switch (current) {
                    case 86: {
                        this.state = 2450;
                        return true;
                    }
                }
                break;
            }
            case 2450: {
                switch (current) {
                    case 101: {
                        this.state = 2451;
                        return true;
                    }
                }
                break;
            }
            case 2451: {
                switch (current) {
                    case 99: {
                        this.state = 2452;
                        return true;
                    }
                }
                break;
            }
            case 2452: {
                switch (current) {
                    case 116: {
                        this.state = 2453;
                        return true;
                    }
                }
                break;
            }
            case 2453: {
                switch (current) {
                    case 111: {
                        this.state = 2454;
                        return true;
                    }
                }
                break;
            }
            case 2454: {
                switch (current) {
                    case 114: {
                        this.state = 2455;
                        return true;
                    }
                }
                break;
            }
            case 2455: {
                switch (current) {
                    case 59: {
                        this.match = "\u294f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2456: {
                switch (current) {
                    case 101: {
                        this.state = 2457;
                        return true;
                    }
                }
                break;
            }
            case 2457: {
                switch (current) {
                    case 101: {
                        this.state = 2458;
                        return true;
                    }
                }
                break;
            }
            case 2458: {
                switch (current) {
                    case 86: {
                        this.state = 2459;
                        return true;
                    }
                }
                break;
            }
            case 2459: {
                switch (current) {
                    case 101: {
                        this.state = 2460;
                        return true;
                    }
                }
                break;
            }
            case 2460: {
                switch (current) {
                    case 99: {
                        this.state = 2461;
                        return true;
                    }
                }
                break;
            }
            case 2461: {
                switch (current) {
                    case 116: {
                        this.state = 2462;
                        return true;
                    }
                }
                break;
            }
            case 2462: {
                switch (current) {
                    case 111: {
                        this.state = 2463;
                        return true;
                    }
                }
                break;
            }
            case 2463: {
                switch (current) {
                    case 114: {
                        this.state = 2464;
                        return true;
                    }
                }
                break;
            }
            case 2464: {
                switch (current) {
                    case 59: {
                        this.match = "\u295c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2465: {
                switch (current) {
                    case 101: {
                        this.state = 2466;
                        return true;
                    }
                }
                break;
            }
            case 2466: {
                switch (current) {
                    case 99: {
                        this.state = 2467;
                        return true;
                    }
                }
                break;
            }
            case 2467: {
                switch (current) {
                    case 116: {
                        this.state = 2468;
                        return true;
                    }
                }
                break;
            }
            case 2468: {
                switch (current) {
                    case 111: {
                        this.state = 2469;
                        return true;
                    }
                }
                break;
            }
            case 2469: {
                switch (current) {
                    case 114: {
                        this.state = 2470;
                        return true;
                    }
                }
                break;
            }
            case 2470: {
                switch (current) {
                    case 59: {
                        this.match = "\u21be";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 2471;
                        return true;
                    }
                }
                break;
            }
            case 2471: {
                switch (current) {
                    case 97: {
                        this.state = 2472;
                        return true;
                    }
                }
                break;
            }
            case 2472: {
                switch (current) {
                    case 114: {
                        this.state = 2473;
                        return true;
                    }
                }
                break;
            }
            case 2473: {
                switch (current) {
                    case 59: {
                        this.match = "\u2954";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2474: {
                switch (current) {
                    case 101: {
                        this.state = 2475;
                        return true;
                    }
                }
                break;
            }
            case 2475: {
                switch (current) {
                    case 99: {
                        this.state = 2476;
                        return true;
                    }
                }
                break;
            }
            case 2476: {
                switch (current) {
                    case 116: {
                        this.state = 2477;
                        return true;
                    }
                }
                break;
            }
            case 2477: {
                switch (current) {
                    case 111: {
                        this.state = 2478;
                        return true;
                    }
                }
                break;
            }
            case 2478: {
                switch (current) {
                    case 114: {
                        this.state = 2479;
                        return true;
                    }
                }
                break;
            }
            case 2479: {
                switch (current) {
                    case 59: {
                        this.match = "\u21c0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 2480;
                        return true;
                    }
                }
                break;
            }
            case 2480: {
                switch (current) {
                    case 97: {
                        this.state = 2481;
                        return true;
                    }
                }
                break;
            }
            case 2481: {
                switch (current) {
                    case 114: {
                        this.state = 2482;
                        return true;
                    }
                }
                break;
            }
            case 2482: {
                switch (current) {
                    case 59: {
                        this.match = "\u2953";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2483: {
                switch (current) {
                    case 114: {
                        this.state = 2484;
                        return true;
                    }
                }
                break;
            }
            case 2484: {
                switch (current) {
                    case 114: {
                        this.state = 2485;
                        return true;
                    }
                }
                break;
            }
            case 2485: {
                switch (current) {
                    case 111: {
                        this.state = 2486;
                        return true;
                    }
                }
                break;
            }
            case 2486: {
                switch (current) {
                    case 119: {
                        this.state = 2487;
                        return true;
                    }
                }
                break;
            }
            case 2487: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2488: {
                switch (current) {
                    case 112: {
                        this.state = 2489;
                        return true;
                    }
                    case 117: {
                        this.state = 2491;
                        return true;
                    }
                }
                break;
            }
            case 2489: {
                switch (current) {
                    case 102: {
                        this.state = 2490;
                        return true;
                    }
                }
                break;
            }
            case 2490: {
                switch (current) {
                    case 59: {
                        this.match = "\u211d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2491: {
                switch (current) {
                    case 110: {
                        this.state = 2492;
                        return true;
                    }
                }
                break;
            }
            case 2492: {
                switch (current) {
                    case 100: {
                        this.state = 2493;
                        return true;
                    }
                }
                break;
            }
            case 2493: {
                switch (current) {
                    case 73: {
                        this.state = 2494;
                        return true;
                    }
                }
                break;
            }
            case 2494: {
                switch (current) {
                    case 109: {
                        this.state = 2495;
                        return true;
                    }
                }
                break;
            }
            case 2495: {
                switch (current) {
                    case 112: {
                        this.state = 2496;
                        return true;
                    }
                }
                break;
            }
            case 2496: {
                switch (current) {
                    case 108: {
                        this.state = 2497;
                        return true;
                    }
                }
                break;
            }
            case 2497: {
                switch (current) {
                    case 105: {
                        this.state = 2498;
                        return true;
                    }
                }
                break;
            }
            case 2498: {
                switch (current) {
                    case 101: {
                        this.state = 2499;
                        return true;
                    }
                }
                break;
            }
            case 2499: {
                switch (current) {
                    case 115: {
                        this.state = 2500;
                        return true;
                    }
                }
                break;
            }
            case 2500: {
                switch (current) {
                    case 59: {
                        this.match = "\u2970";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2501: {
                switch (current) {
                    case 105: {
                        this.state = 2502;
                        return true;
                    }
                }
                break;
            }
            case 2502: {
                switch (current) {
                    case 103: {
                        this.state = 2503;
                        return true;
                    }
                }
                break;
            }
            case 2503: {
                switch (current) {
                    case 104: {
                        this.state = 2504;
                        return true;
                    }
                }
                break;
            }
            case 2504: {
                switch (current) {
                    case 116: {
                        this.state = 2505;
                        return true;
                    }
                }
                break;
            }
            case 2505: {
                switch (current) {
                    case 97: {
                        this.state = 2506;
                        return true;
                    }
                }
                break;
            }
            case 2506: {
                switch (current) {
                    case 114: {
                        this.state = 2507;
                        return true;
                    }
                }
                break;
            }
            case 2507: {
                switch (current) {
                    case 114: {
                        this.state = 2508;
                        return true;
                    }
                }
                break;
            }
            case 2508: {
                switch (current) {
                    case 111: {
                        this.state = 2509;
                        return true;
                    }
                }
                break;
            }
            case 2509: {
                switch (current) {
                    case 119: {
                        this.state = 2510;
                        return true;
                    }
                }
                break;
            }
            case 2510: {
                switch (current) {
                    case 59: {
                        this.match = "\u21db";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2511: {
                switch (current) {
                    case 99: {
                        this.state = 2512;
                        return true;
                    }
                    case 104: {
                        this.state = 2514;
                        return true;
                    }
                }
                break;
            }
            case 2512: {
                switch (current) {
                    case 114: {
                        this.state = 2513;
                        return true;
                    }
                }
                break;
            }
            case 2513: {
                switch (current) {
                    case 59: {
                        this.match = "\u211b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2514: {
                switch (current) {
                    case 59: {
                        this.match = "\u21b1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2515: {
                switch (current) {
                    case 108: {
                        this.state = 2516;
                        return true;
                    }
                }
                break;
            }
            case 2516: {
                switch (current) {
                    case 101: {
                        this.state = 2517;
                        return true;
                    }
                }
                break;
            }
            case 2517: {
                switch (current) {
                    case 68: {
                        this.state = 2518;
                        return true;
                    }
                }
                break;
            }
            case 2518: {
                switch (current) {
                    case 101: {
                        this.state = 2519;
                        return true;
                    }
                }
                break;
            }
            case 2519: {
                switch (current) {
                    case 108: {
                        this.state = 2520;
                        return true;
                    }
                }
                break;
            }
            case 2520: {
                switch (current) {
                    case 97: {
                        this.state = 2521;
                        return true;
                    }
                }
                break;
            }
            case 2521: {
                switch (current) {
                    case 121: {
                        this.state = 2522;
                        return true;
                    }
                }
                break;
            }
            case 2522: {
                switch (current) {
                    case 101: {
                        this.state = 2523;
                        return true;
                    }
                }
                break;
            }
            case 2523: {
                switch (current) {
                    case 100: {
                        this.state = 2524;
                        return true;
                    }
                }
                break;
            }
            case 2524: {
                switch (current) {
                    case 59: {
                        this.match = "\u29f4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2525: {
                switch (current) {
                    case 72: {
                        this.state = 2526;
                        return true;
                    }
                    case 79: {
                        this.state = 2533;
                        return true;
                    }
                    case 97: {
                        this.state = 2538;
                        return true;
                    }
                    case 99: {
                        this.state = 2543;
                        return true;
                    }
                    case 102: {
                        this.state = 2556;
                        return true;
                    }
                    case 104: {
                        this.state = 2558;
                        return true;
                    }
                    case 105: {
                        this.state = 2597;
                        return true;
                    }
                    case 109: {
                        this.state = 2601;
                        return true;
                    }
                    case 111: {
                        this.state = 2611;
                        return true;
                    }
                    case 113: {
                        this.state = 2614;
                        return true;
                    }
                    case 115: {
                        this.state = 2660;
                        return true;
                    }
                    case 116: {
                        this.state = 2663;
                        return true;
                    }
                    case 117: {
                        this.state = 2666;
                        return true;
                    }
                }
                break;
            }
            case 2526: {
                switch (current) {
                    case 67: {
                        this.state = 2527;
                        return true;
                    }
                    case 99: {
                        this.state = 2531;
                        return true;
                    }
                }
                break;
            }
            case 2527: {
                switch (current) {
                    case 72: {
                        this.state = 2528;
                        return true;
                    }
                }
                break;
            }
            case 2528: {
                switch (current) {
                    case 99: {
                        this.state = 2529;
                        return true;
                    }
                }
                break;
            }
            case 2529: {
                switch (current) {
                    case 121: {
                        this.state = 2530;
                        return true;
                    }
                }
                break;
            }
            case 2530: {
                switch (current) {
                    case 59: {
                        this.match = "\u0429";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2531: {
                switch (current) {
                    case 121: {
                        this.state = 2532;
                        return true;
                    }
                }
                break;
            }
            case 2532: {
                switch (current) {
                    case 59: {
                        this.match = "\u0428";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2533: {
                switch (current) {
                    case 70: {
                        this.state = 2534;
                        return true;
                    }
                }
                break;
            }
            case 2534: {
                switch (current) {
                    case 84: {
                        this.state = 2535;
                        return true;
                    }
                }
                break;
            }
            case 2535: {
                switch (current) {
                    case 99: {
                        this.state = 2536;
                        return true;
                    }
                }
                break;
            }
            case 2536: {
                switch (current) {
                    case 121: {
                        this.state = 2537;
                        return true;
                    }
                }
                break;
            }
            case 2537: {
                switch (current) {
                    case 59: {
                        this.match = "\u042c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2538: {
                switch (current) {
                    case 99: {
                        this.state = 2539;
                        return true;
                    }
                }
                break;
            }
            case 2539: {
                switch (current) {
                    case 117: {
                        this.state = 2540;
                        return true;
                    }
                }
                break;
            }
            case 2540: {
                switch (current) {
                    case 116: {
                        this.state = 2541;
                        return true;
                    }
                }
                break;
            }
            case 2541: {
                switch (current) {
                    case 101: {
                        this.state = 2542;
                        return true;
                    }
                }
                break;
            }
            case 2542: {
                switch (current) {
                    case 59: {
                        this.match = "\u015a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2543: {
                switch (current) {
                    case 59: {
                        this.match = "\u2abc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 97: {
                        this.state = 2544;
                        return true;
                    }
                    case 101: {
                        this.state = 2548;
                        return true;
                    }
                    case 105: {
                        this.state = 2552;
                        return true;
                    }
                    case 121: {
                        this.state = 2555;
                        return true;
                    }
                }
                break;
            }
            case 2544: {
                switch (current) {
                    case 114: {
                        this.state = 2545;
                        return true;
                    }
                }
                break;
            }
            case 2545: {
                switch (current) {
                    case 111: {
                        this.state = 2546;
                        return true;
                    }
                }
                break;
            }
            case 2546: {
                switch (current) {
                    case 110: {
                        this.state = 2547;
                        return true;
                    }
                }
                break;
            }
            case 2547: {
                switch (current) {
                    case 59: {
                        this.match = "\u0160";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2548: {
                switch (current) {
                    case 100: {
                        this.state = 2549;
                        return true;
                    }
                }
                break;
            }
            case 2549: {
                switch (current) {
                    case 105: {
                        this.state = 2550;
                        return true;
                    }
                }
                break;
            }
            case 2550: {
                switch (current) {
                    case 108: {
                        this.state = 2551;
                        return true;
                    }
                }
                break;
            }
            case 2551: {
                switch (current) {
                    case 59: {
                        this.match = "\u015e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2552: {
                switch (current) {
                    case 114: {
                        this.state = 2553;
                        return true;
                    }
                }
                break;
            }
            case 2553: {
                switch (current) {
                    case 99: {
                        this.state = 2554;
                        return true;
                    }
                }
                break;
            }
            case 2554: {
                switch (current) {
                    case 59: {
                        this.match = "\u015c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2555: {
                switch (current) {
                    case 59: {
                        this.match = "\u0421";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2556: {
                switch (current) {
                    case 114: {
                        this.state = 2557;
                        return true;
                    }
                }
                break;
            }
            case 2557: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd16";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2558: {
                switch (current) {
                    case 111: {
                        this.state = 2559;
                        return true;
                    }
                }
                break;
            }
            case 2559: {
                switch (current) {
                    case 114: {
                        this.state = 2560;
                        return true;
                    }
                }
                break;
            }
            case 2560: {
                switch (current) {
                    case 116: {
                        this.state = 2561;
                        return true;
                    }
                }
                break;
            }
            case 2561: {
                switch (current) {
                    case 68: {
                        this.state = 2562;
                        return true;
                    }
                    case 76: {
                        this.state = 2571;
                        return true;
                    }
                    case 82: {
                        this.state = 2580;
                        return true;
                    }
                    case 85: {
                        this.state = 2590;
                        return true;
                    }
                }
                break;
            }
            case 2562: {
                switch (current) {
                    case 111: {
                        this.state = 2563;
                        return true;
                    }
                }
                break;
            }
            case 2563: {
                switch (current) {
                    case 119: {
                        this.state = 2564;
                        return true;
                    }
                }
                break;
            }
            case 2564: {
                switch (current) {
                    case 110: {
                        this.state = 2565;
                        return true;
                    }
                }
                break;
            }
            case 2565: {
                switch (current) {
                    case 65: {
                        this.state = 2566;
                        return true;
                    }
                }
                break;
            }
            case 2566: {
                switch (current) {
                    case 114: {
                        this.state = 2567;
                        return true;
                    }
                }
                break;
            }
            case 2567: {
                switch (current) {
                    case 114: {
                        this.state = 2568;
                        return true;
                    }
                }
                break;
            }
            case 2568: {
                switch (current) {
                    case 111: {
                        this.state = 2569;
                        return true;
                    }
                }
                break;
            }
            case 2569: {
                switch (current) {
                    case 119: {
                        this.state = 2570;
                        return true;
                    }
                }
                break;
            }
            case 2570: {
                switch (current) {
                    case 59: {
                        this.match = "\u2193";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2571: {
                switch (current) {
                    case 101: {
                        this.state = 2572;
                        return true;
                    }
                }
                break;
            }
            case 2572: {
                switch (current) {
                    case 102: {
                        this.state = 2573;
                        return true;
                    }
                }
                break;
            }
            case 2573: {
                switch (current) {
                    case 116: {
                        this.state = 2574;
                        return true;
                    }
                }
                break;
            }
            case 2574: {
                switch (current) {
                    case 65: {
                        this.state = 2575;
                        return true;
                    }
                }
                break;
            }
            case 2575: {
                switch (current) {
                    case 114: {
                        this.state = 2576;
                        return true;
                    }
                }
                break;
            }
            case 2576: {
                switch (current) {
                    case 114: {
                        this.state = 2577;
                        return true;
                    }
                }
                break;
            }
            case 2577: {
                switch (current) {
                    case 111: {
                        this.state = 2578;
                        return true;
                    }
                }
                break;
            }
            case 2578: {
                switch (current) {
                    case 119: {
                        this.state = 2579;
                        return true;
                    }
                }
                break;
            }
            case 2579: {
                switch (current) {
                    case 59: {
                        this.match = "\u2190";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2580: {
                switch (current) {
                    case 105: {
                        this.state = 2581;
                        return true;
                    }
                }
                break;
            }
            case 2581: {
                switch (current) {
                    case 103: {
                        this.state = 2582;
                        return true;
                    }
                }
                break;
            }
            case 2582: {
                switch (current) {
                    case 104: {
                        this.state = 2583;
                        return true;
                    }
                }
                break;
            }
            case 2583: {
                switch (current) {
                    case 116: {
                        this.state = 2584;
                        return true;
                    }
                }
                break;
            }
            case 2584: {
                switch (current) {
                    case 65: {
                        this.state = 2585;
                        return true;
                    }
                }
                break;
            }
            case 2585: {
                switch (current) {
                    case 114: {
                        this.state = 2586;
                        return true;
                    }
                }
                break;
            }
            case 2586: {
                switch (current) {
                    case 114: {
                        this.state = 2587;
                        return true;
                    }
                }
                break;
            }
            case 2587: {
                switch (current) {
                    case 111: {
                        this.state = 2588;
                        return true;
                    }
                }
                break;
            }
            case 2588: {
                switch (current) {
                    case 119: {
                        this.state = 2589;
                        return true;
                    }
                }
                break;
            }
            case 2589: {
                switch (current) {
                    case 59: {
                        this.match = "\u2192";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2590: {
                switch (current) {
                    case 112: {
                        this.state = 2591;
                        return true;
                    }
                }
                break;
            }
            case 2591: {
                switch (current) {
                    case 65: {
                        this.state = 2592;
                        return true;
                    }
                }
                break;
            }
            case 2592: {
                switch (current) {
                    case 114: {
                        this.state = 2593;
                        return true;
                    }
                }
                break;
            }
            case 2593: {
                switch (current) {
                    case 114: {
                        this.state = 2594;
                        return true;
                    }
                }
                break;
            }
            case 2594: {
                switch (current) {
                    case 111: {
                        this.state = 2595;
                        return true;
                    }
                }
                break;
            }
            case 2595: {
                switch (current) {
                    case 119: {
                        this.state = 2596;
                        return true;
                    }
                }
                break;
            }
            case 2596: {
                switch (current) {
                    case 59: {
                        this.match = "\u2191";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2597: {
                switch (current) {
                    case 103: {
                        this.state = 2598;
                        return true;
                    }
                }
                break;
            }
            case 2598: {
                switch (current) {
                    case 109: {
                        this.state = 2599;
                        return true;
                    }
                }
                break;
            }
            case 2599: {
                switch (current) {
                    case 97: {
                        this.state = 2600;
                        return true;
                    }
                }
                break;
            }
            case 2600: {
                switch (current) {
                    case 59: {
                        this.match = "\u03a3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2601: {
                switch (current) {
                    case 97: {
                        this.state = 2602;
                        return true;
                    }
                }
                break;
            }
            case 2602: {
                switch (current) {
                    case 108: {
                        this.state = 2603;
                        return true;
                    }
                }
                break;
            }
            case 2603: {
                switch (current) {
                    case 108: {
                        this.state = 2604;
                        return true;
                    }
                }
                break;
            }
            case 2604: {
                switch (current) {
                    case 67: {
                        this.state = 2605;
                        return true;
                    }
                }
                break;
            }
            case 2605: {
                switch (current) {
                    case 105: {
                        this.state = 2606;
                        return true;
                    }
                }
                break;
            }
            case 2606: {
                switch (current) {
                    case 114: {
                        this.state = 2607;
                        return true;
                    }
                }
                break;
            }
            case 2607: {
                switch (current) {
                    case 99: {
                        this.state = 2608;
                        return true;
                    }
                }
                break;
            }
            case 2608: {
                switch (current) {
                    case 108: {
                        this.state = 2609;
                        return true;
                    }
                }
                break;
            }
            case 2609: {
                switch (current) {
                    case 101: {
                        this.state = 2610;
                        return true;
                    }
                }
                break;
            }
            case 2610: {
                switch (current) {
                    case 59: {
                        this.match = "\u2218";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2611: {
                switch (current) {
                    case 112: {
                        this.state = 2612;
                        return true;
                    }
                }
                break;
            }
            case 2612: {
                switch (current) {
                    case 102: {
                        this.state = 2613;
                        return true;
                    }
                }
                break;
            }
            case 2613: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd4a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2614: {
                switch (current) {
                    case 114: {
                        this.state = 2615;
                        return true;
                    }
                    case 117: {
                        this.state = 2617;
                        return true;
                    }
                }
                break;
            }
            case 2615: {
                switch (current) {
                    case 116: {
                        this.state = 2616;
                        return true;
                    }
                }
                break;
            }
            case 2616: {
                switch (current) {
                    case 59: {
                        this.match = "\u221a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2617: {
                switch (current) {
                    case 97: {
                        this.state = 2618;
                        return true;
                    }
                }
                break;
            }
            case 2618: {
                switch (current) {
                    case 114: {
                        this.state = 2619;
                        return true;
                    }
                }
                break;
            }
            case 2619: {
                switch (current) {
                    case 101: {
                        this.state = 2620;
                        return true;
                    }
                }
                break;
            }
            case 2620: {
                switch (current) {
                    case 59: {
                        this.match = "\u25a1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 73: {
                        this.state = 2621;
                        return true;
                    }
                    case 83: {
                        this.state = 2633;
                        return true;
                    }
                    case 85: {
                        this.state = 2655;
                        return true;
                    }
                }
                break;
            }
            case 2621: {
                switch (current) {
                    case 110: {
                        this.state = 2622;
                        return true;
                    }
                }
                break;
            }
            case 2622: {
                switch (current) {
                    case 116: {
                        this.state = 2623;
                        return true;
                    }
                }
                break;
            }
            case 2623: {
                switch (current) {
                    case 101: {
                        this.state = 2624;
                        return true;
                    }
                }
                break;
            }
            case 2624: {
                switch (current) {
                    case 114: {
                        this.state = 2625;
                        return true;
                    }
                }
                break;
            }
            case 2625: {
                switch (current) {
                    case 115: {
                        this.state = 2626;
                        return true;
                    }
                }
                break;
            }
            case 2626: {
                switch (current) {
                    case 101: {
                        this.state = 2627;
                        return true;
                    }
                }
                break;
            }
            case 2627: {
                switch (current) {
                    case 99: {
                        this.state = 2628;
                        return true;
                    }
                }
                break;
            }
            case 2628: {
                switch (current) {
                    case 116: {
                        this.state = 2629;
                        return true;
                    }
                }
                break;
            }
            case 2629: {
                switch (current) {
                    case 105: {
                        this.state = 2630;
                        return true;
                    }
                }
                break;
            }
            case 2630: {
                switch (current) {
                    case 111: {
                        this.state = 2631;
                        return true;
                    }
                }
                break;
            }
            case 2631: {
                switch (current) {
                    case 110: {
                        this.state = 2632;
                        return true;
                    }
                }
                break;
            }
            case 2632: {
                switch (current) {
                    case 59: {
                        this.match = "\u2293";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2633: {
                switch (current) {
                    case 117: {
                        this.state = 2634;
                        return true;
                    }
                }
                break;
            }
            case 2634: {
                switch (current) {
                    case 98: {
                        this.state = 2635;
                        return true;
                    }
                    case 112: {
                        this.state = 2644;
                        return true;
                    }
                }
                break;
            }
            case 2635: {
                switch (current) {
                    case 115: {
                        this.state = 2636;
                        return true;
                    }
                }
                break;
            }
            case 2636: {
                switch (current) {
                    case 101: {
                        this.state = 2637;
                        return true;
                    }
                }
                break;
            }
            case 2637: {
                switch (current) {
                    case 116: {
                        this.state = 2638;
                        return true;
                    }
                }
                break;
            }
            case 2638: {
                switch (current) {
                    case 59: {
                        this.match = "\u228f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2639;
                        return true;
                    }
                }
                break;
            }
            case 2639: {
                switch (current) {
                    case 113: {
                        this.state = 2640;
                        return true;
                    }
                }
                break;
            }
            case 2640: {
                switch (current) {
                    case 117: {
                        this.state = 2641;
                        return true;
                    }
                }
                break;
            }
            case 2641: {
                switch (current) {
                    case 97: {
                        this.state = 2642;
                        return true;
                    }
                }
                break;
            }
            case 2642: {
                switch (current) {
                    case 108: {
                        this.state = 2643;
                        return true;
                    }
                }
                break;
            }
            case 2643: {
                switch (current) {
                    case 59: {
                        this.match = "\u2291";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2644: {
                switch (current) {
                    case 101: {
                        this.state = 2645;
                        return true;
                    }
                }
                break;
            }
            case 2645: {
                switch (current) {
                    case 114: {
                        this.state = 2646;
                        return true;
                    }
                }
                break;
            }
            case 2646: {
                switch (current) {
                    case 115: {
                        this.state = 2647;
                        return true;
                    }
                }
                break;
            }
            case 2647: {
                switch (current) {
                    case 101: {
                        this.state = 2648;
                        return true;
                    }
                }
                break;
            }
            case 2648: {
                switch (current) {
                    case 116: {
                        this.state = 2649;
                        return true;
                    }
                }
                break;
            }
            case 2649: {
                switch (current) {
                    case 59: {
                        this.match = "\u2290";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2650;
                        return true;
                    }
                }
                break;
            }
            case 2650: {
                switch (current) {
                    case 113: {
                        this.state = 2651;
                        return true;
                    }
                }
                break;
            }
            case 2651: {
                switch (current) {
                    case 117: {
                        this.state = 2652;
                        return true;
                    }
                }
                break;
            }
            case 2652: {
                switch (current) {
                    case 97: {
                        this.state = 2653;
                        return true;
                    }
                }
                break;
            }
            case 2653: {
                switch (current) {
                    case 108: {
                        this.state = 2654;
                        return true;
                    }
                }
                break;
            }
            case 2654: {
                switch (current) {
                    case 59: {
                        this.match = "\u2292";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2655: {
                switch (current) {
                    case 110: {
                        this.state = 2656;
                        return true;
                    }
                }
                break;
            }
            case 2656: {
                switch (current) {
                    case 105: {
                        this.state = 2657;
                        return true;
                    }
                }
                break;
            }
            case 2657: {
                switch (current) {
                    case 111: {
                        this.state = 2658;
                        return true;
                    }
                }
                break;
            }
            case 2658: {
                switch (current) {
                    case 110: {
                        this.state = 2659;
                        return true;
                    }
                }
                break;
            }
            case 2659: {
                switch (current) {
                    case 59: {
                        this.match = "\u2294";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2660: {
                switch (current) {
                    case 99: {
                        this.state = 2661;
                        return true;
                    }
                }
                break;
            }
            case 2661: {
                switch (current) {
                    case 114: {
                        this.state = 2662;
                        return true;
                    }
                }
                break;
            }
            case 2662: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcae";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2663: {
                switch (current) {
                    case 97: {
                        this.state = 2664;
                        return true;
                    }
                }
                break;
            }
            case 2664: {
                switch (current) {
                    case 114: {
                        this.state = 2665;
                        return true;
                    }
                }
                break;
            }
            case 2665: {
                switch (current) {
                    case 59: {
                        this.match = "\u22c6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2666: {
                switch (current) {
                    case 98: {
                        this.state = 2667;
                        return true;
                    }
                    case 99: {
                        this.state = 2676;
                        return true;
                    }
                    case 109: {
                        this.state = 2707;
                        return true;
                    }
                    case 112: {
                        this.state = 2708;
                        return true;
                    }
                }
                break;
            }
            case 2667: {
                switch (current) {
                    case 59: {
                        this.match = "\u22d0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 115: {
                        this.state = 2668;
                        return true;
                    }
                }
                break;
            }
            case 2668: {
                switch (current) {
                    case 101: {
                        this.state = 2669;
                        return true;
                    }
                }
                break;
            }
            case 2669: {
                switch (current) {
                    case 116: {
                        this.state = 2670;
                        return true;
                    }
                }
                break;
            }
            case 2670: {
                switch (current) {
                    case 59: {
                        this.match = "\u22d0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2671;
                        return true;
                    }
                }
                break;
            }
            case 2671: {
                switch (current) {
                    case 113: {
                        this.state = 2672;
                        return true;
                    }
                }
                break;
            }
            case 2672: {
                switch (current) {
                    case 117: {
                        this.state = 2673;
                        return true;
                    }
                }
                break;
            }
            case 2673: {
                switch (current) {
                    case 97: {
                        this.state = 2674;
                        return true;
                    }
                }
                break;
            }
            case 2674: {
                switch (current) {
                    case 108: {
                        this.state = 2675;
                        return true;
                    }
                }
                break;
            }
            case 2675: {
                switch (current) {
                    case 59: {
                        this.match = "\u2286";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2676: {
                switch (current) {
                    case 99: {
                        this.state = 2677;
                        return true;
                    }
                    case 104: {
                        this.state = 2702;
                        return true;
                    }
                }
                break;
            }
            case 2677: {
                switch (current) {
                    case 101: {
                        this.state = 2678;
                        return true;
                    }
                }
                break;
            }
            case 2678: {
                switch (current) {
                    case 101: {
                        this.state = 2679;
                        return true;
                    }
                }
                break;
            }
            case 2679: {
                switch (current) {
                    case 100: {
                        this.state = 2680;
                        return true;
                    }
                }
                break;
            }
            case 2680: {
                switch (current) {
                    case 115: {
                        this.state = 2681;
                        return true;
                    }
                }
                break;
            }
            case 2681: {
                switch (current) {
                    case 59: {
                        this.match = "\u227b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2682;
                        return true;
                    }
                    case 83: {
                        this.state = 2687;
                        return true;
                    }
                    case 84: {
                        this.state = 2697;
                        return true;
                    }
                }
                break;
            }
            case 2682: {
                switch (current) {
                    case 113: {
                        this.state = 2683;
                        return true;
                    }
                }
                break;
            }
            case 2683: {
                switch (current) {
                    case 117: {
                        this.state = 2684;
                        return true;
                    }
                }
                break;
            }
            case 2684: {
                switch (current) {
                    case 97: {
                        this.state = 2685;
                        return true;
                    }
                }
                break;
            }
            case 2685: {
                switch (current) {
                    case 108: {
                        this.state = 2686;
                        return true;
                    }
                }
                break;
            }
            case 2686: {
                switch (current) {
                    case 59: {
                        this.match = "\u2ab0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2687: {
                switch (current) {
                    case 108: {
                        this.state = 2688;
                        return true;
                    }
                }
                break;
            }
            case 2688: {
                switch (current) {
                    case 97: {
                        this.state = 2689;
                        return true;
                    }
                }
                break;
            }
            case 2689: {
                switch (current) {
                    case 110: {
                        this.state = 2690;
                        return true;
                    }
                }
                break;
            }
            case 2690: {
                switch (current) {
                    case 116: {
                        this.state = 2691;
                        return true;
                    }
                }
                break;
            }
            case 2691: {
                switch (current) {
                    case 69: {
                        this.state = 2692;
                        return true;
                    }
                }
                break;
            }
            case 2692: {
                switch (current) {
                    case 113: {
                        this.state = 2693;
                        return true;
                    }
                }
                break;
            }
            case 2693: {
                switch (current) {
                    case 117: {
                        this.state = 2694;
                        return true;
                    }
                }
                break;
            }
            case 2694: {
                switch (current) {
                    case 97: {
                        this.state = 2695;
                        return true;
                    }
                }
                break;
            }
            case 2695: {
                switch (current) {
                    case 108: {
                        this.state = 2696;
                        return true;
                    }
                }
                break;
            }
            case 2696: {
                switch (current) {
                    case 59: {
                        this.match = "\u227d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2697: {
                switch (current) {
                    case 105: {
                        this.state = 2698;
                        return true;
                    }
                }
                break;
            }
            case 2698: {
                switch (current) {
                    case 108: {
                        this.state = 2699;
                        return true;
                    }
                }
                break;
            }
            case 2699: {
                switch (current) {
                    case 100: {
                        this.state = 2700;
                        return true;
                    }
                }
                break;
            }
            case 2700: {
                switch (current) {
                    case 101: {
                        this.state = 2701;
                        return true;
                    }
                }
                break;
            }
            case 2701: {
                switch (current) {
                    case 59: {
                        this.match = "\u227f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2702: {
                switch (current) {
                    case 84: {
                        this.state = 2703;
                        return true;
                    }
                }
                break;
            }
            case 2703: {
                switch (current) {
                    case 104: {
                        this.state = 2704;
                        return true;
                    }
                }
                break;
            }
            case 2704: {
                switch (current) {
                    case 97: {
                        this.state = 2705;
                        return true;
                    }
                }
                break;
            }
            case 2705: {
                switch (current) {
                    case 116: {
                        this.state = 2706;
                        return true;
                    }
                }
                break;
            }
            case 2706: {
                switch (current) {
                    case 59: {
                        this.match = "\u220b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2707: {
                switch (current) {
                    case 59: {
                        this.match = "\u2211";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2708: {
                switch (current) {
                    case 59: {
                        this.match = "\u22d1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 2709;
                        return true;
                    }
                    case 115: {
                        this.state = 2719;
                        return true;
                    }
                }
                break;
            }
            case 2709: {
                switch (current) {
                    case 114: {
                        this.state = 2710;
                        return true;
                    }
                }
                break;
            }
            case 2710: {
                switch (current) {
                    case 115: {
                        this.state = 2711;
                        return true;
                    }
                }
                break;
            }
            case 2711: {
                switch (current) {
                    case 101: {
                        this.state = 2712;
                        return true;
                    }
                }
                break;
            }
            case 2712: {
                switch (current) {
                    case 116: {
                        this.state = 2713;
                        return true;
                    }
                }
                break;
            }
            case 2713: {
                switch (current) {
                    case 59: {
                        this.match = "\u2283";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2714;
                        return true;
                    }
                }
                break;
            }
            case 2714: {
                switch (current) {
                    case 113: {
                        this.state = 2715;
                        return true;
                    }
                }
                break;
            }
            case 2715: {
                switch (current) {
                    case 117: {
                        this.state = 2716;
                        return true;
                    }
                }
                break;
            }
            case 2716: {
                switch (current) {
                    case 97: {
                        this.state = 2717;
                        return true;
                    }
                }
                break;
            }
            case 2717: {
                switch (current) {
                    case 108: {
                        this.state = 2718;
                        return true;
                    }
                }
                break;
            }
            case 2718: {
                switch (current) {
                    case 59: {
                        this.match = "\u2287";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2719: {
                switch (current) {
                    case 101: {
                        this.state = 2720;
                        return true;
                    }
                }
                break;
            }
            case 2720: {
                switch (current) {
                    case 116: {
                        this.state = 2721;
                        return true;
                    }
                }
                break;
            }
            case 2721: {
                switch (current) {
                    case 59: {
                        this.match = "\u22d1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2722: {
                switch (current) {
                    case 72: {
                        this.state = 2723;
                        return true;
                    }
                    case 82: {
                        this.state = 2727;
                        return true;
                    }
                    case 83: {
                        this.state = 2731;
                        return true;
                    }
                    case 97: {
                        this.state = 2737;
                        return true;
                    }
                    case 99: {
                        this.state = 2740;
                        return true;
                    }
                    case 102: {
                        this.state = 2750;
                        return true;
                    }
                    case 104: {
                        this.state = 2752;
                        return true;
                    }
                    case 105: {
                        this.state = 2776;
                        return true;
                    }
                    case 111: {
                        this.state = 2799;
                        return true;
                    }
                    case 114: {
                        this.state = 2802;
                        return true;
                    }
                    case 115: {
                        this.state = 2810;
                        return true;
                    }
                }
                break;
            }
            case 2723: {
                switch (current) {
                    case 79: {
                        this.state = 2724;
                        return true;
                    }
                }
                break;
            }
            case 2724: {
                switch (current) {
                    case 82: {
                        this.state = 2725;
                        return true;
                    }
                }
                break;
            }
            case 2725: {
                switch (current) {
                    case 78: {
                        this.match = "\u00de";
                        this.matchLength = this.consumedCount;
                        this.state = 2726;
                        return true;
                    }
                }
                break;
            }
            case 2726: {
                switch (current) {
                    case 59: {
                        this.match = "\u00de";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2727: {
                switch (current) {
                    case 65: {
                        this.state = 2728;
                        return true;
                    }
                }
                break;
            }
            case 2728: {
                switch (current) {
                    case 68: {
                        this.state = 2729;
                        return true;
                    }
                }
                break;
            }
            case 2729: {
                switch (current) {
                    case 69: {
                        this.state = 2730;
                        return true;
                    }
                }
                break;
            }
            case 2730: {
                switch (current) {
                    case 59: {
                        this.match = "\u2122";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2731: {
                switch (current) {
                    case 72: {
                        this.state = 2732;
                        return true;
                    }
                    case 99: {
                        this.state = 2735;
                        return true;
                    }
                }
                break;
            }
            case 2732: {
                switch (current) {
                    case 99: {
                        this.state = 2733;
                        return true;
                    }
                }
                break;
            }
            case 2733: {
                switch (current) {
                    case 121: {
                        this.state = 2734;
                        return true;
                    }
                }
                break;
            }
            case 2734: {
                switch (current) {
                    case 59: {
                        this.match = "\u040b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2735: {
                switch (current) {
                    case 121: {
                        this.state = 2736;
                        return true;
                    }
                }
                break;
            }
            case 2736: {
                switch (current) {
                    case 59: {
                        this.match = "\u0426";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2737: {
                switch (current) {
                    case 98: {
                        this.state = 2738;
                        return true;
                    }
                    case 117: {
                        this.state = 2739;
                        return true;
                    }
                }
                break;
            }
            case 2738: {
                switch (current) {
                    case 59: {
                        this.match = "\t";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2739: {
                switch (current) {
                    case 59: {
                        this.match = "\u03a4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2740: {
                switch (current) {
                    case 97: {
                        this.state = 2741;
                        return true;
                    }
                    case 101: {
                        this.state = 2745;
                        return true;
                    }
                    case 121: {
                        this.state = 2749;
                        return true;
                    }
                }
                break;
            }
            case 2741: {
                switch (current) {
                    case 114: {
                        this.state = 2742;
                        return true;
                    }
                }
                break;
            }
            case 2742: {
                switch (current) {
                    case 111: {
                        this.state = 2743;
                        return true;
                    }
                }
                break;
            }
            case 2743: {
                switch (current) {
                    case 110: {
                        this.state = 2744;
                        return true;
                    }
                }
                break;
            }
            case 2744: {
                switch (current) {
                    case 59: {
                        this.match = "\u0164";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2745: {
                switch (current) {
                    case 100: {
                        this.state = 2746;
                        return true;
                    }
                }
                break;
            }
            case 2746: {
                switch (current) {
                    case 105: {
                        this.state = 2747;
                        return true;
                    }
                }
                break;
            }
            case 2747: {
                switch (current) {
                    case 108: {
                        this.state = 2748;
                        return true;
                    }
                }
                break;
            }
            case 2748: {
                switch (current) {
                    case 59: {
                        this.match = "\u0162";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2749: {
                switch (current) {
                    case 59: {
                        this.match = "\u0422";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2750: {
                switch (current) {
                    case 114: {
                        this.state = 2751;
                        return true;
                    }
                }
                break;
            }
            case 2751: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd17";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2752: {
                switch (current) {
                    case 101: {
                        this.state = 2753;
                        return true;
                    }
                    case 105: {
                        this.state = 2762;
                        return true;
                    }
                }
                break;
            }
            case 2753: {
                switch (current) {
                    case 114: {
                        this.state = 2754;
                        return true;
                    }
                    case 116: {
                        this.state = 2760;
                        return true;
                    }
                }
                break;
            }
            case 2754: {
                switch (current) {
                    case 101: {
                        this.state = 2755;
                        return true;
                    }
                }
                break;
            }
            case 2755: {
                switch (current) {
                    case 102: {
                        this.state = 2756;
                        return true;
                    }
                }
                break;
            }
            case 2756: {
                switch (current) {
                    case 111: {
                        this.state = 2757;
                        return true;
                    }
                }
                break;
            }
            case 2757: {
                switch (current) {
                    case 114: {
                        this.state = 2758;
                        return true;
                    }
                }
                break;
            }
            case 2758: {
                switch (current) {
                    case 101: {
                        this.state = 2759;
                        return true;
                    }
                }
                break;
            }
            case 2759: {
                switch (current) {
                    case 59: {
                        this.match = "\u2234";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2760: {
                switch (current) {
                    case 97: {
                        this.state = 2761;
                        return true;
                    }
                }
                break;
            }
            case 2761: {
                switch (current) {
                    case 59: {
                        this.match = "\u0398";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2762: {
                switch (current) {
                    case 99: {
                        this.state = 2763;
                        return true;
                    }
                    case 110: {
                        this.state = 2770;
                        return true;
                    }
                }
                break;
            }
            case 2763: {
                switch (current) {
                    case 107: {
                        this.state = 2764;
                        return true;
                    }
                }
                break;
            }
            case 2764: {
                switch (current) {
                    case 83: {
                        this.state = 2765;
                        return true;
                    }
                }
                break;
            }
            case 2765: {
                switch (current) {
                    case 112: {
                        this.state = 2766;
                        return true;
                    }
                }
                break;
            }
            case 2766: {
                switch (current) {
                    case 97: {
                        this.state = 2767;
                        return true;
                    }
                }
                break;
            }
            case 2767: {
                switch (current) {
                    case 99: {
                        this.state = 2768;
                        return true;
                    }
                }
                break;
            }
            case 2768: {
                switch (current) {
                    case 101: {
                        this.state = 2769;
                        return true;
                    }
                }
                break;
            }
            case 2769: {
                switch (current) {
                    case 59: {
                        this.match = "\u205f\u200a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2770: {
                switch (current) {
                    case 83: {
                        this.state = 2771;
                        return true;
                    }
                }
                break;
            }
            case 2771: {
                switch (current) {
                    case 112: {
                        this.state = 2772;
                        return true;
                    }
                }
                break;
            }
            case 2772: {
                switch (current) {
                    case 97: {
                        this.state = 2773;
                        return true;
                    }
                }
                break;
            }
            case 2773: {
                switch (current) {
                    case 99: {
                        this.state = 2774;
                        return true;
                    }
                }
                break;
            }
            case 2774: {
                switch (current) {
                    case 101: {
                        this.state = 2775;
                        return true;
                    }
                }
                break;
            }
            case 2775: {
                switch (current) {
                    case 59: {
                        this.match = "\u2009";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2776: {
                switch (current) {
                    case 108: {
                        this.state = 2777;
                        return true;
                    }
                }
                break;
            }
            case 2777: {
                switch (current) {
                    case 100: {
                        this.state = 2778;
                        return true;
                    }
                }
                break;
            }
            case 2778: {
                switch (current) {
                    case 101: {
                        this.state = 2779;
                        return true;
                    }
                }
                break;
            }
            case 2779: {
                switch (current) {
                    case 59: {
                        this.match = "\u223c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 2780;
                        return true;
                    }
                    case 70: {
                        this.state = 2785;
                        return true;
                    }
                    case 84: {
                        this.state = 2794;
                        return true;
                    }
                }
                break;
            }
            case 2780: {
                switch (current) {
                    case 113: {
                        this.state = 2781;
                        return true;
                    }
                }
                break;
            }
            case 2781: {
                switch (current) {
                    case 117: {
                        this.state = 2782;
                        return true;
                    }
                }
                break;
            }
            case 2782: {
                switch (current) {
                    case 97: {
                        this.state = 2783;
                        return true;
                    }
                }
                break;
            }
            case 2783: {
                switch (current) {
                    case 108: {
                        this.state = 2784;
                        return true;
                    }
                }
                break;
            }
            case 2784: {
                switch (current) {
                    case 59: {
                        this.match = "\u2243";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2785: {
                switch (current) {
                    case 117: {
                        this.state = 2786;
                        return true;
                    }
                }
                break;
            }
            case 2786: {
                switch (current) {
                    case 108: {
                        this.state = 2787;
                        return true;
                    }
                }
                break;
            }
            case 2787: {
                switch (current) {
                    case 108: {
                        this.state = 2788;
                        return true;
                    }
                }
                break;
            }
            case 2788: {
                switch (current) {
                    case 69: {
                        this.state = 2789;
                        return true;
                    }
                }
                break;
            }
            case 2789: {
                switch (current) {
                    case 113: {
                        this.state = 2790;
                        return true;
                    }
                }
                break;
            }
            case 2790: {
                switch (current) {
                    case 117: {
                        this.state = 2791;
                        return true;
                    }
                }
                break;
            }
            case 2791: {
                switch (current) {
                    case 97: {
                        this.state = 2792;
                        return true;
                    }
                }
                break;
            }
            case 2792: {
                switch (current) {
                    case 108: {
                        this.state = 2793;
                        return true;
                    }
                }
                break;
            }
            case 2793: {
                switch (current) {
                    case 59: {
                        this.match = "\u2245";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2794: {
                switch (current) {
                    case 105: {
                        this.state = 2795;
                        return true;
                    }
                }
                break;
            }
            case 2795: {
                switch (current) {
                    case 108: {
                        this.state = 2796;
                        return true;
                    }
                }
                break;
            }
            case 2796: {
                switch (current) {
                    case 100: {
                        this.state = 2797;
                        return true;
                    }
                }
                break;
            }
            case 2797: {
                switch (current) {
                    case 101: {
                        this.state = 2798;
                        return true;
                    }
                }
                break;
            }
            case 2798: {
                switch (current) {
                    case 59: {
                        this.match = "\u2248";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2799: {
                switch (current) {
                    case 112: {
                        this.state = 2800;
                        return true;
                    }
                }
                break;
            }
            case 2800: {
                switch (current) {
                    case 102: {
                        this.state = 2801;
                        return true;
                    }
                }
                break;
            }
            case 2801: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd4b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2802: {
                switch (current) {
                    case 105: {
                        this.state = 2803;
                        return true;
                    }
                }
                break;
            }
            case 2803: {
                switch (current) {
                    case 112: {
                        this.state = 2804;
                        return true;
                    }
                }
                break;
            }
            case 2804: {
                switch (current) {
                    case 108: {
                        this.state = 2805;
                        return true;
                    }
                }
                break;
            }
            case 2805: {
                switch (current) {
                    case 101: {
                        this.state = 2806;
                        return true;
                    }
                }
                break;
            }
            case 2806: {
                switch (current) {
                    case 68: {
                        this.state = 2807;
                        return true;
                    }
                }
                break;
            }
            case 2807: {
                switch (current) {
                    case 111: {
                        this.state = 2808;
                        return true;
                    }
                }
                break;
            }
            case 2808: {
                switch (current) {
                    case 116: {
                        this.state = 2809;
                        return true;
                    }
                }
                break;
            }
            case 2809: {
                switch (current) {
                    case 59: {
                        this.match = "\u20db";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2810: {
                switch (current) {
                    case 99: {
                        this.state = 2811;
                        return true;
                    }
                    case 116: {
                        this.state = 2813;
                        return true;
                    }
                }
                break;
            }
            case 2811: {
                switch (current) {
                    case 114: {
                        this.state = 2812;
                        return true;
                    }
                }
                break;
            }
            case 2812: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcaf";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2813: {
                switch (current) {
                    case 114: {
                        this.state = 2814;
                        return true;
                    }
                }
                break;
            }
            case 2814: {
                switch (current) {
                    case 111: {
                        this.state = 2815;
                        return true;
                    }
                }
                break;
            }
            case 2815: {
                switch (current) {
                    case 107: {
                        this.state = 2816;
                        return true;
                    }
                }
                break;
            }
            case 2816: {
                switch (current) {
                    case 59: {
                        this.match = "\u0166";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2817: {
                switch (current) {
                    case 97: {
                        this.state = 2818;
                        return true;
                    }
                    case 98: {
                        this.state = 2829;
                        return true;
                    }
                    case 99: {
                        this.state = 2836;
                        return true;
                    }
                    case 100: {
                        this.state = 2841;
                        return true;
                    }
                    case 102: {
                        this.state = 2846;
                        return true;
                    }
                    case 103: {
                        this.state = 2848;
                        return true;
                    }
                    case 109: {
                        this.state = 2853;
                        return true;
                    }
                    case 110: {
                        this.state = 2857;
                        return true;
                    }
                    case 111: {
                        this.state = 2889;
                        return true;
                    }
                    case 112: {
                        this.state = 2895;
                        return true;
                    }
                    case 114: {
                        this.state = 2982;
                        return true;
                    }
                    case 115: {
                        this.state = 2986;
                        return true;
                    }
                    case 116: {
                        this.state = 2989;
                        return true;
                    }
                    case 117: {
                        this.state = 2994;
                        return true;
                    }
                }
                break;
            }
            case 2818: {
                switch (current) {
                    case 99: {
                        this.state = 2819;
                        return true;
                    }
                    case 114: {
                        this.state = 2823;
                        return true;
                    }
                }
                break;
            }
            case 2819: {
                switch (current) {
                    case 117: {
                        this.state = 2820;
                        return true;
                    }
                }
                break;
            }
            case 2820: {
                switch (current) {
                    case 116: {
                        this.state = 2821;
                        return true;
                    }
                }
                break;
            }
            case 2821: {
                switch (current) {
                    case 101: {
                        this.match = "\u00da";
                        this.matchLength = this.consumedCount;
                        this.state = 2822;
                        return true;
                    }
                }
                break;
            }
            case 2822: {
                switch (current) {
                    case 59: {
                        this.match = "\u00da";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2823: {
                switch (current) {
                    case 114: {
                        this.state = 2824;
                        return true;
                    }
                }
                break;
            }
            case 2824: {
                switch (current) {
                    case 59: {
                        this.match = "\u219f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 111: {
                        this.state = 2825;
                        return true;
                    }
                }
                break;
            }
            case 2825: {
                switch (current) {
                    case 99: {
                        this.state = 2826;
                        return true;
                    }
                }
                break;
            }
            case 2826: {
                switch (current) {
                    case 105: {
                        this.state = 2827;
                        return true;
                    }
                }
                break;
            }
            case 2827: {
                switch (current) {
                    case 114: {
                        this.state = 2828;
                        return true;
                    }
                }
                break;
            }
            case 2828: {
                switch (current) {
                    case 59: {
                        this.match = "\u2949";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2829: {
                switch (current) {
                    case 114: {
                        this.state = 2830;
                        return true;
                    }
                }
                break;
            }
            case 2830: {
                switch (current) {
                    case 99: {
                        this.state = 2831;
                        return true;
                    }
                    case 101: {
                        this.state = 2833;
                        return true;
                    }
                }
                break;
            }
            case 2831: {
                switch (current) {
                    case 121: {
                        this.state = 2832;
                        return true;
                    }
                }
                break;
            }
            case 2832: {
                switch (current) {
                    case 59: {
                        this.match = "\u040e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2833: {
                switch (current) {
                    case 118: {
                        this.state = 2834;
                        return true;
                    }
                }
                break;
            }
            case 2834: {
                switch (current) {
                    case 101: {
                        this.state = 2835;
                        return true;
                    }
                }
                break;
            }
            case 2835: {
                switch (current) {
                    case 59: {
                        this.match = "\u016c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2836: {
                switch (current) {
                    case 105: {
                        this.state = 2837;
                        return true;
                    }
                    case 121: {
                        this.state = 2840;
                        return true;
                    }
                }
                break;
            }
            case 2837: {
                switch (current) {
                    case 114: {
                        this.state = 2838;
                        return true;
                    }
                }
                break;
            }
            case 2838: {
                switch (current) {
                    case 99: {
                        this.match = "\u00db";
                        this.matchLength = this.consumedCount;
                        this.state = 2839;
                        return true;
                    }
                }
                break;
            }
            case 2839: {
                switch (current) {
                    case 59: {
                        this.match = "\u00db";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2840: {
                switch (current) {
                    case 59: {
                        this.match = "\u0423";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2841: {
                switch (current) {
                    case 98: {
                        this.state = 2842;
                        return true;
                    }
                }
                break;
            }
            case 2842: {
                switch (current) {
                    case 108: {
                        this.state = 2843;
                        return true;
                    }
                }
                break;
            }
            case 2843: {
                switch (current) {
                    case 97: {
                        this.state = 2844;
                        return true;
                    }
                }
                break;
            }
            case 2844: {
                switch (current) {
                    case 99: {
                        this.state = 2845;
                        return true;
                    }
                }
                break;
            }
            case 2845: {
                switch (current) {
                    case 59: {
                        this.match = "\u0170";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2846: {
                switch (current) {
                    case 114: {
                        this.state = 2847;
                        return true;
                    }
                }
                break;
            }
            case 2847: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd18";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2848: {
                switch (current) {
                    case 114: {
                        this.state = 2849;
                        return true;
                    }
                }
                break;
            }
            case 2849: {
                switch (current) {
                    case 97: {
                        this.state = 2850;
                        return true;
                    }
                }
                break;
            }
            case 2850: {
                switch (current) {
                    case 118: {
                        this.state = 2851;
                        return true;
                    }
                }
                break;
            }
            case 2851: {
                switch (current) {
                    case 101: {
                        this.match = "\u00d9";
                        this.matchLength = this.consumedCount;
                        this.state = 2852;
                        return true;
                    }
                }
                break;
            }
            case 2852: {
                switch (current) {
                    case 59: {
                        this.match = "\u00d9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2853: {
                switch (current) {
                    case 97: {
                        this.state = 2854;
                        return true;
                    }
                }
                break;
            }
            case 2854: {
                switch (current) {
                    case 99: {
                        this.state = 2855;
                        return true;
                    }
                }
                break;
            }
            case 2855: {
                switch (current) {
                    case 114: {
                        this.state = 2856;
                        return true;
                    }
                }
                break;
            }
            case 2856: {
                switch (current) {
                    case 59: {
                        this.match = "\u016a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2857: {
                switch (current) {
                    case 100: {
                        this.state = 2858;
                        return true;
                    }
                    case 105: {
                        this.state = 2882;
                        return true;
                    }
                }
                break;
            }
            case 2858: {
                switch (current) {
                    case 101: {
                        this.state = 2859;
                        return true;
                    }
                }
                break;
            }
            case 2859: {
                switch (current) {
                    case 114: {
                        this.state = 2860;
                        return true;
                    }
                }
                break;
            }
            case 2860: {
                switch (current) {
                    case 66: {
                        this.state = 2861;
                        return true;
                    }
                    case 80: {
                        this.state = 2871;
                        return true;
                    }
                }
                break;
            }
            case 2861: {
                switch (current) {
                    case 97: {
                        this.state = 2862;
                        return true;
                    }
                    case 114: {
                        this.state = 2864;
                        return true;
                    }
                }
                break;
            }
            case 2862: {
                switch (current) {
                    case 114: {
                        this.state = 2863;
                        return true;
                    }
                }
                break;
            }
            case 2863: {
                switch (current) {
                    case 59: {
                        this.match = "_";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2864: {
                switch (current) {
                    case 97: {
                        this.state = 2865;
                        return true;
                    }
                }
                break;
            }
            case 2865: {
                switch (current) {
                    case 99: {
                        this.state = 2866;
                        return true;
                    }
                }
                break;
            }
            case 2866: {
                switch (current) {
                    case 101: {
                        this.state = 2867;
                        return true;
                    }
                    case 107: {
                        this.state = 2868;
                        return true;
                    }
                }
                break;
            }
            case 2867: {
                switch (current) {
                    case 59: {
                        this.match = "\u23df";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2868: {
                switch (current) {
                    case 101: {
                        this.state = 2869;
                        return true;
                    }
                }
                break;
            }
            case 2869: {
                switch (current) {
                    case 116: {
                        this.state = 2870;
                        return true;
                    }
                }
                break;
            }
            case 2870: {
                switch (current) {
                    case 59: {
                        this.match = "\u23b5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2871: {
                switch (current) {
                    case 97: {
                        this.state = 2872;
                        return true;
                    }
                }
                break;
            }
            case 2872: {
                switch (current) {
                    case 114: {
                        this.state = 2873;
                        return true;
                    }
                }
                break;
            }
            case 2873: {
                switch (current) {
                    case 101: {
                        this.state = 2874;
                        return true;
                    }
                }
                break;
            }
            case 2874: {
                switch (current) {
                    case 110: {
                        this.state = 2875;
                        return true;
                    }
                }
                break;
            }
            case 2875: {
                switch (current) {
                    case 116: {
                        this.state = 2876;
                        return true;
                    }
                }
                break;
            }
            case 2876: {
                switch (current) {
                    case 104: {
                        this.state = 2877;
                        return true;
                    }
                }
                break;
            }
            case 2877: {
                switch (current) {
                    case 101: {
                        this.state = 2878;
                        return true;
                    }
                }
                break;
            }
            case 2878: {
                switch (current) {
                    case 115: {
                        this.state = 2879;
                        return true;
                    }
                }
                break;
            }
            case 2879: {
                switch (current) {
                    case 105: {
                        this.state = 2880;
                        return true;
                    }
                }
                break;
            }
            case 2880: {
                switch (current) {
                    case 115: {
                        this.state = 2881;
                        return true;
                    }
                }
                break;
            }
            case 2881: {
                switch (current) {
                    case 59: {
                        this.match = "\u23dd";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2882: {
                switch (current) {
                    case 111: {
                        this.state = 2883;
                        return true;
                    }
                }
                break;
            }
            case 2883: {
                switch (current) {
                    case 110: {
                        this.state = 2884;
                        return true;
                    }
                }
                break;
            }
            case 2884: {
                switch (current) {
                    case 59: {
                        this.match = "\u22c3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 80: {
                        this.state = 2885;
                        return true;
                    }
                }
                break;
            }
            case 2885: {
                switch (current) {
                    case 108: {
                        this.state = 2886;
                        return true;
                    }
                }
                break;
            }
            case 2886: {
                switch (current) {
                    case 117: {
                        this.state = 2887;
                        return true;
                    }
                }
                break;
            }
            case 2887: {
                switch (current) {
                    case 115: {
                        this.state = 2888;
                        return true;
                    }
                }
                break;
            }
            case 2888: {
                switch (current) {
                    case 59: {
                        this.match = "\u228e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2889: {
                switch (current) {
                    case 103: {
                        this.state = 2890;
                        return true;
                    }
                    case 112: {
                        this.state = 2893;
                        return true;
                    }
                }
                break;
            }
            case 2890: {
                switch (current) {
                    case 111: {
                        this.state = 2891;
                        return true;
                    }
                }
                break;
            }
            case 2891: {
                switch (current) {
                    case 110: {
                        this.state = 2892;
                        return true;
                    }
                }
                break;
            }
            case 2892: {
                switch (current) {
                    case 59: {
                        this.match = "\u0172";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2893: {
                switch (current) {
                    case 102: {
                        this.state = 2894;
                        return true;
                    }
                }
                break;
            }
            case 2894: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd4c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2895: {
                switch (current) {
                    case 65: {
                        this.state = 2896;
                        return true;
                    }
                    case 68: {
                        this.state = 2913;
                        return true;
                    }
                    case 69: {
                        this.state = 2922;
                        return true;
                    }
                    case 84: {
                        this.state = 2933;
                        return true;
                    }
                    case 97: {
                        this.state = 2941;
                        return true;
                    }
                    case 100: {
                        this.state = 2946;
                        return true;
                    }
                    case 112: {
                        this.state = 2955;
                        return true;
                    }
                    case 115: {
                        this.state = 2977;
                        return true;
                    }
                }
                break;
            }
            case 2896: {
                switch (current) {
                    case 114: {
                        this.state = 2897;
                        return true;
                    }
                }
                break;
            }
            case 2897: {
                switch (current) {
                    case 114: {
                        this.state = 2898;
                        return true;
                    }
                }
                break;
            }
            case 2898: {
                switch (current) {
                    case 111: {
                        this.state = 2899;
                        return true;
                    }
                }
                break;
            }
            case 2899: {
                switch (current) {
                    case 119: {
                        this.state = 2900;
                        return true;
                    }
                }
                break;
            }
            case 2900: {
                switch (current) {
                    case 59: {
                        this.match = "\u2191";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 66: {
                        this.state = 2901;
                        return true;
                    }
                    case 68: {
                        this.state = 2904;
                        return true;
                    }
                }
                break;
            }
            case 2901: {
                switch (current) {
                    case 97: {
                        this.state = 2902;
                        return true;
                    }
                }
                break;
            }
            case 2902: {
                switch (current) {
                    case 114: {
                        this.state = 2903;
                        return true;
                    }
                }
                break;
            }
            case 2903: {
                switch (current) {
                    case 59: {
                        this.match = "\u2912";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2904: {
                switch (current) {
                    case 111: {
                        this.state = 2905;
                        return true;
                    }
                }
                break;
            }
            case 2905: {
                switch (current) {
                    case 119: {
                        this.state = 2906;
                        return true;
                    }
                }
                break;
            }
            case 2906: {
                switch (current) {
                    case 110: {
                        this.state = 2907;
                        return true;
                    }
                }
                break;
            }
            case 2907: {
                switch (current) {
                    case 65: {
                        this.state = 2908;
                        return true;
                    }
                }
                break;
            }
            case 2908: {
                switch (current) {
                    case 114: {
                        this.state = 2909;
                        return true;
                    }
                }
                break;
            }
            case 2909: {
                switch (current) {
                    case 114: {
                        this.state = 2910;
                        return true;
                    }
                }
                break;
            }
            case 2910: {
                switch (current) {
                    case 111: {
                        this.state = 2911;
                        return true;
                    }
                }
                break;
            }
            case 2911: {
                switch (current) {
                    case 119: {
                        this.state = 2912;
                        return true;
                    }
                }
                break;
            }
            case 2912: {
                switch (current) {
                    case 59: {
                        this.match = "\u21c5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2913: {
                switch (current) {
                    case 111: {
                        this.state = 2914;
                        return true;
                    }
                }
                break;
            }
            case 2914: {
                switch (current) {
                    case 119: {
                        this.state = 2915;
                        return true;
                    }
                }
                break;
            }
            case 2915: {
                switch (current) {
                    case 110: {
                        this.state = 2916;
                        return true;
                    }
                }
                break;
            }
            case 2916: {
                switch (current) {
                    case 65: {
                        this.state = 2917;
                        return true;
                    }
                }
                break;
            }
            case 2917: {
                switch (current) {
                    case 114: {
                        this.state = 2918;
                        return true;
                    }
                }
                break;
            }
            case 2918: {
                switch (current) {
                    case 114: {
                        this.state = 2919;
                        return true;
                    }
                }
                break;
            }
            case 2919: {
                switch (current) {
                    case 111: {
                        this.state = 2920;
                        return true;
                    }
                }
                break;
            }
            case 2920: {
                switch (current) {
                    case 119: {
                        this.state = 2921;
                        return true;
                    }
                }
                break;
            }
            case 2921: {
                switch (current) {
                    case 59: {
                        this.match = "\u2195";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2922: {
                switch (current) {
                    case 113: {
                        this.state = 2923;
                        return true;
                    }
                }
                break;
            }
            case 2923: {
                switch (current) {
                    case 117: {
                        this.state = 2924;
                        return true;
                    }
                }
                break;
            }
            case 2924: {
                switch (current) {
                    case 105: {
                        this.state = 2925;
                        return true;
                    }
                }
                break;
            }
            case 2925: {
                switch (current) {
                    case 108: {
                        this.state = 2926;
                        return true;
                    }
                }
                break;
            }
            case 2926: {
                switch (current) {
                    case 105: {
                        this.state = 2927;
                        return true;
                    }
                }
                break;
            }
            case 2927: {
                switch (current) {
                    case 98: {
                        this.state = 2928;
                        return true;
                    }
                }
                break;
            }
            case 2928: {
                switch (current) {
                    case 114: {
                        this.state = 2929;
                        return true;
                    }
                }
                break;
            }
            case 2929: {
                switch (current) {
                    case 105: {
                        this.state = 2930;
                        return true;
                    }
                }
                break;
            }
            case 2930: {
                switch (current) {
                    case 117: {
                        this.state = 2931;
                        return true;
                    }
                }
                break;
            }
            case 2931: {
                switch (current) {
                    case 109: {
                        this.state = 2932;
                        return true;
                    }
                }
                break;
            }
            case 2932: {
                switch (current) {
                    case 59: {
                        this.match = "\u296e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2933: {
                switch (current) {
                    case 101: {
                        this.state = 2934;
                        return true;
                    }
                }
                break;
            }
            case 2934: {
                switch (current) {
                    case 101: {
                        this.state = 2935;
                        return true;
                    }
                }
                break;
            }
            case 2935: {
                switch (current) {
                    case 59: {
                        this.match = "\u22a5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 65: {
                        this.state = 2936;
                        return true;
                    }
                }
                break;
            }
            case 2936: {
                switch (current) {
                    case 114: {
                        this.state = 2937;
                        return true;
                    }
                }
                break;
            }
            case 2937: {
                switch (current) {
                    case 114: {
                        this.state = 2938;
                        return true;
                    }
                }
                break;
            }
            case 2938: {
                switch (current) {
                    case 111: {
                        this.state = 2939;
                        return true;
                    }
                }
                break;
            }
            case 2939: {
                switch (current) {
                    case 119: {
                        this.state = 2940;
                        return true;
                    }
                }
                break;
            }
            case 2940: {
                switch (current) {
                    case 59: {
                        this.match = "\u21a5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2941: {
                switch (current) {
                    case 114: {
                        this.state = 2942;
                        return true;
                    }
                }
                break;
            }
            case 2942: {
                switch (current) {
                    case 114: {
                        this.state = 2943;
                        return true;
                    }
                }
                break;
            }
            case 2943: {
                switch (current) {
                    case 111: {
                        this.state = 2944;
                        return true;
                    }
                }
                break;
            }
            case 2944: {
                switch (current) {
                    case 119: {
                        this.state = 2945;
                        return true;
                    }
                }
                break;
            }
            case 2945: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2946: {
                switch (current) {
                    case 111: {
                        this.state = 2947;
                        return true;
                    }
                }
                break;
            }
            case 2947: {
                switch (current) {
                    case 119: {
                        this.state = 2948;
                        return true;
                    }
                }
                break;
            }
            case 2948: {
                switch (current) {
                    case 110: {
                        this.state = 2949;
                        return true;
                    }
                }
                break;
            }
            case 2949: {
                switch (current) {
                    case 97: {
                        this.state = 2950;
                        return true;
                    }
                }
                break;
            }
            case 2950: {
                switch (current) {
                    case 114: {
                        this.state = 2951;
                        return true;
                    }
                }
                break;
            }
            case 2951: {
                switch (current) {
                    case 114: {
                        this.state = 2952;
                        return true;
                    }
                }
                break;
            }
            case 2952: {
                switch (current) {
                    case 111: {
                        this.state = 2953;
                        return true;
                    }
                }
                break;
            }
            case 2953: {
                switch (current) {
                    case 119: {
                        this.state = 2954;
                        return true;
                    }
                }
                break;
            }
            case 2954: {
                switch (current) {
                    case 59: {
                        this.match = "\u21d5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2955: {
                switch (current) {
                    case 101: {
                        this.state = 2956;
                        return true;
                    }
                }
                break;
            }
            case 2956: {
                switch (current) {
                    case 114: {
                        this.state = 2957;
                        return true;
                    }
                }
                break;
            }
            case 2957: {
                switch (current) {
                    case 76: {
                        this.state = 2958;
                        return true;
                    }
                    case 82: {
                        this.state = 2967;
                        return true;
                    }
                }
                break;
            }
            case 2958: {
                switch (current) {
                    case 101: {
                        this.state = 2959;
                        return true;
                    }
                }
                break;
            }
            case 2959: {
                switch (current) {
                    case 102: {
                        this.state = 2960;
                        return true;
                    }
                }
                break;
            }
            case 2960: {
                switch (current) {
                    case 116: {
                        this.state = 2961;
                        return true;
                    }
                }
                break;
            }
            case 2961: {
                switch (current) {
                    case 65: {
                        this.state = 2962;
                        return true;
                    }
                }
                break;
            }
            case 2962: {
                switch (current) {
                    case 114: {
                        this.state = 2963;
                        return true;
                    }
                }
                break;
            }
            case 2963: {
                switch (current) {
                    case 114: {
                        this.state = 2964;
                        return true;
                    }
                }
                break;
            }
            case 2964: {
                switch (current) {
                    case 111: {
                        this.state = 2965;
                        return true;
                    }
                }
                break;
            }
            case 2965: {
                switch (current) {
                    case 119: {
                        this.state = 2966;
                        return true;
                    }
                }
                break;
            }
            case 2966: {
                switch (current) {
                    case 59: {
                        this.match = "\u2196";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2967: {
                switch (current) {
                    case 105: {
                        this.state = 2968;
                        return true;
                    }
                }
                break;
            }
            case 2968: {
                switch (current) {
                    case 103: {
                        this.state = 2969;
                        return true;
                    }
                }
                break;
            }
            case 2969: {
                switch (current) {
                    case 104: {
                        this.state = 2970;
                        return true;
                    }
                }
                break;
            }
            case 2970: {
                switch (current) {
                    case 116: {
                        this.state = 2971;
                        return true;
                    }
                }
                break;
            }
            case 2971: {
                switch (current) {
                    case 65: {
                        this.state = 2972;
                        return true;
                    }
                }
                break;
            }
            case 2972: {
                switch (current) {
                    case 114: {
                        this.state = 2973;
                        return true;
                    }
                }
                break;
            }
            case 2973: {
                switch (current) {
                    case 114: {
                        this.state = 2974;
                        return true;
                    }
                }
                break;
            }
            case 2974: {
                switch (current) {
                    case 111: {
                        this.state = 2975;
                        return true;
                    }
                }
                break;
            }
            case 2975: {
                switch (current) {
                    case 119: {
                        this.state = 2976;
                        return true;
                    }
                }
                break;
            }
            case 2976: {
                switch (current) {
                    case 59: {
                        this.match = "\u2197";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2977: {
                switch (current) {
                    case 105: {
                        this.state = 2978;
                        return true;
                    }
                }
                break;
            }
            case 2978: {
                switch (current) {
                    case 59: {
                        this.match = "\u03d2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 108: {
                        this.state = 2979;
                        return true;
                    }
                }
                break;
            }
            case 2979: {
                switch (current) {
                    case 111: {
                        this.state = 2980;
                        return true;
                    }
                }
                break;
            }
            case 2980: {
                switch (current) {
                    case 110: {
                        this.state = 2981;
                        return true;
                    }
                }
                break;
            }
            case 2981: {
                switch (current) {
                    case 59: {
                        this.match = "\u03a5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2982: {
                switch (current) {
                    case 105: {
                        this.state = 2983;
                        return true;
                    }
                }
                break;
            }
            case 2983: {
                switch (current) {
                    case 110: {
                        this.state = 2984;
                        return true;
                    }
                }
                break;
            }
            case 2984: {
                switch (current) {
                    case 103: {
                        this.state = 2985;
                        return true;
                    }
                }
                break;
            }
            case 2985: {
                switch (current) {
                    case 59: {
                        this.match = "\u016e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2986: {
                switch (current) {
                    case 99: {
                        this.state = 2987;
                        return true;
                    }
                }
                break;
            }
            case 2987: {
                switch (current) {
                    case 114: {
                        this.state = 2988;
                        return true;
                    }
                }
                break;
            }
            case 2988: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcb0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2989: {
                switch (current) {
                    case 105: {
                        this.state = 2990;
                        return true;
                    }
                }
                break;
            }
            case 2990: {
                switch (current) {
                    case 108: {
                        this.state = 2991;
                        return true;
                    }
                }
                break;
            }
            case 2991: {
                switch (current) {
                    case 100: {
                        this.state = 2992;
                        return true;
                    }
                }
                break;
            }
            case 2992: {
                switch (current) {
                    case 101: {
                        this.state = 2993;
                        return true;
                    }
                }
                break;
            }
            case 2993: {
                switch (current) {
                    case 59: {
                        this.match = "\u0168";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2994: {
                switch (current) {
                    case 109: {
                        this.state = 2995;
                        return true;
                    }
                }
                break;
            }
            case 2995: {
                switch (current) {
                    case 108: {
                        this.match = "\u00dc";
                        this.matchLength = this.consumedCount;
                        this.state = 2996;
                        return true;
                    }
                }
                break;
            }
            case 2996: {
                switch (current) {
                    case 59: {
                        this.match = "\u00dc";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 2997: {
                switch (current) {
                    case 68: {
                        this.state = 2998;
                        return true;
                    }
                    case 98: {
                        this.state = 3002;
                        return true;
                    }
                    case 99: {
                        this.state = 3005;
                        return true;
                    }
                    case 100: {
                        this.state = 3007;
                        return true;
                    }
                    case 101: {
                        this.state = 3012;
                        return true;
                    }
                    case 102: {
                        this.state = 3054;
                        return true;
                    }
                    case 111: {
                        this.state = 3056;
                        return true;
                    }
                    case 115: {
                        this.state = 3059;
                        return true;
                    }
                    case 118: {
                        this.state = 3062;
                        return true;
                    }
                }
                break;
            }
            case 2998: {
                switch (current) {
                    case 97: {
                        this.state = 2999;
                        return true;
                    }
                }
                break;
            }
            case 2999: {
                switch (current) {
                    case 115: {
                        this.state = 3000;
                        return true;
                    }
                }
                break;
            }
        }
        return false;
    }

    private boolean parse4(int current) {
        ++this.consumedCount;
        switch (this.state) {
            case 3000: {
                switch (current) {
                    case 104: {
                        this.state = 3001;
                        return true;
                    }
                }
                break;
            }
            case 3001: {
                switch (current) {
                    case 59: {
                        this.match = "\u22ab";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3002: {
                switch (current) {
                    case 97: {
                        this.state = 3003;
                        return true;
                    }
                }
                break;
            }
            case 3003: {
                switch (current) {
                    case 114: {
                        this.state = 3004;
                        return true;
                    }
                }
                break;
            }
            case 3004: {
                switch (current) {
                    case 59: {
                        this.match = "\u2aeb";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3005: {
                switch (current) {
                    case 121: {
                        this.state = 3006;
                        return true;
                    }
                }
                break;
            }
            case 3006: {
                switch (current) {
                    case 59: {
                        this.match = "\u0412";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3007: {
                switch (current) {
                    case 97: {
                        this.state = 3008;
                        return true;
                    }
                }
                break;
            }
            case 3008: {
                switch (current) {
                    case 115: {
                        this.state = 3009;
                        return true;
                    }
                }
                break;
            }
            case 3009: {
                switch (current) {
                    case 104: {
                        this.state = 3010;
                        return true;
                    }
                }
                break;
            }
            case 3010: {
                switch (current) {
                    case 59: {
                        this.match = "\u22a9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 108: {
                        this.state = 3011;
                        return true;
                    }
                }
                break;
            }
            case 3011: {
                switch (current) {
                    case 59: {
                        this.match = "\u2ae6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3012: {
                switch (current) {
                    case 101: {
                        this.state = 3013;
                        return true;
                    }
                    case 114: {
                        this.state = 3014;
                        return true;
                    }
                }
                break;
            }
            case 3013: {
                switch (current) {
                    case 59: {
                        this.match = "\u22c1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3014: {
                switch (current) {
                    case 98: {
                        this.state = 3015;
                        return true;
                    }
                    case 116: {
                        this.state = 3018;
                        return true;
                    }
                    case 121: {
                        this.state = 3044;
                        return true;
                    }
                }
                break;
            }
            case 3015: {
                switch (current) {
                    case 97: {
                        this.state = 3016;
                        return true;
                    }
                }
                break;
            }
            case 3016: {
                switch (current) {
                    case 114: {
                        this.state = 3017;
                        return true;
                    }
                }
                break;
            }
            case 3017: {
                switch (current) {
                    case 59: {
                        this.match = "\u2016";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3018: {
                switch (current) {
                    case 59: {
                        this.match = "\u2016";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 105: {
                        this.state = 3019;
                        return true;
                    }
                }
                break;
            }
            case 3019: {
                switch (current) {
                    case 99: {
                        this.state = 3020;
                        return true;
                    }
                }
                break;
            }
            case 3020: {
                switch (current) {
                    case 97: {
                        this.state = 3021;
                        return true;
                    }
                }
                break;
            }
            case 3021: {
                switch (current) {
                    case 108: {
                        this.state = 3022;
                        return true;
                    }
                }
                break;
            }
            case 3022: {
                switch (current) {
                    case 66: {
                        this.state = 3023;
                        return true;
                    }
                    case 76: {
                        this.state = 3026;
                        return true;
                    }
                    case 83: {
                        this.state = 3030;
                        return true;
                    }
                    case 84: {
                        this.state = 3039;
                        return true;
                    }
                }
                break;
            }
            case 3023: {
                switch (current) {
                    case 97: {
                        this.state = 3024;
                        return true;
                    }
                }
                break;
            }
            case 3024: {
                switch (current) {
                    case 114: {
                        this.state = 3025;
                        return true;
                    }
                }
                break;
            }
            case 3025: {
                switch (current) {
                    case 59: {
                        this.match = "\u2223";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3026: {
                switch (current) {
                    case 105: {
                        this.state = 3027;
                        return true;
                    }
                }
                break;
            }
            case 3027: {
                switch (current) {
                    case 110: {
                        this.state = 3028;
                        return true;
                    }
                }
                break;
            }
            case 3028: {
                switch (current) {
                    case 101: {
                        this.state = 3029;
                        return true;
                    }
                }
                break;
            }
            case 3029: {
                switch (current) {
                    case 59: {
                        this.match = "|";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3030: {
                switch (current) {
                    case 101: {
                        this.state = 3031;
                        return true;
                    }
                }
                break;
            }
            case 3031: {
                switch (current) {
                    case 112: {
                        this.state = 3032;
                        return true;
                    }
                }
                break;
            }
            case 3032: {
                switch (current) {
                    case 97: {
                        this.state = 3033;
                        return true;
                    }
                }
                break;
            }
            case 3033: {
                switch (current) {
                    case 114: {
                        this.state = 3034;
                        return true;
                    }
                }
                break;
            }
            case 3034: {
                switch (current) {
                    case 97: {
                        this.state = 3035;
                        return true;
                    }
                }
                break;
            }
            case 3035: {
                switch (current) {
                    case 116: {
                        this.state = 3036;
                        return true;
                    }
                }
                break;
            }
            case 3036: {
                switch (current) {
                    case 111: {
                        this.state = 3037;
                        return true;
                    }
                }
                break;
            }
            case 3037: {
                switch (current) {
                    case 114: {
                        this.state = 3038;
                        return true;
                    }
                }
                break;
            }
            case 3038: {
                switch (current) {
                    case 59: {
                        this.match = "\u2758";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3039: {
                switch (current) {
                    case 105: {
                        this.state = 3040;
                        return true;
                    }
                }
                break;
            }
            case 3040: {
                switch (current) {
                    case 108: {
                        this.state = 3041;
                        return true;
                    }
                }
                break;
            }
            case 3041: {
                switch (current) {
                    case 100: {
                        this.state = 3042;
                        return true;
                    }
                }
                break;
            }
            case 3042: {
                switch (current) {
                    case 101: {
                        this.state = 3043;
                        return true;
                    }
                }
                break;
            }
            case 3043: {
                switch (current) {
                    case 59: {
                        this.match = "\u2240";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3044: {
                switch (current) {
                    case 84: {
                        this.state = 3045;
                        return true;
                    }
                }
                break;
            }
            case 3045: {
                switch (current) {
                    case 104: {
                        this.state = 3046;
                        return true;
                    }
                }
                break;
            }
            case 3046: {
                switch (current) {
                    case 105: {
                        this.state = 3047;
                        return true;
                    }
                }
                break;
            }
            case 3047: {
                switch (current) {
                    case 110: {
                        this.state = 3048;
                        return true;
                    }
                }
                break;
            }
            case 3048: {
                switch (current) {
                    case 83: {
                        this.state = 3049;
                        return true;
                    }
                }
                break;
            }
            case 3049: {
                switch (current) {
                    case 112: {
                        this.state = 3050;
                        return true;
                    }
                }
                break;
            }
            case 3050: {
                switch (current) {
                    case 97: {
                        this.state = 3051;
                        return true;
                    }
                }
                break;
            }
            case 3051: {
                switch (current) {
                    case 99: {
                        this.state = 3052;
                        return true;
                    }
                }
                break;
            }
            case 3052: {
                switch (current) {
                    case 101: {
                        this.state = 3053;
                        return true;
                    }
                }
                break;
            }
            case 3053: {
                switch (current) {
                    case 59: {
                        this.match = "\u200a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3054: {
                switch (current) {
                    case 114: {
                        this.state = 3055;
                        return true;
                    }
                }
                break;
            }
            case 3055: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd19";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3056: {
                switch (current) {
                    case 112: {
                        this.state = 3057;
                        return true;
                    }
                }
                break;
            }
            case 3057: {
                switch (current) {
                    case 102: {
                        this.state = 3058;
                        return true;
                    }
                }
                break;
            }
            case 3058: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd4d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3059: {
                switch (current) {
                    case 99: {
                        this.state = 3060;
                        return true;
                    }
                }
                break;
            }
            case 3060: {
                switch (current) {
                    case 114: {
                        this.state = 3061;
                        return true;
                    }
                }
                break;
            }
            case 3061: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcb1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3062: {
                switch (current) {
                    case 100: {
                        this.state = 3063;
                        return true;
                    }
                }
                break;
            }
            case 3063: {
                switch (current) {
                    case 97: {
                        this.state = 3064;
                        return true;
                    }
                }
                break;
            }
            case 3064: {
                switch (current) {
                    case 115: {
                        this.state = 3065;
                        return true;
                    }
                }
                break;
            }
            case 3065: {
                switch (current) {
                    case 104: {
                        this.state = 3066;
                        return true;
                    }
                }
                break;
            }
            case 3066: {
                switch (current) {
                    case 59: {
                        this.match = "\u22aa";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3067: {
                switch (current) {
                    case 99: {
                        this.state = 3068;
                        return true;
                    }
                    case 101: {
                        this.state = 3072;
                        return true;
                    }
                    case 102: {
                        this.state = 3076;
                        return true;
                    }
                    case 111: {
                        this.state = 3078;
                        return true;
                    }
                    case 115: {
                        this.state = 3081;
                        return true;
                    }
                }
                break;
            }
            case 3068: {
                switch (current) {
                    case 105: {
                        this.state = 3069;
                        return true;
                    }
                }
                break;
            }
            case 3069: {
                switch (current) {
                    case 114: {
                        this.state = 3070;
                        return true;
                    }
                }
                break;
            }
            case 3070: {
                switch (current) {
                    case 99: {
                        this.state = 3071;
                        return true;
                    }
                }
                break;
            }
            case 3071: {
                switch (current) {
                    case 59: {
                        this.match = "\u0174";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3072: {
                switch (current) {
                    case 100: {
                        this.state = 3073;
                        return true;
                    }
                }
                break;
            }
            case 3073: {
                switch (current) {
                    case 103: {
                        this.state = 3074;
                        return true;
                    }
                }
                break;
            }
            case 3074: {
                switch (current) {
                    case 101: {
                        this.state = 3075;
                        return true;
                    }
                }
                break;
            }
            case 3075: {
                switch (current) {
                    case 59: {
                        this.match = "\u22c0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3076: {
                switch (current) {
                    case 114: {
                        this.state = 3077;
                        return true;
                    }
                }
                break;
            }
            case 3077: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd1a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3078: {
                switch (current) {
                    case 112: {
                        this.state = 3079;
                        return true;
                    }
                }
                break;
            }
            case 3079: {
                switch (current) {
                    case 102: {
                        this.state = 3080;
                        return true;
                    }
                }
                break;
            }
            case 3080: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd4e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3081: {
                switch (current) {
                    case 99: {
                        this.state = 3082;
                        return true;
                    }
                }
                break;
            }
            case 3082: {
                switch (current) {
                    case 114: {
                        this.state = 3083;
                        return true;
                    }
                }
                break;
            }
            case 3083: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcb2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3084: {
                switch (current) {
                    case 102: {
                        this.state = 3085;
                        return true;
                    }
                    case 105: {
                        this.state = 3087;
                        return true;
                    }
                    case 111: {
                        this.state = 3088;
                        return true;
                    }
                    case 115: {
                        this.state = 3091;
                        return true;
                    }
                }
                break;
            }
            case 3085: {
                switch (current) {
                    case 114: {
                        this.state = 3086;
                        return true;
                    }
                }
                break;
            }
            case 3086: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd1b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3087: {
                switch (current) {
                    case 59: {
                        this.match = "\u039e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3088: {
                switch (current) {
                    case 112: {
                        this.state = 3089;
                        return true;
                    }
                }
                break;
            }
            case 3089: {
                switch (current) {
                    case 102: {
                        this.state = 3090;
                        return true;
                    }
                }
                break;
            }
            case 3090: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd4f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3091: {
                switch (current) {
                    case 99: {
                        this.state = 3092;
                        return true;
                    }
                }
                break;
            }
            case 3092: {
                switch (current) {
                    case 114: {
                        this.state = 3093;
                        return true;
                    }
                }
                break;
            }
            case 3093: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcb3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3094: {
                switch (current) {
                    case 65: {
                        this.state = 3095;
                        return true;
                    }
                    case 73: {
                        this.state = 3098;
                        return true;
                    }
                    case 85: {
                        this.state = 3101;
                        return true;
                    }
                    case 97: {
                        this.state = 3104;
                        return true;
                    }
                    case 99: {
                        this.state = 3109;
                        return true;
                    }
                    case 102: {
                        this.state = 3114;
                        return true;
                    }
                    case 111: {
                        this.state = 3116;
                        return true;
                    }
                    case 115: {
                        this.state = 3119;
                        return true;
                    }
                    case 117: {
                        this.state = 3122;
                        return true;
                    }
                }
                break;
            }
            case 3095: {
                switch (current) {
                    case 99: {
                        this.state = 3096;
                        return true;
                    }
                }
                break;
            }
            case 3096: {
                switch (current) {
                    case 121: {
                        this.state = 3097;
                        return true;
                    }
                }
                break;
            }
            case 3097: {
                switch (current) {
                    case 59: {
                        this.match = "\u042f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3098: {
                switch (current) {
                    case 99: {
                        this.state = 3099;
                        return true;
                    }
                }
                break;
            }
            case 3099: {
                switch (current) {
                    case 121: {
                        this.state = 3100;
                        return true;
                    }
                }
                break;
            }
            case 3100: {
                switch (current) {
                    case 59: {
                        this.match = "\u0407";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3101: {
                switch (current) {
                    case 99: {
                        this.state = 3102;
                        return true;
                    }
                }
                break;
            }
            case 3102: {
                switch (current) {
                    case 121: {
                        this.state = 3103;
                        return true;
                    }
                }
                break;
            }
            case 3103: {
                switch (current) {
                    case 59: {
                        this.match = "\u042e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3104: {
                switch (current) {
                    case 99: {
                        this.state = 3105;
                        return true;
                    }
                }
                break;
            }
            case 3105: {
                switch (current) {
                    case 117: {
                        this.state = 3106;
                        return true;
                    }
                }
                break;
            }
            case 3106: {
                switch (current) {
                    case 116: {
                        this.state = 3107;
                        return true;
                    }
                }
                break;
            }
            case 3107: {
                switch (current) {
                    case 101: {
                        this.match = "\u00dd";
                        this.matchLength = this.consumedCount;
                        this.state = 3108;
                        return true;
                    }
                }
                break;
            }
            case 3108: {
                switch (current) {
                    case 59: {
                        this.match = "\u00dd";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3109: {
                switch (current) {
                    case 105: {
                        this.state = 3110;
                        return true;
                    }
                    case 121: {
                        this.state = 3113;
                        return true;
                    }
                }
                break;
            }
            case 3110: {
                switch (current) {
                    case 114: {
                        this.state = 3111;
                        return true;
                    }
                }
                break;
            }
            case 3111: {
                switch (current) {
                    case 99: {
                        this.state = 3112;
                        return true;
                    }
                }
                break;
            }
            case 3112: {
                switch (current) {
                    case 59: {
                        this.match = "\u0176";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3113: {
                switch (current) {
                    case 59: {
                        this.match = "\u042b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3114: {
                switch (current) {
                    case 114: {
                        this.state = 3115;
                        return true;
                    }
                }
                break;
            }
            case 3115: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd1c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3116: {
                switch (current) {
                    case 112: {
                        this.state = 3117;
                        return true;
                    }
                }
                break;
            }
            case 3117: {
                switch (current) {
                    case 102: {
                        this.state = 3118;
                        return true;
                    }
                }
                break;
            }
            case 3118: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd50";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3119: {
                switch (current) {
                    case 99: {
                        this.state = 3120;
                        return true;
                    }
                }
                break;
            }
            case 3120: {
                switch (current) {
                    case 114: {
                        this.state = 3121;
                        return true;
                    }
                }
                break;
            }
            case 3121: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcb4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3122: {
                switch (current) {
                    case 109: {
                        this.state = 3123;
                        return true;
                    }
                }
                break;
            }
            case 3123: {
                switch (current) {
                    case 108: {
                        this.state = 3124;
                        return true;
                    }
                }
                break;
            }
            case 3124: {
                switch (current) {
                    case 59: {
                        this.match = "\u0178";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3125: {
                switch (current) {
                    case 72: {
                        this.state = 3126;
                        return true;
                    }
                    case 97: {
                        this.state = 3129;
                        return true;
                    }
                    case 99: {
                        this.state = 3134;
                        return true;
                    }
                    case 100: {
                        this.state = 3140;
                        return true;
                    }
                    case 101: {
                        this.state = 3143;
                        return true;
                    }
                    case 102: {
                        this.state = 3158;
                        return true;
                    }
                    case 111: {
                        this.state = 3160;
                        return true;
                    }
                    case 115: {
                        this.state = 3163;
                        return true;
                    }
                }
                break;
            }
            case 3126: {
                switch (current) {
                    case 99: {
                        this.state = 3127;
                        return true;
                    }
                }
                break;
            }
            case 3127: {
                switch (current) {
                    case 121: {
                        this.state = 3128;
                        return true;
                    }
                }
                break;
            }
            case 3128: {
                switch (current) {
                    case 59: {
                        this.match = "\u0416";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3129: {
                switch (current) {
                    case 99: {
                        this.state = 3130;
                        return true;
                    }
                }
                break;
            }
            case 3130: {
                switch (current) {
                    case 117: {
                        this.state = 3131;
                        return true;
                    }
                }
                break;
            }
            case 3131: {
                switch (current) {
                    case 116: {
                        this.state = 3132;
                        return true;
                    }
                }
                break;
            }
            case 3132: {
                switch (current) {
                    case 101: {
                        this.state = 3133;
                        return true;
                    }
                }
                break;
            }
            case 3133: {
                switch (current) {
                    case 59: {
                        this.match = "\u0179";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3134: {
                switch (current) {
                    case 97: {
                        this.state = 3135;
                        return true;
                    }
                    case 121: {
                        this.state = 3139;
                        return true;
                    }
                }
                break;
            }
            case 3135: {
                switch (current) {
                    case 114: {
                        this.state = 3136;
                        return true;
                    }
                }
                break;
            }
            case 3136: {
                switch (current) {
                    case 111: {
                        this.state = 3137;
                        return true;
                    }
                }
                break;
            }
            case 3137: {
                switch (current) {
                    case 110: {
                        this.state = 3138;
                        return true;
                    }
                }
                break;
            }
            case 3138: {
                switch (current) {
                    case 59: {
                        this.match = "\u017d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3139: {
                switch (current) {
                    case 59: {
                        this.match = "\u0417";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3140: {
                switch (current) {
                    case 111: {
                        this.state = 3141;
                        return true;
                    }
                }
                break;
            }
            case 3141: {
                switch (current) {
                    case 116: {
                        this.state = 3142;
                        return true;
                    }
                }
                break;
            }
            case 3142: {
                switch (current) {
                    case 59: {
                        this.match = "\u017b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3143: {
                switch (current) {
                    case 114: {
                        this.state = 3144;
                        return true;
                    }
                    case 116: {
                        this.state = 3156;
                        return true;
                    }
                }
                break;
            }
            case 3144: {
                switch (current) {
                    case 111: {
                        this.state = 3145;
                        return true;
                    }
                }
                break;
            }
            case 3145: {
                switch (current) {
                    case 87: {
                        this.state = 3146;
                        return true;
                    }
                }
                break;
            }
            case 3146: {
                switch (current) {
                    case 105: {
                        this.state = 3147;
                        return true;
                    }
                }
                break;
            }
            case 3147: {
                switch (current) {
                    case 100: {
                        this.state = 3148;
                        return true;
                    }
                }
                break;
            }
            case 3148: {
                switch (current) {
                    case 116: {
                        this.state = 3149;
                        return true;
                    }
                }
                break;
            }
            case 3149: {
                switch (current) {
                    case 104: {
                        this.state = 3150;
                        return true;
                    }
                }
                break;
            }
            case 3150: {
                switch (current) {
                    case 83: {
                        this.state = 3151;
                        return true;
                    }
                }
                break;
            }
            case 3151: {
                switch (current) {
                    case 112: {
                        this.state = 3152;
                        return true;
                    }
                }
                break;
            }
            case 3152: {
                switch (current) {
                    case 97: {
                        this.state = 3153;
                        return true;
                    }
                }
                break;
            }
            case 3153: {
                switch (current) {
                    case 99: {
                        this.state = 3154;
                        return true;
                    }
                }
                break;
            }
            case 3154: {
                switch (current) {
                    case 101: {
                        this.state = 3155;
                        return true;
                    }
                }
                break;
            }
            case 3155: {
                switch (current) {
                    case 59: {
                        this.match = "\u200b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3156: {
                switch (current) {
                    case 97: {
                        this.state = 3157;
                        return true;
                    }
                }
                break;
            }
            case 3157: {
                switch (current) {
                    case 59: {
                        this.match = "\u0396";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3158: {
                switch (current) {
                    case 114: {
                        this.state = 3159;
                        return true;
                    }
                }
                break;
            }
            case 3159: {
                switch (current) {
                    case 59: {
                        this.match = "\u2128";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3160: {
                switch (current) {
                    case 112: {
                        this.state = 3161;
                        return true;
                    }
                }
                break;
            }
            case 3161: {
                switch (current) {
                    case 102: {
                        this.state = 3162;
                        return true;
                    }
                }
                break;
            }
            case 3162: {
                switch (current) {
                    case 59: {
                        this.match = "\u2124";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3163: {
                switch (current) {
                    case 99: {
                        this.state = 3164;
                        return true;
                    }
                }
                break;
            }
            case 3164: {
                switch (current) {
                    case 114: {
                        this.state = 3165;
                        return true;
                    }
                }
                break;
            }
            case 3165: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcb5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3166: {
                switch (current) {
                    case 97: {
                        this.state = 3167;
                        return true;
                    }
                    case 98: {
                        this.state = 3172;
                        return true;
                    }
                    case 99: {
                        this.state = 3177;
                        return true;
                    }
                    case 101: {
                        this.state = 3187;
                        return true;
                    }
                    case 102: {
                        this.state = 3191;
                        return true;
                    }
                    case 103: {
                        this.state = 3193;
                        return true;
                    }
                    case 108: {
                        this.state = 3198;
                        return true;
                    }
                    case 109: {
                        this.state = 3209;
                        return true;
                    }
                    case 110: {
                        this.state = 3216;
                        return true;
                    }
                    case 111: {
                        this.state = 3257;
                        return true;
                    }
                    case 112: {
                        this.state = 3263;
                        return true;
                    }
                    case 114: {
                        this.state = 3280;
                        return true;
                    }
                    case 115: {
                        this.state = 3284;
                        return true;
                    }
                    case 116: {
                        this.state = 3293;
                        return true;
                    }
                    case 117: {
                        this.state = 3298;
                        return true;
                    }
                    case 119: {
                        this.state = 3301;
                        return true;
                    }
                }
                break;
            }
            case 3167: {
                switch (current) {
                    case 99: {
                        this.state = 3168;
                        return true;
                    }
                }
                break;
            }
            case 3168: {
                switch (current) {
                    case 117: {
                        this.state = 3169;
                        return true;
                    }
                }
                break;
            }
            case 3169: {
                switch (current) {
                    case 116: {
                        this.state = 3170;
                        return true;
                    }
                }
                break;
            }
            case 3170: {
                switch (current) {
                    case 101: {
                        this.match = "\u00e1";
                        this.matchLength = this.consumedCount;
                        this.state = 3171;
                        return true;
                    }
                }
                break;
            }
            case 3171: {
                switch (current) {
                    case 59: {
                        this.match = "\u00e1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3172: {
                switch (current) {
                    case 114: {
                        this.state = 3173;
                        return true;
                    }
                }
                break;
            }
            case 3173: {
                switch (current) {
                    case 101: {
                        this.state = 3174;
                        return true;
                    }
                }
                break;
            }
            case 3174: {
                switch (current) {
                    case 118: {
                        this.state = 3175;
                        return true;
                    }
                }
                break;
            }
            case 3175: {
                switch (current) {
                    case 101: {
                        this.state = 3176;
                        return true;
                    }
                }
                break;
            }
            case 3176: {
                switch (current) {
                    case 59: {
                        this.match = "\u0103";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3177: {
                switch (current) {
                    case 59: {
                        this.match = "\u223e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 3178;
                        return true;
                    }
                    case 100: {
                        this.state = 3179;
                        return true;
                    }
                    case 105: {
                        this.state = 3180;
                        return true;
                    }
                    case 117: {
                        this.state = 3183;
                        return true;
                    }
                    case 121: {
                        this.state = 3186;
                        return true;
                    }
                }
                break;
            }
            case 3178: {
                switch (current) {
                    case 59: {
                        this.match = "\u223e\u0333";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3179: {
                switch (current) {
                    case 59: {
                        this.match = "\u223f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3180: {
                switch (current) {
                    case 114: {
                        this.state = 3181;
                        return true;
                    }
                }
                break;
            }
            case 3181: {
                switch (current) {
                    case 99: {
                        this.match = "\u00e2";
                        this.matchLength = this.consumedCount;
                        this.state = 3182;
                        return true;
                    }
                }
                break;
            }
            case 3182: {
                switch (current) {
                    case 59: {
                        this.match = "\u00e2";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3183: {
                switch (current) {
                    case 116: {
                        this.state = 3184;
                        return true;
                    }
                }
                break;
            }
            case 3184: {
                switch (current) {
                    case 101: {
                        this.match = "\u00b4";
                        this.matchLength = this.consumedCount;
                        this.state = 3185;
                        return true;
                    }
                }
                break;
            }
            case 3185: {
                switch (current) {
                    case 59: {
                        this.match = "\u00b4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3186: {
                switch (current) {
                    case 59: {
                        this.match = "\u0430";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3187: {
                switch (current) {
                    case 108: {
                        this.state = 3188;
                        return true;
                    }
                }
                break;
            }
            case 3188: {
                switch (current) {
                    case 105: {
                        this.state = 3189;
                        return true;
                    }
                }
                break;
            }
            case 3189: {
                switch (current) {
                    case 103: {
                        this.match = "\u00e6";
                        this.matchLength = this.consumedCount;
                        this.state = 3190;
                        return true;
                    }
                }
                break;
            }
            case 3190: {
                switch (current) {
                    case 59: {
                        this.match = "\u00e6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3191: {
                switch (current) {
                    case 59: {
                        this.match = "\u2061";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 114: {
                        this.state = 3192;
                        return true;
                    }
                }
                break;
            }
            case 3192: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd1e";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3193: {
                switch (current) {
                    case 114: {
                        this.state = 3194;
                        return true;
                    }
                }
                break;
            }
            case 3194: {
                switch (current) {
                    case 97: {
                        this.state = 3195;
                        return true;
                    }
                }
                break;
            }
            case 3195: {
                switch (current) {
                    case 118: {
                        this.state = 3196;
                        return true;
                    }
                }
                break;
            }
            case 3196: {
                switch (current) {
                    case 101: {
                        this.match = "\u00e0";
                        this.matchLength = this.consumedCount;
                        this.state = 3197;
                        return true;
                    }
                }
                break;
            }
            case 3197: {
                switch (current) {
                    case 59: {
                        this.match = "\u00e0";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3198: {
                switch (current) {
                    case 101: {
                        this.state = 3199;
                        return true;
                    }
                    case 112: {
                        this.state = 3206;
                        return true;
                    }
                }
                break;
            }
            case 3199: {
                switch (current) {
                    case 102: {
                        this.state = 3200;
                        return true;
                    }
                    case 112: {
                        this.state = 3204;
                        return true;
                    }
                }
                break;
            }
            case 3200: {
                switch (current) {
                    case 115: {
                        this.state = 3201;
                        return true;
                    }
                }
                break;
            }
            case 3201: {
                switch (current) {
                    case 121: {
                        this.state = 3202;
                        return true;
                    }
                }
                break;
            }
            case 3202: {
                switch (current) {
                    case 109: {
                        this.state = 3203;
                        return true;
                    }
                }
                break;
            }
            case 3203: {
                switch (current) {
                    case 59: {
                        this.match = "\u2135";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3204: {
                switch (current) {
                    case 104: {
                        this.state = 3205;
                        return true;
                    }
                }
                break;
            }
            case 3205: {
                switch (current) {
                    case 59: {
                        this.match = "\u2135";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3206: {
                switch (current) {
                    case 104: {
                        this.state = 3207;
                        return true;
                    }
                }
                break;
            }
            case 3207: {
                switch (current) {
                    case 97: {
                        this.state = 3208;
                        return true;
                    }
                }
                break;
            }
            case 3208: {
                switch (current) {
                    case 59: {
                        this.match = "\u03b1";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3209: {
                switch (current) {
                    case 97: {
                        this.state = 3210;
                        return true;
                    }
                    case 112: {
                        this.match = "&";
                        this.matchLength = this.consumedCount;
                        this.state = 3215;
                        return true;
                    }
                }
                break;
            }
            case 3210: {
                switch (current) {
                    case 99: {
                        this.state = 3211;
                        return true;
                    }
                    case 108: {
                        this.state = 3213;
                        return true;
                    }
                }
                break;
            }
            case 3211: {
                switch (current) {
                    case 114: {
                        this.state = 3212;
                        return true;
                    }
                }
                break;
            }
            case 3212: {
                switch (current) {
                    case 59: {
                        this.match = "\u0101";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3213: {
                switch (current) {
                    case 103: {
                        this.state = 3214;
                        return true;
                    }
                }
                break;
            }
            case 3214: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a3f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3215: {
                switch (current) {
                    case 59: {
                        this.match = "&";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3216: {
                switch (current) {
                    case 100: {
                        this.state = 3217;
                        return true;
                    }
                    case 103: {
                        this.state = 3228;
                        return true;
                    }
                }
                break;
            }
            case 3217: {
                switch (current) {
                    case 59: {
                        this.match = "\u2227";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 97: {
                        this.state = 3218;
                        return true;
                    }
                    case 100: {
                        this.state = 3221;
                        return true;
                    }
                    case 115: {
                        this.state = 3222;
                        return true;
                    }
                    case 118: {
                        this.state = 3227;
                        return true;
                    }
                }
                break;
            }
            case 3218: {
                switch (current) {
                    case 110: {
                        this.state = 3219;
                        return true;
                    }
                }
                break;
            }
            case 3219: {
                switch (current) {
                    case 100: {
                        this.state = 3220;
                        return true;
                    }
                }
                break;
            }
            case 3220: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a55";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3221: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a5c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3222: {
                switch (current) {
                    case 108: {
                        this.state = 3223;
                        return true;
                    }
                }
                break;
            }
            case 3223: {
                switch (current) {
                    case 111: {
                        this.state = 3224;
                        return true;
                    }
                }
                break;
            }
            case 3224: {
                switch (current) {
                    case 112: {
                        this.state = 3225;
                        return true;
                    }
                }
                break;
            }
            case 3225: {
                switch (current) {
                    case 101: {
                        this.state = 3226;
                        return true;
                    }
                }
                break;
            }
            case 3226: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a58";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3227: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a5a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3228: {
                switch (current) {
                    case 59: {
                        this.match = "\u2220";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 3229;
                        return true;
                    }
                    case 108: {
                        this.state = 3230;
                        return true;
                    }
                    case 109: {
                        this.state = 3232;
                        return true;
                    }
                    case 114: {
                        this.state = 3244;
                        return true;
                    }
                    case 115: {
                        this.state = 3249;
                        return true;
                    }
                    case 122: {
                        this.state = 3253;
                        return true;
                    }
                }
                break;
            }
            case 3229: {
                switch (current) {
                    case 59: {
                        this.match = "\u29a4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3230: {
                switch (current) {
                    case 101: {
                        this.state = 3231;
                        return true;
                    }
                }
                break;
            }
            case 3231: {
                switch (current) {
                    case 59: {
                        this.match = "\u2220";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3232: {
                switch (current) {
                    case 115: {
                        this.state = 3233;
                        return true;
                    }
                }
                break;
            }
            case 3233: {
                switch (current) {
                    case 100: {
                        this.state = 3234;
                        return true;
                    }
                }
                break;
            }
            case 3234: {
                switch (current) {
                    case 59: {
                        this.match = "\u2221";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 97: {
                        this.state = 3235;
                        return true;
                    }
                }
                break;
            }
            case 3235: {
                switch (current) {
                    case 97: {
                        this.state = 3236;
                        return true;
                    }
                    case 98: {
                        this.state = 3237;
                        return true;
                    }
                    case 99: {
                        this.state = 3238;
                        return true;
                    }
                    case 100: {
                        this.state = 3239;
                        return true;
                    }
                    case 101: {
                        this.state = 3240;
                        return true;
                    }
                    case 102: {
                        this.state = 3241;
                        return true;
                    }
                    case 103: {
                        this.state = 3242;
                        return true;
                    }
                    case 104: {
                        this.state = 3243;
                        return true;
                    }
                }
                break;
            }
            case 3236: {
                switch (current) {
                    case 59: {
                        this.match = "\u29a8";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3237: {
                switch (current) {
                    case 59: {
                        this.match = "\u29a9";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3238: {
                switch (current) {
                    case 59: {
                        this.match = "\u29aa";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3239: {
                switch (current) {
                    case 59: {
                        this.match = "\u29ab";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3240: {
                switch (current) {
                    case 59: {
                        this.match = "\u29ac";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3241: {
                switch (current) {
                    case 59: {
                        this.match = "\u29ad";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3242: {
                switch (current) {
                    case 59: {
                        this.match = "\u29ae";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3243: {
                switch (current) {
                    case 59: {
                        this.match = "\u29af";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3244: {
                switch (current) {
                    case 116: {
                        this.state = 3245;
                        return true;
                    }
                }
                break;
            }
            case 3245: {
                switch (current) {
                    case 59: {
                        this.match = "\u221f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 118: {
                        this.state = 3246;
                        return true;
                    }
                }
                break;
            }
            case 3246: {
                switch (current) {
                    case 98: {
                        this.state = 3247;
                        return true;
                    }
                }
                break;
            }
            case 3247: {
                switch (current) {
                    case 59: {
                        this.match = "\u22be";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 100: {
                        this.state = 3248;
                        return true;
                    }
                }
                break;
            }
            case 3248: {
                switch (current) {
                    case 59: {
                        this.match = "\u299d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3249: {
                switch (current) {
                    case 112: {
                        this.state = 3250;
                        return true;
                    }
                    case 116: {
                        this.state = 3252;
                        return true;
                    }
                }
                break;
            }
            case 3250: {
                switch (current) {
                    case 104: {
                        this.state = 3251;
                        return true;
                    }
                }
                break;
            }
            case 3251: {
                switch (current) {
                    case 59: {
                        this.match = "\u2222";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3252: {
                switch (current) {
                    case 59: {
                        this.match = "\u00c5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3253: {
                switch (current) {
                    case 97: {
                        this.state = 3254;
                        return true;
                    }
                }
                break;
            }
            case 3254: {
                switch (current) {
                    case 114: {
                        this.state = 3255;
                        return true;
                    }
                }
                break;
            }
            case 3255: {
                switch (current) {
                    case 114: {
                        this.state = 3256;
                        return true;
                    }
                }
                break;
            }
            case 3256: {
                switch (current) {
                    case 59: {
                        this.match = "\u237c";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3257: {
                switch (current) {
                    case 103: {
                        this.state = 3258;
                        return true;
                    }
                    case 112: {
                        this.state = 3261;
                        return true;
                    }
                }
                break;
            }
            case 3258: {
                switch (current) {
                    case 111: {
                        this.state = 3259;
                        return true;
                    }
                }
                break;
            }
            case 3259: {
                switch (current) {
                    case 110: {
                        this.state = 3260;
                        return true;
                    }
                }
                break;
            }
            case 3260: {
                switch (current) {
                    case 59: {
                        this.match = "\u0105";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3261: {
                switch (current) {
                    case 102: {
                        this.state = 3262;
                        return true;
                    }
                }
                break;
            }
            case 3262: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udd52";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3263: {
                switch (current) {
                    case 59: {
                        this.match = "\u2248";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 69: {
                        this.state = 3264;
                        return true;
                    }
                    case 97: {
                        this.state = 3265;
                        return true;
                    }
                    case 101: {
                        this.state = 3269;
                        return true;
                    }
                    case 105: {
                        this.state = 3270;
                        return true;
                    }
                    case 111: {
                        this.state = 3272;
                        return true;
                    }
                    case 112: {
                        this.state = 3274;
                        return true;
                    }
                }
                break;
            }
            case 3264: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a70";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3265: {
                switch (current) {
                    case 99: {
                        this.state = 3266;
                        return true;
                    }
                }
                break;
            }
            case 3266: {
                switch (current) {
                    case 105: {
                        this.state = 3267;
                        return true;
                    }
                }
                break;
            }
            case 3267: {
                switch (current) {
                    case 114: {
                        this.state = 3268;
                        return true;
                    }
                }
                break;
            }
            case 3268: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a6f";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3269: {
                switch (current) {
                    case 59: {
                        this.match = "\u224a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3270: {
                switch (current) {
                    case 100: {
                        this.state = 3271;
                        return true;
                    }
                }
                break;
            }
            case 3271: {
                switch (current) {
                    case 59: {
                        this.match = "\u224b";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3272: {
                switch (current) {
                    case 115: {
                        this.state = 3273;
                        return true;
                    }
                }
                break;
            }
            case 3273: {
                switch (current) {
                    case 59: {
                        this.match = "'";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3274: {
                switch (current) {
                    case 114: {
                        this.state = 3275;
                        return true;
                    }
                }
                break;
            }
            case 3275: {
                switch (current) {
                    case 111: {
                        this.state = 3276;
                        return true;
                    }
                }
                break;
            }
            case 3276: {
                switch (current) {
                    case 120: {
                        this.state = 3277;
                        return true;
                    }
                }
                break;
            }
            case 3277: {
                switch (current) {
                    case 59: {
                        this.match = "\u2248";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 3278;
                        return true;
                    }
                }
                break;
            }
            case 3278: {
                switch (current) {
                    case 113: {
                        this.state = 3279;
                        return true;
                    }
                }
                break;
            }
            case 3279: {
                switch (current) {
                    case 59: {
                        this.match = "\u224a";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3280: {
                switch (current) {
                    case 105: {
                        this.state = 3281;
                        return true;
                    }
                }
                break;
            }
            case 3281: {
                switch (current) {
                    case 110: {
                        this.state = 3282;
                        return true;
                    }
                }
                break;
            }
            case 3282: {
                switch (current) {
                    case 103: {
                        this.match = "\u00e5";
                        this.matchLength = this.consumedCount;
                        this.state = 3283;
                        return true;
                    }
                }
                break;
            }
            case 3283: {
                switch (current) {
                    case 59: {
                        this.match = "\u00e5";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3284: {
                switch (current) {
                    case 99: {
                        this.state = 3285;
                        return true;
                    }
                    case 116: {
                        this.state = 3287;
                        return true;
                    }
                    case 121: {
                        this.state = 3288;
                        return true;
                    }
                }
                break;
            }
            case 3285: {
                switch (current) {
                    case 114: {
                        this.state = 3286;
                        return true;
                    }
                }
                break;
            }
            case 3286: {
                switch (current) {
                    case 59: {
                        this.match = "\ud835\udcb6";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3287: {
                switch (current) {
                    case 59: {
                        this.match = "*";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3288: {
                switch (current) {
                    case 109: {
                        this.state = 3289;
                        return true;
                    }
                }
                break;
            }
            case 3289: {
                switch (current) {
                    case 112: {
                        this.state = 3290;
                        return true;
                    }
                }
                break;
            }
            case 3290: {
                switch (current) {
                    case 59: {
                        this.match = "\u2248";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                    case 101: {
                        this.state = 3291;
                        return true;
                    }
                }
                break;
            }
            case 3291: {
                switch (current) {
                    case 113: {
                        this.state = 3292;
                        return true;
                    }
                }
                break;
            }
            case 3292: {
                switch (current) {
                    case 59: {
                        this.match = "\u224d";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3293: {
                switch (current) {
                    case 105: {
                        this.state = 3294;
                        return true;
                    }
                }
                break;
            }
            case 3294: {
                switch (current) {
                    case 108: {
                        this.state = 3295;
                        return true;
                    }
                }
                break;
            }
            case 3295: {
                switch (current) {
                    case 100: {
                        this.state = 3296;
                        return true;
                    }
                }
                break;
            }
            case 3296: {
                switch (current) {
                    case 101: {
                        this.match = "\u00e3";
                        this.matchLength = this.consumedCount;
                        this.state = 3297;
                        return true;
                    }
                }
                break;
            }
            case 3297: {
                switch (current) {
                    case 59: {
                        this.match = "\u00e3";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3298: {
                switch (current) {
                    case 109: {
                        this.state = 3299;
                        return true;
                    }
                }
                break;
            }
            case 3299: {
                switch (current) {
                    case 108: {
                        this.match = "\u00e4";
                        this.matchLength = this.consumedCount;
                        this.state = 3300;
                        return true;
                    }
                }
                break;
            }
            case 3300: {
                switch (current) {
                    case 59: {
                        this.match = "\u00e4";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3301: {
                switch (current) {
                    case 99: {
                        this.state = 3302;
                        return true;
                    }
                    case 105: {
                        this.state = 3308;
                        return true;
                    }
                }
                break;
            }
            case 3302: {
                switch (current) {
                    case 111: {
                        this.state = 3303;
                        return true;
                    }
                }
                break;
            }
            case 3303: {
                switch (current) {
                    case 110: {
                        this.state = 3304;
                        return true;
                    }
                }
                break;
            }
            case 3304: {
                switch (current) {
                    case 105: {
                        this.state = 3305;
                        return true;
                    }
                }
                break;
            }
            case 3305: {
                switch (current) {
                    case 110: {
                        this.state = 3306;
                        return true;
                    }
                }
                break;
            }
            case 3306: {
                switch (current) {
                    case 116: {
                        this.state = 3307;
                        return true;
                    }
                }
                break;
            }
            case 3307: {
                switch (current) {
                    case 59: {
                        this.match = "\u2233";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3308: {
                switch (current) {
                    case 110: {
                        this.state = 3309;
                        return true;
                    }
                }
                break;
            }
            case 3309: {
                switch (current) {
                    case 116: {
                        this.state = 3310;
                        return true;
                    }
                }
                break;
            }
            case 3310: {
                switch (current) {
                    case 59: {
                        this.match = "\u2a11";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3311: {
                switch (current) {
                    case 78: {
                        this.state = 3312;
                        return true;
                    }
                    case 97: {
                        this.state = 3315;
                        return true;
                    }
                    case 98: {
                        this.state = 3348;
                        return true;
                    }
                    case 99: {
                        this.state = 3355;
                        return true;
                    }
                    case 100: {
                        this.state = 3360;
                        return true;
                    }
                    case 101: {
                        this.state = 3364;
                        return true;
                    }
                    case 102: {
                        this.state = 3389;
                        return true;
                    }
                    case 105: {
                        this.state = 3391;
                        return true;
                    }
                    case 107: {
                        this.state = 3449;
                        return true;
                    }
                    case 108: {
                        this.state = 3454;
                        return true;
                    }
                    case 110: {
                        this.state = 3503;
                        return true;
                    }
                    case 111: {
                        this.state = 3511;
                        return true;
                    }
                    case 112: {
                        this.state = 3584;
                        return true;
                    }
                    case 114: {
                        this.state = 3589;
                        return true;
                    }
                    case 115: {
                        this.state = 3597;
                        return true;
                    }
                    case 117: {
                        this.state = 3613;
                        return true;
                    }
                }
                break;
            }
            case 3312: {
                switch (current) {
                    case 111: {
                        this.state = 3313;
                        return true;
                    }
                }
                break;
            }
            case 3313: {
                switch (current) {
                    case 116: {
                        this.state = 3314;
                        return true;
                    }
                }
                break;
            }
            case 3314: {
                switch (current) {
                    case 59: {
                        this.match = "\u2aed";
                        this.matchLength = this.consumedCount;
                        this.state = -2;
                        return false;
                    }
                }
                break;
            }
            case 3315: {
                switch (current) {
                    case 99: {
                        this.state = 3316;
                        return true;
                    }
                    case 114: {