/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.edapt.declaration.inheritance;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edapt.common.MetamodelFactory;
import org.eclipse.emf.edapt.declaration.EdaptConstraint;
import org.eclipse.emf.edapt.declaration.EdaptOperation;
import org.eclipse.emf.edapt.declaration.EdaptParameter;
import org.eclipse.emf.edapt.declaration.OperationImplementation;
import org.eclipse.emf.edapt.migration.Metamodel;
import org.eclipse.emf.edapt.migration.Model;

@Deprecated
@EdaptOperation(identifier="extractSuperClass", label="Extract Super Class", description="In the metamodel, a number of features of a class are extracted to a new super class. In the model, nothing is changed.")
public class ExtractSuperClass
extends OperationImplementation {
    @EdaptParameter(main=true, description="The class from which the features are extracted")
    public EClass subClass;
    @EdaptParameter(optional=true, description="The features to be extracted")
    public List<EStructuralFeature> toExtract = new ArrayList<EStructuralFeature>();
    @EdaptParameter(description="The package in which the super class is created")
    public EPackage ePackage;
    @EdaptParameter(description="The name of the super class")
    public String superClassName;
    @EdaptParameter(description="Whether the super class is abstract")
    public Boolean abstr = true;
    @EdaptParameter(optional=true, description="The super classes of the sub class which become super classes of the super class")
    public List<EClass> superSuperClasses = new ArrayList<EClass>();

    @EdaptConstraint(restricts="toExtract", description="The features to be extracted must belong to sub class")
    public boolean checkToExtractSameClass(EStructuralFeature toExtract) {
        return this.subClass.getEStructuralFeatures().contains((Object)toExtract);
    }

    @EdaptConstraint(restricts="superSuperClasses", description="The super classes to be extracted must be a containsAll of the subclass's super types")
    public boolean checkSuperSuperClasses(EClass superSuperClasses) {
        return this.subClass.getESuperTypes().contains((Object)superSuperClasses);
    }

    public void initialize(Metamodel metamodel) {
        this.ePackage = this.subClass.getEPackage();
    }

    public void execute(Metamodel metamodel, Model model) {
        EClass superClass = MetamodelFactory.newEClass((EPackage)this.ePackage, (String)this.superClassName);
        superClass.setAbstract(this.abstr.booleanValue());
        superClass.getEStructuralFeatures().addAll(this.toExtract);
        superClass.getESuperTypes().addAll(this.superSuperClasses);
        this.subClass.getESuperTypes().add((Object)superClass);
        this.subClass.getESuperTypes().removeAll(this.superSuperClasses);
        for (EStructuralFeature feature : this.toExtract) {
            EReference reference;
            if (!(feature instanceof EReference) || (reference = (EReference)feature).getEOpposite() == null) continue;
            reference.getEOpposite().setEType((EClassifier)superClass);
        }
    }
}

