/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.modules.git;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.core.resources.IContainer;
import org.eclipse.ease.modules.AbstractScriptModule;
import org.eclipse.ease.modules.ScriptParameter;
import org.eclipse.ease.modules.WrapToScript;
import org.eclipse.ease.tools.ResourceTools;
import org.eclipse.jgit.api.CloneCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.PullResult;
import org.eclipse.jgit.api.Status;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.api.errors.InvalidRemoteException;
import org.eclipse.jgit.api.errors.TransportException;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.PushResult;
import org.eclipse.jgit.transport.UsernamePasswordCredentialsProvider;

public class GitModule
extends AbstractScriptModule {
    @WrapToScript
    public Git clone(String remoteLocation, Object localLocation, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String user, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String pass, @ScriptParameter(defaultValue="org.eclipse.ease.modules.ScriptParameter.null") String branch) throws InvalidRemoteException, TransportException, GitAPIException {
        File folder = this.resolveFolder(localLocation);
        if (folder != null) {
            CloneCommand cloneCommand = Git.cloneRepository();
            cloneCommand.setURI(remoteLocation);
            cloneCommand.setDirectory(folder);
            if (user != null && pass != null) {
                cloneCommand.setCredentialsProvider((CredentialsProvider)new UsernamePasswordCredentialsProvider(user, pass));
            }
            if (branch != null) {
                cloneCommand.setBranchesToClone(Arrays.asList(branch));
            }
            Git result = cloneCommand.call();
            GitModule.addToEGit(result.getRepository().getDirectory());
            return result;
        }
        throw new RuntimeException("invalid local folder detected: " + localLocation);
    }

    @WrapToScript
    public Git openRepository(Object location) throws IOException {
        if (location instanceof Git) {
            return (Git)location;
        }
        File folder = this.resolveFolder(location);
        if (folder != null) {
            return Git.open((File)folder);
        }
        throw new RuntimeException("Invalid folder location: " + location);
    }

    @WrapToScript
    public Git initRepository(Object location, @ScriptParameter(defaultValue="false") boolean bare) throws IllegalStateException, GitAPIException {
        File folder = this.resolveFolder(location);
        if (folder != null) {
            if (!folder.exists()) {
                folder.mkdirs();
            }
            Git result = Git.init().setDirectory(folder).setBare(bare).call();
            GitModule.addToEGit(result.getRepository().getDirectory());
            return result;
        }
        throw new RuntimeException("Invalid folder location: " + location);
    }

    private static void addToEGit(File directory) {
    }

    @WrapToScript
    public RevCommit commit(Object repository, String message, String author, @ScriptParameter(defaultValue="false") boolean amend) throws IOException, GitAPIException {
        Git repo = this.openRepository(repository);
        if (repo != null) {
            String authorName = "";
            String authorEmail = "";
            if (author != null) {
                String[] authorTokens = author.split("|");
                if (authorTokens.length > 0) {
                    authorName = authorTokens[0].trim();
                }
                if (authorTokens.length > 1) {
                    authorEmail = authorTokens[1].trim();
                }
            }
            return repo.commit().setMessage(message).setAuthor(authorName, authorEmail).setAmend(amend).call();
        }
        throw new RuntimeException("No repository found at: " + repository);
    }

    @WrapToScript
    public DirCache add(Object repository, String filepattern) throws IOException, GitAPIException {
        Git repo = this.openRepository(repository);
        if (repo != null) {
            return repo.add().addFilepattern(filepattern).call();
        }
        throw new RuntimeException("No repository found at: " + repository);
    }

    @WrapToScript
    public Status getStatus(Object repository) throws IOException, GitAPIException {
        Git repo = this.openRepository(repository);
        if (repo != null) {
            return repo.status().call();
        }
        throw new RuntimeException("No repository found at: " + repository);
    }

    @WrapToScript
    public Iterable<PushResult> push(Object repository) throws IOException, GitAPIException {
        Git repo = this.openRepository(repository);
        if (repo != null) {
            return repo.push().call();
        }
        throw new RuntimeException("No repository found at: " + repository);
    }

    @WrapToScript
    public PullResult pull(Object repository) throws IOException, GitAPIException {
        Git repo = this.openRepository(repository);
        if (repo != null) {
            return repo.pull().call();
        }
        throw new RuntimeException("No repository found at: " + repository);
    }

    private final File resolveFolder(Object location) {
        Object folder = ResourceTools.resolveFolder((Object)location, (Object)this.getScriptEngine(), (boolean)false);
        if (folder instanceof IContainer) {
            folder = ((IContainer)folder).getRawLocation().makeAbsolute().toFile();
        }
        if (folder instanceof File && (!((File)folder).exists() || ((File)folder).isDirectory())) {
            return (File)folder;
        }
        return null;
    }
}

