/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.sirius;

import java.util.Arrays;
import org.eclipse.emf.diffmerge.api.IMatch;
import org.eclipse.emf.diffmerge.api.Role;
import org.eclipse.emf.diffmerge.api.diff.IDifference;
import org.eclipse.emf.diffmerge.api.diff.IElementRelativePresence;
import org.eclipse.emf.diffmerge.api.diff.IReferenceValuePresence;
import org.eclipse.emf.diffmerge.api.diff.IValuePresence;
import org.eclipse.emf.diffmerge.ui.sirius.Messages;
import org.eclipse.emf.diffmerge.ui.viewers.EMFDiffNode;
import org.eclipse.emf.diffmerge.ui.viewers.categories.AbstractDifferenceCategory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.business.api.resource.ResourceDescriptor;

public class SiriusTechnicalDifferenceCategory
extends AbstractDifferenceCategory {
    public static final String ID = "Sirius.Technical";

    public SiriusTechnicalDifferenceCategory() {
        this.setActive(true);
        this.setInFocusMode(false);
        this.setVisible(true);
        this.setModifiable(true);
    }

    public boolean covers(IDifference difference_p, EMFDiffNode node_p) {
        boolean result = false;
        if (difference_p instanceof IElementRelativePresence) {
            IMatch match = ((IElementRelativePresence)difference_p).getElementMatch();
            result = this.isSiriusTechnicalMatch(match);
            if (!result && difference_p instanceof IReferenceValuePresence) {
                IMatch valueMatch = ((IReferenceValuePresence)difference_p).getElementMatch();
                result = this.isSiriusTechnicalMatch(valueMatch);
            }
            if (!result && difference_p instanceof IValuePresence) {
                Object value = ((IValuePresence)difference_p).getValue();
                result = this.isSiriusTechnicalObject(value);
            }
        }
        return result;
    }

    public String getDescription(EMFDiffNode node_p) {
        return Messages.SiriusTechnicalDifferenceCategory_Description;
    }

    public String getID() {
        return ID;
    }

    public String getText(EMFDiffNode node_p) {
        return Messages.SiriusTechnicalDifferenceCategory_Text;
    }

    protected boolean isSiriusTechnicalObject(Object object_p) {
        return object_p instanceof ResourceDescriptor;
    }

    protected boolean isSiriusTechnicalMatch(IMatch match_p) {
        for (Role role : Arrays.asList(Role.REFERENCE, Role.TARGET)) {
            EObject element = match_p.get(role);
            if (element == null || !this.isSiriusTechnicalObject(element)) continue;
            return true;
        }
        return false;
    }
}

