/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.providers;

import java.util.Collection;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternApplication;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternInstance;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRepository;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternVersion;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IAtomicLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.IElementRelativeLocation;
import org.eclipse.emf.diffmerge.patterns.core.api.locations.ILocation;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternRepository;
import org.eclipse.emf.diffmerge.patterns.diagrams.misc.UnresolvedPattern;
import org.eclipse.emf.diffmerge.patterns.diagrams.misc.UnresolvedRepository;
import org.eclipse.emf.diffmerge.patterns.diagrams.util.PatternsDiagramsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.engine.TemplatePatternsUtil;
import org.eclipse.emf.diffmerge.patterns.templates.gen.templatepatterns.TemplatePatternData;
import org.eclipse.emf.diffmerge.patterns.ui.Messages;
import org.eclipse.emf.diffmerge.patterns.ui.PatternsUIPlugin;
import org.eclipse.emf.diffmerge.patterns.ui.dialogs.TemplateUsageDialog;
import org.eclipse.emf.diffmerge.patterns.ui.environment.IModelEnvironmentUI;
import org.eclipse.emf.diffmerge.util.ModelsUtil;
import org.eclipse.emf.diffmerge.util.structures.FOrderedSet;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class DiscriminatingLabelProvider
extends LabelProvider {
    private static DiscriminatingLabelProvider __instance;

    public static DiscriminatingLabelProvider getInstance() {
        if (__instance == null) {
            __instance = new DiscriminatingLabelProvider();
        }
        return __instance;
    }

    private String getPatternText(IPattern pattern_p) {
        return String.valueOf(pattern_p.isTemplate() ? Messages.DiscriminatingLabelProvider_Template : "") + pattern_p.getName();
    }

    private String getPatternInstanceText(IPatternInstance instance_p) {
        TemplatePatternData data;
        String versionText;
        StringBuilder builder = new StringBuilder();
        builder.append(Messages.DiscriminatingLabelProvider_Instance);
        IPatternVersion version = instance_p.getPatternVersion();
        if (version != null && (versionText = version.getVersion()) != null) {
            builder.append(" v");
            builder.append(versionText);
        }
        builder.append(" (");
        Object mergeTargets = new FOrderedSet();
        FOrderedSet additionTargets = new FOrderedSet();
        for (ILocation location : instance_p.getLocations()) {
            for (IAtomicLocation atomicLocation : location.getAtomicContents()) {
                EObject element;
                if (!(atomicLocation instanceof IElementRelativeLocation) || (element = ((IElementRelativeLocation)atomicLocation).getElement()) == null) continue;
                if (atomicLocation.supportsMerge()) {
                    mergeTargets.add(element);
                    continue;
                }
                additionTargets.add(element);
            }
        }
        if (mergeTargets.isEmpty() && (data = TemplatePatternsUtil.getPatternData((IPatternApplication)instance_p)) != null) {
            mergeTargets = ModelsUtil.getRoots((Collection)data.getInstanceElements());
        }
        if (!mergeTargets.isEmpty()) {
            builder.append(this.getText(mergeTargets.iterator().next()));
            if (mergeTargets.size() > 1) {
                builder.append(", ...");
            }
        } else if (!additionTargets.isEmpty()) {
            builder.append(Messages.DiscriminatingLabelProvider_In);
            builder.append(' ');
            builder.append(this.getText(additionTargets.iterator().next()));
            if (additionTargets.size() > 1) {
                builder.append(", ...");
            }
        }
        builder.append(')');
        return builder.toString();
    }

    private String getPatternRepositoryText(IPatternRepository repository_p) {
        StringBuilder builder = new StringBuilder();
        if (repository_p instanceof PatternRepository) {
            builder.append(((PatternRepository)repository_p).getName());
            builder.append("  [");
            builder.append(PatternsDiagramsUtil.getPath((String)((PatternRepository)repository_p).getPath()));
            builder.append("]");
        } else {
            builder.append(Messages.DiscriminatingLabelProvider_Catalog);
            builder.append(' ');
            builder.append(repository_p.getId());
        }
        return builder.toString();
    }

    public String getText(Object element_p) {
        String result = null;
        if (element_p == TemplateUsageDialog.EMPTY_ELEMENT) {
            result = Messages.DiscriminatingLabelProvider_Empty;
        } else if (element_p == TemplateUsageDialog.FAILURE_ELEMENT) {
            result = Messages.DiscriminatingLabelProvider_Failure;
        } else if (element_p instanceof IPattern) {
            result = this.getPatternText((IPattern)element_p);
        } else if (element_p instanceof IPatternInstance) {
            result = this.getPatternInstanceText((IPatternInstance)element_p);
        } else if (element_p instanceof IPatternRepository) {
            result = this.getPatternRepositoryText((IPatternRepository)element_p);
        } else if (element_p instanceof EObject) {
            IModelEnvironmentUI me = PatternsUIPlugin.getDefault().getModelEnvironmentUI();
            result = me.getText(element_p);
        }
        if (result == null || result.length() == 0) {
            result = element_p.toString();
        }
        if (result != null) {
            result = result.replaceAll("%20", " ");
        }
        return result;
    }

    public Image getImage(Object element_p) {
        Image result = null;
        if (element_p == TemplateUsageDialog.FAILURE_ELEMENT) {
            result = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE");
        } else if (element_p instanceof IPatternRepository || element_p instanceof UnresolvedRepository) {
            result = PatternsUIPlugin.getDefault().getImage(PatternsUIPlugin.ImageID.CATALOG);
        } else if (element_p instanceof IPattern || element_p instanceof UnresolvedPattern) {
            result = PatternsUIPlugin.getDefault().getImage(PatternsUIPlugin.ImageID.PATTERN);
        } else if (element_p instanceof IPatternInstance) {
            result = PatternsUIPlugin.getDefault().getImage(PatternsUIPlugin.ImageID.INSTANCE);
        } else if (element_p instanceof EObject) {
            IModelEnvironmentUI me = PatternsUIPlugin.getDefault().getModelEnvironmentUI();
            result = me.getImage(element_p);
        }
        return result;
    }
}

