/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.util;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.datatools.sqltools.common.ui.util.Messages;
import org.eclipse.datatools.sqltools.common.ui.util.SubstitutionTextReader;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyleRange;

public class HTML2TextReader
extends SubstitutionTextReader {
    private static final String _EMPTY_STRING = "";
    private static final Map _fgEntityLookup;
    private static final Set _fgTags;
    private int _fCounter = 0;
    private TextPresentation _fTextPresentation;
    private int _fBold = 0;
    private int _fStartOffset = -1;
    private boolean _fInParagraph = false;
    private boolean _fIsPreformattedText = false;

    static {
        _fgTags = new HashSet();
        _fgTags.add("b");
        _fgTags.add("br");
        _fgTags.add("h5");
        _fgTags.add("p");
        _fgTags.add("dl");
        _fgTags.add("dt");
        _fgTags.add("dd");
        _fgTags.add("li");
        _fgTags.add("ul");
        _fgTags.add("pre");
        _fgEntityLookup = new HashMap(7);
        _fgEntityLookup.put("lt", "<");
        _fgEntityLookup.put("gt", ">");
        _fgEntityLookup.put("nbsp", " ");
        _fgEntityLookup.put("amp", "&");
        _fgEntityLookup.put("circ", "^");
        _fgEntityLookup.put("tilde", "~");
        _fgEntityLookup.put("quot", "\"");
    }

    public HTML2TextReader(Reader reader, TextPresentation presentation) {
        super(new PushbackReader(reader));
        this._fTextPresentation = presentation;
    }

    public int read() throws IOException {
        int c = super.read();
        if (c != -1) {
            ++this._fCounter;
        }
        return c;
    }

    protected void startBold() {
        if (this._fBold == 0) {
            this._fStartOffset = this._fCounter;
        }
        ++this._fBold;
    }

    protected void startPreformattedText() {
        this._fIsPreformattedText = true;
        this.setSkipWhitespace(false);
    }

    protected void stopPreformattedText() {
        this._fIsPreformattedText = false;
        this.setSkipWhitespace(true);
    }

    protected void stopBold() {
        --this._fBold;
        if (this._fBold == 0) {
            if (this._fTextPresentation != null) {
                this._fTextPresentation.addStyleRange(new StyleRange(this._fStartOffset, this._fCounter - this._fStartOffset, null, null, 1));
            }
            this._fStartOffset = -1;
        }
    }

    protected String computeSubstitution(int c) throws IOException {
        if (c == 60) {
            return this.processHTMLTag();
        }
        if (c == 38) {
            return this.processEntity();
        }
        if (this._fIsPreformattedText) {
            return this.processPreformattedText(c);
        }
        return null;
    }

    private String html2Text(String html) {
        if (html == null || html.length() == 0) {
            return _EMPTY_STRING;
        }
        String tag = html;
        if ('/' == tag.charAt(0)) {
            tag = tag.substring(1);
        }
        if (!_fgTags.contains(tag)) {
            return _EMPTY_STRING;
        }
        if ("pre".equals(html)) {
            this.startPreformattedText();
            return _EMPTY_STRING;
        }
        if ("/pre".equals(html)) {
            this.stopPreformattedText();
            return _EMPTY_STRING;
        }
        if (this._fIsPreformattedText) {
            return _EMPTY_STRING;
        }
        if ("b".equals(html)) {
            this.startBold();
            return _EMPTY_STRING;
        }
        if ("h5".equals(html) || "dt".equals(html)) {
            this.startBold();
            return _EMPTY_STRING;
        }
        if ("dl".equals(html)) {
            return LINE_DELIM;
        }
        if ("dd".equals(html)) {
            return "\t";
        }
        if ("li".equals(html)) {
            return String.valueOf(LINE_DELIM) + Messages.HTML2TextReader_listItemPrefix;
        }
        if ("/b".equals(html)) {
            this.stopBold();
            return _EMPTY_STRING;
        }
        if ("p".equals(html)) {
            this._fInParagraph = true;
            return LINE_DELIM;
        }
        if ("br".equals(html)) {
            return LINE_DELIM;
        }
        if ("/p".equals(html)) {
            boolean inParagraph = this._fInParagraph;
            this._fInParagraph = false;
            return inParagraph ? _EMPTY_STRING : LINE_DELIM;
        }
        if ("/h5".equals(html) || "/dt".equals(html)) {
            this.stopBold();
            return LINE_DELIM;
        }
        if ("/dd".equals(html)) {
            return LINE_DELIM;
        }
        return _EMPTY_STRING;
    }

    private String processHTMLTag() throws IOException {
        StringBuffer buf = new StringBuffer();
        while (true) {
            int ch = this.nextChar();
            while (ch != -1 && ch != 62) {
                buf.append(Character.toLowerCase((char)ch));
                ch = this.nextChar();
                if (ch == 34) {
                    buf.append(Character.toLowerCase((char)ch));
                    ch = this.nextChar();
                    while (ch != -1 && ch != 34) {
                        buf.append(Character.toLowerCase((char)ch));
                        ch = this.nextChar();
                    }
                }
                if (ch != 60) continue;
                this.unread(ch);
                return String.valueOf('<') + buf.toString();
            }
            if (ch == -1) {
                return null;
            }
            int tagLen = buf.length();
            if (tagLen < 3 || !"!--".equals(buf.substring(0, 3)) || tagLen >= 5 && "--!".equals(buf.substring(tagLen - 3))) break;
            buf.append(ch);
        }
        return this.html2Text(buf.toString());
    }

    private String processPreformattedText(int c) {
        if (c == 13 || c == 10) {
            ++this._fCounter;
        }
        return null;
    }

    private void unread(int ch) throws IOException {
        ((PushbackReader)this.getReader()).unread(ch);
    }

    protected String entity2Text(String symbol) {
        if (symbol.length() > 1 && symbol.charAt(0) == '#') {
            try {
                int ch = symbol.charAt(1) == 'x' ? Integer.parseInt(symbol.substring(2), 16) : Integer.parseInt(symbol.substring(1), 10);
                return _EMPTY_STRING + (char)ch;
            }
            catch (NumberFormatException numberFormatException) {}
        } else {
            String str = (String)_fgEntityLookup.get(symbol);
            if (str != null) {
                return str;
            }
        }
        return "&" + symbol;
    }

    private String processEntity() throws IOException {
        StringBuffer buf = new StringBuffer();
        int ch = this.nextChar();
        while (Character.isLetterOrDigit((char)ch) || ch == 35) {
            buf.append((char)ch);
            ch = this.nextChar();
        }
        if (ch == 59) {
            return this.entity2Text(buf.toString());
        }
        buf.insert(0, '&');
        if (ch != -1) {
            buf.append((char)ch);
        }
        return buf.toString();
    }
}

