/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.connectivity.ui.wizards;

import java.util.Properties;
import org.eclipse.datatools.connectivity.internal.ui.ConnectivityUIPlugin;
import org.eclipse.datatools.connectivity.internal.ui.DelimitedStringList;
import org.eclipse.datatools.connectivity.ui.wizards.IDriverUIContributorInformation;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class OptionalPropertiesPane
extends Composite
implements ModifyListener {
    protected boolean isReadOnly = false;
    protected DelimitedStringList delimitedStringControl;
    protected Properties properties;

    public OptionalPropertiesPane(Composite parent, int style, boolean isReadOnly) {
        super(parent, style);
        OptionalPropertiesPane parentComposite = this;
        this.isReadOnly = isReadOnly;
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        Label optionalPropertiesLabel = new Label((Composite)parentComposite, 0);
        GridData gdata = new GridData(768);
        gdata.horizontalSpan = 2;
        optionalPropertiesLabel.setLayoutData((Object)gdata);
        optionalPropertiesLabel.setText(ConnectivityUIPlugin.getDefault().getResourceString("CommonDriverUIContributor.optionalProps.label"));
        this.delimitedStringControl = new DelimitedStringList(parentComposite, 0, isReadOnly);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        this.delimitedStringControl.setLayoutData(gd);
        this.addListeners();
    }

    public void setDriverUIContributorInformation(IDriverUIContributorInformation contributorInformation) {
        this.properties = contributorInformation.getProperties();
    }

    protected void addListeners() {
        this.delimitedStringControl.addModifyListener(this);
    }

    protected void removeListeners() {
        this.delimitedStringControl.removeModifyListener(this);
    }

    public boolean validateControl(DialogPage page) {
        boolean isValid = true;
        if (this.delimitedStringControl.getWarning() != null) {
            page.setErrorMessage(this.delimitedStringControl.getWarning());
            isValid = false;
        }
        return isValid;
    }

    public void modifyText(ModifyEvent e) {
        if (this.isReadOnly) {
            return;
        }
        this.setConnectionInformation();
    }

    public void loadProperties() {
        this.removeListeners();
        String propertyList = this.properties.getProperty("org.eclipse.datatools.connectivity.db.connectionProperties");
        if (propertyList != null) {
            this.delimitedStringControl.setSelection(propertyList);
        }
        this.addListeners();
    }

    public void setConnectionInformation() {
        this.properties.setProperty("org.eclipse.datatools.connectivity.db.connectionProperties", this.delimitedStringControl.getSelection());
    }
}

