/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.generator;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.comma.actions.actions.Action;
import org.eclipse.comma.actions.actions.ActionList;
import org.eclipse.comma.actions.actions.AssignmentAction;
import org.eclipse.comma.actions.actions.CommandEvent;
import org.eclipse.comma.actions.actions.CommandReply;
import org.eclipse.comma.actions.actions.EventCall;
import org.eclipse.comma.actions.actions.IfAction;
import org.eclipse.comma.actions.actions.PCFragment;
import org.eclipse.comma.actions.actions.ParallelComposition;
import org.eclipse.comma.actions.actions.RecordFieldAssignmentAction;
import org.eclipse.comma.actions.utilities.ActionsUtilities;
import org.eclipse.comma.behavior.behavior.AbstractBehavior;
import org.eclipse.comma.behavior.behavior.Clause;
import org.eclipse.comma.behavior.behavior.InAllStatesBlock;
import org.eclipse.comma.behavior.behavior.NonTriggeredTransition;
import org.eclipse.comma.behavior.behavior.State;
import org.eclipse.comma.behavior.behavior.StateMachine;
import org.eclipse.comma.behavior.behavior.Transition;
import org.eclipse.comma.behavior.behavior.TriggeredTransition;
import org.eclipse.comma.behavior.interfaces.interfaceDefinition.Interface;
import org.eclipse.comma.behavior.utilities.StateMachineUtilities;
import org.eclipse.comma.expressions.expression.Expression;
import org.eclipse.comma.expressions.expression.ExpressionQuantifier;
import org.eclipse.comma.expressions.expression.Variable;
import org.eclipse.comma.monitoring.generator.ConstraintsRulesGenerator;
import org.eclipse.comma.monitoring.generator.TypesJavaGenerator;
import org.eclipse.comma.signature.interfaceSignature.Command;
import org.eclipse.comma.signature.interfaceSignature.DIRECTION;
import org.eclipse.comma.signature.interfaceSignature.InterfaceEvent;
import org.eclipse.comma.signature.interfaceSignature.Notification;
import org.eclipse.comma.signature.interfaceSignature.Parameter;
import org.eclipse.comma.signature.interfaceSignature.Signature;
import org.eclipse.comma.signature.utilities.InterfaceUtilities;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.generator.IFileSystemAccess;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.ExclusiveRange;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class InterfaceDecisionGenerator
extends ConstraintsRulesGenerator {
    protected Signature signature;
    protected Map<InterfaceEvent, StateMachine> event2Machine;
    protected Map<Clause, String> clause2Method;
    protected Map<TriggeredTransition, String> transition2Method;
    private Map<StateMachine, List<InterfaceEvent>> eventPartitions;

    public InterfaceDecisionGenerator(Signature signature, Interface behavior, boolean recordsPresent, IFileSystemAccess fsa) {
        super((AbstractBehavior)behavior, recordsPresent, fsa);
        this.signature = signature;
    }

    public void generateUtilityClass() {
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(InterfaceDecisionGenerator.utilityClassName(this.signature).toString()), this.generateUtilityClassContent(this.behavior));
    }

    public void generateDecisionClass() {
        this.fsa.generateFile(TypesJavaGenerator.generatedFileName(InterfaceDecisionGenerator.decisionClassName(this.signature).toString()), this.generateDecisionClassContent());
    }

    protected CharSequence generateUtilityClassContent(AbstractBehavior intdef) {
        boolean _not;
        boolean _greaterThan;
        Object _name_9;
        StringConcatenation _xblockexpression = null;
        EList machines = intdef.getMachines();
        this.quantifiersInMachines = this.getQuantifiersInStateMachines(intdef, (List<StateMachine>)machines);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.LinkedHashMap;");
        _builder.newLine();
        _builder.append("import java.util.HashSet;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".CState;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        if (this.recordsPresent) {
            _builder.append("import ");
            String _join = IterableExtensions.join(TypesJavaGenerator.recordPackageFragments, (CharSequence)".");
            _builder.append(_join);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _utilityClassName = InterfaceDecisionGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName);
        _builder.append(" extends CState {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("/* global variables from the spec */");
        _builder.newLine();
        EList _vars = intdef.getVars();
        for (Object v : _vars) {
            _builder.append("\t");
            _builder.append("private ");
            CharSequence _javaType = this.toJavaType((EObject)v.getType());
            _builder.append((Object)_javaType, "\t");
            _builder.append(" ");
            _builder.append("commaVar_", "\t");
            String _name = v.getName();
            _builder.append(_name, "\t");
            _builder.append(" = ");
            CharSequence _defaultValue = this.defaultValue((EObject)v.getType());
            _builder.append((Object)_defaultValue, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* variables for current state in machines */");
        _builder.newLine();
        for (StateMachine sm : machines) {
            _builder.append("\t");
            _builder.append("private String ");
            String _name_1 = sm.getName();
            _builder.append(_name_1, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* getters and setters for global variables */");
        _builder.newLine();
        EList _vars_1 = intdef.getVars();
        for (Object v_1 : _vars_1) {
            _builder.append("\t");
            _builder.append("public ");
            CharSequence _javaType_1 = this.toJavaType((EObject)v_1.getType());
            _builder.append((Object)_javaType_1, "\t");
            _builder.append(" get_");
            _builder.append("commaVar_", "\t");
            String _name_2 = v_1.getName();
            _builder.append(_name_2, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            _builder.append("commaVar_", "\t\t");
            String _name_3 = v_1.getName();
            _builder.append(_name_3, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void set_");
            _builder.append("commaVar_", "\t");
            String _name_4 = v_1.getName();
            _builder.append(_name_4, "\t");
            _builder.append("(");
            CharSequence _javaType_2 = this.toJavaType((EObject)v_1.getType());
            _builder.append((Object)_javaType_2, "\t");
            _builder.append(" p) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("commaVar_", "\t\t");
            String _name_5 = v_1.getName();
            _builder.append(_name_5, "\t\t");
            _builder.append(" = p;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("/* getters and setter for variables that hold current state */");
        _builder.newLine();
        for (StateMachine sm_1 : machines) {
            _builder.append("\t");
            _builder.append("public String get_");
            String _name_6 = sm_1.getName();
            _builder.append(_name_6, "\t");
            _builder.append("() {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("return ");
            String _name_7 = sm_1.getName();
            _builder.append(_name_7, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("public void set_");
            String _name_8 = sm_1.getName();
            _builder.append(_name_8, "\t");
            _builder.append("(String p) {");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("if(!");
            _name_9 = sm_1.getName();
            _builder.append((String)_name_9, "\t\t");
            _builder.append(".equals(p)){");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("activeStates.remove(");
            String _name_10 = sm_1.getName();
            _builder.append(_name_10, "\t\t\t");
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("\t\t");
            _builder.append("activeStates.add(p);");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            String _name_11 = sm_1.getName();
            _builder.append(_name_11, "\t\t");
            _builder.append(" = p;");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
            _builder.append("\t");
            _builder.newLine();
        }
        int _size = this.quantifiersInMachines.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("\t");
            _builder.append("/* methods that implement quantifiers */");
            _builder.newLine();
            for (ExpressionQuantifier quantifier : this.quantifiersInMachines) {
                _builder.append("\t");
                CharSequence _generateQuantifierMethod = this.generateQuantifierMethod(quantifier, this.quantifiersInMachines.indexOf(quantifier));
                _builder.append((Object)_generateQuantifierMethod, "\t");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("/* constructor that performs initialization */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _utilityClassName_1 = InterfaceDecisionGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("/* initialization of the set with active states of the state machines */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("activeStates = new HashSet<String>();");
        _builder.newLine();
        Functions.Function1<StateMachine, EList<State>> _function = new Functions.Function1<StateMachine, EList<State>>(){

            public EList<State> apply(StateMachine it) {
                return it.getStates();
            }
        };
        Functions.Function1<State, Boolean> _function_1 = new Functions.Function1<State, Boolean>(){

            public Boolean apply(State s) {
                return s.isInitial();
            }
        };
        Iterable _filter = IterableExtensions.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)machines, (Functions.Function1)_function)), (Functions.Function1)_function_1);
        _name_9 = _filter.iterator();
        while (_name_9.hasNext()) {
            State s = (State)_name_9.next();
            _builder.append("\t\t");
            _builder.append("activeStates.add(\"");
            String _name_12 = s.getName();
            _builder.append(_name_12, "\t\t");
            _builder.append("\");");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of global variables in model init section */");
        _builder.newLine();
        EList _initActions = intdef.getInitActions();
        for (Object a : _initActions) {
            _builder.append("\t\t");
            CharSequence _generateAction = this.generateAction((Action)a);
            _builder.append((Object)_generateAction, "\t\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initilization of current state variables */");
        _builder.newLine();
        for (StateMachine sm_2 : machines) {
            _builder.append("\t\t");
            String _name_13 = sm_2.getName();
            _builder.append(_name_13, "\t\t");
            _builder.append(" = \"");
            Functions.Function1<State, Boolean> _function_2 = new Functions.Function1<State, Boolean>(){

                public Boolean apply(State s) {
                    return s.isInitial();
                }
            };
            String _name_14 = ((State[])Conversions.unwrapArray((Object)IterableExtensions.filter((Iterable)sm_2.getStates(), (Functions.Function1)_function_2), State.class))[0].getName();
            _builder.append(_name_14, "\t\t");
            _builder.append("\";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of the last execution state */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("executionState = \"\";");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("/* initialization of coverage info */");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("clauseMap = new LinkedHashMap<String, Integer>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("stateMap = new LinkedHashMap<String, Integer>();");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.newLine();
        for (StateMachine m : machines) {
            EList _states = m.getStates();
            for (State s_1 : _states) {
                _builder.append("\t\t");
                _builder.append("stateMap.put(\"");
                String _name_15 = s_1.getName();
                _builder.append(_name_15, "\t\t");
                _builder.append("\", ");
                boolean _isInitial = s_1.isInitial();
                if (_isInitial) {
                    _builder.append("1");
                } else {
                    _builder.append("0");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
                _builder.append("\t\t");
                List allTransitionInState = StateMachineUtilities.transitionsForState((State)s_1);
                _builder.newLineIfNotEmpty();
                int _size_1 = allTransitionInState.size();
                ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size_1, true);
                for (Integer ti : _doubleDotLessThan) {
                    int _size_2 = ((Transition)allTransitionInState.get(ti)).getClauses().size();
                    ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _size_2, true);
                    for (Integer ci : _doubleDotLessThan_1) {
                        _builder.append("\t\t");
                        _builder.append("clauseMap.put(\"");
                        String _name_16 = s_1.getName();
                        _builder.append(_name_16, "\t\t");
                        _builder.append(" transition ");
                        _builder.append((Object)(ti + 1), "\t\t");
                        CharSequence _eventName = this.getEventName((Transition)allTransitionInState.get(ti), (Clause)((Transition)allTransitionInState.get(ti)).getClauses().get(ci.intValue()));
                        _builder.append((Object)_eventName, "\t\t");
                        _builder.append(" clause ");
                        _builder.append((Object)(ci + 1), "\t\t");
                        _builder.append("\", 0);");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
        }
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("/* print method */");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public String toString() {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("String result = \"Values of global variables and current machine states:\" + \"\\n\\n\";");
        _builder.newLine();
        boolean _isEmpty = intdef.getVars().isEmpty();
        boolean bl2 = _not = !_isEmpty;
        if (_not) {
            EList _vars_2 = intdef.getVars();
            for (Variable v_2 : _vars_2) {
                _builder.append("\t\t");
                _builder.append("result = result + \"");
                String _name_17 = v_2.getName();
                _builder.append(_name_17, "\t\t");
                _builder.append(" = \" + ");
                _builder.append("commaVar_", "\t\t");
                String _name_18 = v_2.getName();
                _builder.append(_name_18, "\t\t");
                _builder.append(" + \"\\n\";");
                _builder.newLineIfNotEmpty();
            }
        } else {
            _builder.append("\t\t");
            _builder.append("result = result + \"No global variables\" + \"\\n\";");
            _builder.newLine();
        }
        for (StateMachine m_1 : machines) {
            _builder.append("\t\t");
            _builder.append("result = result + \"Machine ");
            String _name_19 = m_1.getName();
            _builder.append(_name_19, "\t\t");
            _builder.append(" in state \" + ");
            String _name_20 = m_1.getName();
            _builder.append(_name_20, "\t\t");
            _builder.append(" + \"\\n\";");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("return result;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    protected CharSequence generateDecisionClassContent() {
        StringConcatenation _xblockexpression = null;
        this.eventPartitions = StateMachineUtilities.getEventPartitions((AbstractBehavior)this.behavior, (Signature)this.signature);
        HashMap<InterfaceEvent, StateMachine> _hashMap = new HashMap<InterfaceEvent, StateMachine>();
        this.event2Machine = _hashMap;
        HashMap<Clause, String> _hashMap_1 = new HashMap<Clause, String>();
        this.clause2Method = _hashMap_1;
        HashMap<TriggeredTransition, String> _hashMap_2 = new HashMap<TriggeredTransition, String>();
        this.transition2Method = _hashMap_2;
        List events = InterfaceUtilities.getAllInterfaceEvents((Signature)this.signature);
        for (InterfaceEvent ev : events) {
            Set<StateMachine> _keySet = this.eventPartitions.keySet();
            for (StateMachine sm : _keySet) {
                boolean _contains = this.eventPartitions.get(sm).contains(ev);
                if (!_contains) continue;
                this.event2Machine.put(ev, sm);
            }
        }
        EList machines = this.behavior.getMachines();
        this.quantifiersInMachines = this.getQuantifiersInStateMachines(this.behavior, (List<StateMachine>)machines);
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generatedPackage = TypesJavaGenerator.generatedPackage();
        _builder.append((Object)_generatedPackage);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        _builder.append("import java.util.ArrayList;");
        _builder.newLine();
        _builder.append("import java.util.List;");
        _builder.newLine();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".values.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".messages.*;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".utils.Utils;");
        _builder.newLineIfNotEmpty();
        _builder.append("import ");
        _builder.append(TypesJavaGenerator.rootPackage);
        _builder.append(".constraints.CRule;");
        _builder.newLineIfNotEmpty();
        if (this.recordsPresent) {
            _builder.append("import ");
            String _join = IterableExtensions.join(TypesJavaGenerator.recordPackageFragments, (CharSequence)".");
            _builder.append(_join);
            _builder.append(".*;");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append("public class ");
        CharSequence _decisionClassName = InterfaceDecisionGenerator.decisionClassName(this.signature);
        _builder.append((Object)_decisionClassName);
        _builder.append(" extends CInterfaceDecisionClass {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        CharSequence _utilityClassName = InterfaceDecisionGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName, "\t");
        _builder.append(" stateOfDecisionClass;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        CharSequence _utilityClassName_1 = InterfaceDecisionGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_1, "\t");
        _builder.append(" lastReceivedState;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("private ");
        CharSequence _rulesClassName = this.rulesClassName();
        _builder.append((Object)_rulesClassName, "\t");
        _builder.append(" rulesProvider;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public ");
        CharSequence _decisionClassName_1 = InterfaceDecisionGenerator.decisionClassName(this.signature);
        _builder.append((Object)_decisionClassName_1, "\t");
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = new ");
        CharSequence _utilityClassName_2 = InterfaceDecisionGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_2, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("lastReceivedState = new ");
        CharSequence _utilityClassName_3 = InterfaceDecisionGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_3, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("rulesProvider = new ");
        CharSequence _rulesClassName_1 = this.rulesClassName();
        _builder.append((Object)_rulesClassName_1, "\t\t");
        _builder.append("();");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public void setState(CState state) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("lastReceivedState = (");
        CharSequence _utilityClassName_4 = InterfaceDecisionGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_4, "\t\t");
        _builder.append(") state;");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("stateOfDecisionClass = (");
        CharSequence _utilityClassName_5 = InterfaceDecisionGenerator.utilityClassName(this.signature);
        _builder.append((Object)_utilityClassName_5, "\t\t");
        _builder.append(") Utils.deepCopy(lastReceivedState);");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CState getState() {");
        _builder.newLine();
        _builder.append("\t    ");
        _builder.append("return stateOfDecisionClass;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public CInterfaceDecisionResult consume(CObservedMessage message) {");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("switch(message.getName()) {");
        _builder.newLine();
        for (InterfaceEvent e : events) {
            _builder.append("\t\t\t");
            _builder.append("\t");
            int j = 0;
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t\t");
            _builder.append("case \"");
            String _name = e.getName();
            _builder.append(_name, "\t\t\t");
            _builder.append("\" : return ");
            String _name_1 = e.getName();
            _builder.append(_name_1, "\t\t\t");
            _builder.append("(");
            if (!(e instanceof Notification)) {
                EList _parameters = e.getParameters();
                boolean _hasElements = false;
                for (Parameter p : _parameters) {
                    boolean _notEquals;
                    if (!_hasElements) {
                        _hasElements = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t\t\t");
                    }
                    DIRECTION _direction = p.getDirection();
                    boolean bl = _notEquals = !Objects.equal((Object)_direction, (Object)DIRECTION.OUT);
                    if (_notEquals) {
                        _builder.append("(");
                        CharSequence _javaType = this.toJavaType((EObject)p.getType());
                        _builder.append((Object)_javaType, "\t\t\t");
                        _builder.append(") message.getParameters().get(");
                        int _plusPlus = j++;
                        _builder.append((Object)_plusPlus, "\t\t\t");
                        _builder.append(")");
                        continue;
                    }
                    CharSequence _defaultValue = this.defaultValue((EObject)p.getType());
                    _builder.append((Object)_defaultValue, "\t\t\t");
                }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t\t");
        _builder.append("default: return unknownEvent;");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.newLine();
        for (InterfaceEvent e_1 : events) {
            _builder.append("\t");
            CharSequence _generateEventRootMethod = this.generateEventRootMethod(e_1);
            _builder.append((Object)_generateEventRootMethod, "\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.newLine();
        }
        _builder.append("\t");
        CharSequence _generateClauseMethods = this.generateClauseMethods((List<StateMachine>)machines);
        _builder.append((Object)_generateClauseMethods, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateTriggeredMethodsInStates = this.generateTriggeredMethodsInStates((List<StateMachine>)machines, events);
        _builder.append((Object)_generateTriggeredMethodsInStates, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _generateNonTriggeredMethodsInStates = this.generateNonTriggeredMethodsInStates((List<StateMachine>)machines, events);
        _builder.append((Object)_generateNonTriggeredMethodsInStates, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("@Override");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("public List<CRule> getRules() {");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("return rulesProvider.getRules();");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateClauseMethods(List<StateMachine> machines) {
        StringConcatenation _builder = new StringConcatenation();
        for (StateMachine m : machines) {
            CharSequence _generateClauseMethods = this.generateClauseMethods(m);
            _builder.append((Object)_generateClauseMethods);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateClauseMethods(StateMachine m) {
        StringConcatenation _builder = new StringConcatenation();
        int _size = m.getInAllStates().size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            CharSequence _generateClauseMethods = this.generateClauseMethods(m, "block" + Integer.valueOf(i + 1), (List<Transition>)((InAllStatesBlock)m.getInAllStates().get(i.intValue())).getTransitions());
            _builder.append((Object)_generateClauseMethods);
            _builder.newLineIfNotEmpty();
        }
        int _size_1 = m.getStates().size();
        ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _size_1, true);
        for (Integer i_1 : _doubleDotLessThan_1) {
            CharSequence _generateClauseMethods_1 = this.generateClauseMethods(m, ((State)m.getStates().get(i_1.intValue())).getName(), (List<Transition>)((State)m.getStates().get(i_1.intValue())).getTransitions());
            _builder.append((Object)_generateClauseMethods_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence generateClauseMethods(StateMachine m, String nameFragment, List<Transition> transitions) {
        StringConcatenation _builder = new StringConcatenation();
        int _size = transitions.size();
        ExclusiveRange _doubleDotLessThan = new ExclusiveRange(0, _size, true);
        for (Integer i : _doubleDotLessThan) {
            int _size_1 = transitions.get(i).getClauses().size();
            ExclusiveRange _doubleDotLessThan_1 = new ExclusiveRange(0, _size_1, true);
            for (Integer j : _doubleDotLessThan_1) {
                String _name = m.getName();
                String _plus = String.valueOf(_name) + "_";
                String _plus_1 = String.valueOf(_plus) + nameFragment;
                String _plus_2 = String.valueOf(_plus_1) + "_t";
                String _plus_3 = String.valueOf(_plus_2) + Integer.valueOf(i + 1);
                String _plus_4 = String.valueOf(_plus_3) + "_c";
                String methodName = String.valueOf(_plus_4) + Integer.valueOf(j + 1);
                _builder.newLineIfNotEmpty();
                CharSequence _generateClauseMethod = this.generateClauseMethod(m, methodName, transitions.get(i), (Clause)transitions.get(i).getClauses().get(j.intValue()));
                _builder.append((Object)_generateClauseMethod);
                _builder.newLineIfNotEmpty();
                _builder.newLine();
            }
            Transition _get = transitions.get(i);
            if (!(_get instanceof TriggeredTransition)) continue;
            String _name_1 = m.getName();
            String _plus_5 = String.valueOf(_name_1) + "_";
            String _plus_6 = String.valueOf(_plus_5) + nameFragment;
            String _plus_7 = String.valueOf(_plus_6) + "_t";
            String _plus_8 = String.valueOf(_plus_7) + Integer.valueOf(i + 1);
            Transition _get_1 = transitions.get(i);
            CharSequence _generateTriggeredTransitionMethod = this.generateTriggeredTransitionMethod(m, _plus_8, (TriggeredTransition)_get_1);
            _builder.append((Object)_generateTriggeredTransitionMethod);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateTriggeredTransitionMethod(StateMachine m, String methodName, TriggeredTransition transition) {
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        this.transition2Method.put(transition, methodName);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private void ");
        _builder.append(methodName);
        _builder.append("(String stateName, int tIndex, List<CExecutionContext> result");
        EList _parameters = transition.getParameters();
        for (Variable p : _parameters) {
            _builder.append(", ");
            CharSequence _javaType = this.toJavaType((EObject)p.getType());
            _builder.append((Object)_javaType);
            _builder.append(" ");
            _builder.append("commaTVar_");
            String _name = p.getName();
            _builder.append(_name);
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        Expression _guard = transition.getGuard();
        boolean bl = _tripleNotEquals = _guard != null;
        if (_tripleNotEquals) {
            _builder.append("\t");
            _builder.append("if(");
            CharSequence _generateExpression = this.generateExpression(transition.getGuard());
            _builder.append((Object)_generateExpression, "\t");
            _builder.append("){");
            _builder.newLineIfNotEmpty();
            EList _clauses = transition.getClauses();
            for (Clause c : _clauses) {
                _builder.append("\t");
                _builder.append("//TODO deep copy of params");
                _builder.newLine();
                _builder.append("\t");
                String _get = this.clause2Method.get(c);
                _builder.append(_get, "\t");
                _builder.append("(stateName, tIndex, result");
                EList _parameters_1 = transition.getParameters();
                for (Variable p_1 : _parameters_1) {
                    _builder.append(", ");
                    _builder.append("commaTVar_", "\t");
                    String _name_1 = p_1.getName();
                    _builder.append(_name_1, "\t");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("}");
            _builder.newLine();
        } else {
            EList _clauses_1 = transition.getClauses();
            for (Clause c_1 : _clauses_1) {
                _builder.append("\t");
                _builder.append("//TODO deep copy of params");
                _builder.newLine();
                _builder.append("\t");
                String _get_1 = this.clause2Method.get(c_1);
                _builder.append(_get_1, "\t");
                _builder.append("(stateName, tIndex, result");
                EList _parameters_2 = transition.getParameters();
                for (Variable p_2 : _parameters_2) {
                    _builder.append(", ");
                    _builder.append("commaTVar_", "\t");
                    String _name_2 = p_2.getName();
                    _builder.append(_name_2, "\t");
                }
                _builder.append(");");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateClauseMethod(StateMachine m, String methodName, Transition transition, Clause clause) {
        boolean _tripleNotEquals_2;
        boolean _tripleNotEquals_1;
        boolean _tripleNotEquals;
        StringConcatenation _xblockexpression = null;
        this.clause2Method.put(clause, methodName);
        String _xifexpression = null;
        if (transition instanceof TriggeredTransition) {
            StringConcatenation _builder = new StringConcatenation();
            EList _parameters = ((TriggeredTransition)transition).getParameters();
            for (Variable p : _parameters) {
                _builder.append(", ");
                CharSequence _javaType = this.toJavaType((EObject)p.getType());
                _builder.append((Object)_javaType);
                _builder.append(" ");
                _builder.append("commaTVar_");
                String _name = p.getName();
                _builder.append(_name);
            }
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _xifexpression = _builder_1.toString();
        }
        String parametersList = _xifexpression;
        CharSequence eventName = this.getEventName(transition, clause);
        StringConcatenation _builder_2 = new StringConcatenation();
        _builder_2.append("private void ");
        _builder_2.append(methodName);
        _builder_2.append("(String stateName, int tIndex, List<CExecutionContext> result");
        _builder_2.append(parametersList);
        _builder_2.append(") {");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append("String clauseKey = stateName + \" transition \" + (tIndex + 1) + \"");
        _builder_2.append((Object)eventName, "\t");
        _builder_2.append("\" + \" clause ");
        int _indexOf = transition.getClauses().indexOf((Object)clause);
        int _plus = _indexOf + 1;
        _builder_2.append((Object)_plus, "\t");
        _builder_2.append("\";");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append("CExecutionContext context = new CExecutionContext();");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("stateOfDecisionClass = (");
        CharSequence _utilityClassName = InterfaceDecisionGenerator.utilityClassName(this.signature);
        _builder_2.append((Object)_utilityClassName, "\t");
        _builder_2.append(") Utils.deepCopy(lastReceivedState);");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append("stateOfDecisionClass.takeSnapshot();");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("CMessagePattern mp;");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("CParallelCompositionPattern pc;");
        _builder_2.newLine();
        ActionList _actions = clause.getActions();
        boolean bl = _tripleNotEquals = _actions != null;
        if (_tripleNotEquals) {
            EList _actions_1 = clause.getActions().getActions();
            for (Action a : _actions_1) {
                _builder_2.append("\t");
                CharSequence _generateActionInContext = this.generateActionInContext(a, null);
                _builder_2.append((Object)_generateActionInContext, "\t");
                _builder_2.append(";");
                _builder_2.newLineIfNotEmpty();
            }
        }
        _builder_2.append("\t");
        _builder_2.append("//end of actions");
        _builder_2.newLine();
        _builder_2.append("\t");
        _builder_2.append("//check for runtime errors");
        _builder_2.newLine();
        if (transition instanceof TriggeredTransition) {
            _builder_2.append("\t");
            _builder_2.append("//checkTriggeredTransition(context)();");
            _builder_2.newLine();
        } else {
            _builder_2.append("\t");
            _builder_2.append("//checkNonTriggeredTransition(context)();");
            _builder_2.newLine();
        }
        _builder_2.append("\t");
        _builder_2.append("stateOfDecisionClass.set_");
        String _name_1 = m.getName();
        _builder_2.append(_name_1, "\t");
        _builder_2.append("(");
        State _target = clause.getTarget();
        boolean bl2 = _tripleNotEquals_1 = _target != null;
        if (_tripleNotEquals_1) {
            _builder_2.append("\"");
            String _name_2 = clause.getTarget().getName();
            _builder_2.append(_name_2, "\t");
            _builder_2.append("\"");
        } else {
            _builder_2.append("stateName");
        }
        _builder_2.append(");");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append("updateState(stateOfDecisionClass, stateName, ");
        State _target_1 = clause.getTarget();
        boolean bl3 = _tripleNotEquals_2 = _target_1 != null;
        if (_tripleNotEquals_2) {
            _builder_2.append("\"");
            String _name_3 = clause.getTarget().getName();
            _builder_2.append(_name_3, "\t");
            _builder_2.append("\"");
        } else {
            _builder_2.append("stateName");
        }
        _builder_2.append(", clauseKey, context);");
        _builder_2.newLineIfNotEmpty();
        _builder_2.append("\t");
        _builder_2.append("result.add(context);");
        _builder_2.newLine();
        _builder_2.append("}");
        _builder_2.newLine();
        _xblockexpression = _builder_2;
        return _xblockexpression;
    }

    public CharSequence generateTriggeredMethodsInStates(List<StateMachine> machines, List<InterfaceEvent> events) {
        StringConcatenation _builder = new StringConcatenation();
        for (StateMachine sm : machines) {
            EList _states = sm.getStates();
            for (State state : _states) {
                Functions.Function1<InterfaceEvent, Boolean> _function = new Functions.Function1<InterfaceEvent, Boolean>(){

                    public Boolean apply(InterfaceEvent e) {
                        return !(e instanceof Notification);
                    }
                };
                Iterable _filter = IterableExtensions.filter(events, (Functions.Function1)_function);
                for (InterfaceEvent ev : _filter) {
                    boolean _not;
                    List<TriggeredTransition> transitions = this.getTriggeredTransitionsInState(ev, state);
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = transitions.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (!_not) continue;
                    CharSequence _generateTriggeredTransitionMethodInState = this.generateTriggeredTransitionMethodInState(ev, transitions, state);
                    _builder.append((Object)_generateTriggeredTransitionMethodInState);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                }
            }
        }
        return _builder;
    }

    public CharSequence generateNonTriggeredMethodsInStates(List<StateMachine> machines, List<InterfaceEvent> events) {
        StringConcatenation _builder = new StringConcatenation();
        for (StateMachine sm : machines) {
            EList _states = sm.getStates();
            for (State state : _states) {
                Iterable _filter = Iterables.filter(events, Notification.class);
                for (Notification n : _filter) {
                    boolean _not;
                    List<NonTriggeredTransition> transitions = this.getNonTriggeredTransitionsInState((InterfaceEvent)n, state);
                    _builder.newLineIfNotEmpty();
                    boolean _isEmpty = transitions.isEmpty();
                    boolean bl = _not = !_isEmpty;
                    if (!_not) continue;
                    CharSequence _generateNonTriggeredTransitionMethodInState = this.generateNonTriggeredTransitionMethodInState((InterfaceEvent)n, transitions, state);
                    _builder.append((Object)_generateNonTriggeredTransitionMethodInState);
                    _builder.newLineIfNotEmpty();
                    _builder.newLine();
                }
            }
        }
        return _builder;
    }

    public CharSequence generateEventRootMethod(InterfaceEvent event) {
        StringConcatenation _xblockexpression = null;
        StateMachine stateMachine = this.event2Machine.get(event);
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CInterfaceDecisionResult ");
        String _name = event.getName();
        _builder.append(_name);
        _builder.append("(");
        if (!(event instanceof Notification)) {
            EList _parameters = event.getParameters();
            boolean _hasElements = false;
            for (Parameter p : _parameters) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)", ", "");
                }
                CharSequence _javaType = this.toJavaType((EObject)p.getType());
                _builder.append((Object)_javaType);
                _builder.append(" ");
                _builder.append("commaTVar_");
                String _name_1 = p.getName();
                _builder.append(_name_1);
            }
        }
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("switch(stateOfDecisionClass.get_");
        String _name_2 = stateMachine.getName();
        _builder.append(_name_2, "\t");
        _builder.append("()) {");
        _builder.newLineIfNotEmpty();
        EList _states = stateMachine.getStates();
        for (State s : _states) {
            boolean _not;
            boolean _emptyTransitionsInState = this.emptyTransitionsInState(event, s);
            boolean bl = _not = !_emptyTransitionsInState;
            if (!_not) continue;
            _builder.append("\t");
            _builder.append("case \"");
            String _name_3 = s.getName();
            _builder.append(_name_3, "\t");
            _builder.append("\": return ");
            String _name_4 = s.getName();
            _builder.append(_name_4, "\t");
            _builder.append("_");
            String _name_5 = event.getName();
            _builder.append(_name_5, "\t");
            _builder.append("(");
            if (!(event instanceof Notification)) {
                EList _parameters_1 = event.getParameters();
                boolean _hasElements_1 = false;
                for (Parameter p_1 : _parameters_1) {
                    if (!_hasElements_1) {
                        _hasElements_1 = true;
                    } else {
                        _builder.appendImmediate((Object)", ", "\t");
                    }
                    _builder.append("commaTVar_", "\t");
                    String _name_6 = p_1.getName();
                    _builder.append(_name_6, "\t");
                }
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("default: return noTransitions;");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("}");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public CharSequence generateTriggeredTransitionMethodInState(InterfaceEvent event, List<TriggeredTransition> transitions, State s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CInterfaceDecisionResult ");
        String _name = s.getName();
        _builder.append(_name);
        _builder.append("_");
        String _name_1 = event.getName();
        _builder.append(_name_1);
        _builder.append("(");
        EList _parameters = event.getParameters();
        boolean _hasElements = false;
        for (Parameter p : _parameters) {
            if (!_hasElements) {
                _hasElements = true;
            } else {
                _builder.appendImmediate((Object)", ", "");
            }
            CharSequence _javaType = this.toJavaType((EObject)p.getType());
            _builder.append((Object)_javaType);
            _builder.append(" ");
            _builder.append("commaVar_");
            String _name_2 = p.getName();
            _builder.append(_name_2);
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("List<CExecutionContext> result = new ArrayList<CExecutionContext>();");
        _builder.newLine();
        for (TriggeredTransition t : transitions) {
            boolean _greaterThan;
            _builder.append("\t");
            int transitionIndex = StateMachineUtilities.transitionsForState((State)s).indexOf(t);
            _builder.newLineIfNotEmpty();
            int _indexOf = transitions.indexOf(t);
            boolean bl = _greaterThan = _indexOf > 0;
            if (_greaterThan) {
                _builder.append("\t");
                _builder.append("stateOfDecisionClass = (");
                CharSequence _utilityClassName = InterfaceDecisionGenerator.utilityClassName(this.signature);
                _builder.append((Object)_utilityClassName, "\t");
                _builder.append(") Utils.deepCopy(lastReceivedState);");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            String _get = this.transition2Method.get(t);
            _builder.append(_get, "\t");
            _builder.append("(\"");
            String _name_3 = s.getName();
            _builder.append(_name_3, "\t");
            _builder.append("\", ");
            _builder.append((Object)transitionIndex, "\t");
            _builder.append(", result");
            EList _parameters_1 = event.getParameters();
            for (Parameter p_1 : _parameters_1) {
                _builder.append(", ");
                _builder.append("commaVar_", "\t");
                String _name_4 = p_1.getName();
                _builder.append(_name_4, "\t");
            }
            _builder.append(");");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("\t");
        _builder.append("return checkTransitionsResult(result);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateNonTriggeredTransitionBody(NonTriggeredTransition t, State s, InterfaceEvent ev, int transitionIndex) {
        StringConcatenation _xblockexpression = null;
        ArrayList<Clause> clauses = this.getClausesForOutgoingEvent(t, ev);
        StringConcatenation _builder = new StringConcatenation();
        for (Clause c : clauses) {
            String _get = this.clause2Method.get(c);
            _builder.append(_get);
            _builder.append("(\"");
            String _name = s.getName();
            _builder.append(_name);
            _builder.append("\", ");
            _builder.append((Object)transitionIndex);
            _builder.append(", result);");
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    public ArrayList<Clause> getClausesForOutgoingEvent(NonTriggeredTransition t, final InterfaceEvent ev) {
        ArrayList<Clause> _xblockexpression = null;
        ArrayList<Clause> result = new ArrayList<Clause>();
        EList _clauses = t.getClauses();
        for (Clause c : _clauses) {
            boolean _not;
            Class<EventCall> clazz = EventCall.class;
            LinkedList<Object> actions = new LinkedList<Object>();
            Functions.Function1<EventCall, Boolean> _function = new Functions.Function1<EventCall, Boolean>(){

                public Boolean apply(EventCall e) {
                    InterfaceEvent _event = e.getEvent();
                    return Objects.equal((Object)_event, (Object)ev);
                }
            };
            Iterable _filter = IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)t, clazz), (Functions.Function1)_function);
            for (EventCall a : _filter) {
                actions.add(a);
            }
            List _allContentsOfType = EcoreUtil2.getAllContentsOfType((EObject)t, ParallelComposition.class);
            for (ParallelComposition pc : _allContentsOfType) {
                List _flatten = ActionsUtilities.flatten((PCFragment)pc);
                for (Action a_1 : _flatten) {
                    InterfaceEvent _event;
                    boolean _equals;
                    if (!(a_1 instanceof EventCall) || !(_equals = Objects.equal((Object)(_event = ((EventCall)a_1).getEvent()), (Object)ev))) continue;
                    actions.add(a_1);
                }
            }
            boolean _isEmpty = actions.isEmpty();
            boolean bl = _not = !_isEmpty;
            if (!_not) continue;
            result.add(c);
        }
        _xblockexpression = result;
        return _xblockexpression;
    }

    public CharSequence generateNonTriggeredTransitionMethodInState(InterfaceEvent event, List<NonTriggeredTransition> transitions, State s) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("private CInterfaceDecisionResult ");
        String _name = s.getName();
        _builder.append(_name);
        _builder.append("_");
        String _name_1 = event.getName();
        _builder.append(_name_1);
        _builder.append("() {");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("List<CExecutionContext> result = new ArrayList<CExecutionContext>();");
        _builder.newLine();
        for (NonTriggeredTransition t : transitions) {
            Expression _guard;
            boolean _tripleNotEquals;
            boolean _greaterThan;
            _builder.append("\t");
            int transitionIndex = StateMachineUtilities.transitionsForState((State)s).indexOf(t);
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
            _builder.append("//begin transition");
            _builder.newLine();
            int _indexOf = transitions.indexOf(t);
            boolean bl = _greaterThan = _indexOf > 0;
            if (_greaterThan) {
                _builder.append("\t");
                _builder.append("stateOfDecisionClass = (");
                CharSequence _utilityClassName = InterfaceDecisionGenerator.utilityClassName(this.signature);
                _builder.append((Object)_utilityClassName, "\t");
                _builder.append(") Utils.deepCopy(lastReceivedState);");
                _builder.newLineIfNotEmpty();
            }
            boolean bl2 = _tripleNotEquals = (_guard = t.getGuard()) != null;
            if (_tripleNotEquals) {
                _builder.append("\t");
                _builder.append("if(");
                CharSequence _generateExpression = this.generateExpression(t.getGuard());
                _builder.append((Object)_generateExpression, "\t");
                _builder.append(") {");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _generateNonTriggeredTransitionBody = this.generateNonTriggeredTransitionBody(t, s, event, transitionIndex);
                _builder.append((Object)_generateNonTriggeredTransitionBody, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("}");
                _builder.newLine();
            } else {
                _builder.append("\t");
                CharSequence _generateNonTriggeredTransitionBody_1 = this.generateNonTriggeredTransitionBody(t, s, event, transitionIndex);
                _builder.append((Object)_generateNonTriggeredTransitionBody_1, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
            _builder.append("\t");
            _builder.append("//end of transition");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.append("return checkTransitionsResult(result);");
        _builder.newLine();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    public boolean emptyTransitionsInState(InterfaceEvent event, State s) {
        boolean _xifexpression = false;
        _xifexpression = event instanceof Notification ? this.getNonTriggeredTransitionsInState(event, s).isEmpty() : this.getTriggeredTransitionsInState(event, s).isEmpty();
        return _xifexpression;
    }

    public List<TriggeredTransition> getTriggeredTransitionsInState(final InterfaceEvent event, State s) {
        ArrayList<TriggeredTransition> _xblockexpression = null;
        ArrayList<TriggeredTransition> result = new ArrayList<TriggeredTransition>();
        EObject _eContainer = s.eContainer();
        List allTriggeredTransitions = StateMachineUtilities.getTriggeredTransitions((StateMachine)((StateMachine)_eContainer), (State)s);
        Functions.Function1<TriggeredTransition, Boolean> _function = new Functions.Function1<TriggeredTransition, Boolean>(){

            public Boolean apply(TriggeredTransition t) {
                InterfaceEvent _trigger = t.getTrigger();
                return Objects.equal((Object)_trigger, (Object)event);
            }
        };
        Iterables.addAll(result, (Iterable)IterableExtensions.filter((Iterable)allTriggeredTransitions, (Functions.Function1)_function));
        _xblockexpression = result;
        return _xblockexpression;
    }

    public List<NonTriggeredTransition> getNonTriggeredTransitionsInState(final InterfaceEvent event, State s) {
        ArrayList<NonTriggeredTransition> _xblockexpression = null;
        EObject _eContainer = s.eContainer();
        List transitions = StateMachineUtilities.getNonTriggeredTransitions((StateMachine)((StateMachine)_eContainer), (State)s);
        ArrayList<NonTriggeredTransition> transitionsForEvent = new ArrayList<NonTriggeredTransition>();
        for (Transition t : transitions) {
            if (IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)EcoreUtil2.getAllContentsOfType((EObject)t, EventCall.class), (Functions.Function1)new Functions.Function1<EventCall, Boolean>(){

                public Boolean apply(EventCall e) {
                    InterfaceEvent _event = e.getEvent();
                    return Objects.equal((Object)_event, (Object)event);
                }
            })) && IterableExtensions.isEmpty((Iterable)IterableExtensions.filter((Iterable)Iterables.concat((Iterable)ListExtensions.map((List)EcoreUtil2.getAllContentsOfType((EObject)t, ParallelComposition.class), (Functions.Function1)new Functions.Function1<ParallelComposition, List<Action>>(){

                public List<Action> apply(ParallelComposition it) {
                    return ActionsUtilities.flatten((PCFragment)it);
                }
            })), (Functions.Function1)new Functions.Function1<Action, Boolean>(){

                public Boolean apply(Action e) {
                    InterfaceEvent _event = ((EventCall)e).getEvent();
                    return Objects.equal((Object)_event, (Object)event);
                }
            }))) continue;
            transitionsForEvent.add((NonTriggeredTransition)t);
        }
        _xblockexpression = transitionsForEvent;
        return _xblockexpression;
    }

    protected CharSequence _generateActionInContext(AssignmentAction a, InterfaceEvent ev) {
        return this.generateAction((Action)a);
    }

    protected CharSequence _generateActionInContext(IfAction ifact, InterfaceEvent ev) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("if(");
        CharSequence _generateExpression = this.generateExpression(ifact.getGuard());
        _builder.append((Object)_generateExpression);
        _builder.append("){");
        _builder.newLineIfNotEmpty();
        EList _actions = ifact.getThenList().getActions();
        for (Action a : _actions) {
            _builder.append("\t");
            CharSequence _generateActionInContext = this.generateActionInContext(a, ev);
            _builder.append((Object)_generateActionInContext, "\t");
            _builder.append(";");
            _builder.newLineIfNotEmpty();
        }
        ActionList _elseList = ifact.getElseList();
        boolean bl = _tripleNotEquals = _elseList != null;
        if (_tripleNotEquals) {
            _builder.append("}else{");
            _builder.newLine();
            EList _actions_1 = ifact.getElseList().getActions();
            for (Action a_1 : _actions_1) {
                _builder.append("\t");
                CharSequence _generateActionInContext_1 = this.generateActionInContext(a_1, ev);
                _builder.append((Object)_generateActionInContext_1, "\t");
                _builder.append(";");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("}");
        return _builder;
    }

    protected CharSequence _generateActionInContext(RecordFieldAssignmentAction a, InterfaceEvent ev) {
        return this.generateAction((Action)a);
    }

    protected CharSequence _generateActionInContext(CommandReply a, InterfaceEvent ev) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messagePatternFromAction = this.messagePatternFromAction((EObject)a, ev);
        _builder.append((Object)_messagePatternFromAction);
        _builder.newLineIfNotEmpty();
        _builder.append("context.addToExpectedMessages(new CMessageMultiplicityPattern().setMessagePattern(mp).setInterfaceState((CState)Utils.deepCopy(stateOfDecisionClass)))");
        return _builder;
    }

    protected CharSequence _generateActionInContext(EventCall a, InterfaceEvent ev) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _messagePatternFromAction = this.messagePatternFromAction((EObject)a, ev);
        _builder.append((Object)_messagePatternFromAction);
        _builder.newLineIfNotEmpty();
        _builder.append("context.addToExpectedMessages(new CMessageMultiplicityPattern(mp, ");
        _builder.append((Object)ActionsUtilities.getNormalizedMultiplicity((EventCall)a).lower);
        _builder.append(", ");
        _builder.append((Object)ActionsUtilities.getNormalizedMultiplicity((EventCall)a).upper);
        _builder.append(").setInterfaceState((CState)Utils.deepCopy(stateOfDecisionClass)))");
        return _builder;
    }

    protected CharSequence _generateActionInContext(ParallelComposition pc, InterfaceEvent ev) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("pc = new CParallelCompositionPattern();");
        _builder.newLine();
        List _flatten = ActionsUtilities.flatten((PCFragment)pc);
        for (Action c : _flatten) {
            CharSequence _messagePatternFromAction = this.messagePatternFromAction((EObject)c, ev);
            _builder.append((Object)_messagePatternFromAction);
            _builder.newLineIfNotEmpty();
            _builder.append("pc.addElement(new CMessageMultiplicityPattern(mp, ");
            if (c instanceof EventCall) {
                _builder.append((Object)ActionsUtilities.getNormalizedMultiplicity((EventCall)((EventCall)c)).lower);
                _builder.append(", ");
                _builder.append((Object)ActionsUtilities.getNormalizedMultiplicity((EventCall)((EventCall)c)).upper);
            } else {
                _builder.append("1, 1");
            }
            _builder.append("));");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("context.addToExpectedMessages(pc.setInterfaceState((CState)Utils.deepCopy(stateOfDecisionClass)))");
        return _builder;
    }

    protected CharSequence _messagePatternFromAction(EventCall a, InterfaceEvent ev) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("mp = new CNotificationPattern(); mp.setName(\"");
        String _name = a.getEvent().getName();
        _builder.append(_name);
        _builder.append("\");");
        _builder.newLineIfNotEmpty();
        EList _parameters = a.getParameters();
        for (Expression p : _parameters) {
            _builder.append("mp.addParameter(");
            CharSequence _generateExpression = this.generateExpression(p);
            _builder.append((Object)_generateExpression);
            _builder.append(");");
            _builder.newLineIfNotEmpty();
            _builder.append("\t");
        }
        return _builder;
    }

    protected CharSequence _messagePatternFromAction(CommandReply a, InterfaceEvent ev) {
        boolean _greaterThan;
        StringConcatenation _xblockexpression = null;
        String commandName = "";
        if (ev != null && ev instanceof Command) {
            commandName = ev.getName();
        } else {
            boolean _tripleNotEquals;
            CommandEvent _command = a.getCommand();
            boolean bl = _tripleNotEquals = _command != null;
            if (_tripleNotEquals) {
                commandName = a.getCommand().getEvent().getName();
            } else {
                TriggeredTransition parentTransition = (TriggeredTransition)EcoreUtil2.getContainerOfType((EObject)a, TriggeredTransition.class);
                if (parentTransition != null) {
                    commandName = parentTransition.getTrigger().getName();
                }
            }
        }
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("mp = new CReplyPattern(); ");
        if (commandName != null) {
            _builder.append("mp.setName(\"");
            _builder.append(commandName);
            _builder.append("\")");
        }
        _builder.append(";");
        _builder.newLineIfNotEmpty();
        int _size = a.getParameters().size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            _builder.append("mp");
            EList _parameters = a.getParameters();
            for (Expression p : _parameters) {
                _builder.append(".addParameter(");
                CharSequence _generateExpression = this.generateExpression(p);
                _builder.append((Object)_generateExpression);
                _builder.append(")");
            }
            _builder.append(";");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
        }
        _xblockexpression = _builder;
        return _xblockexpression;
    }

    @Override
    public CharSequence rulesClassPrefix() {
        return this.signature.getName();
    }

    public CharSequence getEventName(Transition t, Clause c) {
        StringConcatenation _xifexpression = null;
        if (t instanceof TriggeredTransition) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append(" ");
            String _name = ((TriggeredTransition)t).getTrigger().getName();
            _builder.append(_name, " ");
            _xifexpression = _builder;
        } else {
            StringConcatenation _xblockexpression = null;
            List eventCalls = EcoreUtil2.getAllContentsOfType((EObject)c, EventCall.class);
            StringConcatenation _xifexpression_1 = null;
            boolean _isEmpty = eventCalls.isEmpty();
            if (_isEmpty) {
                StringConcatenation _builder_1;
                _xifexpression_1 = _builder_1 = new StringConcatenation();
            } else {
                StringConcatenation _builder_2 = new StringConcatenation();
                _builder_2.append(" ");
                String _name_1 = ((EventCall)eventCalls.get(0)).getEvent().getName();
                _builder_2.append(_name_1, " ");
                _xifexpression_1 = _builder_2;
            }
            _xifexpression = _xblockexpression = _xifexpression_1;
        }
        return _xifexpression;
    }

    public static CharSequence decisionClassName(Signature s) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = s.getName();
        _builder.append(_name);
        _builder.append("DecisionClass");
        return _builder;
    }

    public static CharSequence utilityClassName(Signature s) {
        StringConcatenation _builder = new StringConcatenation();
        String _name = s.getName();
        _builder.append(_name);
        _builder.append("State");
        return _builder;
    }

    public CharSequence generateActionInContext(Action a, InterfaceEvent ev) {
        if (a instanceof EventCall) {
            return this._generateActionInContext((EventCall)a, ev);
        }
        if (a instanceof AssignmentAction) {
            return this._generateActionInContext((AssignmentAction)a, ev);
        }
        if (a instanceof CommandReply) {
            return this._generateActionInContext((CommandReply)a, ev);
        }
        if (a instanceof IfAction) {
            return this._generateActionInContext((IfAction)a, ev);
        }
        if (a instanceof ParallelComposition) {
            return this._generateActionInContext((ParallelComposition)a, ev);
        }
        if (a instanceof RecordFieldAssignmentAction) {
            return this._generateActionInContext((RecordFieldAssignmentAction)a, ev);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(a, ev).toString());
    }

    public CharSequence messagePatternFromAction(EObject a, InterfaceEvent ev) {
        if (a instanceof EventCall) {
            return this._messagePatternFromAction((EventCall)a, ev);
        }
        if (a instanceof CommandReply) {
            return this._messagePatternFromAction((CommandReply)a, ev);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(a, ev).toString());
    }
}

