/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.model.nodes.variables;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.DataItemTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.nodes.variables.PropertyTypeNode;
import org.eclipse.milo.opcua.sdk.client.model.types.variables.AnalogItemType;
import org.eclipse.milo.opcua.sdk.client.nodes.UaNode;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.LocalizedText;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.Variant;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.enumerated.NodeClass;
import org.eclipse.milo.opcua.stack.core.types.structured.EUInformation;
import org.eclipse.milo.opcua.stack.core.types.structured.Range;

public class AnalogItemTypeNode
extends DataItemTypeNode
implements AnalogItemType {
    public AnalogItemTypeNode(OpcUaClient client, NodeId nodeId, NodeClass nodeClass, QualifiedName browseName, LocalizedText displayName, LocalizedText description, UInteger writeMask, UInteger userWriteMask, DataValue value, NodeId dataType, Integer valueRank, UInteger[] arrayDimensions, UByte accessLevel, UByte userAccessLevel, Double minimumSamplingInterval, Boolean historizing) {
        super(client, nodeId, nodeClass, browseName, displayName, description, writeMask, userWriteMask, value, dataType, valueRank, arrayDimensions, accessLevel, userAccessLevel, minimumSamplingInterval, historizing);
    }

    @Override
    public Range getInstrumentRange() throws UaException {
        PropertyTypeNode node = this.getInstrumentRangeNode();
        return this.cast(node.getValue().getValue().getValue(), Range.class);
    }

    @Override
    public void setInstrumentRange(Range instrumentRange) throws UaException {
        PropertyTypeNode node = this.getInstrumentRangeNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)instrumentRange);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Range readInstrumentRange() throws UaException {
        try {
            return this.readInstrumentRangeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeInstrumentRange(Range instrumentRange) throws UaException {
        try {
            this.writeInstrumentRangeAsync(instrumentRange).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Range> readInstrumentRangeAsync() {
        return ((CompletableFuture)this.getInstrumentRangeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), Range.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeInstrumentRangeAsync(Range instrumentRange) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)instrumentRange);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getInstrumentRangeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getInstrumentRangeNode() throws UaException {
        try {
            return this.getInstrumentRangeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getInstrumentRangeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "InstrumentRange", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public Range getEuRange() throws UaException {
        PropertyTypeNode node = this.getEuRangeNode();
        return this.cast(node.getValue().getValue().getValue(), Range.class);
    }

    @Override
    public void setEuRange(Range euRange) throws UaException {
        PropertyTypeNode node = this.getEuRangeNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)euRange);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public Range readEuRange() throws UaException {
        try {
            return this.readEuRangeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEuRange(Range euRange) throws UaException {
        try {
            this.writeEuRangeAsync(euRange).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends Range> readEuRangeAsync() {
        return ((CompletableFuture)this.getEuRangeNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), Range.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeEuRangeAsync(Range euRange) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)euRange);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getEuRangeNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEuRangeNode() throws UaException {
        try {
            return this.getEuRangeNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEuRangeNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EURange", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }

    @Override
    public EUInformation getEngineeringUnits() throws UaException {
        PropertyTypeNode node = this.getEngineeringUnitsNode();
        return this.cast(node.getValue().getValue().getValue(), EUInformation.class);
    }

    @Override
    public void setEngineeringUnits(EUInformation engineeringUnits) throws UaException {
        PropertyTypeNode node = this.getEngineeringUnitsNode();
        ExtensionObject value = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)engineeringUnits);
        node.setValue(new Variant((Object)value));
    }

    @Override
    public EUInformation readEngineeringUnits() throws UaException {
        try {
            return this.readEngineeringUnitsAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public void writeEngineeringUnits(EUInformation engineeringUnits) throws UaException {
        try {
            this.writeEngineeringUnitsAsync(engineeringUnits).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    @Override
    public CompletableFuture<? extends EUInformation> readEngineeringUnitsAsync() {
        return ((CompletableFuture)this.getEngineeringUnitsNodeAsync().thenCompose(node -> node.readAttributeAsync(AttributeId.Value))).thenApply(v -> this.cast(v.getValue().getValue(), EUInformation.class));
    }

    @Override
    public CompletableFuture<StatusCode> writeEngineeringUnitsAsync(EUInformation engineeringUnits) {
        ExtensionObject encoded = ExtensionObject.encode((SerializationContext)this.client.getStaticSerializationContext(), (UaStructure)engineeringUnits);
        DataValue value = DataValue.valueOnly((Variant)new Variant((Object)encoded));
        return this.getEngineeringUnitsNodeAsync().thenCompose(node -> node.writeAttributeAsync(AttributeId.Value, value));
    }

    @Override
    public PropertyTypeNode getEngineeringUnitsNode() throws UaException {
        try {
            return this.getEngineeringUnitsNodeAsync().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw UaException.extract((Throwable)e).orElse(new UaException(0x80010000L, (Throwable)e));
        }
    }

    public CompletableFuture<? extends PropertyTypeNode> getEngineeringUnitsNodeAsync() {
        CompletableFuture<UaNode> future = this.getMemberNodeAsync("http://opcfoundation.org/UA/", "EngineeringUnits", ExpandedNodeId.parse((String)"nsu=http://opcfoundation.org/UA/;i=46"), false);
        return future.thenApply(node -> (PropertyTypeNode)node);
    }
}

