/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.sdk.client.session;

import com.digitalpetri.netty.fsm.ChannelFsm;
import com.digitalpetri.strictmachine.Fsm;
import com.digitalpetri.strictmachine.FsmContext;
import com.digitalpetri.strictmachine.dsl.ActionContext;
import com.digitalpetri.strictmachine.dsl.FsmBuilder;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Streams;
import com.google.common.primitives.Bytes;
import io.netty.channel.Channel;
import java.nio.ByteBuffer;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.milo.opcua.sdk.client.OpcUaClient;
import org.eclipse.milo.opcua.sdk.client.OpcUaSession;
import org.eclipse.milo.opcua.sdk.client.api.ServiceFaultListener;
import org.eclipse.milo.opcua.sdk.client.api.config.OpcUaClientConfig;
import org.eclipse.milo.opcua.sdk.client.api.identity.SignedIdentityToken;
import org.eclipse.milo.opcua.sdk.client.api.subscriptions.UaSubscription;
import org.eclipse.milo.opcua.sdk.client.session.Event;
import org.eclipse.milo.opcua.sdk.client.session.SessionFsm;
import org.eclipse.milo.opcua.sdk.client.session.State;
import org.eclipse.milo.opcua.sdk.client.subscriptions.OpcUaSubscriptionManager;
import org.eclipse.milo.opcua.stack.client.UaStackClient;
import org.eclipse.milo.opcua.stack.client.transport.UaTransport;
import org.eclipse.milo.opcua.stack.client.transport.tcp.OpcTcpTransport;
import org.eclipse.milo.opcua.stack.core.AttributeId;
import org.eclipse.milo.opcua.stack.core.Identifiers;
import org.eclipse.milo.opcua.stack.core.StatusCodes;
import org.eclipse.milo.opcua.stack.core.UaException;
import org.eclipse.milo.opcua.stack.core.security.SecurityAlgorithm;
import org.eclipse.milo.opcua.stack.core.security.SecurityPolicy;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.types.builtin.ByteString;
import org.eclipse.milo.opcua.stack.core.types.builtin.DataValue;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExtensionObject;
import org.eclipse.milo.opcua.stack.core.types.builtin.QualifiedName;
import org.eclipse.milo.opcua.stack.core.types.builtin.StatusCode;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.Unsigned;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ApplicationType;
import org.eclipse.milo.opcua.stack.core.types.enumerated.ServerState;
import org.eclipse.milo.opcua.stack.core.types.enumerated.TimestampsToReturn;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ActivateSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ApplicationDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.CloseSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.CreateSessionResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.EndpointDescription;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.ReadValueId;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.ServiceFault;
import org.eclipse.milo.opcua.stack.core.types.structured.SignatureData;
import org.eclipse.milo.opcua.stack.core.types.structured.SignedSoftwareCertificate;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferResult;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsRequest;
import org.eclipse.milo.opcua.stack.core.types.structured.TransferSubscriptionsResponse;
import org.eclipse.milo.opcua.stack.core.types.structured.UserIdentityToken;
import org.eclipse.milo.opcua.stack.core.util.CertificateUtil;
import org.eclipse.milo.opcua.stack.core.util.ConversionUtil;
import org.eclipse.milo.opcua.stack.core.util.EndpointUtil;
import org.eclipse.milo.opcua.stack.core.util.FutureUtils;
import org.eclipse.milo.opcua.stack.core.util.NonceUtil;
import org.eclipse.milo.opcua.stack.core.util.SignatureUtil;
import org.eclipse.milo.opcua.stack.core.util.Unit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionFsmFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"org.eclipse.milo.opcua.sdk.client.SessionFsm");
    private static final int MAX_WAIT_SECONDS = 16;

    private SessionFsmFactory() {
    }

    public static SessionFsm newSessionFsm(OpcUaClient client) {
        FsmBuilder builder = new FsmBuilder((Executor)client.getConfig().getExecutor(), "org.eclipse.milo.opcua.sdk.client.SessionFsm");
        SessionFsmFactory.configureSessionFsm((FsmBuilder<State, Event>)builder, client);
        Fsm fsm = builder.build((Enum)State.Inactive);
        client.addFaultListener(new SessionFaultListener(fsm));
        return new SessionFsm((Fsm<State, Event>)fsm);
    }

    private static void configureSessionFsm(FsmBuilder<State, Event> fb, OpcUaClient client) {
        SessionFsmFactory.configureInactiveState(fb, client);
        SessionFsmFactory.configureCreatingWaitState(fb, client);
        SessionFsmFactory.configureCreatingState(fb, client);
        SessionFsmFactory.configureActivatingState(fb, client);
        SessionFsmFactory.configureTransferringState(fb, client);
        SessionFsmFactory.configureInitializingState(fb, client);
        SessionFsmFactory.configureActiveState(fb, client);
        SessionFsmFactory.configureClosingState(fb, client);
    }

    private static void configureInactiveState(FsmBuilder<State, Event> fb, OpcUaClient client) {
        fb.when((Enum)State.Inactive).on(Event.OpenSession.class).transitionTo((Object)State.Creating);
        fb.onTransitionTo((Enum)State.Inactive).from(s -> s != State.Inactive).viaAny().execute(FsmContext::processShelvedEvents);
        fb.onInternalTransition((Enum)State.Inactive).via(Event.GetSession.class).execute(ctx -> {
            Event.GetSession event = (Event.GetSession)ctx.event();
            client.getConfig().getExecutor().execute(() -> event.future.completeExceptionally(new UaException(2149974016L)));
        });
        fb.onInternalTransition((Enum)State.Inactive).via(Event.CloseSession.class).execute(ctx -> {
            Event.CloseSession event = (Event.CloseSession)ctx.event();
            client.getConfig().getExecutor().execute(() -> event.future.complete(Unit.VALUE));
        });
    }

    private static void configureCreatingWaitState(FsmBuilder<State, Event> fb, OpcUaClient client) {
        fb.when((Enum)State.CreatingWait).on(Event.CreatingWaitExpired.class).transitionTo((Object)State.Creating);
        fb.when((Enum)State.CreatingWait).on(Event.CloseSession.class).transitionTo((Object)State.Inactive);
        fb.onTransitionTo((Enum)State.CreatingWait).from(s -> s != State.CreatingWait).viaAny().execute(FsmContext::processShelvedEvents);
        fb.onTransitionTo((Enum)State.CreatingWait).from(s -> s != State.CreatingWait).viaAny().execute(ctx -> {
            SessionFsm.SessionFuture sessionFuture = new SessionFsm.SessionFuture();
            SessionFsm.KEY_SESSION_FUTURE.set((FsmContext)ctx, (Object)sessionFuture);
            Long waitTime = (Long)SessionFsm.KEY_WAIT_TIME.get((FsmContext)ctx);
            waitTime = waitTime == null ? Long.valueOf(1L) : Long.valueOf(Math.min(16L, waitTime << 1));
            SessionFsm.KEY_WAIT_TIME.set((FsmContext)ctx, (Object)waitTime);
            ScheduledFuture<?> waitFuture = client.getConfig().getScheduledExecutor().schedule(() -> ctx.fireEvent((Object)new Event.CreatingWaitExpired()), (long)waitTime, TimeUnit.SECONDS);
            SessionFsm.KEY_WAIT_FUTURE.set((FsmContext)ctx, waitFuture);
        });
        fb.onTransitionFrom((Enum)State.CreatingWait).to((Enum)State.Inactive).via(Event.CloseSession.class).execute(ctx -> {
            ScheduledFuture waitFuture = (ScheduledFuture)SessionFsm.KEY_WAIT_FUTURE.remove((FsmContext)ctx);
            if (waitFuture != null) {
                waitFuture.cancel(false);
            }
            SessionFsm.KEY_WAIT_TIME.remove((FsmContext)ctx);
            Event.CloseSession event = (Event.CloseSession)ctx.event();
            client.getConfig().getExecutor().execute(() -> event.future.complete(Unit.VALUE));
        });
        fb.onInternalTransition((Enum)State.CreatingWait).via(Event.GetSession.class).execute(SessionFsmFactory::handleGetSessionEvent);
        fb.onInternalTransition((Enum)State.CreatingWait).via(Event.OpenSession.class).execute(SessionFsmFactory::handleOpenSessionEvent);
    }

    private static void configureCreatingState(FsmBuilder<State, Event> fb, OpcUaClient client) {
        fb.when((Enum)State.Creating).on(Event.CreateSessionSuccess.class).transitionTo((Object)State.Activating);
        fb.when((Enum)State.Creating).on(Event.CreateSessionFailure.class).transitionTo((Object)State.CreatingWait).executeFirst(ctx -> {
            Event.CreateSessionFailure e = (Event.CreateSessionFailure)ctx.event();
            SessionFsmFactory.handleFailureToOpenSession(client, (ActionContext<State, Event>)ctx, e.failure);
        });
        fb.onTransitionTo((Enum)State.Creating).from((Enum)State.Inactive).via(Event.OpenSession.class).execute(ctx -> {
            SessionFsm.SessionFuture sessionFuture = new SessionFsm.SessionFuture();
            SessionFsm.KEY_SESSION_FUTURE.set((FsmContext)ctx, (Object)sessionFuture);
            SessionFsmFactory.handleOpenSessionEvent((ActionContext<State, Event>)ctx);
            SessionFsmFactory.createSession((FsmContext<State, Event>)ctx, client).whenComplete((csr, ex) -> {
                if (csr != null) {
                    LOGGER.debug("[{}] CreateSession succeeded: {}", (Object)ctx.getInstanceId(), (Object)csr.getSessionId());
                    ctx.fireEvent((Object)new Event.CreateSessionSuccess((CreateSessionResponse)csr));
                } else {
                    LOGGER.debug("[{}] CreateSession failed: {}", new Object[]{ctx.getInstanceId(), ex.getMessage(), ex});
                    ctx.fireEvent((Object)new Event.CreateSessionFailure((Throwable)ex));
                }
            });
        });
        fb.onTransitionTo((Enum)State.Creating).from((Enum)State.CreatingWait).via(Event.CreatingWaitExpired.class).execute(ctx -> SessionFsmFactory.createSession((FsmContext<State, Event>)ctx, client).whenComplete((csr, ex) -> {
            if (csr != null) {
                LOGGER.debug("[{}] CreateSession succeeded: {}", (Object)ctx.getInstanceId(), (Object)csr.getSessionId());
                ctx.fireEvent((Object)new Event.CreateSessionSuccess((CreateSessionResponse)csr));
            } else {
                LOGGER.debug("[{}] CreateSession failed: {}", new Object[]{ctx.getInstanceId(), ex.getMessage(), ex});
                ctx.fireEvent((Object)new Event.CreateSessionFailure((Throwable)ex));
            }
        }));
        fb.onInternalTransition((Enum)State.Creating).via(Event.GetSession.class).execute(SessionFsmFactory::handleGetSessionEvent);
        fb.onInternalTransition((Enum)State.Creating).via(Event.OpenSession.class).execute(SessionFsmFactory::handleOpenSessionEvent);
        fb.onInternalTransition((Enum)State.Creating).via(Event.CloseSession.class).execute(ctx -> ctx.shelveEvent(ctx.event()));
    }

    private static void configureActivatingState(FsmBuilder<State, Event> fb, OpcUaClient client) {
        fb.when((Enum)State.Activating).on(Event.ActivateSessionSuccess.class).transitionTo((Object)State.Transferring);
        fb.when((Enum)State.Activating).on(Event.ActivateSessionFailure.class).transitionTo((Object)State.CreatingWait).executeFirst(ctx -> {
            Event.ActivateSessionFailure e = (Event.ActivateSessionFailure)ctx.event();
            SessionFsmFactory.handleFailureToOpenSession(client, (ActionContext<State, Event>)ctx, e.failure);
        });
        fb.onTransitionTo((Enum)State.Activating).from((Enum)State.Creating).via(Event.CreateSessionSuccess.class).execute(ctx -> {
            Event.CreateSessionSuccess event = (Event.CreateSessionSuccess)ctx.event();
            SessionFsmFactory.activateSession((FsmContext<State, Event>)ctx, client, event.response).whenComplete((session, ex) -> {
                if (session != null) {
                    LOGGER.debug("[{}] Session activated: {}", (Object)ctx.getInstanceId(), session);
                    ctx.fireEvent((Object)new Event.ActivateSessionSuccess((OpcUaSession)session));
                } else {
                    LOGGER.debug("[{}] ActivateSession failed: {}", new Object[]{ctx.getInstanceId(), ex.getMessage(), ex});
                    ctx.fireEvent((Object)new Event.ActivateSessionFailure((Throwable)ex));
                }
            });
        });
        fb.onInternalTransition((Enum)State.Activating).via(Event.GetSession.class).execute(SessionFsmFactory::handleGetSessionEvent);
        fb.onInternalTransition((Enum)State.Activating).via(Event.OpenSession.class).execute(SessionFsmFactory::handleOpenSessionEvent);
        fb.onInternalTransition((Enum)State.Activating).via(Event.CloseSession.class).execute(ctx -> ctx.shelveEvent(ctx.event()));
    }

    private static void configureTransferringState(FsmBuilder<State, Event> fb, OpcUaClient client) {
        fb.when((Enum)State.Transferring).on(Event.TransferSubscriptionsSuccess.class).transitionTo((Object)State.Initializing);
        fb.when((Enum)State.Transferring).on(Event.TransferSubscriptionsFailure.class).transitionTo((Object)State.CreatingWait).executeFirst(ctx -> {
            Event.TransferSubscriptionsFailure e = (Event.TransferSubscriptionsFailure)ctx.event();
            SessionFsmFactory.handleFailureToOpenSession(client, (ActionContext<State, Event>)ctx, e.failure);
        });
        fb.onTransitionTo((Enum)State.Transferring).from((Enum)State.Activating).via(Event.ActivateSessionSuccess.class).execute(ctx -> {
            Event.ActivateSessionSuccess event = (Event.ActivateSessionSuccess)ctx.event();
            SessionFsmFactory.transferSubscriptions((FsmContext<State, Event>)ctx, client, event.session).whenComplete((u, ex) -> {
                if (u != null) {
                    LOGGER.debug("[{}] TransferSubscriptions succeeded", (Object)ctx.getInstanceId());
                    ctx.fireEvent((Object)new Event.TransferSubscriptionsSuccess(event.session));
                } else {
                    LOGGER.debug("[{}] TransferSubscriptions failed: {}", new Object[]{ctx.getInstanceId(), ex.getMessage(), ex});
                    ctx.fireEvent((Object)new Event.TransferSubscriptionsFailure((Throwable)ex));
                }
            });
        });
        fb.onInternalTransition((Enum)State.Transferring).via(Event.GetSession.class).execute(SessionFsmFactory::handleGetSessionEvent);
        fb.onInternalTransition((Enum)State.Transferring).via(Event.OpenSession.class).execute(SessionFsmFactory::handleOpenSessionEvent);
        fb.onInternalTransition((Enum)State.Transferring).via(Event.CloseSession.class).execute(ctx -> ctx.shelveEvent(ctx.event()));
    }

    private static void configureInitializingState(FsmBuilder<State, Event> fb, OpcUaClient client) {
        fb.when((Enum)State.Initializing).on(Event.InitializeSuccess.class).transitionTo((Object)State.Active);
        fb.when((Enum)State.Initializing).on(Event.InitializeFailure.class).transitionTo((Object)State.CreatingWait).executeFirst(ctx -> {
            Event.InitializeFailure e = (Event.InitializeFailure)ctx.event();
            SessionFsmFactory.handleFailureToOpenSession(client, (ActionContext<State, Event>)ctx, e.failure);
        });
        fb.onTransitionTo((Enum)State.Initializing).from((Enum)State.Transferring).via(Event.TransferSubscriptionsSuccess.class).execute(ctx -> {
            Event.TransferSubscriptionsSuccess event = (Event.TransferSubscriptionsSuccess)ctx.event();
            OpcUaSession session = event.session;
            SessionFsmFactory.initialize((FsmContext<State, Event>)ctx, client, session).whenComplete((u, ex) -> {
                if (u != null) {
                    LOGGER.debug("[{}] Initialization succeeded: {}", (Object)ctx.getInstanceId(), (Object)session);
                    ctx.fireEvent((Object)new Event.InitializeSuccess(session));
                } else {
                    LOGGER.warn("[{}] Initialization failed: {}", new Object[]{ctx.getInstanceId(), session, ex});
                    ctx.fireEvent((Object)new Event.InitializeFailure((Throwable)ex));
                }
            });
        });
        fb.onInternalTransition((Enum)State.Initializing).via(Event.GetSession.class).execute(SessionFsmFactory::handleGetSessionEvent);
        fb.onInternalTransition((Enum)State.Initializing).via(Event.OpenSession.class).execute(SessionFsmFactory::handleOpenSessionEvent);
        fb.onInternalTransition((Enum)State.Initializing).via(Event.CloseSession.class).execute(ctx -> ctx.shelveEvent(ctx.event()));
    }

    private static void configureActiveState(FsmBuilder<State, Event> fb, OpcUaClient client) {
        fb.when((Enum)State.Active).on(Event.CloseSession.class).transitionTo((Object)State.Closing);
        fb.when((Enum)State.Active).on(e -> e.getClass() == Event.KeepAliveFailure.class || e.getClass() == Event.ServiceFault.class || e.getClass() == Event.ConnectionLost.class).transitionTo((Object)State.CreatingWait);
        fb.onTransitionTo((Enum)State.Active).from((Enum)State.Initializing).via(Event.InitializeSuccess.class).execute(ctx -> {
            Event.InitializeSuccess event = (Event.InitializeSuccess)ctx.event();
            SessionFsm.KEY_WAIT_TIME.remove((FsmContext)ctx);
            long keepAliveInterval = client.getConfig().getKeepAliveInterval().longValue();
            SessionFsm.KEY_KEEP_ALIVE_FAILURE_COUNT.set((FsmContext)ctx, (Object)0L);
            ScheduledFuture<?> scheduledFuture = client.getConfig().getScheduledExecutor().scheduleWithFixedDelay(() -> ctx.fireEvent((Object)new Event.KeepAlive(event.session)), keepAliveInterval, keepAliveInterval, TimeUnit.MILLISECONDS);
            SessionFsm.KEY_KEEP_ALIVE_SCHEDULED_FUTURE.set((FsmContext)ctx, scheduledFuture);
            SessionFsm.KEY_SESSION.set((FsmContext)ctx, (Object)event.session);
            SessionFsm.SessionFuture sessionFuture = (SessionFsm.SessionFuture)SessionFsm.KEY_SESSION_FUTURE.get((FsmContext)ctx);
            UaTransport transport = client.getStackClient().getTransport();
            if (transport instanceof OpcTcpTransport) {
                final ChannelFsm channelFsm = ((OpcTcpTransport)transport).channelFsm();
                channelFsm.addTransitionListener(new ChannelFsm.TransitionListener(){

                    public void onStateTransition(com.digitalpetri.netty.fsm.State from, com.digitalpetri.netty.fsm.State to, com.digitalpetri.netty.fsm.Event via) {
                        if (from == com.digitalpetri.netty.fsm.State.Connected && to != com.digitalpetri.netty.fsm.State.Connected) {
                            channelFsm.removeTransitionListener((ChannelFsm.TransitionListener)this);
                            LOGGER.debug("ChannelFsm transition from={} to={} via={}", new Object[]{from, to, via});
                            ctx.fireEvent((Object)new Event.ConnectionLost());
                        }
                    }
                });
            }
            client.getConfig().getExecutor().execute(() -> sessionFuture.future.complete(event.session));
        });
        fb.onTransitionTo((Enum)State.Active).from((Enum)State.Initializing).via(Event.InitializeSuccess.class).execute(FsmContext::processShelvedEvents);
        fb.onTransitionFrom((Enum)State.Active).to(s -> s == State.Closing || s == State.CreatingWait).viaAny().execute(ctx -> {
            ScheduledFuture scheduledFuture = (ScheduledFuture)SessionFsm.KEY_KEEP_ALIVE_SCHEDULED_FUTURE.remove((FsmContext)ctx);
            if (scheduledFuture != null) {
                scheduledFuture.cancel(false);
            }
        });
        fb.onTransitionTo((Enum)State.Active).from(s -> s != State.Active).viaAny().execute(ctx -> {
            OpcUaSession session = (OpcUaSession)SessionFsm.KEY_SESSION.get((FsmContext)ctx);
            SessionFsm.SessionActivityListeners sessionActivityListeners = (SessionFsm.SessionActivityListeners)SessionFsm.KEY_SESSION_ACTIVITY_LISTENERS.get((FsmContext)ctx);
            client.getConfig().getExecutor().execute(() -> sessionActivityListeners.sessionActivityListeners.forEach(listener -> listener.onSessionActive(session)));
        });
        fb.onTransitionFrom((Enum)State.Active).to(s -> s != State.Active).viaAny().execute(ctx -> {
            OpcUaSession session = (OpcUaSession)SessionFsm.KEY_SESSION.get((FsmContext)ctx);
            SessionFsm.SessionActivityListeners sessionActivityListeners = (SessionFsm.SessionActivityListeners)SessionFsm.KEY_SESSION_ACTIVITY_LISTENERS.get((FsmContext)ctx);
            client.getConfig().getExecutor().execute(() -> sessionActivityListeners.sessionActivityListeners.forEach(listener -> listener.onSessionInactive(session)));
        });
        fb.onInternalTransition((Enum)State.Active).via(Event.KeepAlive.class).execute(ctx -> {
            Event.KeepAlive event = (Event.KeepAlive)ctx.event();
            SessionFsmFactory.sendKeepAlive(client, event.session).whenComplete((response, ex) -> {
                if (response != null) {
                    Object value;
                    DataValue[] results = response.getResults();
                    if (results != null && results.length > 0 && (value = results[0].getValue().getValue()) instanceof Integer) {
                        ServerState state = ServerState.from((int)((Integer)value));
                        LOGGER.debug("[{}] ServerState: {}", (Object)ctx.getInstanceId(), (Object)state);
                    }
                    SessionFsm.KEY_KEEP_ALIVE_FAILURE_COUNT.set((FsmContext)ctx, (Object)0L);
                } else {
                    Long keepAliveFailureCount = (Long)SessionFsm.KEY_KEEP_ALIVE_FAILURE_COUNT.get((FsmContext)ctx);
                    keepAliveFailureCount = keepAliveFailureCount == null ? Long.valueOf(1L) : Long.valueOf(keepAliveFailureCount + 1L);
                    SessionFsm.KEY_KEEP_ALIVE_FAILURE_COUNT.set((FsmContext)ctx, (Object)keepAliveFailureCount);
                    long keepAliveFailuresAllowed = client.getConfig().getKeepAliveFailuresAllowed().longValue();
                    if (keepAliveFailureCount > keepAliveFailuresAllowed) {
                        Channel channel;
                        LOGGER.warn("[{}] Keep Alive failureCount={} exceeds failuresAllowed={}", new Object[]{ctx.getInstanceId(), keepAliveFailureCount, keepAliveFailuresAllowed});
                        ctx.fireEvent((Object)new Event.KeepAliveFailure());
                        UaTransport transport = client.getStackClient().getTransport();
                        if (transport instanceof OpcTcpTransport && (channel = (Channel)((OpcTcpTransport)transport).channel().getNow(null)) != null) {
                            channel.close();
                        }
                    } else {
                        LOGGER.debug("[{}] Keep Alive failureCount={}", new Object[]{ctx.getInstanceId(), keepAliveFailureCount, ex});
                    }
                }
            });
        });
        fb.onInternalTransition((Enum)State.Active).via(Event.GetSession.class).execute(SessionFsmFactory::handleGetSessionEvent);
        fb.onInternalTransition((Enum)State.Active).via(Event.OpenSession.class).execute(SessionFsmFactory::handleOpenSessionEvent);
    }

    private static void configureClosingState(FsmBuilder<State, Event> fb, OpcUaClient client) {
        fb.when((Enum)State.Closing).on(Event.CloseSessionSuccess.class).transitionTo((Object)State.Inactive);
        fb.onTransitionTo((Enum)State.Closing).from((Enum)State.Active).via(Event.CloseSession.class).execute(ctx -> {
            SessionFsm.CloseFuture closeFuture = new SessionFsm.CloseFuture();
            SessionFsm.KEY_CLOSE_FUTURE.set((FsmContext)ctx, (Object)closeFuture);
            Event.CloseSession closeSession = (Event.CloseSession)ctx.event();
            FutureUtils.complete(closeSession.future).with(closeFuture.future);
            OpcUaSession session = (OpcUaSession)SessionFsm.KEY_SESSION.get((FsmContext)ctx);
            SessionFsmFactory.closeSession((FsmContext<State, Event>)ctx, client, session).whenComplete((u, ex) -> {
                if (u != null) {
                    LOGGER.debug("[{}] Session closed: {}", (Object)ctx.getInstanceId(), (Object)session);
                } else {
                    LOGGER.debug("[{}] CloseSession failed: {}", new Object[]{ctx.getInstanceId(), ex.getMessage(), ex});
                }
                ctx.fireEvent((Object)new Event.CloseSessionSuccess());
            });
        });
        fb.onTransitionFrom((Enum)State.Closing).to((Enum)State.Inactive).via(Event.CloseSessionSuccess.class).execute(ctx -> {
            SessionFsm.CloseFuture closeFuture = (SessionFsm.CloseFuture)SessionFsm.KEY_CLOSE_FUTURE.get((FsmContext)ctx);
            if (closeFuture != null) {
                client.getConfig().getExecutor().execute(() -> closeFuture.future.complete(Unit.VALUE));
            }
        });
        fb.onInternalTransition((Enum)State.Closing).via(Event.CloseSession.class).execute(ctx -> {
            Event.CloseSession event = (Event.CloseSession)ctx.event();
            SessionFsm.CloseFuture closeFuture = (SessionFsm.CloseFuture)SessionFsm.KEY_CLOSE_FUTURE.get((FsmContext)ctx);
            if (closeFuture != null) {
                FutureUtils.complete(event.future).with(closeFuture.future);
            }
        });
        fb.onInternalTransition((Enum)State.Closing).via(e -> e.getClass() != Event.CloseSession.class).execute(ctx -> ctx.shelveEvent(ctx.event()));
    }

    private static void handleGetSessionEvent(ActionContext<State, Event> ctx) {
        CompletableFuture<OpcUaSession> sessionFuture = ((SessionFsm.SessionFuture)SessionFsm.KEY_SESSION_FUTURE.get(ctx)).future;
        Event.GetSession event = (Event.GetSession)ctx.event();
        FutureUtils.complete(event.future).with(sessionFuture);
    }

    private static void handleOpenSessionEvent(ActionContext<State, Event> ctx) {
        CompletableFuture<OpcUaSession> sessionFuture = ((SessionFsm.SessionFuture)SessionFsm.KEY_SESSION_FUTURE.get(ctx)).future;
        Event.OpenSession event = (Event.OpenSession)ctx.event();
        FutureUtils.complete(event.future).with(sessionFuture);
    }

    private static void handleFailureToOpenSession(OpcUaClient client, ActionContext<State, Event> ctx, Throwable failure) {
        SessionFsm.SessionFuture sessionFuture = (SessionFsm.SessionFuture)SessionFsm.KEY_SESSION_FUTURE.remove(ctx);
        if (sessionFuture != null) {
            client.getConfig().getExecutor().execute(() -> sessionFuture.future.completeExceptionally(failure));
        }
    }

    private static CompletableFuture<Unit> closeSession(FsmContext<State, Event> ctx, OpcUaClient client, OpcUaSession session) {
        CompletableFuture<Unit> closeFuture = new CompletableFuture<Unit>();
        UaStackClient stackClient = client.getStackClient();
        RequestHeader requestHeader = stackClient.newRequestHeader(session.getAuthenticationToken(), Unsigned.uint((int)5000));
        CloseSessionRequest request = new CloseSessionRequest(requestHeader, Boolean.valueOf(true));
        LOGGER.debug("[{}] Sending CloseSessionRequest...", (Object)ctx.getInstanceId());
        stackClient.sendRequest((UaRequestMessage)request).whenCompleteAsync((csr, ex2) -> {
            client.getSubscriptionManager().cancelWatchdogTimers();
            closeFuture.complete(Unit.VALUE);
        }, (Executor)client.getConfig().getExecutor());
        return closeFuture;
    }

    private static CompletableFuture<CreateSessionResponse> createSession(FsmContext<State, Event> ctx, OpcUaClient client) {
        UaStackClient stackClient = client.getStackClient();
        EndpointDescription endpoint = stackClient.getConfig().getEndpoint();
        String gatewayServerUri = endpoint.getServer().getGatewayServerUri();
        String serverUri = gatewayServerUri != null && !gatewayServerUri.isEmpty() ? endpoint.getServer().getApplicationUri() : null;
        ByteString clientNonce = NonceUtil.generateNonce((int)32);
        ByteString clientCertificate = stackClient.getConfig().getCertificate().map(c -> {
            try {
                return ByteString.of((byte[])c.getEncoded());
            }
            catch (CertificateEncodingException e) {
                return ByteString.NULL_VALUE;
            }
        }).orElse(ByteString.NULL_VALUE);
        ApplicationDescription clientDescription = new ApplicationDescription(client.getConfig().getApplicationUri(), client.getConfig().getProductUri(), client.getConfig().getApplicationName(), ApplicationType.Client, null, null, null);
        CreateSessionRequest request = new CreateSessionRequest(client.newRequestHeader(), clientDescription, serverUri, client.getConfig().getEndpoint().getEndpointUrl(), client.getConfig().getSessionName().get(), clientNonce, clientCertificate, Double.valueOf(client.getConfig().getSessionTimeout().doubleValue()), client.getConfig().getMaxResponseMessageSize());
        LOGGER.debug("[{}] Sending CreateSessionRequest...", (Object)ctx.getInstanceId());
        return ((CompletableFuture)stackClient.sendRequest((UaRequestMessage)request).thenApply(CreateSessionResponse.class::cast)).thenCompose(response -> {
            try {
                SecurityPolicy securityPolicy = SecurityPolicy.fromUri((String)endpoint.getSecurityPolicyUri());
                if (securityPolicy != SecurityPolicy.None) {
                    X509Certificate certificateFromEndpoint;
                    if (response.getServerCertificate().isNullOrEmpty()) {
                        throw new UaException(2148728832L, "Certificate missing from CreateSessionResponse");
                    }
                    List serverCertificateChain = CertificateUtil.decodeCertificates((byte[])response.getServerCertificate().bytesOrEmpty());
                    X509Certificate serverCertificate = (X509Certificate)serverCertificateChain.get(0);
                    if (!serverCertificate.equals(certificateFromEndpoint = CertificateUtil.decodeCertificate((byte[])endpoint.getServerCertificate().bytesOrEmpty()))) {
                        throw new UaException(2148728832L, "Certificate from CreateSessionResponse did not match certificate from EndpointDescription!");
                    }
                    client.getConfig().getCertificateValidator().validateCertificateChain(serverCertificateChain, endpoint.getServer().getApplicationUri(), new String[]{EndpointUtil.getHost((String)endpoint.getEndpointUrl())});
                    SignatureData serverSignature = response.getServerSignature();
                    byte[] dataBytes = Bytes.concat((byte[][])new byte[][]{clientCertificate.bytesOrEmpty(), clientNonce.bytesOrEmpty()});
                    byte[] signatureBytes = serverSignature.getSignature().bytesOrEmpty();
                    SignatureUtil.verify((SecurityAlgorithm)SecurityAlgorithm.fromUri((String)serverSignature.getAlgorithm()), (X509Certificate)serverCertificate, (byte[])dataBytes, (byte[])signatureBytes);
                }
                return CompletableFuture.completedFuture(response);
            }
            catch (UaException e) {
                return FutureUtils.failedFuture((Throwable)e);
            }
        });
    }

    private static CompletableFuture<OpcUaSession> activateSession(FsmContext<State, Event> ctx, OpcUaClient client, CreateSessionResponse csr) {
        UaStackClient stackClient = client.getStackClient();
        try {
            EndpointDescription endpoint = client.getConfig().getEndpoint();
            ByteString csrNonce = csr.getServerNonce();
            SignedIdentityToken signedIdentityToken = client.getConfig().getIdentityProvider().getIdentityToken(endpoint, csrNonce);
            UserIdentityToken userIdentityToken = signedIdentityToken.getToken();
            SignatureData userTokenSignature = signedIdentityToken.getSignature();
            ActivateSessionRequest request = new ActivateSessionRequest(client.newRequestHeader(csr.getAuthenticationToken()), SessionFsmFactory.buildClientSignature(client.getConfig(), csrNonce), new SignedSoftwareCertificate[0], client.getConfig().getSessionLocaleIds(), ExtensionObject.encode((SerializationContext)client.getStaticSerializationContext(), (UaStructure)userIdentityToken), userTokenSignature);
            LOGGER.debug("[{}] Sending ActivateSessionRequest...", (Object)ctx.getInstanceId());
            return ((CompletableFuture)stackClient.sendRequest((UaRequestMessage)request).thenApply(ActivateSessionResponse.class::cast)).thenCompose(asr -> {
                ByteString asrNonce = asr.getServerNonce();
                OpcUaSession session = new OpcUaSession(csr.getAuthenticationToken(), csr.getSessionId(), client.getConfig().getSessionName().get(), csr.getRevisedSessionTimeout(), csr.getMaxRequestMessageSize(), csr.getServerCertificate(), csr.getServerSoftwareCertificates());
                session.setServerNonce(asrNonce);
                return CompletableFuture.completedFuture(session);
            });
        }
        catch (Exception ex) {
            return FutureUtils.failedFuture((Throwable)ex);
        }
    }

    private static CompletableFuture<Unit> transferSubscriptions(FsmContext<State, Event> ctx, OpcUaClient client, OpcUaSession session) {
        UaStackClient stackClient = client.getStackClient();
        OpcUaSubscriptionManager subscriptionManager = client.getSubscriptionManager();
        ImmutableList<UaSubscription> subscriptions = subscriptionManager.getSubscriptions();
        if (subscriptions.isEmpty()) {
            return CompletableFuture.completedFuture(Unit.VALUE);
        }
        CompletableFuture<Unit> transferFuture = new CompletableFuture<Unit>();
        UInteger[] subscriptionIdsArray = (UInteger[])subscriptions.stream().map(UaSubscription::getSubscriptionId).toArray(UInteger[]::new);
        TransferSubscriptionsRequest request = new TransferSubscriptionsRequest(client.newRequestHeader(session.getAuthenticationToken()), subscriptionIdsArray, Boolean.valueOf(true));
        LOGGER.debug("[{}] Sending TransferSubscriptionsRequest...", (Object)ctx.getInstanceId());
        ((CompletableFuture)stackClient.sendRequest((UaRequestMessage)request).thenApply(TransferSubscriptionsResponse.class::cast)).whenComplete((tsr, ex) -> {
            if (tsr != null) {
                List results = ConversionUtil.l((Object[])tsr.getResults());
                LOGGER.debug("[{}] TransferSubscriptions supported: {}", (Object)ctx.getInstanceId(), (Object)tsr.getResponseHeader().getServiceResult());
                if (LOGGER.isDebugEnabled()) {
                    try {
                        Stream<UInteger> subscriptionIds = subscriptions.stream().map(UaSubscription::getSubscriptionId);
                        Stream<StatusCode> statusCodes = results.stream().map(TransferResult::getStatusCode);
                        Object[] ss = (String[])Streams.zip(subscriptionIds, statusCodes, (i, s) -> String.format("id=%s/%s", i, StatusCodes.lookup((long)s.getValue()).map(sa -> sa[0]).orElse(s.toString()))).toArray(String[]::new);
                        LOGGER.debug("[{}] TransferSubscriptions results: {}", (Object)ctx.getInstanceId(), (Object)Arrays.toString(ss));
                    }
                    catch (Throwable t) {
                        LOGGER.error("[{}] error logging TransferSubscription results", (Object)ctx.getInstanceId(), (Object)t);
                    }
                }
                client.getConfig().getExecutor().execute(() -> {
                    for (int i = 0; i < results.size(); ++i) {
                        TransferResult result = (TransferResult)results.get(i);
                        if (result.getStatusCode().isGood()) continue;
                        UaSubscription subscription = (UaSubscription)subscriptions.get(i);
                        subscriptionManager.transferFailed(subscription.getSubscriptionId(), result.getStatusCode());
                    }
                });
                transferFuture.complete(Unit.VALUE);
            } else {
                StatusCode statusCode = UaException.extract((Throwable)ex).map(UaException::getStatusCode).orElse(StatusCode.BAD);
                LOGGER.debug("[{}] TransferSubscriptions not supported: {}", (Object)ctx.getInstanceId(), (Object)statusCode);
                client.getConfig().getExecutor().execute(() -> {
                    for (UaSubscription subscription : subscriptions) {
                        subscriptionManager.transferFailed(subscription.getSubscriptionId(), statusCode);
                    }
                });
                if (statusCode.getValue() == 0x80400000L || statusCode.getValue() == 2151481344L || statusCode.getValue() == 0x808D0000L || statusCode.getValue() == 0x800B0000L) {
                    transferFuture.complete(Unit.VALUE);
                } else {
                    transferFuture.completeExceptionally((Throwable)ex);
                }
            }
        });
        return transferFuture;
    }

    private static CompletableFuture<Unit> initialize(FsmContext<State, Event> ctx, OpcUaClient client, OpcUaSession session) {
        List<SessionFsm.SessionInitializer> initializers = ((SessionFsm.SessionInitializers)SessionFsm.KEY_SESSION_INITIALIZERS.get(ctx)).sessionInitializers;
        if (initializers.isEmpty()) {
            return CompletableFuture.completedFuture(Unit.VALUE);
        }
        UaStackClient stackClient = client.getStackClient();
        CompletableFuture[] futures = (CompletableFuture[])initializers.stream().map(i -> i.initialize(stackClient, session)).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenApply(v -> Unit.VALUE);
    }

    private static CompletableFuture<ReadResponse> sendKeepAlive(OpcUaClient client, OpcUaSession session) {
        ReadRequest keepAliveRequest = SessionFsmFactory.createKeepAliveRequest(client, session);
        return client.getStackClient().sendRequest((UaRequestMessage)keepAliveRequest).thenApply(ReadResponse.class::cast);
    }

    private static ReadRequest createKeepAliveRequest(OpcUaClient client, OpcUaSession session) {
        RequestHeader requestHeader = client.getStackClient().newRequestHeader(session.getAuthenticationToken(), client.getConfig().getKeepAliveTimeout());
        return new ReadRequest(requestHeader, Double.valueOf(0.0), TimestampsToReturn.Neither, new ReadValueId[]{new ReadValueId(Identifiers.Server_ServerStatus_State, AttributeId.Value.uid(), null, QualifiedName.NULL_VALUE)});
    }

    private static SignatureData buildClientSignature(OpcUaClientConfig config, ByteString serverNonce) throws Exception {
        EndpointDescription endpoint = config.getEndpoint();
        SecurityPolicy securityPolicy = SecurityPolicy.fromUri((String)endpoint.getSecurityPolicyUri());
        if (securityPolicy == SecurityPolicy.None) {
            return new SignatureData(null, null);
        }
        SecurityAlgorithm signatureAlgorithm = securityPolicy.getAsymmetricSignatureAlgorithm();
        PrivateKey privateKey = config.getKeyPair().map(KeyPair::getPrivate).orElse(null);
        List serverCertificates = CertificateUtil.decodeCertificates((byte[])endpoint.getServerCertificate().bytesOrEmpty());
        byte[] serverNonceBytes = serverNonce.bytesOrEmpty();
        byte[] serverCertificateBytes = ((X509Certificate)serverCertificates.get(0)).getEncoded();
        byte[] dataToSign = Bytes.concat((byte[][])new byte[][]{serverCertificateBytes, serverNonceBytes});
        byte[] signature = SignatureUtil.sign((SecurityAlgorithm)signatureAlgorithm, (PrivateKey)privateKey, (ByteBuffer[])new ByteBuffer[]{ByteBuffer.wrap(dataToSign)});
        return new SignatureData(signatureAlgorithm.getUri(), ByteString.of((byte[])signature));
    }

    private static class SessionFaultListener
    implements ServiceFaultListener {
        private static final Predicate<StatusCode> SESSION_ERROR = statusCode -> {
            long status = statusCode.getValue();
            return status == 2149974016L || status == 2149908480L || status == 2150039552L;
        };
        private static final Predicate<StatusCode> SECURE_CHANNEL_ERROR = statusCode -> {
            long status = statusCode.getValue();
            return status == 0x80220000L || status == 2148728832L || status == 2155806720L || status == 2152923136L;
        };
        private final Logger logger = LoggerFactory.getLogger((String)"org.eclipse.milo.opcua.sdk.client.SessionFsm");
        private final Fsm<State, Event> fsm;

        private SessionFaultListener(Fsm<State, Event> fsm) {
            this.fsm = fsm;
        }

        @Override
        public void onServiceFault(ServiceFault serviceFault) {
            StatusCode serviceResult = serviceFault.getResponseHeader().getServiceResult();
            if (SESSION_ERROR.or(SECURE_CHANNEL_ERROR).test(serviceResult)) {
                this.logger.debug("[{}] ServiceFault: {}", this.fsm.getFromContext(FsmContext::getInstanceId), (Object)serviceResult);
                this.fsm.fireEvent((Object)new Event.ServiceFault(serviceResult));
            }
        }
    }
}

