=begin
#OpenBao API

#HTTP API that gives you full access to OpenBao. All API routes are prefixed with `/v1/`.

The version of the OpenAPI document: 2.0.0

Generated by: https://openapi-generator.tech
Generator version: 7.7.0

=end

require 'date'
require 'time'

module OpenbaoClient
  class PkiConfigureAcmeRequest
    # whether the ExtKeyUsage field from a role is used, defaults to false meaning that certificate will be signed with ServerAuth.
    attr_accessor :allow_role_ext_key_usage

    # which issuers are allowed for use with ACME; by default, this will only be the primary (default) issuer
    attr_accessor :allowed_issuers

    # which roles are allowed for use with ACME; by default via '*', these will be all roles including sign-verbatim; when concrete role names are specified, any default_directory_policy role must be included to allow usage of the default acme directories under /pki/acme/directory and /pki/issuer/:issuer_id/acme/directory.
    attr_accessor :allowed_roles

    # the policy to be used for non-role-qualified ACME requests; by default ACME issuance will be otherwise unrestricted, equivalent to the sign-verbatim endpoint; one may also specify a role to use as this policy, as \"role:<role_name>\", the specified role must be allowed by allowed_roles
    attr_accessor :default_directory_policy

    # DNS resolver to use for domain resolution on this mount. Defaults to using the default system resolver. Must be in the format <host>:<port>, with both parts mandatory.
    attr_accessor :dns_resolver

    # Specify the policy to use for external account binding behaviour, 'not-required', 'new-account-required' or 'always-required'
    attr_accessor :eab_policy

    # whether ACME is enabled, defaults to false meaning that clusters will by default not get ACME support
    attr_accessor :enabled

    # Attribute mapping from ruby-style variable name to JSON key.
    def self.attribute_map
      {
        :'allow_role_ext_key_usage' => :'allow_role_ext_key_usage',
        :'allowed_issuers' => :'allowed_issuers',
        :'allowed_roles' => :'allowed_roles',
        :'default_directory_policy' => :'default_directory_policy',
        :'dns_resolver' => :'dns_resolver',
        :'eab_policy' => :'eab_policy',
        :'enabled' => :'enabled'
      }
    end

    # Returns all the JSON keys this model knows about
    def self.acceptable_attributes
      attribute_map.values
    end

    # Attribute type mapping.
    def self.openapi_types
      {
        :'allow_role_ext_key_usage' => :'Boolean',
        :'allowed_issuers' => :'Array<String>',
        :'allowed_roles' => :'Array<String>',
        :'default_directory_policy' => :'String',
        :'dns_resolver' => :'String',
        :'eab_policy' => :'String',
        :'enabled' => :'Boolean'
      }
    end

    # List of attributes with nullable: true
    def self.openapi_nullable
      Set.new([
      ])
    end

    # Initializes the object
    # @param [Hash] attributes Model attributes in the form of hash
    def initialize(attributes = {})
      if (!attributes.is_a?(Hash))
        fail ArgumentError, "The input argument (attributes) must be a hash in `OpenbaoClient::PkiConfigureAcmeRequest` initialize method"
      end

      # check to see if the attribute exists and convert string to symbol for hash key
      attributes = attributes.each_with_object({}) { |(k, v), h|
        if (!self.class.attribute_map.key?(k.to_sym))
          fail ArgumentError, "`#{k}` is not a valid attribute in `OpenbaoClient::PkiConfigureAcmeRequest`. Please check the name to make sure it's valid. List of attributes: " + self.class.attribute_map.keys.inspect
        end
        h[k.to_sym] = v
      }

      if attributes.key?(:'allow_role_ext_key_usage')
        self.allow_role_ext_key_usage = attributes[:'allow_role_ext_key_usage']
      else
        self.allow_role_ext_key_usage = false
      end

      if attributes.key?(:'allowed_issuers')
        if (value = attributes[:'allowed_issuers']).is_a?(Array)
          self.allowed_issuers = value
        end
      end

      if attributes.key?(:'allowed_roles')
        if (value = attributes[:'allowed_roles']).is_a?(Array)
          self.allowed_roles = value
        end
      end

      if attributes.key?(:'default_directory_policy')
        self.default_directory_policy = attributes[:'default_directory_policy']
      else
        self.default_directory_policy = 'sign-verbatim'
      end

      if attributes.key?(:'dns_resolver')
        self.dns_resolver = attributes[:'dns_resolver']
      else
        self.dns_resolver = ''
      end

      if attributes.key?(:'eab_policy')
        self.eab_policy = attributes[:'eab_policy']
      else
        self.eab_policy = 'always-required'
      end

      if attributes.key?(:'enabled')
        self.enabled = attributes[:'enabled']
      else
        self.enabled = false
      end
    end

    # Show invalid properties with the reasons. Usually used together with valid?
    # @return Array for valid properties with the reasons
    def list_invalid_properties
      warn '[DEPRECATED] the `list_invalid_properties` method is obsolete'
      invalid_properties = Array.new
      invalid_properties
    end

    # Check to see if the all the properties in the model are valid
    # @return true if the model is valid
    def valid?
      warn '[DEPRECATED] the `valid?` method is obsolete'
      true
    end

    # Checks equality by comparing each attribute.
    # @param [Object] Object to be compared
    def ==(o)
      return true if self.equal?(o)
      self.class == o.class &&
          allow_role_ext_key_usage == o.allow_role_ext_key_usage &&
          allowed_issuers == o.allowed_issuers &&
          allowed_roles == o.allowed_roles &&
          default_directory_policy == o.default_directory_policy &&
          dns_resolver == o.dns_resolver &&
          eab_policy == o.eab_policy &&
          enabled == o.enabled
    end

    # @see the `==` method
    # @param [Object] Object to be compared
    def eql?(o)
      self == o
    end

    # Calculates hash code according to all attributes.
    # @return [Integer] Hash code
    def hash
      [allow_role_ext_key_usage, allowed_issuers, allowed_roles, default_directory_policy, dns_resolver, eab_policy, enabled].hash
    end

    # Builds the object from hash
    # @param [Hash] attributes Model attributes in the form of hash
    # @return [Object] Returns the model itself
    def self.build_from_hash(attributes)
      return nil unless attributes.is_a?(Hash)
      attributes = attributes.transform_keys(&:to_sym)
      transformed_hash = {}
      openapi_types.each_pair do |key, type|
        if attributes.key?(attribute_map[key]) && attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = nil
        elsif type =~ /\AArray<(.*)>/i
          # check to ensure the input is an array given that the attribute
          # is documented as an array but the input is not
          if attributes[attribute_map[key]].is_a?(Array)
            transformed_hash["#{key}"] = attributes[attribute_map[key]].map { |v| _deserialize($1, v) }
          end
        elsif !attributes[attribute_map[key]].nil?
          transformed_hash["#{key}"] = _deserialize(type, attributes[attribute_map[key]])
        end
      end
      new(transformed_hash)
    end

    # Deserializes the data based on type
    # @param string type Data type
    # @param string value Value to be deserialized
    # @return [Object] Deserialized data
    def self._deserialize(type, value)
      case type.to_sym
      when :Time
        Time.parse(value)
      when :Date
        Date.parse(value)
      when :String
        value.to_s
      when :Integer
        value.to_i
      when :Float
        value.to_f
      when :Boolean
        if value.to_s =~ /\A(true|t|yes|y|1)\z/i
          true
        else
          false
        end
      when :Object
        # generic object (usually a Hash), return directly
        value
      when /\AArray<(?<inner_type>.+)>\z/
        inner_type = Regexp.last_match[:inner_type]
        value.map { |v| _deserialize(inner_type, v) }
      when /\AHash<(?<k_type>.+?), (?<v_type>.+)>\z/
        k_type = Regexp.last_match[:k_type]
        v_type = Regexp.last_match[:v_type]
        {}.tap do |hash|
          value.each do |k, v|
            hash[_deserialize(k_type, k)] = _deserialize(v_type, v)
          end
        end
      else # model
        # models (e.g. Pet) or oneOf
        klass = OpenbaoClient.const_get(type)
        klass.respond_to?(:openapi_any_of) || klass.respond_to?(:openapi_one_of) ? klass.build(value) : klass.build_from_hash(value)
      end
    end

    # Returns the string representation of the object
    # @return [String] String presentation of the object
    def to_s
      to_hash.to_s
    end

    # to_body is an alias to to_hash (backward compatibility)
    # @return [Hash] Returns the object in the form of hash
    def to_body
      to_hash
    end

    # Returns the object in the form of hash
    # @return [Hash] Returns the object in the form of hash
    def to_hash
      hash = {}
      self.class.attribute_map.each_pair do |attr, param|
        value = self.send(attr)
        if value.nil?
          is_nullable = self.class.openapi_nullable.include?(attr)
          next if !is_nullable || (is_nullable && !instance_variable_defined?(:"@#{attr}"))
        end

        hash[param] = _to_hash(value)
      end
      hash
    end

    # Outputs non-array value in the form of hash
    # For object, use to_hash. Otherwise, just return the value
    # @param [Object] value Any valid value
    # @return [Hash] Returns the value in the form of hash
    def _to_hash(value)
      if value.is_a?(Array)
        value.compact.map { |v| _to_hash(v) }
      elsif value.is_a?(Hash)
        {}.tap do |hash|
          value.each { |k, v| hash[k] = _to_hash(v) }
        end
      elsif value.respond_to? :to_hash
        value.to_hash
      else
        value
      end
    end

  end

end
