/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.jruby;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.jruby.Ruby;
import org.jruby.RubyBasicObject;
import org.jruby.RubyClass;
import org.jruby.RubyObject;
import org.jruby.anno.JRubyMethod;
import org.jruby.api.Access;
import org.jruby.api.Define;
import org.jruby.api.Error;
import org.jruby.javasupport.Java;
import org.jruby.runtime.Block;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

public class JRubyObjectInputStream
extends RubyObject {
    JRubyObjectInputStreamImpl impl;

    public static RubyClass createJRubyObjectInputStream(ThreadContext context) {
        return (RubyClass)Define.defineClass(context, "JRubyObjectInputStream", Access.objectClass(context), JRubyObjectInputStream::new).defineMethods(context, JRubyObjectInputStream.class);
    }

    @Deprecated(since="10.0")
    public static IRubyObject newInstance(IRubyObject recv2, IRubyObject[] args2, Block block) {
        return JRubyObjectInputStream.newInstance(((RubyBasicObject)recv2).getCurrentContext(), recv2, args2, block);
    }

    @JRubyMethod(name={"new"}, rest=true, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2, Block block) {
        IRubyObject obj = ((RubyClass)recv2).allocate(context);
        obj.callMethod(context, "initialize", args2, block);
        return obj;
    }

    public JRubyObjectInputStream(Ruby runtime2, RubyClass rubyClass) {
        super(runtime2, rubyClass);
    }

    @Deprecated(since="10.0")
    public IRubyObject initialize(IRubyObject wrappedStream) {
        return this.initialize(this.getCurrentContext(), wrappedStream);
    }

    @JRubyMethod(name={"initialize"}, required=1, visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject wrappedStream) {
        InputStream stream = wrappedStream.toJava(InputStream.class);
        try {
            this.impl = new JRubyObjectInputStreamImpl(context.runtime, stream);
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        return this;
    }

    @Deprecated(since="10.0")
    public IRubyObject readObject() {
        return this.readObject(this.getCurrentContext());
    }

    @JRubyMethod(name={"read_object"}, alias={"readObject"})
    public IRubyObject readObject(ThreadContext context) {
        try {
            return Java.getInstance(context.runtime, this.impl.readObject());
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        catch (ClassNotFoundException cnfe) {
            throw Error.nameError(context, cnfe.getLocalizedMessage(), cnfe.getMessage(), cnfe);
        }
    }

    @Deprecated(since="10.0")
    public IRubyObject close() {
        return this.close(this.getCurrentContext());
    }

    @JRubyMethod(name={"close"})
    public IRubyObject close(ThreadContext context) {
        try {
            this.impl.close();
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
        return this;
    }

    static class JRubyObjectInputStreamImpl
    extends ObjectInputStream {
        protected final Ruby runtime;

        public JRubyObjectInputStreamImpl(Ruby runtime2, InputStream in) throws IOException {
            super(in);
            this.runtime = runtime2;
        }

        protected Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            return Class.forName(desc.getName(), true, this.runtime.getJRubyClassLoader());
        }
    }
}

