/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.4.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

BSplineTransformInitializerFilter is a helper class intended to initialize the control point grid such
that it has a physically consistent definition. It sets the transform
domain origin, physical dimensions and direction from information
obtained from the image. It also sets the mesh size if asked to do so
by calling SetTransformDomainMeshSize() before calling InitializeTransform().



Luis Ibanez Nick Tustison

See:
 itk::simple::BSplineTransformInitializer for the procedural interface

 itk::BSplineTransformInitializer for the Doxygen on the original ITK class.


C++ includes: sitkBSplineTransformInitializerFilter.h
*/
public class BSplineTransformInitializerFilter extends ProcessObject {
  private transient long swigCPtr;

  protected BSplineTransformInitializerFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.BSplineTransformInitializerFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(BSplineTransformInitializerFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(BSplineTransformInitializerFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
itk::simple::BSplineTransformInitializerFilter::~BSplineTransformInitializerFilter() override

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_BSplineTransformInitializerFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::BSplineTransformInitializerFilter::BSplineTransformInitializerFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  BSplineTransformInitializerFilter() {
    this(SimpleITKJNI.new_BSplineTransformInitializerFilter(), true);
  }

  /**
Self&amp; itk::simple::BSplineTransformInitializerFilter::SetTransformDomainMeshSize(const std::vector&lt; uint32_t &gt; &amp;TransformDomainMeshSize)

Allow the user to set the mesh size of the transform via the
initializer even though the initializer does not do anything with that
information. Default = 1^ImageDimension.

*/
public  void setTransformDomainMeshSize(VectorUInt32 TransformDomainMeshSize) {
    SimpleITKJNI.BSplineTransformInitializerFilter_setTransformDomainMeshSize(swigCPtr, this, VectorUInt32.getCPtr(TransformDomainMeshSize), TransformDomainMeshSize);
  }

  /**
std::vector&lt;uint32_t&gt; itk::simple::BSplineTransformInitializerFilter::GetTransformDomainMeshSize() const
*/
public  VectorUInt32 getTransformDomainMeshSize() {
    return new VectorUInt32(SimpleITKJNI.BSplineTransformInitializerFilter_getTransformDomainMeshSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::BSplineTransformInitializerFilter::SetOrder(unsigned int order)

The order of the bspline in the output BSplineTransform. This value effects the number of control points.

*/
public  void setOrder(long order) {
    SimpleITKJNI.BSplineTransformInitializerFilter_setOrder(swigCPtr, this, order);
  }

  /**
unsigned int itk::simple::BSplineTransformInitializerFilter::GetOrder() const
*/
public  long getOrder() {
    return SimpleITKJNI.BSplineTransformInitializerFilter_getOrder(swigCPtr, this);
  }

  /**
std::string itk::simple::BSplineTransformInitializerFilter::GetName() const override

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.BSplineTransformInitializerFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::BSplineTransformInitializerFilter::ToString() const override

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.BSplineTransformInitializerFilter_toString(swigCPtr, this);
  }

  /**
BSplineTransform itk::simple::BSplineTransformInitializerFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  BSplineTransform execute(Image image1) {
    return new BSplineTransform(SimpleITKJNI.BSplineTransformInitializerFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
