﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/rtbfabric/RTBFabric_EXPORTS.h>
#include <aws/rtbfabric/model/FilterCriterion.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace RTBFabric {
namespace Model {

/**
 * <p>Describes the configuration of a filter.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/rtbfabric-2023-05-15/Filter">AWS
 * API Reference</a></p>
 */
class Filter {
 public:
  AWS_RTBFABRIC_API Filter() = default;
  AWS_RTBFABRIC_API Filter(Aws::Utils::Json::JsonView jsonValue);
  AWS_RTBFABRIC_API Filter& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_RTBFABRIC_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>Describes the criteria for a filter.</p>
   */
  inline const Aws::Vector<FilterCriterion>& GetCriteria() const { return m_criteria; }
  inline bool CriteriaHasBeenSet() const { return m_criteriaHasBeenSet; }
  template <typename CriteriaT = Aws::Vector<FilterCriterion>>
  void SetCriteria(CriteriaT&& value) {
    m_criteriaHasBeenSet = true;
    m_criteria = std::forward<CriteriaT>(value);
  }
  template <typename CriteriaT = Aws::Vector<FilterCriterion>>
  Filter& WithCriteria(CriteriaT&& value) {
    SetCriteria(std::forward<CriteriaT>(value));
    return *this;
  }
  template <typename CriteriaT = FilterCriterion>
  Filter& AddCriteria(CriteriaT&& value) {
    m_criteriaHasBeenSet = true;
    m_criteria.emplace_back(std::forward<CriteriaT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<FilterCriterion> m_criteria;
  bool m_criteriaHasBeenSet = false;
};

}  // namespace Model
}  // namespace RTBFabric
}  // namespace Aws
