/**
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements. See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership. The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.wss4j.policy.builders;

import org.apache.neethi.Assertion;
import org.apache.neethi.AssertionBuilderFactory;
import org.apache.wss4j.policy.SP11Constants;
import org.apache.wss4j.policy.SP13Constants;
import org.apache.wss4j.policy.SPConstants;
import org.apache.wss4j.policy.SPUtils;
import org.apache.wss4j.policy.model.RequiredElements;
import org.apache.wss4j.policy.model.XPath;
import org.w3c.dom.Element;

import javax.xml.namespace.QName;
import java.util.List;

public class RequiredElementsBuilder extends SignedElementsBuilder {

    @Override
    public Assertion build(Element element, AssertionBuilderFactory factory) throws IllegalArgumentException {

        final SPConstants.SPVersion spVersion = SPConstants.SPVersion.getSPVersion(element.getNamespaceURI());
        final String xPathVersion = getXPathVersion(element);
        final List<XPath> xPaths = getXPathExpressions(element, spVersion);
        RequiredElements requiredElements = new RequiredElements(spVersion, xPathVersion, xPaths);
        requiredElements.setOptional(SPUtils.isOptional(element));
        requiredElements.setIgnorable(SPUtils.isIgnorable(element));
        return requiredElements;
    }

    @Override
    public QName[] getKnownElements() {
        return new QName[]{SP13Constants.REQUIRED_ELEMENTS, SP11Constants.REQUIRED_ELEMENTS};
    }
}
