/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.application.metadata.impl;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.analysis_engine.metadata.AnalysisEngineMetaData;
import org.apache.uima.application.metadata.ConfigParamOverrides;
import org.apache.uima.application.metadata.DeploymentOverrides;
import org.apache.uima.application.metadata.OverrideSet;
import org.apache.uima.application.metadata.UimaApplication;
import org.apache.uima.application.metadata.UimaCasProcessor;
import org.apache.uima.application.metadata.impl.AbstractUimaCasProcessor;
import org.apache.uima.application.metadata.impl.UimaApplication_Impl;
import org.apache.uima.application.util.UimaXmlParsingUtil;
import org.apache.uima.collection.CasConsumerDescription;
import org.apache.uima.collection.metadata.CasProcessorErrorHandling;
import org.apache.uima.collection.metadata.CpeCasProcessor;
import org.apache.uima.cpe.model.CasProcessorSettings;
import org.apache.uima.cpe.model.ConfigParametersModel;
import org.apache.uima.cpe.model.CpeCasProcessorModel;
import org.apache.uima.resource.CustomResourceSpecifier;
import org.apache.uima.resource.Parameter;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.resource.ResourceManager;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.resource.URISpecifier;
import org.apache.uima.resource.metadata.NameValuePair;
import org.apache.uima.resource.metadata.ProcessingResourceMetaData;
import org.apache.uima.resource.metadata.TypePriorities;
import org.apache.uima.resource.metadata.impl.PropertyXmlInfo;
import org.apache.uima.resource.metadata.impl.XmlizationInfo;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.util.InvalidXMLException;
import org.apache.uima.util.XMLParser;
import org.apache.uima.util.XMLizable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UimaCasProcessor_impl
extends AbstractUimaCasProcessor
implements UimaCasProcessor {
    static final long serialVersionUID = -2248322904617280983L;
    protected Object cloneResourceSpecifier;
    private TypePriorities typePriorities;
    private CpeCasProcessor cpeCasProcessor;
    private transient CasProcessorSettings casProcessorSettings = null;
    private CasProcessorErrorHandling casProcessorErrorHandling = null;
    private int batchSize = -1;

    public UimaCasProcessor_impl() {
        super(0, null);
    }

    public UimaCasProcessor_impl(UimaApplication app) {
        super(0, app);
    }

    public static UimaCasProcessor createUimaCasProcessor(String xmlDescriptor, UimaCasProcessor uimaCasProcessor) throws InvalidXMLException, ResourceInitializationException, IOException {
        XMLizable xmlizable = UimaXmlParsingUtil.parseUimaXmlDescriptor(xmlDescriptor);
        if (xmlizable == null) {
            return null;
        }
        UimaCasProcessor_impl u = (UimaCasProcessor_impl)uimaCasProcessor;
        if (uimaCasProcessor == null) {
            u = new UimaCasProcessor_impl();
        }
        u.xmlizableDescriptor = xmlizable;
        u.xmlDescriptor = xmlDescriptor;
        if (xmlizable instanceof AnalysisEngineDescription) {
            AnalysisEngineMetaData a = ((AnalysisEngineDescription)xmlizable).getAnalysisEngineMetaData();
            u.setCasProcessorCategory(2);
            u.setInstanceName(a.getName());
            u.configParamDecls = a.getConfigurationParameterDeclarations();
            u.configParamSettings = a.getConfigurationParameterSettings();
            u.typePriorities = UimaCasProcessor_impl.getTypePriorities(xmlizable, u.getResourceManager());
        } else if (xmlizable instanceof CasConsumerDescription) {
            ProcessingResourceMetaData p = ((CasConsumerDescription)xmlizable).getCasConsumerMetaData();
            u.setCasProcessorCategory(4);
            u.setInstanceName(p.getName());
            u.configParamDecls = p.getConfigurationParameterDeclarations();
            u.configParamSettings = p.getConfigurationParameterSettings();
        } else if (xmlizable instanceof URISpecifier) {
            URISpecifier specifier = (URISpecifier)xmlizable;
            Trace.err("URISpecifier protocol=" + specifier.getProtocol() + " resource type=" + specifier.getResourceType() + " uri=" + specifier.getUri());
            u.setCasProcessorCategory(6);
        } else if (xmlizable instanceof CustomResourceSpecifier) {
            u.setCasProcessorCategory(7);
            CustomResourceSpecifier specifier = (CustomResourceSpecifier)xmlizable;
            u.cloneResourceSpecifier = specifier.clone();
            Parameter[] params = specifier.getParameters();
            Trace.err("CustomResourceSpecifier ResourceClassname=" + specifier.getResourceClassName() + " Parameter size=" + params.length);
            for (int i = 0; i < params.length; ++i) {
                Trace.err("Param name: " + params[i].getName() + " value: " + params[i].getValue());
            }
        } else {
            Trace.err("UNKNOWN Descriptor: " + xmlizable.getClass().getName());
        }
        u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings, null);
        UimaCasProcessor_impl.createConfigParamOverrides(u.configParamsModel);
        return u;
    }

    public static UimaCasProcessor createUimaCasProcessor(CpeCasProcessor cpeCasProcessor, ResourceSpecifier specifier, UimaApplication app) throws InvalidXMLException, ResourceInitializationException {
        UimaCasProcessor_impl u = new UimaCasProcessor_impl(app);
        u.xmlDescriptor = cpeCasProcessor.getDescriptor();
        u.cpeCasProcessor = cpeCasProcessor;
        u.setInstanceName(cpeCasProcessor.getName());
        u.xmlizableDescriptor = specifier;
        if (specifier instanceof AnalysisEngineDescription) {
            AnalysisEngineMetaData a = ((AnalysisEngineDescription)specifier).getAnalysisEngineMetaData();
            u.setCasProcessorCategory(2);
            u.configParamDecls = a.getConfigurationParameterDeclarations();
            u.configParamSettings = a.getConfigurationParameterSettings();
            u.typePriorities = UimaCasProcessor_impl.getTypePriorities((XMLizable)specifier, u.getResourceManager());
        } else if (specifier instanceof CasConsumerDescription) {
            ProcessingResourceMetaData p = ((CasConsumerDescription)specifier).getCasConsumerMetaData();
            u.setCasProcessorCategory(4);
            u.configParamDecls = p.getConfigurationParameterDeclarations();
            u.configParamSettings = p.getConfigurationParameterSettings();
        }
        u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings, cpeCasProcessor.getConfigurationParameterSettings());
        UimaCasProcessor_impl.createConfigParamOverrides(u.configParamsModel);
        return u;
    }

    protected static UimaCasProcessor createUimaCasProcessorFrom(UimaCasProcessor uimaCasProcessor, CpeCasProcessor cpeCasProcessor, ResourceSpecifier specifier, UimaApplication app) throws InvalidXMLException, ResourceInitializationException {
        UimaCasProcessor_impl u = uimaCasProcessor != null ? (UimaCasProcessor_impl)uimaCasProcessor : new UimaCasProcessor_impl(app);
        u.xmlDescriptor = cpeCasProcessor.getDescriptor();
        u.cpeCasProcessor = cpeCasProcessor;
        u.xmlizableDescriptor = specifier;
        if (specifier instanceof AnalysisEngineDescription) {
            AnalysisEngineMetaData a = ((AnalysisEngineDescription)specifier).getAnalysisEngineMetaData();
            u.setCasProcessorCategory(2);
            u.setInstanceName(a.getName());
            u.configParamDecls = a.getConfigurationParameterDeclarations();
            u.configParamSettings = a.getConfigurationParameterSettings();
            u.typePriorities = UimaCasProcessor_impl.getTypePriorities((XMLizable)specifier, u.getResourceManager());
        } else if (specifier instanceof CasConsumerDescription) {
            ProcessingResourceMetaData p = ((CasConsumerDescription)specifier).getCasConsumerMetaData();
            u.setCasProcessorCategory(4);
            u.setInstanceName(p.getName());
            u.configParamDecls = p.getConfigurationParameterDeclarations();
            u.configParamSettings = p.getConfigurationParameterSettings();
        }
        return u;
    }

    public static UimaCasProcessor createUimaCasProcessor(CpeCasProcessor cpeCasProcessor, XMLizable xmlizable, UimaApplication app) throws InvalidXMLException, ResourceInitializationException {
        UimaCasProcessor_impl u = new UimaCasProcessor_impl(app);
        u.xmlDescriptor = cpeCasProcessor.getDescriptor();
        u.cpeCasProcessor = cpeCasProcessor;
        u.xmlizableDescriptor = xmlizable;
        if (xmlizable instanceof AnalysisEngineDescription) {
            AnalysisEngineMetaData a = ((AnalysisEngineDescription)xmlizable).getAnalysisEngineMetaData();
            u.setCasProcessorCategory(2);
            u.setInstanceName(a.getName());
            u.configParamDecls = a.getConfigurationParameterDeclarations();
            u.configParamSettings = a.getConfigurationParameterSettings();
            u.typePriorities = UimaCasProcessor_impl.getTypePriorities(xmlizable, u.getResourceManager());
        } else if (xmlizable instanceof CasConsumerDescription) {
            ProcessingResourceMetaData p = ((CasConsumerDescription)xmlizable).getCasConsumerMetaData();
            u.setCasProcessorCategory(4);
            u.setInstanceName(p.getName());
            u.configParamDecls = p.getConfigurationParameterDeclarations();
            u.configParamSettings = p.getConfigurationParameterSettings();
        } else if (xmlizable instanceof URISpecifier) {
            URISpecifier specifier = (URISpecifier)xmlizable;
            u.setCasProcessorCategory(6);
            String name = "Unknow";
            try {
                name = new URI(specifier.getUri()).getPath();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            u.setInstanceName(name);
        } else if (xmlizable instanceof CustomResourceSpecifier) {
            CustomResourceSpecifier specifier = (CustomResourceSpecifier)xmlizable;
            u.setCasProcessorCategory(7);
            u.setInstanceName(specifier.getResourceClassName());
        }
        u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings, cpeCasProcessor.getConfigurationParameterSettings());
        UimaCasProcessor_impl.createConfigParamOverrides(u.configParamsModel);
        return u;
    }

    public static UimaCasProcessor createUimaCasProcessorFromString(String xmlDescriptorString, UimaApplication app) throws InvalidXMLException, ResourceInitializationException {
        UimaCasProcessor_impl u;
        XMLizable xmlizable = UimaXmlParsingUtil.parseUimaXmlDescriptorFromString(xmlDescriptorString);
        if (xmlizable == null) {
            return null;
        }
        if (xmlizable instanceof UimaCasProcessor) {
            u = (UimaCasProcessor_impl)xmlizable;
        } else {
            u = new UimaCasProcessor_impl(app);
            u.xmlDescriptor = null;
        }
        u.xmlizableDescriptor = xmlizable;
        if (xmlizable instanceof AnalysisEngineDescription) {
            AnalysisEngineMetaData a = ((AnalysisEngineDescription)xmlizable).getAnalysisEngineMetaData();
            u.setCasProcessorCategory(2);
            u.setInstanceName(a.getName());
            u.configParamDecls = a.getConfigurationParameterDeclarations();
            u.configParamSettings = a.getConfigurationParameterSettings();
            u.typePriorities = UimaCasProcessor_impl.getTypePriorities(xmlizable, u.getResourceManager());
        } else if (xmlizable instanceof CasConsumerDescription) {
            ProcessingResourceMetaData p = ((CasConsumerDescription)xmlizable).getCasConsumerMetaData();
            u.setCasProcessorCategory(4);
            u.setInstanceName(p.getName());
            u.configParamDecls = p.getConfigurationParameterDeclarations();
            u.configParamSettings = p.getConfigurationParameterSettings();
        } else if (xmlizable instanceof URISpecifier) {
            URISpecifier specifier = (URISpecifier)xmlizable;
            u.setCasProcessorCategory(6);
            String name = "Unknow";
            try {
                name = new URI(specifier.getUri()).getPath();
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            u.setInstanceName(name);
            return u;
        }
        u.configParamsModel = new ConfigParametersModel(u.configParamDecls, u.configParamSettings, null);
        UimaCasProcessor_impl.createConfigParamOverrides(u.configParamsModel);
        return u;
    }

    public static TypePriorities getTypePriorities(XMLizable xmlizable, ResourceManager rm) throws InvalidXMLException, ResourceInitializationException {
        TypePriorities tp = null;
        return tp;
    }

    public void initConfigurationParameters(CpeCasProcessorModel model) {
        this.configParamsModel = model.getConfigParamsModel();
        ConfigParamOverrides overrides = this.getConfigParamOverrides();
        if (overrides == null) {
            return;
        }
        OverrideSet[] sets = overrides.getOverrideSets();
        for (int i = 0; i < sets.length; ++i) {
            sets[i].setConfigParametersModel(this.configParamsModel);
        }
    }

    public void buildFromXMLElement(Element aElement, XMLParser aParser, XMLParser.ParsingOptions aOptions) throws InvalidXMLException {
        this.setInstanceName(aElement.getAttribute("name"));
        NodeList childNodes = aElement.getChildNodes();
        for (int i = 0; i < childNodes.getLength(); ++i) {
            Node curNode = childNodes.item(i);
            if (!(curNode instanceof Element)) continue;
            Element elem = (Element)curNode;
            if ("import".equals(elem.getTagName())) {
                this.setXmlDescriptor(elem.getAttribute("location"));
                try {
                    UimaCasProcessor_impl.createUimaCasProcessor(UimaApplication_Impl.resolveUimaXmlDescriptor(this.getXmlDescriptor()), this);
                }
                catch (ResourceInitializationException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                continue;
            }
            if ("deploymentOverrides".equals(elem.getTagName())) {
                this.setDeploymentOverrides((DeploymentOverrides)aParser.buildObject(elem, aOptions));
                continue;
            }
            if ("deploymentSettings".equals(elem.getTagName())) continue;
            Trace.err("Unknown Tag: " + elem.getTagName());
        }
        if (this.getConfigParamsModel() != null) {
            ConfigParametersModel models = this.getConfigParamsModel();
            OverrideSet[] sets = this.getDeploymentOverrides().getConfigParamOverrides().getOverrideSets();
            if (sets != null && sets[0].getConfigurationParameterSettings() != null) {
                NameValuePair[] pairs = sets[0].getConfigurationParameterSettings().getParameterSettings();
                if (pairs != null && pairs.length > 0) {
                    UimaCasProcessor_impl.createConfigParamOverrides(models, sets[0].getConfigurationParameterSettings());
                } else {
                    Trace.err("EMPTY Overrides");
                }
            } else {
                Trace.err("NO Overrides");
            }
        }
    }

    protected XmlizationInfo getXmlizationInfo() {
        return new XmlizationInfo("configurationParameters", new PropertyXmlInfo[]{new PropertyXmlInfo("configurationParameters", null), new PropertyXmlInfo("commonParameters", "commonParameters"), new PropertyXmlInfo("configurationGroups", null)});
    }

    public ConfigParamOverrides getConfigParamOverrides() {
        if (this.mDeploymentOverrides == null) {
            return null;
        }
        return this.mDeploymentOverrides.getConfigParamOverrides();
    }

    public void setCasProcessorCategory(int casprocCategory) {
        this.casprocCategory = casprocCategory;
    }

    public CpeCasProcessor getCpeCasProcessor() {
        return this.cpeCasProcessor;
    }

    public void setCpeCasProcessor(CpeCasProcessor cpeCasProcessor) {
        this.cpeCasProcessor = cpeCasProcessor;
    }

    public CasProcessorSettings getCasProcessorSettings() {
        return this.casProcessorSettings;
    }

    public void setCasProcessorSettings(CasProcessorSettings casProcessorSettings) {
        this.casProcessorSettings = casProcessorSettings;
    }

    public CasProcessorErrorHandling getCasProcessorErrorHandling() {
        return this.casProcessorErrorHandling;
    }

    public void setCasProcessorErrorHandling(CasProcessorErrorHandling casProcessorErrorHandling) {
        this.casProcessorErrorHandling = casProcessorErrorHandling;
    }

    public int getBatchSize() {
        return this.batchSize;
    }

    public void setBatchSize(int batchSize) {
        this.batchSize = batchSize;
    }

    public Object getCloneResourceSpecifier() {
        return this.cloneResourceSpecifier;
    }
}

