/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.dde.internal.details;

import org.apache.uima.aae.deployment.AEDeploymentMetaData;
import org.apache.uima.aae.deployment.AsyncAggregateErrorConfiguration;
import org.apache.uima.aae.deployment.AsyncPrimitiveErrorConfiguration;
import org.apache.uima.aae.deployment.RemoteAEDeploymentMetaData;
import org.apache.uima.analysis_engine.AnalysisEngineDescription;
import org.apache.uima.dde.internal.DeploymentDescriptorEditor;
import org.apache.uima.dde.internal.details.AEMetaDataDetailsPage;
import org.apache.uima.dde.internal.details.EmptyDetailsPage;
import org.apache.uima.dde.internal.page.MasterDetails;
import org.apache.uima.resource.ResourceSpecifier;
import org.apache.uima.tools.debug.util.Trace;
import org.apache.uima.tools.internal.uima.util.FormMessage;
import org.eclipse.ui.forms.DetailsPart;
import org.eclipse.ui.forms.IDetailsPage;
import org.eclipse.ui.forms.IDetailsPageProvider;
import org.eclipse.ui.forms.IManagedForm;

public class DetailsPageProvider
implements IDetailsPageProvider {
    private DeploymentDescriptorEditor multiPageEditor;
    private IManagedForm managedForm = null;
    private MasterDetails masterPart;

    public DetailsPageProvider(DeploymentDescriptorEditor editor, IManagedForm managedForm, MasterDetails master, DetailsPart detailsPart) {
        this.multiPageEditor = editor;
        this.managedForm = managedForm;
        this.masterPart = master;
    }

    public IDetailsPage getPage(Object key) {
        if (key.equals(AsyncPrimitiveErrorConfiguration.class)) {
            return new AEMetaDataDetailsPage(this.multiPageEditor, this.managedForm, this.masterPart, false);
        }
        if (key.equals(AsyncAggregateErrorConfiguration.class)) {
            return new AEMetaDataDetailsPage(this.multiPageEditor, this.managedForm, this.masterPart, true);
        }
        return new EmptyDetailsPage(this.managedForm);
    }

    public Object getPageKey(Object object) {
        this.updateStatus(null, 3);
        if (object instanceof AEDeploymentMetaData) {
            AEDeploymentMetaData metaData = (AEDeploymentMetaData)object;
            Class cls = null;
            cls = metaData.isTopAnalysisEngine() ? AsyncPrimitiveErrorConfiguration.class : AsyncAggregateErrorConfiguration.class;
            return cls;
        }
        if (object instanceof RemoteAEDeploymentMetaData) {
            return AsyncAggregateErrorConfiguration.class;
        }
        Trace.trace((String)("Unkown class: " + object.getClass().getName()));
        return EmptyDetailsPage.class;
    }

    public Object getPageKey_OLD(Object object) {
        this.updateStatus(null, 3);
        if (object instanceof AEDeploymentMetaData) {
            AEDeploymentMetaData metaData = (AEDeploymentMetaData)object;
            Class cls = null;
            ResourceSpecifier rs = metaData.getResourceSpecifier();
            if (rs != null) {
                if (rs instanceof AnalysisEngineDescription) {
                    cls = metaData.isTopAnalysisEngine() ? AsyncPrimitiveErrorConfiguration.class : AsyncAggregateErrorConfiguration.class;
                }
            } else {
                String parentKey = null;
                if (metaData.getParent() != null) {
                    parentKey = metaData.getParent().getKey();
                } else if (metaData.isTopAnalysisEngine()) {
                    this.updateStatus("The top descriptor is not specified.", 3);
                    return null;
                }
                if (parentKey == null) {
                    parentKey = "Top Analysis Engine";
                }
                this.updateStatus("The analysis engine's key=\"" + metaData.getKey() + "\" is not valid for the aggregate \"" + parentKey + "\"", 3);
            }
            return cls;
        }
        if (object instanceof RemoteAEDeploymentMetaData) {
            RemoteAEDeploymentMetaData metaData = (RemoteAEDeploymentMetaData)object;
            Class<AsyncAggregateErrorConfiguration> cls = null;
            ResourceSpecifier rs = metaData.getResourceSpecifier();
            if (rs != null) {
                if (rs instanceof AnalysisEngineDescription) {
                    cls = AsyncAggregateErrorConfiguration.class;
                }
            } else {
                String parentKey = metaData.getParent().getKey();
                if (parentKey == null) {
                    parentKey = "Top Analysis Engine";
                }
                this.updateStatus("The analysis engine's key=\"" + metaData.getKey() + "\" is not valid for the aggregate \"" + parentKey + "\"", 3);
            }
            return cls;
        }
        Trace.trace((String)("Unkown class: " + object.getClass().getName()));
        return EmptyDetailsPage.class;
    }

    protected void updateStatus(String msg, int msgType) {
        FormMessage.setMessage(this.managedForm.getForm().getForm(), msg, msgType);
    }
}

