/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.ui.console;

import java.io.IOException;
import java.util.List;
import org.eclipse.dltk.console.IScriptConsoleShell;
import org.eclipse.dltk.console.ScriptConsoleCompletionProposal;
import org.eclipse.dltk.console.ui.IScriptConsoleViewer;
import org.eclipse.dltk.console.ui.ScriptConsoleCompletionProcessor;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationPresenter;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.swt.graphics.Image;

public class RutaConsoleCompletionProcessor
extends ScriptConsoleCompletionProcessor {
    protected ScriptConsoleCompletionProcessor.IProposalDecorator tmDecorator = new ScriptConsoleCompletionProcessor.IProposalDecorator(){

        public String formatProposal(ScriptConsoleCompletionProposal c) {
            return c.getDisplay();
        }

        public Image getImage(ScriptConsoleCompletionProposal c) {
            String type = c.getType();
            if (type.equals("var")) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.localvariable_obj.gif");
            }
            if (type.equals("proc")) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.methpub_obj.gif");
            }
            if (type.equals("command")) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.methpri_obj.gif");
            }
            if (type.equals("func")) {
                return DLTKPluginImages.get((String)"org.eclipse.dltk.ui.field_default_obj.gif");
            }
            return null;
        }
    };
    private IContextInformationValidator validator;

    public RutaConsoleCompletionProcessor(IScriptConsoleShell interpreterShell) {
        super(interpreterShell);
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{'$'};
    }

    protected ICompletionProposal[] computeCompletionProposalsImpl(IScriptConsoleViewer viewer, int offset) {
        try {
            String commandLine = viewer.getCommandLine();
            int cursorPosition = offset - viewer.getCommandLineOffset();
            List list = this.getInterpreterShell().getCompletions(commandLine, cursorPosition);
            List proposals = this.createProposalsFromString(list, offset, this.tmDecorator);
            return proposals.toArray(new ICompletionProposal[proposals.size()]);
        }
        catch (IOException e) {
            e.printStackTrace();
            return new ICompletionProposal[0];
        }
    }

    protected IContextInformation[] computeContextInformationImpl(ITextViewer viewer, int offset) {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        if (this.validator == null) {
            this.validator = new Validator();
        }
        return this.validator;
    }

    protected static class Validator
    implements IContextInformationValidator,
    IContextInformationPresenter {
        protected int installOffset;

        protected Validator() {
        }

        public boolean isContextInformationValid(int offset) {
            return Math.abs(this.installOffset - offset) < 5;
        }

        public void install(IContextInformation info, ITextViewer viewer, int offset) {
            this.installOffset = offset;
        }

        public boolean updatePresentation(int documentPosition, TextPresentation presentation) {
            return false;
        }
    }
}

