/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.explain.apply;

import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.ruta.explain.apply.ApplyViewPage;
import org.apache.uima.ruta.explain.tree.IExplainTreeNode;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class ApplyTreeLabelProvider
extends LabelProvider
implements ILabelProvider {
    private ApplyViewPage owner;
    ImageDescriptor blockApply;

    public ApplyTreeLabelProvider(ApplyViewPage owner) {
        this.owner = owner;
    }

    public Image getImage(Object element) {
        IExplainTreeNode debugNode;
        FeatureStructure fs;
        if (element instanceof IExplainTreeNode && (fs = (debugNode = (IExplainTreeNode)element).getFeatureStructure()) != null) {
            String name = fs.getType().getName();
            if (name.equals("org.apache.uima.ruta.type.DebugRuleApply") && debugNode.getChildren().size() >= 3) {
                name = name + "Delegate";
            }
            return this.owner.getImage(name);
        }
        return null;
    }

    public String getText(Object element) {
        String result = "error";
        if (element instanceof IExplainTreeNode) {
            IExplainTreeNode debugNode = (IExplainTreeNode)element;
            TypeSystem ts = debugNode.getTypeSystem();
            Type ruleType = ts.getType("org.apache.uima.ruta.type.DebugRuleApply");
            FeatureStructure fs = debugNode.getFeatureStructure();
            if (fs != null && ts.subsumes(ruleType, fs.getType())) {
                Feature f1 = ruleType.getFeatureByBaseName("applied");
                int v1 = fs.getIntValue(f1);
                Feature f2 = ruleType.getFeatureByBaseName("tried");
                int v2 = fs.getIntValue(f2);
                Feature f3 = ruleType.getFeatureByBaseName("element");
                String v3 = fs.getStringValue(f3);
                v3 = v3.replaceAll("[\\n\\r]", "");
                Feature f4 = ruleType.getFeatureByBaseName("time");
                long v4 = fs.getLongValue(f4);
                String time = "";
                if ((double)v4 > 0.0) {
                    double took = (double)v4 / 1000.0;
                    time = " [" + took + "s";
                    IExplainTreeNode parentNode = debugNode.getParent();
                    if (parentNode != null) {
                        FeatureStructure parent = parentNode.getFeatureStructure();
                        if (parent != null) {
                            long parentTime = parent.getLongValue(f4);
                            double percent = took / ((double)parentTime / 1000.0) * 100.0;
                            percent = (double)Math.round(percent * 100.0) / 100.0;
                            time = time + "|" + percent + "%]";
                        } else {
                            time = time + "]";
                        }
                    } else {
                        time = time + "]";
                    }
                }
                result = "[" + v1 + "/" + v2 + "] " + v3 + time;
            }
        }
        return result;
    }

    public static String escape(String str) {
        String result = str.replaceAll("\\\\", "\\\\\\\\");
        return result;
    }
}

