/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.util;

import java.io.Serializable;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public final class BulkSet<S>
extends AbstractSet<S>
implements Set<S>,
Serializable {
    private final Map<S, Long> map = new LinkedHashMap<S, Long>();
    private transient Class<?> allContainedElementsClass = null;
    private transient boolean allContainedElementsClassChecked = true;

    public Class<?> getAllContainedElementsClass() {
        if (this.allContainedElementsSameClass()) {
            return this.allContainedElementsClass;
        }
        return null;
    }

    public boolean allContainedElementsSameClass() {
        if (!this.allContainedElementsClassChecked) {
            this.allContainedElementsClass = null;
            this.allContainedElementsClassChecked = true;
            boolean hadNull = false;
            for (S key : this.map.keySet()) {
                if (key == null) {
                    this.allContainedElementsClass = null;
                    break;
                }
                if (this.allContainedElementsClass != null && !key.getClass().equals(this.allContainedElementsClass)) {
                    this.allContainedElementsClass = null;
                    break;
                }
                if (this.allContainedElementsClass != null) continue;
                this.allContainedElementsClass = key.getClass();
            }
        }
        return this.allContainedElementsClass != null;
    }

    @Override
    public int size() {
        return (int)this.longSize();
    }

    public int uniqueSize() {
        return this.map.size();
    }

    public long longSize() {
        return this.map.values().stream().collect(Collectors.summingLong(Long::longValue));
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public boolean contains(Object s) {
        return this.map.containsKey(s);
    }

    @Override
    public boolean add(S s) {
        return this.add(s, 1L);
    }

    @Override
    public boolean addAll(Collection<? extends S> collection) {
        if (collection instanceof BulkSet) {
            ((BulkSet)collection).map.forEach(this::add);
        } else {
            collection.iterator().forEachRemaining(this::add);
        }
        return true;
    }

    public void forEach(BiConsumer<S, Long> consumer) {
        this.map.forEach(consumer);
    }

    public Map<S, Long> asBulk() {
        return Collections.unmodifiableMap(this.map);
    }

    public boolean add(S s, long bulk) {
        this.allContainedElementsClassChecked = false;
        Long current = this.map.get(s);
        if (current != null) {
            this.map.put(s, current + bulk);
            return false;
        }
        this.map.put(s, bulk);
        return true;
    }

    public long get(S s) {
        Long bulk = this.map.get(s);
        return null == bulk ? 0L : bulk;
    }

    @Override
    public boolean remove(Object s) {
        return this.map.remove(s) != null;
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    @Override
    public Spliterator<S> spliterator() {
        return this.toList().spliterator();
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Objects.requireNonNull(collection);
        boolean modified = false;
        for (Object object : collection) {
            if (null == this.map.remove(object)) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    @Override
    public boolean equals(Object object) {
        return object instanceof BulkSet && this.map.equals(((BulkSet)object).map);
    }

    @Override
    public String toString() {
        return this.map.toString();
    }

    private List<S> toList() {
        ArrayList list = new ArrayList();
        this.map.forEach((? super K k, ? super V v) -> {
            for (long i = 0L; i < v; ++i) {
                list.add(k);
            }
        });
        return list;
    }

    @Override
    public Iterator<S> iterator() {
        return new Iterator<S>(){
            final Iterator<Map.Entry<S, Long>> entryIterator;
            S lastObject;
            long lastCount;
            {
                this.entryIterator = BulkSet.this.map.entrySet().iterator();
                this.lastObject = null;
                this.lastCount = 0L;
            }

            @Override
            public boolean hasNext() {
                return this.lastCount > 0L || this.entryIterator.hasNext();
            }

            @Override
            public S next() {
                if (this.lastCount > 0L) {
                    --this.lastCount;
                    return this.lastObject;
                }
                Map.Entry entry = this.entryIterator.next();
                if (entry.getValue() == 1L) {
                    return entry.getKey();
                }
                this.lastObject = entry.getKey();
                this.lastCount = entry.getValue() - 1L;
                return this.lastObject;
            }
        };
    }
}

