/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.saml.store;

import java.util.LinkedHashMap;
import java.util.Optional;
import org.opensaml.core.xml.XMLObject;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.context.session.SessionStore;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.saml.store.SAMLMessageStore;
import org.pac4j.saml.util.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpSessionStore
implements SAMLMessageStore {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    private final WebContext context;
    private final SessionStore sessionStore;
    private LinkedHashMap<String, String> internalMessages;
    private static final String SAML_STORAGE_KEY = "_springSamlStorageKey";

    public HttpSessionStore(WebContext context, SessionStore sessionStore) {
        CommonHelper.assertNotNull((String)"context", (Object)context);
        CommonHelper.assertNotNull((String)"sessionStore", (Object)sessionStore);
        this.context = context;
        this.sessionStore = sessionStore;
    }

    public void set(String messageID, XMLObject message) {
        this.log.debug("Storing message {} to session {}", (Object)messageID, this.sessionStore.getSessionId(this.context, true).get());
        LinkedHashMap<String, String> messages = this.getMessages();
        messages.put(messageID, Configuration.serializeSamlObject(message).toString());
        this.updateSession(messages);
    }

    public Optional<XMLObject> get(String messageID) {
        LinkedHashMap<String, String> messages = this.getMessages();
        String o = messages.get(messageID);
        if (o == null) {
            this.log.debug("Message {} not found in session {}", (Object)messageID, this.sessionStore.getSessionId(this.context, true).get());
            return Optional.empty();
        }
        this.log.debug("Message {} found in session {}, clearing", (Object)messageID, this.sessionStore.getSessionId(this.context, true).get());
        messages.clear();
        this.updateSession(messages);
        return Configuration.deserializeSamlObject(o);
    }

    private LinkedHashMap<String, String> getMessages() {
        if (this.internalMessages == null) {
            this.internalMessages = this.initializeSession();
        }
        return this.internalMessages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LinkedHashMap<String, String> initializeSession() {
        Optional messages = this.sessionStore.get(this.context, SAML_STORAGE_KEY);
        if (!messages.isPresent()) {
            WebContext webContext = this.context;
            synchronized (webContext) {
                messages = this.sessionStore.get(this.context, SAML_STORAGE_KEY);
                if (!messages.isPresent()) {
                    messages = Optional.of(new LinkedHashMap());
                    this.updateSession(messages.get());
                }
            }
        }
        return (LinkedHashMap)messages.get();
    }

    private void updateSession(LinkedHashMap<String, String> messages) {
        this.sessionStore.set(this.context, SAML_STORAGE_KEY, messages);
    }

    public void remove(String key) {
        this.set(key, null);
    }
}

