/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.oidc.services;

import java.util.List;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.OidcRegisteredService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuth20ServicesManagerRegisteredServiceLocator;
import org.apereo.cas.util.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OidcServicesManagerRegisteredServiceLocator
extends OAuth20ServicesManagerRegisteredServiceLocator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OidcServicesManagerRegisteredServiceLocator.class);
    static final int DEFAULT_ORDER = -2147483647;

    public OidcServicesManagerRegisteredServiceLocator(CasConfigurationProperties casProperties) {
        super(casProperties);
        this.setOrder(-2147483647);
        this.setRegisteredServiceFilter((registeredService, service) -> {
            boolean match = this.supports((RegisteredService)registeredService, (Service)service);
            if (match) {
                OidcRegisteredService oidcService = (OidcRegisteredService)registeredService;
                LOGGER.trace("Attempting to locate service [{}] via [{}]", service, (Object)oidcService);
                List clientIdAttribute = (List)service.getAttributes().get("client_id");
                match = CollectionUtils.firstElement((Object)clientIdAttribute).map(Object::toString).stream().anyMatch(clientId -> oidcService.getClientId().equalsIgnoreCase((String)clientId));
            }
            return match;
        });
    }

    public boolean supports(RegisteredService registeredService, Service service) {
        return registeredService instanceof OidcRegisteredService && super.supportsInternal(registeredService, service);
    }
}

