/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.sling.loader;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.io.IOUtils;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.testing.mock.sling.ResourceResolverType;
import org.apache.sling.testing.mock.sling.junit.SlingContext;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;

public abstract class AbstractContentLoaderFolderFileVaultXmlTest {
    @Rule
    public SlingContext context = new SlingContext(this.getResourceResolverType());

    protected abstract ResourceResolverType getResourceResolverType();

    @Before
    public void setUp() {
        this.context.load().folderFileVaultXml("src/test/resources/xml-jcr-import-samples", "/apps");
        this.context.load().folderFileVaultXml("src/test/resources/xml-jcr-import-samples", "/content");
    }

    @After
    public final void tearDown() throws Exception {
        Assert.assertFalse((boolean)this.context.resourceResolver().hasChanges());
    }

    @Test
    public void testContentResourceType() {
        Resource resource = this.context.resourceResolver().getResource("/content/samples/en/jcr:content");
        Assert.assertEquals((Object)"samples/sample-app/components/content/page/homepage", (Object)resource.getResourceType());
    }

    @Test
    public void testContentListChildren() {
        Resource resource = this.context.resourceResolver().getResource("/content/samples/en");
        List result = IteratorUtils.toList((Iterator)resource.listChildren());
        Assert.assertEquals((Object)"jcr:content", (Object)((Resource)result.get(0)).getName());
        Assert.assertEquals((Object)"tools", (Object)((Resource)result.get(1)).getName());
    }

    @Test
    public void testDamResourceType() {
        Resource resource = this.context.resourceResolver().getResource("/content/dam/talk.png/jcr:content");
        Assert.assertEquals((Object)"app:AssetContent", (Object)resource.getResourceType());
    }

    @Test
    public void testBinaryResource() throws IOException {
        Resource fileResource = this.context.resourceResolver().getResource("/content/dam/talk.png/jcr:content/renditions/original");
        try (InputStream is = (InputStream)fileResource.adaptTo(InputStream.class);){
            Assert.assertNotNull((String)("InputSteam is null for " + fileResource.getPath()), (Object)is);
            byte[] binaryData = IOUtils.toByteArray((InputStream)is);
            Assert.assertEquals((long)8668L, (long)binaryData.length);
        }
    }

    @Test
    public void testAppsResource() {
        Resource resource = this.context.resourceResolver().getResource("/apps/app1/components/comp1");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"Component #1", (Object)resource.getValueMap().get("jcr:title", String.class));
    }

    @Test
    public void testAppsResource_SearchPath() {
        Resource resource = this.context.resourceResolver().getResource("app1/components/comp1");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"Component #1", (Object)resource.getValueMap().get("jcr:title", String.class));
    }

    @Test
    public void testAppsResource_ParentResourceType() {
        Resource resource = this.context.resourceResolver().getResource("/content/samples/en/jcr:content/comp1-resource");
        Assert.assertNotNull((Object)resource);
        Assert.assertEquals((Object)"app1/components/base", (Object)this.context.resourceResolver().getParentResourceType(resource));
        Assert.assertTrue((boolean)this.context.resourceResolver().isResourceType(resource, "app1/components/comp1"));
        Assert.assertTrue((boolean)this.context.resourceResolver().isResourceType(resource, "/apps/app1/components/comp1"));
        Assert.assertTrue((boolean)this.context.resourceResolver().isResourceType(resource, "app1/components/base"));
        Assert.assertTrue((boolean)this.context.resourceResolver().isResourceType(resource, "core/components/superResource"));
    }
}

