/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.starter.testservices.resourceprovider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.SyntheticResource;
import org.apache.sling.api.resource.ValueMap;
import org.apache.sling.spi.resource.provider.ResolveContext;
import org.apache.sling.spi.resource.provider.ResourceContext;
import org.apache.sling.spi.resource.provider.ResourceProvider;
import org.apache.sling.starter.testservices.resourceprovider.PlanetResource;
import org.osgi.service.component.annotations.Component;

@Component(service={ResourceProvider.class}, property={"provider.name:String=Planets", "provider.root:String=/planets"})
public class PlanetsResourceProvider
extends ResourceProvider<DoesNotNeedAContext> {
    private static final Map<String, ValueMap> PLANETS = new HashMap<String, ValueMap>();
    public static final String ROOT = "/planets";

    public Resource getResource(ResolveContext<DoesNotNeedAContext> ctx, String path, ResourceContext resourceContext, Resource parent) {
        if (ROOT.equals(path)) {
            return new SyntheticResource(ctx.getResourceResolver(), path, "sling/test-services/planet");
        }
        ValueMap data = PLANETS.get(path);
        return data == null ? null : new PlanetResource(ctx.getResourceResolver(), path, data);
    }

    public Iterator<Resource> listChildren(ResolveContext<DoesNotNeedAContext> ctx, Resource parent) {
        if (parent.getPath().startsWith(ROOT)) {
            ArrayList<PlanetResource> kids = new ArrayList<PlanetResource>();
            for (Map.Entry<String, ValueMap> e : PLANETS.entrySet()) {
                if (!parent.getPath().equals(PlanetsResourceProvider.parentPath(e.getKey()))) continue;
                kids.add(new PlanetResource(parent.getResourceResolver(), e.getKey(), e.getValue()));
            }
            return kids.iterator();
        }
        return null;
    }

    private static String parentPath(String path) {
        int lastSlash = path.lastIndexOf("/");
        return lastSlash > 0 ? path.substring(0, lastSlash) : "";
    }

    private static ValueMap definePlanet(String name, int distance) {
        PlanetResource.PlanetValueMap valueMap = new PlanetResource.PlanetValueMap(name, distance);
        PLANETS.put("/planets/" + name.toLowerCase(), (ValueMap)valueMap);
        return valueMap;
    }

    static {
        PlanetsResourceProvider.definePlanet("Mercury", 57910);
        PlanetsResourceProvider.definePlanet("Venus", 108200);
        PlanetsResourceProvider.definePlanet("Earth", 149600).put((Object)"comment", (Object)"Resources can each have different sets of properties");
        PlanetsResourceProvider.definePlanet("Mars", 227940);
        PlanetsResourceProvider.definePlanet("Jupiter", 4332);
        PlanetsResourceProvider.definePlanet("Saturn", 10759);
        PlanetsResourceProvider.definePlanet("Uranus", 30685);
        PlanetsResourceProvider.definePlanet("Neptune", 60190);
        String moonPath = "/planets/earth/moon";
        PLANETS.put("/planets/earth/moon", (ValueMap)new PlanetResource.PlanetValueMap("Moon", 384));
    }

    public static class DoesNotNeedAContext {
    }
}

