/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.log.logback.internal;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;

class Tailer {
    static final int BUFFER_SIZE = 1024;
    private final int numOfLines;
    private final TailerListener listener;
    private final byte[] buffer = new byte[1024];

    public Tailer(PrintWriter printWriter, int numOfLines) {
        this(new PrinterListener(printWriter), numOfLines);
    }

    public Tailer(TailerListener listener, int numOfLines) {
        this.listener = listener;
        this.numOfLines = numOfLines;
    }

    public void tail(File file) throws IOException {
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            long startPos = this.getTailStartPos(raf, this.numOfLines);
            this.readLines(raf, startPos);
        }
    }

    private long getTailStartPos(RandomAccessFile file, int n) throws IOException {
        int newlineCount = 0;
        long length = file.length();
        long pos = length - 1024L;
        int buffLength = 1024;
        if (pos < 0L) {
            pos = 0L;
            buffLength = (int)length;
        }
        while (true) {
            file.seek(pos);
            file.readFully(this.buffer, 0, buffLength);
            for (int i = buffLength - 1; i >= 0; --i) {
                if ((char)this.buffer[i] != '\n' || ++newlineCount < n) continue;
                return pos += (long)(i + 1);
            }
            if (pos == 0L) break;
            if (pos - 1024L < 0L) {
                buffLength = (int)pos;
                pos = 0L;
                continue;
            }
            pos -= 1024L;
        }
        return pos;
    }

    private void readLines(RandomAccessFile file, long startPos) throws IOException {
        int num;
        StringBuilder sb = new StringBuilder();
        file.seek(startPos);
        boolean seenCR = false;
        while ((num = file.read(this.buffer)) != -1) {
            block5: for (int i = 0; i < num; ++i) {
                byte ch = this.buffer[i];
                switch (ch) {
                    case 10: {
                        seenCR = false;
                        this.listener.handle(sb.toString());
                        sb.setLength(0);
                        continue block5;
                    }
                    case 13: {
                        if (seenCR) {
                            sb.append('\r');
                        }
                        seenCR = true;
                        continue block5;
                    }
                    default: {
                        if (seenCR) {
                            seenCR = false;
                            this.listener.handle(sb.toString());
                            sb.setLength(0);
                        }
                        sb.append((char)ch);
                    }
                }
            }
        }
        if (sb.length() != 0) {
            this.listener.handle(sb.toString());
        }
    }

    private static class PrinterListener
    implements TailerListener {
        private final PrintWriter pw;

        public PrinterListener(PrintWriter pw) {
            this.pw = pw;
        }

        @Override
        public void handle(String line) {
            this.pw.println(line);
        }
    }

    static interface TailerListener {
        public void handle(String var1);
    }
}

