/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.shenyu.infra.etcd.autoconfig;

import io.etcd.jetcd.Client;
import org.apache.shenyu.infra.etcd.client.EtcdClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionOnSyncEtcd
@ConditionalOnClass(Client.class)
@EnableConfigurationProperties(EtcdProperties.class)
public class EtcdConfiguration {

    private static final Logger log = LoggerFactory.getLogger(EtcdConfiguration.class);

    /**
     * Init etcd client.
     *
     * @param etcdProperties etcd properties
     * @return Etcd Client
     */
    @Bean
    @ConditionalOnMissingBean
    public EtcdClient etcdClient(final EtcdProperties etcdProperties) {

        log.info("Initializing Etcd Client with URL: {}", etcdProperties.getEtcd().getUrl());
        return EtcdClient.builder()
                .client(
                        Client.builder()
                                .endpoints(etcdProperties.getEtcd().getUrl().split(","))
                                .build()
                ).build();
    }

}
