/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.servicecomb.demo.multiServiceCenterClient;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;

import org.apache.servicecomb.demo.CategorizedTestCaseRunner;
import org.apache.servicecomb.demo.TestMgr;
import org.springframework.boot.WebApplicationType;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.stereotype.Component;

@SpringBootApplication
@Component
public class Application {

  public static void main(final String[] args) throws Exception {
    new SpringApplicationBuilder().sources(Application.class)
        .web(WebApplicationType.NONE).build().run(args);

    runTest();
  }

  public static void runTest() throws Exception {
    CategorizedTestCaseRunner.runCategorizedTestCase("demo-multi-service-center-serverA");
    testTransportThreads();
    TestMgr.summary();
    if (!TestMgr.errors().isEmpty()) {
      throw new IllegalStateException("tests failed");
    }
  }

  private static void testTransportThreads() throws Exception {
    Set<Thread> threadSet = Thread.getAllStackTraces().keySet();
    List<String> expectedThread = new ArrayList<>();
    threadSet.forEach(thread -> {
      if (thread.getName().startsWith("transport-vert.x-eventloop-thread")) {
        expectedThread.add(thread.getName());
      }
    });
    // After SSL improvements https://github.com/eclipse-vertx/vert.x/pull/4468 introduced in 4.3.4
    // SSL helper will use `internal-blocking` thread init ssl engine
    // transport-vert.x-eventloop-thread-0
    // transport-vert.x-eventloop-thread-1
    // transport-vert.x-eventloop-thread-2
    // transport-vert.x-eventloop-thread-3
    // transport-vert.x-eventloop-thread-4
    // transport-vert.x-eventloop-thread-5
    // transport-vert.x-internal-blocking-0
    // transport-vert.x-internal-blocking-1
    TestMgr.check(6, expectedThread.size());
  }
}
